/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.auth;

import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpRequestPreemptiveAuthenticator;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.manager.AnonymousAuthenticationManager;

@PluggableService
public class AnonymousPreemptiveAuthenticator
implements HttpRequestPreemptiveAuthenticator {
    private static final String ANONYMOUS = "Anonymous";

    @Override
    public Subject attemptAuthentication(HttpServletRequest request, HttpManagementConfiguration managementConfig) {
        AuthenticationProvider authenticationProvider = managementConfig.getAuthenticationProvider(request);
        SubjectCreator subjectCreator = authenticationProvider.getSubjectCreator(request.isSecure());
        if (authenticationProvider instanceof AnonymousAuthenticationManager) {
            return subjectCreator.createResultWithGroups(AnonymousAuthenticationManager.ANONYMOUS_AUTHENTICATION).getSubject();
        }
        return null;
    }

    public String getType() {
        return ANONYMOUS;
    }
}

