/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.filter;

import java.io.IOException;
import java.security.Principal;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String method = null;
        String user = null;
        String url = null;
        if (LOGGER.isDebugEnabled()) {
            method = httpRequest.getMethod();
            user = this.getRequestPrincipals(httpRequest);
            url = this.getRequestURL(httpRequest);
            LOGGER.debug("REQUEST  user='{}' method='{}' url='{}'", new Object[]{user, method, url});
        }
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable throwable) {
            if (LOGGER.isDebugEnabled()) {
                if (user == null) {
                    user = this.getRequestPrincipals(httpRequest);
                }
                String responseStatus = String.valueOf(httpResponse.getStatus());
                LOGGER.debug("RESPONSE user='{}' method='{}' url='{}' status='{}'", new Object[]{user, method, url, responseStatus});
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            if (user == null) {
                user = this.getRequestPrincipals(httpRequest);
            }
            String responseStatus = String.valueOf(httpResponse.getStatus());
            LOGGER.debug("RESPONSE user='{}' method='{}' url='{}' status='{}'", new Object[]{user, method, url, responseStatus});
        }
    }

    public void destroy() {
    }

    private String getRequestURL(HttpServletRequest httpRequest) {
        StringBuilder urlBuilder = new StringBuilder(httpRequest.getRequestURL());
        String queryString = httpRequest.getQueryString();
        if (queryString != null) {
            urlBuilder.append('?').append(queryString);
        }
        String url = urlBuilder.toString();
        return url;
    }

    private String getRequestPrincipals(HttpServletRequest httpRequest) {
        Set<Principal> principalSet;
        Subject subject;
        HttpSession session = httpRequest.getSession(false);
        if (session != null && (subject = HttpManagementUtil.getAuthorisedSubject(session)) != null && !(principalSet = subject.getPrincipals()).isEmpty()) {
            TreeSet<String> principalNames = new TreeSet<String>();
            for (Principal principal : principalSet) {
                principalNames.add(principal.getName());
            }
            return principalNames.toString();
        }
        return null;
    }
}

