/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectAttribute;
import org.apache.qpid.server.model.ConfiguredObjectOperation;
import org.apache.qpid.server.model.ConfiguredSettableAttribute;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.OperationParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiDocsServlet
extends AbstractServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiDocsServlet.class);
    private final Model _model;
    private final List<Class<? extends ConfiguredObject>> _types;
    private Class<? extends ConfiguredObject>[] _hierarchy;
    private static final Set<Character> VOWELS = new HashSet<Character>(Arrays.asList(Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('i'), Character.valueOf('o'), Character.valueOf('u')));
    public static final Comparator<Class<? extends ConfiguredObject>> CLASS_COMPARATOR = new Comparator<Class<? extends ConfiguredObject>>(){

        @Override
        public int compare(Class<? extends ConfiguredObject> o1, Class<? extends ConfiguredObject> o2) {
            return o1.getSimpleName().compareTo(o2.getSimpleName());
        }
    };
    private static final Map<Class<? extends ConfiguredObject>, List<String>> REGISTERED_CLASSES = new TreeMap<Class<ConfiguredObject>, List<String>>(CLASS_COMPARATOR);

    public ApiDocsServlet(Model model) {
        this._model = model;
        this._hierarchy = null;
        this._types = null;
    }

    public ApiDocsServlet(Model model, List<String> registeredPaths, Class<? extends ConfiguredObject> ... hierarchy) {
        this._model = model;
        this._hierarchy = hierarchy;
        this._types = new ArrayList<Class<? extends ConfiguredObject>>(this._model.getTypeRegistry().getTypeSpecialisations(this.getConfiguredClass()));
        Collections.sort(this._types, CLASS_COMPARATOR);
        List<String> paths = REGISTERED_CLASSES.get(this.getConfiguredClass());
        if (paths == null) {
            paths = new ArrayList<String>();
            REGISTERED_CLASSES.put(this.getConfiguredClass(), paths);
        }
        paths.addAll(registeredPaths);
    }

    @Override
    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setStatus(200);
        PrintWriter writer = response.getWriter();
        this.writePreamble(writer);
        this.writeHead(writer);
        if (this._hierarchy == null) {
            writer.println("<table class=\"api\">");
            writer.println("<thead>");
            writer.println("<tr>");
            writer.println("<th class=\"type\">Type</th>");
            writer.println("<th class=\"path\">Path</th>");
            writer.println("<th class=\"description\">Description</th>");
            writer.println("</tr>");
            writer.println("</thead>");
            writer.println("<tbody>");
            for (Map.Entry<Class<? extends ConfiguredObject>, List<String>> entry : REGISTERED_CLASSES.entrySet()) {
                List<String> paths = entry.getValue();
                Class<? extends ConfiguredObject> objClass = entry.getKey();
                writer.println("<tr>");
                writer.println("<td class=\"type\" rowspan=\"" + paths.size() + "\"><a href=\"latest/" + objClass.getSimpleName().toLowerCase() + "\">" + objClass.getSimpleName() + "</a></td>");
                writer.println("<td class=\"path\">" + paths.get(0) + "</td>");
                writer.println("<td class=\"description\" rowspan=\"" + paths.size() + "\">" + objClass.getAnnotation(ManagedObject.class).description() + "</td>");
                writer.println("</tr>");
                for (int i = 1; i < paths.size(); ++i) {
                    writer.println("<tr>");
                    writer.println("<td class=\"path\">" + paths.get(i) + "</td>");
                    writer.println("</tr>");
                }
            }
            writer.println("</tbody>");
            writer.println("</table>");
        } else {
            this.writeCategoryDescription(writer);
            this.writeUsage(writer, request);
            this.writeTypes(writer);
            this.writeAttributes(writer);
            this.writeOperations(writer);
        }
        this.writeFoot(writer);
    }

    private void writePreamble(PrintWriter writer) {
        writer.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
        writer.println("\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        writer.println("<html>");
    }

    private void writeHead(PrintWriter writer) {
        writer.println("<head>");
        writer.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"/css/apidocs.css\">");
        this.writeTitle(writer);
        writer.println("</head>");
        writer.println("<body>");
    }

    private void writeTitle(PrintWriter writer) {
        writer.print("<title>");
        if (this._hierarchy == null) {
            writer.print("Qpid API");
        } else {
            writer.print("Qpid API: " + this.getConfiguredClass().getSimpleName());
        }
        writer.println("</title>");
    }

    private void writeCategoryDescription(PrintWriter writer) {
        writer.println("<h1>" + this.getConfiguredClass().getSimpleName() + "</h1>");
        writer.println(this.getConfiguredClass().getAnnotation(ManagedObject.class).description());
    }

    private void writeUsage(PrintWriter writer, HttpServletRequest request) {
        writer.println("<a name=\"usage\"><h2>Usage</h2></a>");
        writer.println("<table class=\"usage\">");
        writer.println("<tbody>");
        writer.print("<tr><th class=\"operation\">Read</th><td class=\"method\">GET</td><td class=\"path\">" + request.getServletPath().replace("apidocs", "api"));
        for (Class<? extends ConfiguredObject> category : this._hierarchy) {
            writer.print("[/&lt;" + category.getSimpleName().toLowerCase() + " name or id&gt;");
        }
        for (int i = 0; i < this._hierarchy.length; ++i) {
            writer.print("] ");
        }
        writer.println("</td></tr>");
        writer.print("<tr><th class=\"operation\">Update</th><td class=\"method\">PUT or POST</td><td class=\"path\">" + request.getServletPath().replace("apidocs", "api"));
        for (Class<? extends ConfiguredObject> category : this._hierarchy) {
            writer.print("/&lt;" + category.getSimpleName().toLowerCase() + " name or id&gt;");
        }
        writer.print("<tr><th class=\"operation\">Create</th><td class=\"method\">PUT or POST</td><td class=\"path\">" + request.getServletPath().replace("apidocs", "api"));
        for (int i = 0; i < this._hierarchy.length - 1; ++i) {
            writer.print("/&lt;" + this._hierarchy[i].getSimpleName().toLowerCase() + " name or id&gt;");
        }
        writer.print("<tr><th class=\"operation\">Delete</th><td class=\"method\">DELETE</td><td class=\"path\">" + request.getServletPath().replace("apidocs", "api"));
        for (Class<? extends ConfiguredObject> category : this._hierarchy) {
            writer.print("/&lt;" + category.getSimpleName().toLowerCase() + " name or id&gt;");
        }
        writer.println("</tbody>");
        writer.println("</table>");
    }

    private void writeTypes(PrintWriter writer) {
        if (!(this._types.isEmpty() || this._types.size() == 1 && this.getTypeName(this._types.iterator().next()).trim().equals(""))) {
            writer.println("<a name=\"types\"><h2>Types</h2></a>");
            writer.println("<table class=\"types\">");
            writer.println("<thead>");
            writer.println("<tr><th class=\"type\">Type</th><th class=\"description\">Description</th></tr>");
            writer.println("</thead>");
            writer.println("<tbody>");
            for (Class<? extends ConfiguredObject> type : this._types) {
                writer.print("<tr><td class=\"type\">");
                writer.print(this.getTypeName(type));
                writer.print("</td><td class=\"description\">");
                writer.print(type.getAnnotation(ManagedObject.class).description());
                writer.println("</td></tr>");
            }
            writer.println("</tbody>");
        }
        writer.println("</table>");
    }

    private String getTypeName(Class<? extends ConfiguredObject> type) {
        return type.getAnnotation(ManagedObject.class).type() == null ? this._model.getTypeRegistry().getTypeClass(type).getSimpleName() : type.getAnnotation(ManagedObject.class).type();
    }

    private void writeAttributes(PrintWriter writer) {
        writer.println("<a name=\"types\"><h2>Attributes</h2></a>");
        writer.println("<h2>Common Attributes</h2>");
        this.writeAttributesTable(writer, this._model.getTypeRegistry().getAttributeTypes(this.getConfiguredClass()).values());
        for (Class<? extends ConfiguredObject> type : this._types) {
            String typeName = this.getTypeName(type);
            Collection typeSpecificAttributes = this._model.getTypeRegistry().getTypeSpecificAttributes(type);
            if (typeSpecificAttributes.isEmpty()) continue;
            writer.println("<h2><span class=\"type\">" + typeName + "</span> Specific Attributes</h2>");
            this.writeAttributesTable(writer, typeSpecificAttributes);
        }
    }

    private void writeAttributesTable(PrintWriter writer, Collection<ConfiguredObjectAttribute<?, ?>> attributeTypes) {
        writer.println("<table class=\"attributes\">");
        writer.println("<thead>");
        writer.println("<tr><th class=\"name\">Attribute Name</th><th class=\"type\">Type</th><th class=\"description\">Description</th></tr>");
        writer.println("</thead>");
        writer.println("<tbody>");
        for (ConfiguredObjectAttribute<?, ?> attribute : attributeTypes) {
            if (attribute.isDerived()) continue;
            writer.println("<tr><td class=\"name\">" + attribute.getName() + "</td><td class=\"type\">" + this.renderType(attribute) + "</td><td class=\"description\">" + attribute.getDescription() + "</td></tr>");
        }
        writer.println("</tbody>");
        writer.println("</table>");
    }

    private void writeOperations(PrintWriter writer) {
        writer.println("<a name=\"types\"><h2>Operations</h2></a>");
        writer.println("<h2>Common Operations</h2>");
        Collection<ConfiguredObjectOperation<?>> categoryOperations = this._model.getTypeRegistry().getOperations(this.getConfiguredClass()).values();
        this.writeOperationsTables(writer, categoryOperations);
        for (Class<? extends ConfiguredObject> type : this._types) {
            String typeName = this.getTypeName(type);
            HashSet typeSpecificOperations = new HashSet(this._model.getTypeRegistry().getOperations(type).values());
            typeSpecificOperations.removeAll(categoryOperations);
            if (typeSpecificOperations.isEmpty() || type == this.getConfiguredClass()) continue;
            writer.println("<h2><span class=\"type\">" + typeName + "</span> Specific Operations</h2>");
            this.writeOperationsTables(writer, typeSpecificOperations);
        }
    }

    private void writeOperationsTables(PrintWriter writer, Collection<ConfiguredObjectOperation<?>> operations) {
        for (ConfiguredObjectOperation<?> operation : operations) {
            writer.println("<table class=\"operation\">");
            writer.println("<thead>");
            writer.println("<tr><th class=\"name\">Operation Name</th><th class=\"returnType\">Return Type</th><th class=\"description\">Description</th></tr>");
            writer.println("</thead>");
            writer.println("<tbody>");
            writer.println("<tr><td class=\"name\">" + operation.getName() + "</td><td class=\"type\">" + this.renderType(operation) + "</td><td class=\"description\">" + operation.getDescription() + "</td></tr>");
            if (!operation.getParameters().isEmpty()) {
                writer.println("<tr><td class=\"allparameters\" colspan=\"3\">" + this.renderParameters(operation.getParameters()) + "</td></tr>");
            }
            writer.println("</tbody>");
            writer.println("</table>");
        }
    }

    private String renderParameters(List<OperationParameter> parameters) {
        StringBuilder writer = new StringBuilder();
        writer.append("<table class=\"parameters\">");
        writer.append("<thead>");
        writer.append("<tr><th class=\"name\">Parameter Name</th><th class=\"type\">Type</th><th class=\"description\">Description</th></tr>");
        writer.append("</thead>");
        writer.append("<tbody>");
        for (OperationParameter param : parameters) {
            writer.append("<tr><td class=\"name\">" + param.getName() + "</td><td class=\"type\">" + this.renderType(param) + "</td><td class=\"description\">" + param.getDescription() + "</td></tr>");
        }
        writer.append("</tbody>");
        writer.append("</table>");
        return writer.toString();
    }

    private String renderType(ConfiguredObjectAttribute attribute) {
        Class type = attribute.getType();
        return this.renderType(type, attribute instanceof ConfiguredSettableAttribute && ((ConfiguredSettableAttribute)attribute).hasValidValues() ? ((ConfiguredSettableAttribute)attribute).validValues() : null);
    }

    private String renderType(OperationParameter parameter) {
        Class type = parameter.getType();
        List validValues = parameter.getValidValues();
        return this.renderType(type, validValues);
    }

    private String renderType(Class type, Collection<String> validValues) {
        boolean hasValuesRestriction;
        if (Enum.class.isAssignableFrom(type)) {
            return "<div class=\"restriction\" title=\"enum: " + EnumSet.allOf(type) + "\">string</div>";
        }
        if (ConfiguredObject.class.isAssignableFrom(type)) {
            return "<div class=\"restriction\" title=\"name or id of a" + (VOWELS.contains(Character.valueOf(type.getSimpleName().toLowerCase().charAt(0))) ? "n " : " ") + type.getSimpleName() + "\">string</div>";
        }
        if (UUID.class == type) {
            return "<div class=\"restriction\" title=\"must be a UUID\">string</div>";
        }
        StringBuilder returnVal = new StringBuilder();
        boolean bl = hasValuesRestriction = validValues != null && !validValues.isEmpty();
        if (hasValuesRestriction) {
            returnVal.append("<div class=\"restricted\" title=\"Valid values: " + validValues + "\">");
        }
        if (Number.class.isAssignableFrom(type)) {
            returnVal.append("number");
        } else if (Boolean.class == type) {
            returnVal.append("boolean");
        } else if (String.class == type) {
            returnVal.append("string");
        } else if (Collection.class.isAssignableFrom(type)) {
            returnVal.append("array");
        } else if (Map.class.isAssignableFrom(type)) {
            returnVal.append("object");
        } else {
            returnVal.append(type.getSimpleName());
        }
        if (hasValuesRestriction) {
            returnVal.append("</div>");
        }
        return returnVal.toString();
    }

    private String renderType(ConfiguredObjectOperation<?> operation) {
        return operation.getGenericReturnType() instanceof Class ? ((Class)operation.getGenericReturnType()).getName() : operation.getGenericReturnType().toString();
    }

    private void writeFoot(PrintWriter writer) {
        writer.println("</body>");
        writer.println("</html>");
    }

    private Class<? extends ConfiguredObject> getConfiguredClass() {
        return this._hierarchy.length == 0 ? Broker.class : this._hierarchy[this._hierarchy.length - 1];
    }
}

