/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectAttribute;
import org.apache.qpid.server.model.Model;

public class ConfiguredObjectToMapConverter {
    public static final String STATISTICS_MAP_KEY = "statistics";
    private static Set<String> CONFIG_EXCLUDED_ATTRIBUTES = new HashSet<String>(Arrays.asList("id", "durable", "createdBy", "createdTime", "lastUpdatedBy", "lastUpdatedTime"));

    public Map<String, Object> convertObjectToMap(ConfiguredObject<?> confObject, Class<? extends ConfiguredObject> clazz, ConverterOptions converterOptions) {
        LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
        this.incorporateAttributesIntoMap(confObject, object, converterOptions);
        if (!converterOptions.isExtractAsConfig()) {
            this.incorporateStatisticsIntoMap(confObject, object);
        }
        if (converterOptions.getDepth() > 0) {
            this.incorporateChildrenIntoMap(confObject, clazz, object, converterOptions);
        }
        return object;
    }

    private void incorporateAttributesIntoMap(ConfiguredObject<?> confObject, Map<String, Object> object, ConverterOptions converterOptions) {
        if (converterOptions.isExtractAsConfig() && confObject.getModel().getParentTypes(confObject.getCategoryClass()).size() > 1) {
            Iterator parentClasses = confObject.getModel().getParentTypes(confObject.getCategoryClass()).iterator();
            parentClasses.next();
            while (parentClasses.hasNext()) {
                Class parentClass = (Class)parentClasses.next();
                ConfiguredObject parent = confObject.getParent(parentClass);
                if (parent == null) continue;
                String categoryName = parentClass.getSimpleName();
                object.put(categoryName.substring(0, 1).toLowerCase() + categoryName.substring(1), parent.getName());
            }
        }
        for (String name : confObject.getAttributeNames()) {
            ConfiguredObjectAttribute attribute;
            Object value;
            if (converterOptions.isExtractAsConfig() && CONFIG_EXCLUDED_ATTRIBUTES.contains(name)) continue;
            Object object2 = value = converterOptions.isUseActualValues() ? confObject.getActualAttributes().get(name) : confObject.getAttribute(name);
            if (value instanceof ConfiguredObject) {
                object.put(name, ((ConfiguredObject)value).getName());
                continue;
            }
            if ("context".equals(name)) {
                Map<String, Object> contextValues = this.collectContext(confObject, converterOptions.isExcludeInheritedContext(), converterOptions.isUseActualValues());
                if (contextValues.isEmpty()) continue;
                object.put("context", contextValues);
                continue;
            }
            if (value instanceof Collection) {
                ArrayList<String> converted = new ArrayList<String>();
                for (Object member : (Collection)value) {
                    if (member instanceof ConfiguredObject) {
                        converted.add(((ConfiguredObject)member).getName());
                        continue;
                    }
                    converted.add((String)member);
                }
                object.put(name, converted);
                continue;
            }
            if (value != null) {
                attribute = (ConfiguredObjectAttribute)confObject.getModel().getTypeRegistry().getAttributeTypes(confObject.getClass()).get(name);
                if (!(!attribute.isSecureValue(value) || converterOptions.isSecureTransport() && converterOptions.isExtractAsConfig())) {
                    value = confObject.getAttribute(name);
                }
                if (attribute.isOversized() && !converterOptions.isExtractAsConfig() && !converterOptions.isUseActualValues()) {
                    String valueString = String.valueOf(value);
                    if (valueString.length() > converterOptions.getOversizeThreshold()) {
                        String replacementValue = "".equals(attribute.getOversizedAltText()) ? String.valueOf(value).substring(0, converterOptions.getOversizeThreshold() - 4) + "..." : attribute.getOversizedAltText();
                        object.put(name, replacementValue);
                        continue;
                    }
                    object.put(name, value);
                    continue;
                }
                object.put(name, value);
                continue;
            }
            if (!converterOptions.isExtractAsConfig() || !(attribute = (ConfiguredObjectAttribute)confObject.getModel().getTypeRegistry().getAttributeTypes(confObject.getClass()).get(name)).isPersisted() || !attribute.isDerived()) continue;
            object.put(name, confObject.getAttribute(name));
        }
    }

    private Map<String, Object> collectContext(ConfiguredObject<?> configuredObject, boolean excludeInheritedContext, boolean useActualValues) {
        HashMap<String, Object> actualContext = new HashMap<String, Object>();
        if (excludeInheritedContext) {
            Object value = configuredObject.getActualAttributes().get("context");
            if (value instanceof Map) {
                actualContext.putAll((Map)value);
            }
        } else {
            actualContext.putAll(configuredObject.getModel().getTypeRegistry().getDefaultContext());
            actualContext.putAll(System.getenv());
            actualContext.putAll(System.getProperties());
            this.collectInheritedActualContext(configuredObject, actualContext);
        }
        if (useActualValues) {
            return actualContext;
        }
        HashMap<String, Object> effectiveContext = new HashMap<String, Object>();
        for (String contextKey : actualContext.keySet()) {
            effectiveContext.put(contextKey, configuredObject.getContextValue(String.class, contextKey));
        }
        return effectiveContext;
    }

    private void collectInheritedActualContext(ConfiguredObject<?> confObject, Map<String, Object> contextValues) {
        Object value;
        ConfiguredObject parent;
        Model model = confObject.getModel();
        Collection parents = model.getParentTypes(confObject.getCategoryClass());
        if (parents != null && !parents.isEmpty() && (parent = confObject.getParent((Class)parents.iterator().next())) != null) {
            this.collectInheritedActualContext(parent, contextValues);
        }
        if ((value = confObject.getActualAttributes().get("context")) instanceof Map) {
            contextValues.putAll((Map)value);
        }
    }

    private void incorporateStatisticsIntoMap(ConfiguredObject<?> confObject, Map<String, Object> object) {
        TreeMap statMap = new TreeMap(confObject.getStatistics());
        if (!statMap.isEmpty()) {
            object.put(STATISTICS_MAP_KEY, statMap);
        }
    }

    private void incorporateChildrenIntoMap(ConfiguredObject confObject, Class<? extends ConfiguredObject> clazz, Map<String, Object> object, ConverterOptions converterOptions) {
        ArrayList childTypes = new ArrayList(confObject.getModel().getChildTypes(clazz));
        Collections.sort(childTypes, new Comparator<Class<? extends ConfiguredObject>>(){

            @Override
            public int compare(Class<? extends ConfiguredObject> o1, Class<? extends ConfiguredObject> o2) {
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
        });
        ConverterOptions childConverterOptions = new ConverterOptions(converterOptions, converterOptions.getDepth() - 1);
        for (Class childClass : childTypes) {
            Collection children;
            if (converterOptions.isExtractAsConfig() && confObject.getModel().getParentTypes(childClass).iterator().next() != confObject.getCategoryClass() || (children = confObject.getChildren(childClass)) == null) continue;
            ArrayList sortedChildren = new ArrayList(children);
            Collections.sort(sortedChildren, new Comparator<ConfiguredObject>(){

                @Override
                public int compare(ConfiguredObject o1, ConfiguredObject o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            ArrayList<Map<String, Object>> childObjects = new ArrayList<Map<String, Object>>();
            for (ConfiguredObject child : sortedChildren) {
                if (converterOptions.isExtractAsConfig() && !child.isDurable()) continue;
                childObjects.add(this.convertObjectToMap(child, childClass, childConverterOptions));
            }
            if (childObjects.isEmpty()) continue;
            String childTypeSingular = childClass.getSimpleName().toLowerCase();
            object.put(childTypeSingular + (childTypeSingular.endsWith("s") ? "es" : "s"), childObjects);
        }
    }

    public static final class ConverterOptions {
        private final int _depth;
        private final boolean _useActualValues;
        private final boolean _extractAsConfig;
        private final int _oversizeThreshold;
        private final boolean _secureTransport;
        private final boolean _excludeInheritedContext;

        public ConverterOptions(ConverterOptions options, int depth) {
            this(depth, options.isUseActualValues(), options.isExtractAsConfig(), options.getOversizeThreshold(), options.isSecureTransport(), options.isExcludeInheritedContext());
        }

        public ConverterOptions(int depth, boolean useActualValues, boolean extractAsConfig, int oversizeThreshold, boolean secureTransport, boolean excludeInheritedContext) {
            this._depth = depth;
            this._useActualValues = useActualValues;
            this._extractAsConfig = extractAsConfig;
            this._oversizeThreshold = oversizeThreshold;
            this._secureTransport = secureTransport;
            this._excludeInheritedContext = excludeInheritedContext;
        }

        public int getDepth() {
            return this._depth;
        }

        public boolean isUseActualValues() {
            return this._useActualValues;
        }

        public boolean isExtractAsConfig() {
            return this._extractAsConfig;
        }

        public int getOversizeThreshold() {
            return this._oversizeThreshold;
        }

        public boolean isSecureTransport() {
            return this._secureTransport;
        }

        public boolean isExcludeInheritedContext() {
            return this._excludeInheritedContext;
        }
    }
}

