/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.PreferencesProvider;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;

public class LoggedOnUserPreferencesServlet
extends AbstractServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PreferencesProvider preferencesProvider = this.getPreferencesProvider(request);
        if (preferencesProvider == null) {
            response.sendError(404, "Preferences provider is not configured");
            return;
        }
        String userName = this.getAuthenticatedUserName(request);
        Map preferences = preferencesProvider.getPreferences(userName);
        if (preferences == null) {
            preferences = Collections.emptyMap();
        }
        this.sendJsonResponse(preferences, request, response);
    }

    @Override
    protected void doPutWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PreferencesProvider preferencesProvider = this.getPreferencesProvider(request);
        if (preferencesProvider == null) {
            response.sendError(404, "Preferences provider is not configured");
            return;
        }
        String userName = this.getAuthenticatedUserName(request);
        ObjectMapper mapper = new ObjectMapper();
        Map newPreferences = (Map)mapper.readValue((InputStream)request.getInputStream(), LinkedHashMap.class);
        preferencesProvider.deletePreferences(new String[]{userName});
        Map preferences = preferencesProvider.setPreferences(userName, newPreferences);
        if (preferences == null) {
            preferences = Collections.emptyMap();
        }
        this.sendJsonResponse(preferences, request, response);
    }

    @Override
    protected void doPostWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ObjectMapper mapper;
        Map newPreferences;
        PreferencesProvider preferencesProvider = this.getPreferencesProvider(request);
        if (preferencesProvider == null) {
            response.sendError(404, "Preferences provider is not configured");
            return;
        }
        String userName = this.getAuthenticatedUserName(request);
        Map preferences = preferencesProvider.setPreferences(userName, newPreferences = (Map)(mapper = new ObjectMapper()).readValue((InputStream)request.getInputStream(), LinkedHashMap.class));
        if (preferences == null) {
            preferences = Collections.emptyMap();
        }
        this.sendJsonResponse(preferences, request, response);
    }

    private String getAuthenticatedUserName(HttpServletRequest request) {
        Subject subject = this.getAuthorisedSubject(request);
        AuthenticatedPrincipal principal = AuthenticatedPrincipal.getAuthenticatedPrincipalFromSubject((Subject)subject);
        return principal.getName();
    }

    private PreferencesProvider getPreferencesProvider(HttpServletRequest request) {
        AuthenticationProvider authenticationProvider = this.getManagementConfiguration().getAuthenticationProvider(request);
        if (authenticationProvider == null) {
            throw new IllegalStateException("Authentication provider is not found");
        }
        return authenticationProvider.getPreferencesProvider();
    }
}

