/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.report.ReportRunner;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.VirtualHost;

public class QueueReportServlet
extends AbstractServlet {
    @Override
    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String[] pathInfoElements = this.getPathInfoElements(request);
        if (pathInfoElements != null && pathInfoElements.length == 3) {
            Queue<?> queue = this.getQueueFromRequest(request);
            ReportRunner<?> reportRunner = ReportRunner.createRunner(pathInfoElements[2], request.getParameterMap());
            Object output = reportRunner.runReport(queue);
            response.setContentType(reportRunner.getContentType());
            if (reportRunner.isBinaryReport()) {
                response.getOutputStream().write((byte[])output);
            } else {
                response.getWriter().write((String)output);
            }
        } else {
            throw new IllegalArgumentException("Invalid path is specified");
        }
    }

    private Queue<?> getQueueFromRequest(HttpServletRequest request) {
        String[] pathInfoElements = this.getPathInfoElements(request);
        if (pathInfoElements == null || pathInfoElements.length < 2) {
            throw new IllegalArgumentException("Invalid path is specified");
        }
        String vhostName = pathInfoElements[0];
        String queueName = pathInfoElements[1];
        VirtualHost vhost = this.getBroker().findVirtualHostByName(vhostName);
        if (vhost == null) {
            throw new IllegalArgumentException("Could not find virtual host with name '" + vhostName + "'");
        }
        Queue queueFromVirtualHost = this.getQueueFromVirtualHost(queueName, vhost);
        if (queueFromVirtualHost == null) {
            throw new IllegalArgumentException("Could not find queue with name '" + queueName + "' on virtual host '" + vhost.getName() + "'");
        }
        return queueFromVirtualHost;
    }

    private Queue getQueueFromVirtualHost(String queueName, VirtualHost<?, ?, ?> vhost) {
        Queue queue = null;
        for (Queue q : vhost.getQueues()) {
            if (!q.getName().equals(queueName)) continue;
            queue = q;
            break;
        }
        return queue;
    }
}

