/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.ConfiguredObjectToMapConverter;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectOperation;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.IllegalStateTransitionException;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.util.ExternalServiceException;
import org.apache.qpid.server.util.ExternalServiceTimeoutException;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.util.urlstreamhandler.data.Handler;
import org.apache.qpid.util.DataUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServlet
extends AbstractServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestServlet.class);
    private static final String HIERARCHY_INIT_PARAMETER = "hierarchy";
    public static final String DEPTH_PARAM = "depth";
    public static final String OVERSIZE_PARAM = "oversize";
    public static final String ACTUALS_PARAM = "actuals";
    public static final String SORT_PARAM = "sort";
    public static final String INCLUDE_SYS_CONTEXT_PARAM = "includeSysContext";
    public static final String INHERITED_ACTUALS_PARAM = "inheritedActuals";
    public static final String EXTRACT_INITIAL_CONFIG_PARAM = "extractInitialConfig";
    public static final String EXCLUDE_INHERITED_CONTEXT_PARAM = "excludeInheritedContext";
    public static final int SC_UNPROCESSABLE_ENTITY = 422;
    public static final String CONTENT_DISPOSITION_ATTACHMENT_FILENAME_PARAM = "contentDispositionAttachmentFilename";
    public static final Set<String> RESERVED_PARAMS = new HashSet<String>(Arrays.asList("depth", "sort", "oversize", "actuals", "includeSysContext", "extractInitialConfig", "inheritedActuals", "contentDispositionAttachmentFilename", "excludeInheritedContext"));
    public static final int DEFAULT_DEPTH = 1;
    public static final int DEFAULT_OVERSIZE = 120;
    private Class<? extends ConfiguredObject>[] _hierarchy;
    private final ConfiguredObjectToMapConverter _objectConverter = new ConfiguredObjectToMapConverter();
    private final boolean _hierarchyInitializationRequired;

    public RestServlet() {
        this._hierarchyInitializationRequired = true;
    }

    public RestServlet(Class<? extends ConfiguredObject> ... hierarchy) {
        this._hierarchy = hierarchy;
        this._hierarchyInitializationRequired = false;
    }

    @Override
    public void init() throws ServletException {
        super.init();
        if (this._hierarchyInitializationRequired) {
            this.doInitialization();
        }
        Handler.register();
    }

    private void doInitialization() throws ServletException {
        ServletConfig config = this.getServletConfig();
        String hierarchy = config.getInitParameter(HIERARCHY_INIT_PARAMETER);
        if (hierarchy != null && !"".equals(hierarchy)) {
            String[] hierarchyItems;
            ArrayList classes = new ArrayList();
            for (String item : hierarchyItems = hierarchy.split(",")) {
                Class<?> itemClass;
                try {
                    itemClass = Class.forName(item);
                }
                catch (ClassNotFoundException e) {
                    try {
                        itemClass = Class.forName("org.apache.qpid.server.model." + item);
                    }
                    catch (ClassNotFoundException e1) {
                        throw new ServletException("Unknown configured object class '" + item + "' is specified in hierarchy for " + config.getServletName());
                    }
                }
                Class<?> clazz = itemClass;
                classes.add(clazz);
            }
            Class[] hierarchyClasses = new Class[classes.size()];
            this._hierarchy = classes.toArray(hierarchyClasses);
        } else {
            this._hierarchy = new Class[0];
        }
    }

    protected Collection<ConfiguredObject<?>> getObjects(HttpServletRequest request) {
        Object[] pathInfoElements = this.getPathInfoElements(request);
        ArrayList<String> names = new ArrayList<String>();
        if (pathInfoElements != null) {
            if (pathInfoElements.length > this._hierarchy.length) {
                throw new IllegalArgumentException("Too many entries in path for REST servlet " + this.getServletName() + ". Expected hierarchy length: " + this._hierarchy.length + "; Request hierarchy length: " + pathInfoElements.length + "; Path Elements: " + Arrays.toString(pathInfoElements));
            }
            names.addAll(Arrays.asList(pathInfoElements));
        }
        ArrayList<Object> parents = new ArrayList();
        parents.add(this.getBroker());
        ArrayList<Object> children = new ArrayList();
        HashMap filters = new HashMap();
        Model model = this.getBroker().getModel();
        boolean wildcard = false;
        Class<Broker> parentType = Broker.class;
        for (int i = 0; i < this._hierarchy.length; ++i) {
            if (model.getChildTypes(parentType).contains(this._hierarchy[i])) {
                parentType = this._hierarchy[i];
                for (ConfiguredObject configuredObject : parents) {
                    if (names.size() > i && names.get(i) != null && !((String)names.get(i)).equals("*") && ((String)names.get(i)).trim().length() != 0) {
                        for (ConfiguredObject child : configuredObject.getChildren(this._hierarchy[i])) {
                            if (!child.getName().equals(names.get(i))) continue;
                            children.add(child);
                        }
                        if (!children.isEmpty()) continue;
                        return null;
                    }
                    wildcard = true;
                    children.addAll(configuredObject.getChildren(this._hierarchy[i]));
                }
            } else {
                children = parents;
                if (names.size() > i && names.get(i) != null && !((String)names.get(i)).equals("*") && ((String)names.get(i)).trim().length() != 0) {
                    filters.put(this._hierarchy[i], names.get(i));
                } else {
                    wildcard = true;
                }
            }
            parents = children;
            children = new ArrayList();
        }
        if (!filters.isEmpty() && !parents.isEmpty()) {
            ArrayList potentials = parents;
            parents = new ArrayList();
            for (ConfiguredObject configuredObject : potentials) {
                boolean match = true;
                for (Map.Entry entry : filters.entrySet()) {
                    Collection<? extends ConfiguredObject> ancestors = this.getAncestors(this.getConfiguredClass(), (Class)entry.getKey(), configuredObject);
                    match = false;
                    for (ConfiguredObject configuredObject2 : ancestors) {
                        if (!configuredObject2.getName().equals(entry.getValue())) continue;
                        match = true;
                        break;
                    }
                    if (match) continue;
                    break;
                }
                if (!match) continue;
                parents.add(configuredObject);
            }
        }
        return parents.isEmpty() && !wildcard ? null : this.filter(parents, request);
    }

    private Collection<ConfiguredObject<?>> filter(Collection<ConfiguredObject<?>> objects, HttpServletRequest request) {
        HashMap<String, List<String>> filters = new HashMap<String, List<String>>();
        for (String param : Collections.list(request.getParameterNames())) {
            if (RESERVED_PARAMS.contains(param)) continue;
            filters.put(param, Arrays.asList(request.getParameterValues(param)));
        }
        if (filters.isEmpty()) {
            return objects;
        }
        ArrayList filteredObj = new ArrayList(objects);
        Iterator iter = filteredObj.iterator();
        while (iter.hasNext()) {
            ConfiguredObject obj = (ConfiguredObject)iter.next();
            for (Map.Entry entry : filters.entrySet()) {
                Object value = obj.getAttribute((String)entry.getKey());
                if (((Collection)entry.getValue()).contains(String.valueOf(value))) continue;
                iter.remove();
            }
        }
        return filteredObj;
    }

    private Collection<? extends ConfiguredObject> getAncestors(Class<? extends ConfiguredObject> childType, Class<? extends ConfiguredObject> ancestorType, ConfiguredObject child) {
        HashSet<Object> ancestors = new HashSet<Object>();
        Collection parentTypes = child.getModel().getParentTypes(childType);
        for (Class parentClazz : parentTypes) {
            ConfiguredObject parent;
            if (parentClazz == ancestorType) {
                parent = child.getParent(parentClazz);
                if (parent == null) continue;
                ancestors.add(parent);
                continue;
            }
            parent = child.getParent(parentClazz);
            if (parent == null) continue;
            ancestors.addAll(this.getAncestors(parentClazz, ancestorType, parent));
        }
        return ancestors;
    }

    @Override
    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String[] pathInfoElements = this.getPathInfoElements(request);
        if (pathInfoElements != null && pathInfoElements.length == this._hierarchy.length + 1) {
            this.doOperation(request, response);
        } else {
            boolean excludeInheritedContext;
            boolean actuals;
            int oversizeThreshold;
            int depth;
            Collection<ConfiguredObject<?>> allObjects;
            String attachmentFilename = request.getParameter(CONTENT_DISPOSITION_ATTACHMENT_FILENAME_PARAM);
            boolean extractInitialConfig = this.getBooleanParameterFromRequest(request, EXTRACT_INITIAL_CONFIG_PARAM);
            if (attachmentFilename != null) {
                this.setContentDispositionHeaderIfNecessary(response, attachmentFilename);
            }
            if ((allObjects = this.getObjects(request)) == null || allObjects.isEmpty() && this.isSingleObjectRequest(request)) {
                this.sendJsonErrorResponse(request, response, 404, "Not Found");
                return;
            }
            if (extractInitialConfig) {
                depth = Integer.MAX_VALUE;
                oversizeThreshold = Integer.MAX_VALUE;
                actuals = true;
                excludeInheritedContext = true;
            } else {
                depth = this.getIntParameterFromRequest(request, DEPTH_PARAM, 1);
                oversizeThreshold = this.getIntParameterFromRequest(request, OVERSIZE_PARAM, 120);
                actuals = this.getBooleanParameterFromRequest(request, ACTUALS_PARAM);
                String includeSystemContextParameter = request.getParameter(INCLUDE_SYS_CONTEXT_PARAM);
                String inheritedActualsParameter = request.getParameter(INHERITED_ACTUALS_PARAM);
                String excludeInheritedContextParameter = request.getParameter(EXCLUDE_INHERITED_CONTEXT_PARAM);
                if (excludeInheritedContextParameter == null) {
                    excludeInheritedContext = inheritedActualsParameter == null && includeSystemContextParameter == null ? actuals : (inheritedActualsParameter != null && includeSystemContextParameter != null ? (actuals ? !Boolean.parseBoolean(inheritedActualsParameter) : !Boolean.parseBoolean(includeSystemContextParameter)) : (inheritedActualsParameter != null ? (actuals ? !Boolean.parseBoolean(inheritedActualsParameter) : false) : (actuals ? true : !Boolean.parseBoolean(includeSystemContextParameter))));
                } else {
                    if (inheritedActualsParameter != null || includeSystemContextParameter != null) {
                        this.sendJsonErrorResponse(request, response, 422, String.format("Parameter '%s' cannot be specified together with '%s' or '%s'", EXCLUDE_INHERITED_CONTEXT_PARAM, INHERITED_ACTUALS_PARAM, INCLUDE_SYS_CONTEXT_PARAM));
                        return;
                    }
                    excludeInheritedContext = Boolean.parseBoolean(excludeInheritedContextParameter);
                }
            }
            ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>();
            for (ConfiguredObject<?> configuredObject : allObjects) {
                output.add(this._objectConverter.convertObjectToMap(configuredObject, this.getConfiguredClass(), new ConfiguredObjectToMapConverter.ConverterOptions(depth, actuals, extractInitialConfig, oversizeThreshold, request.isSecure(), excludeInheritedContext)));
            }
            boolean sendCachingHeaders = attachmentFilename == null;
            this.sendJsonResponse(extractInitialConfig && output.size() == 1 ? output.get(0) : output, request, response, 200, sendCachingHeaders);
        }
    }

    private boolean isSingleObjectRequest(HttpServletRequest request) {
        if (this._hierarchy.length > 0) {
            String[] pathInfoElements = this.getPathInfoElements(request);
            return pathInfoElements != null && pathInfoElements.length == this._hierarchy.length;
        }
        return false;
    }

    private void setContentDispositionHeaderIfNecessary(HttpServletResponse response, String attachmentFilename) {
        if (attachmentFilename != null) {
            String filenameRfc2183 = HttpManagementUtil.ensureFilenameIsRfc2183(attachmentFilename);
            if (filenameRfc2183.length() > 0) {
                response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", filenameRfc2183));
            } else {
                response.setHeader("Content-Disposition", "attachment");
            }
        }
    }

    private Class<? extends ConfiguredObject> getConfiguredClass() {
        return this._hierarchy.length == 0 ? Broker.class : this._hierarchy[this._hierarchy.length - 1];
    }

    @Override
    protected void doPutWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.performCreateOrUpdate(request, response);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            super.service(request, response);
        }
        catch (Exception | NoClassDefFoundError e) {
            this.setResponseStatus(request, response, e);
        }
    }

    private void performCreateOrUpdate(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean isOperation;
        response.setContentType("application/json");
        List<String> names = this.getParentNamesFromServletPath(request);
        boolean isFullObjectURL = names.size() == this._hierarchy.length;
        boolean isPostToFullURL = isFullObjectURL && "POST".equalsIgnoreCase(request.getMethod());
        String[] pathInfoElements = this.getPathInfoElements(request);
        boolean bl = isOperation = pathInfoElements != null && pathInfoElements.length == this._hierarchy.length + 1 && isPostToFullURL;
        if (!isOperation) {
            ConfiguredObject<?> configuredObject;
            Map<String, Object> providedObject = this.getRequestProvidedObject(request);
            if (names.isEmpty() && this._hierarchy.length == 0) {
                this.getBroker().setAttributes(providedObject);
                response.setStatus(200);
                return;
            }
            ConfiguredObject theParent = this.getBroker();
            ConfiguredObject[] otherParents = null;
            Class<? extends ConfiguredObject> objClass = this.getConfiguredClass();
            if (this._hierarchy.length > 1) {
                List<ConfiguredObject> parents = this.findAllObjectParents(names);
                theParent = parents.remove(0);
                otherParents = parents.toArray(new ConfiguredObject[parents.size()]);
            }
            if (isFullObjectURL) {
                providedObject.put("name", names.get(names.size() - 1));
                configuredObject = this.findObjectToUpdateInParent(objClass, providedObject, theParent, otherParents);
                if (configuredObject != null) {
                    configuredObject.setAttributes(providedObject);
                    response.setStatus(200);
                    return;
                }
                if (isPostToFullURL) {
                    this.sendJsonErrorResponse(request, response, 404, "Object with " + (providedObject.containsKey("id") ? " id '" + providedObject.get("id") : " name '" + providedObject.get("name")) + "' does not exist!");
                    return;
                }
            }
            configuredObject = theParent.createChild(objClass, providedObject, otherParents);
            StringBuffer requestURL = request.getRequestURL();
            if (!isFullObjectURL) {
                requestURL.append("/").append(configuredObject.getName());
            }
            response.setHeader("Location", requestURL.toString());
            response.setStatus(201);
        } else {
            this.doOperation(request, response);
        }
    }

    private void doOperation(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Map<String, Object> operationArguments;
        Broker<?> subject;
        List<String> names = this.getParentNamesFromServletPath(request);
        String[] pathInfoElements = this.getPathInfoElements(request);
        if (names.isEmpty() && this._hierarchy.length == 0) {
            subject = this.getBroker();
        } else {
            Map<String, Object> objectName;
            ConfiguredObject theParent = this.getBroker();
            ConfiguredObject[] otherParents = null;
            Class<? extends ConfiguredObject> objClass = this.getConfiguredClass();
            if (this._hierarchy.length > 1) {
                List<ConfiguredObject> parents = this.findAllObjectParents(names);
                theParent = parents.remove(0);
                otherParents = parents.toArray(new ConfiguredObject[parents.size()]);
            }
            if ((subject = this.findObjectToUpdateInParent(objClass, objectName = Collections.singletonMap("name", names.get(names.size() - 1)), theParent, otherParents)) == null) {
                this.sendJsonErrorResponse(request, response, 404, this.getConfiguredClass().getSimpleName() + " '" + pathInfoElements[pathInfoElements.length - 2] + "' not found.");
                return;
            }
        }
        String operationName = pathInfoElements[pathInfoElements.length - 1];
        Map availableOperations = this.getBroker().getModel().getTypeRegistry().getOperations(subject.getClass());
        ConfiguredObjectOperation operation = (ConfiguredObjectOperation)availableOperations.get(operationName);
        String requestMethod = request.getMethod();
        if (operation == null) {
            this.sendJsonErrorResponse(request, response, 404, "No such operation: " + operationName);
            return;
        }
        switch (requestMethod) {
            case "GET": {
                if (operation.isNonModifying()) {
                    operationArguments = this.getOperationArgumentsAsMap(request);
                    break;
                }
                response.addHeader("Allow", "POST");
                this.sendJsonErrorResponse(request, response, 405, "Operation " + operationName + " modifies the object so you must use POST.");
                return;
            }
            case "POST": {
                operationArguments = this.getRequestProvidedObject(request);
                break;
            }
            default: {
                response.addHeader("Allow", operation.isNonModifying() ? "POST, GET" : "POST");
                this.sendJsonErrorResponse(request, response, 405, "Operation " + operationName + " does not support the " + requestMethod + " requestMethod.");
                return;
            }
        }
        Object returnVal = operation.perform(subject, operationArguments);
        if (returnVal instanceof Content) {
            Content content = (Content)returnVal;
            this.writeTypedContent(content, request, response);
        } else {
            ConfiguredObjectToMapConverter.ConverterOptions converterOptions = new ConfiguredObjectToMapConverter.ConverterOptions(1, false, false, 120, request.isSecure(), true);
            if (ConfiguredObject.class.isAssignableFrom(operation.getReturnType())) {
                returnVal = this._objectConverter.convertObjectToMap((ConfiguredObject)returnVal, operation.getReturnType(), converterOptions);
            } else if (this.returnsCollectionOfConfiguredObjects(operation)) {
                ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>();
                for (Object configuredObject : (Collection)returnVal) {
                    output.add(this._objectConverter.convertObjectToMap((ConfiguredObject)configuredObject, this.getCollectionMemberType((ParameterizedType)operation.getGenericReturnType()), converterOptions));
                }
                returnVal = output;
            }
            this.sendJsonResponse(returnVal, request, response);
        }
    }

    private boolean returnsCollectionOfConfiguredObjects(ConfiguredObjectOperation operation) {
        return Collection.class.isAssignableFrom(operation.getReturnType()) && operation.getGenericReturnType() instanceof ParameterizedType && ConfiguredObject.class.isAssignableFrom(this.getCollectionMemberType((ParameterizedType)operation.getGenericReturnType()));
    }

    private Class getCollectionMemberType(ParameterizedType collectionType) {
        return RestServlet.getRawType(collectionType.getActualTypeArguments()[0]);
    }

    private static Class getRawType(Type t) {
        Type[] upperBounds;
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        if (t instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)t).getBounds();
            if (bounds.length == 1) {
                return RestServlet.getRawType(bounds[0]);
            }
        } else if (t instanceof WildcardType && (upperBounds = ((WildcardType)t).getUpperBounds()).length == 1) {
            return RestServlet.getRawType(upperBounds[0]);
        }
        throw new ServerScopedRuntimeException("Unable to process type when constructing configuration model: " + t);
    }

    private Map<String, Object> getOperationArgumentsAsMap(HttpServletRequest request) {
        HashMap<String, Object> providedObject = new HashMap<String, Object>();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            String[] value = (String[])entry.getValue();
            if (value == null) continue;
            if (value.length > 1) {
                providedObject.put((String)entry.getKey(), Arrays.asList(value));
                continue;
            }
            providedObject.put((String)entry.getKey(), value[0]);
        }
        return providedObject;
    }

    private List<ConfiguredObject> findAllObjectParents(List<String> names) {
        Collection[] objects = new Collection[this._hierarchy.length];
        block0: for (int i = 0; i < this._hierarchy.length - 1; ++i) {
            objects[i] = new HashSet();
            if (i == 0) {
                for (ConfiguredObject object : this.getBroker().getChildren(this._hierarchy[0])) {
                    if (!object.getName().equals(names.get(0))) continue;
                    objects[0].add(object);
                    continue block0;
                }
                continue;
            }
            for (int j = i - 1; j >= 0; --j) {
                if (!this.getBroker().getModel().getChildTypes(this._hierarchy[j]).contains(this._hierarchy[i])) continue;
                for (ConfiguredObject parent : objects[j]) {
                    for (ConfiguredObject object : parent.getChildren(this._hierarchy[i])) {
                        if (!object.getName().equals(names.get(i))) continue;
                        objects[i].add(object);
                    }
                }
                continue block0;
            }
        }
        ArrayList<ConfiguredObject> parents = new ArrayList<ConfiguredObject>();
        Class<? extends ConfiguredObject> objClass = this.getConfiguredClass();
        Collection parentClasses = this.getBroker().getModel().getParentTypes(objClass);
        for (int i = this._hierarchy.length - 2; i >= 0; --i) {
            if (!parentClasses.contains(this._hierarchy[i])) continue;
            if (objects[i].size() == 1) {
                parents.add((ConfiguredObject)objects[i].iterator().next());
                continue;
            }
            throw new IllegalArgumentException("Cannot deduce parent of class " + this._hierarchy[i].getSimpleName());
        }
        return parents;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getParentNamesFromServletPath(HttpServletRequest request) {
        ArrayList<String> names = new ArrayList<String>();
        String[] pathInfoElements = this.getPathInfoElements(request);
        if (pathInfoElements == null) return names;
        if (pathInfoElements.length != this._hierarchy.length && (this._hierarchy.length <= 0 || pathInfoElements.length != this._hierarchy.length - 1)) {
            if (pathInfoElements.length != this._hierarchy.length + 1) throw new IllegalArgumentException("Either parent path or full object path must be specified on object creation. Full object path must be specified on object update. Found " + names + " of size " + names.size() + " expecting " + this._hierarchy.length);
            names.addAll(Arrays.asList(pathInfoElements).subList(0, pathInfoElements.length - 1));
            return names;
        } else {
            names.addAll(Arrays.asList(pathInfoElements));
        }
        return names;
    }

    private Map<String, Object> getRequestProvidedObject(HttpServletRequest request) throws IOException, ServletException {
        Map<String, Object> providedObject;
        ArrayList headers = Collections.list(request.getHeaderNames());
        ObjectMapper mapper = new ObjectMapper();
        if (headers.contains("Content-Type") && request.getHeader("Content-Type").startsWith("multipart/form-data")) {
            providedObject = new HashMap<String, Object>();
            HashMap<String, String> fileUploads = new HashMap<String, String>();
            Collection parts = request.getParts();
            for (Part part : parts) {
                if ("data".equals(part.getName()) && "application/json".equals(part.getContentType())) {
                    providedObject = (Map)mapper.readValue(part.getInputStream(), LinkedHashMap.class);
                    continue;
                }
                byte[] data = new byte[(int)part.getSize()];
                part.getInputStream().read(data);
                String inlineURL = DataUrlUtils.getDataUrlForBytes((byte[])data);
                fileUploads.put(part.getName(), inlineURL);
            }
            providedObject.putAll(fileUploads);
        } else {
            try {
                providedObject = (HashMap<String, Object>)mapper.readValue((InputStream)request.getInputStream(), LinkedHashMap.class);
            }
            catch (JsonParseException e) {
                throw new IllegalArgumentException("Cannot parse the operation body as json", e);
            }
        }
        return providedObject;
    }

    private ConfiguredObject<?> findObjectToUpdateInParent(Class<? extends ConfiguredObject> objClass, Map<String, Object> providedObject, ConfiguredObject theParent, ConfiguredObject[] otherParents) {
        Collection existingChildren = theParent.getChildren(objClass);
        for (ConfiguredObject obj : existingChildren) {
            if ((!providedObject.containsKey("id") || !String.valueOf(providedObject.get("id")).equals(obj.getId().toString())) && (!obj.getName().equals(providedObject.get("name")) || !this.sameOtherParents(obj, otherParents, objClass))) continue;
            return obj;
        }
        return null;
    }

    private boolean sameOtherParents(ConfiguredObject obj, ConfiguredObject[] otherParents, Class<? extends ConfiguredObject> objClass) {
        Collection parentClasses = obj.getModel().getParentTypes(objClass);
        if (otherParents == null || otherParents.length == 0) {
            return parentClasses.size() == 1;
        }
        for (ConfiguredObject parent : otherParents) {
            boolean found = false;
            for (Class parentClass : parentClasses) {
                if (parent != obj.getParent(parentClass)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private void setResponseStatus(HttpServletRequest request, HttpServletResponse response, Throwable e) throws IOException {
        if (e instanceof AccessControlException) {
            LOGGER.debug("AccessControlException, sending {}", (Object)403, (Object)e);
            response.setStatus(403);
        } else {
            int responseCode = 400;
            String message = e.getMessage();
            if (e instanceof AbstractConfiguredObject.DuplicateIdException || e instanceof AbstractConfiguredObject.DuplicateNameException || e instanceof IntegrityViolationException || e instanceof IllegalStateTransitionException) {
                responseCode = 409;
            } else if (e instanceof IllegalConfigurationException || e instanceof IllegalArgumentException) {
                LOGGER.warn(e.getClass().getSimpleName() + " processing request : " + message);
                Throwable t = e;
                int maxDepth = 10;
                while ((t = t.getCause()) != null && maxDepth-- != 0) {
                    LOGGER.warn("... caused by " + t.getClass().getSimpleName() + "  : " + t.getMessage());
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(e.getClass().getSimpleName() + " processing request", e);
                }
                responseCode = 422;
            } else if (e instanceof NoClassDefFoundError) {
                message = "Not found: " + message;
                LOGGER.warn("Unexpected exception processing request ", e);
            } else if (e instanceof ExternalServiceTimeoutException) {
                responseCode = 504;
                LOGGER.warn("External request timeout ", e);
            } else if (e instanceof ExternalServiceException) {
                responseCode = 502;
                LOGGER.warn("External request failed ", e);
            } else {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException("Unexpected Exception", e);
            }
            this.sendJsonErrorResponse(request, response, responseCode, message);
        }
    }

    @Override
    protected void doDeleteWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Collection<ConfiguredObject<?>> allObjects = this.getObjects(request);
        if (allObjects != null) {
            for (ConfiguredObject<?> o : allObjects) {
                o.delete();
            }
            this.sendCachingHeadersOnResponse(response);
            response.setStatus(200);
        } else {
            this.sendJsonErrorResponse(request, response, 404, "Not Found");
        }
    }

    @Override
    protected void doPostWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.performCreateOrUpdate(request, response);
    }

    private int getIntParameterFromRequest(HttpServletRequest request, String paramName, int defaultValue) {
        int intValue = defaultValue;
        String stringValue = request.getParameter(paramName);
        if (stringValue != null) {
            try {
                intValue = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Could not parse " + stringValue + " as integer for parameter " + paramName);
            }
        }
        return intValue;
    }

    private boolean getBooleanParameterFromRequest(HttpServletRequest request, String paramName) {
        return this.getBooleanParameterFromRequest(request, paramName, false);
    }

    private boolean getBooleanParameterFromRequest(HttpServletRequest request, String paramName, boolean defaultValue) {
        String value = request.getParameter(paramName);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }
}

