/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.io.IOException;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.bind.DatatypeConverter;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.servlet.ServletConnectionPrincipal;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslServlet
extends AbstractServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaslServlet.class);
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final String ATTR_RANDOM = "SaslServlet.Random";
    private static final String ATTR_ID = "SaslServlet.ID";
    private static final String ATTR_SASL_SERVER = "SaslServlet.SaslServer";
    private static final String ATTR_EXPIRY = "SaslServlet.Expiry";
    private static final long SASL_EXCHANGE_EXPIRY = 3000L;

    @Override
    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        this.getRandom(session);
        SubjectCreator subjectCreator = this.getSubjectCreator(request);
        List mechanismsList = subjectCreator.getMechanisms();
        String[] mechanisms = mechanismsList.toArray(new String[mechanismsList.size()]);
        LinkedHashMap<String, Object> outputObject = new LinkedHashMap<String, Object>();
        Subject subject = this.getAuthorisedSubject(request);
        if (subject != null) {
            AuthenticatedPrincipal principal = AuthenticatedPrincipal.getAuthenticatedPrincipalFromSubject((Subject)subject);
            outputObject.put("user", principal.getName());
        } else if (request.getRemoteUser() != null) {
            outputObject.put("user", request.getRemoteUser());
        }
        outputObject.put("mechanisms", mechanisms);
        this.sendJsonResponse(outputObject, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Random getRandom(HttpSession session) {
        Random rand = (Random)session.getAttribute(ATTR_RANDOM);
        if (rand == null) {
            SecureRandom secureRandom = SECURE_RANDOM;
            synchronized (secureRandom) {
                rand = new Random(SECURE_RANDOM.nextLong());
            }
            session.setAttribute(ATTR_RANDOM, (Object)rand);
        }
        return rand;
    }

    @Override
    protected void doPostWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.checkSaslAuthEnabled(request);
        try {
            HttpSession session = request.getSession();
            String mechanism = request.getParameter("mechanism");
            String id = request.getParameter("id");
            String saslResponse = request.getParameter("response");
            SubjectCreator subjectCreator = this.getSubjectCreator(request);
            if (mechanism != null) {
                if (id == null) {
                    LOGGER.debug("Creating SaslServer for mechanism: {}", (Object)mechanism);
                    SaslServer saslServer = subjectCreator.createSaslServer(mechanism, request.getServerName(), null);
                    this.evaluateSaslResponse(request, response, session, saslResponse, saslServer, subjectCreator);
                } else {
                    response.setStatus(417);
                    session.removeAttribute(ATTR_ID);
                    session.removeAttribute(ATTR_SASL_SERVER);
                    session.removeAttribute(ATTR_EXPIRY);
                }
            } else if (id != null) {
                if (id.equals(session.getAttribute(ATTR_ID)) && System.currentTimeMillis() < (Long)session.getAttribute(ATTR_EXPIRY)) {
                    SaslServer saslServer = (SaslServer)session.getAttribute(ATTR_SASL_SERVER);
                    this.evaluateSaslResponse(request, response, session, saslResponse, saslServer, subjectCreator);
                } else {
                    response.setStatus(417);
                    session.removeAttribute(ATTR_ID);
                    session.removeAttribute(ATTR_SASL_SERVER);
                    session.removeAttribute(ATTR_EXPIRY);
                }
            } else {
                response.setStatus(417);
                session.removeAttribute(ATTR_ID);
                session.removeAttribute(ATTR_SASL_SERVER);
                session.removeAttribute(ATTR_EXPIRY);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error processing SASL request", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            LOGGER.error("Error processing SASL request", (Throwable)e);
            throw e;
        }
    }

    private void checkSaslAuthEnabled(HttpServletRequest request) {
        boolean saslAuthEnabled = false;
        HttpManagementConfiguration management = this.getManagementConfiguration();
        saslAuthEnabled = request.isSecure() ? management.isHttpsSaslAuthenticationEnabled() : management.isHttpSaslAuthenticationEnabled();
        if (!saslAuthEnabled) {
            throw new ConnectionScopedRuntimeException("Sasl authentication disabled.");
        }
    }

    private void evaluateSaslResponse(HttpServletRequest request, HttpServletResponse response, HttpSession session, String saslResponse, SaslServer saslServer, SubjectCreator subjectCreator) throws IOException {
        byte[] challenge;
        try {
            challenge = saslServer.evaluateResponse(saslResponse == null ? new byte[]{} : Strings.decodeBase64((String)saslResponse));
        }
        catch (SaslException e) {
            session.removeAttribute(ATTR_ID);
            session.removeAttribute(ATTR_SASL_SERVER);
            session.removeAttribute(ATTR_EXPIRY);
            response.setStatus(401);
            return;
        }
        if (saslServer.isComplete()) {
            Subject originalSubject = subjectCreator.createSubjectWithGroups((Principal)new AuthenticatedPrincipal(saslServer.getAuthorizationID()));
            Subject subject = new Subject(false, originalSubject.getPrincipals(), originalSubject.getPublicCredentials(), originalSubject.getPrivateCredentials());
            subject.getPrincipals().add((Principal)((Object)new ServletConnectionPrincipal((ServletRequest)request)));
            subject.setReadOnly();
            Broker<?> broker = this.getBroker();
            try {
                HttpManagementUtil.assertManagementAccess(broker.getSecurityManager(), subject);
            }
            catch (SecurityException e) {
                this.sendError(response, 403);
                return;
            }
            HttpManagementUtil.saveAuthorisedSubject(request.getSession(), subject);
            session.removeAttribute(ATTR_ID);
            session.removeAttribute(ATTR_SASL_SERVER);
            session.removeAttribute(ATTR_EXPIRY);
            if (challenge != null && challenge.length != 0) {
                LinkedHashMap<String, String> outputObject = new LinkedHashMap<String, String>();
                outputObject.put("challenge", DatatypeConverter.printBase64Binary((byte[])challenge));
                this.sendJsonResponse(outputObject, request, response);
            }
            response.setStatus(200);
        } else {
            Random rand = this.getRandom(session);
            String id = String.valueOf(rand.nextLong());
            session.setAttribute(ATTR_ID, (Object)id);
            session.setAttribute(ATTR_SASL_SERVER, (Object)saslServer);
            session.setAttribute(ATTR_EXPIRY, (Object)(System.currentTimeMillis() + 3000L));
            response.setStatus(200);
            LinkedHashMap<String, String> outputObject = new LinkedHashMap<String, String>();
            outputObject.put("id", id);
            outputObject.put("challenge", DatatypeConverter.printBase64Binary((byte[])challenge));
            this.sendJsonResponse(outputObject, request, response);
        }
    }

    private SubjectCreator getSubjectCreator(HttpServletRequest request) {
        return HttpManagementUtil.getManagementConfiguration(this.getServletContext()).getAuthenticationProvider(request).getSubjectCreator(request.isSecure());
    }

    @Override
    protected Subject getAuthorisedSubject(HttpServletRequest request) {
        Subject subject = HttpManagementUtil.getAuthorisedSubject(request.getSession());
        if (subject == null) {
            subject = HttpManagementUtil.tryToAuthenticate(request, HttpManagementUtil.getManagementConfiguration(this.getServletContext()));
        }
        return subject;
    }
}

