/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.PreferencesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPreferencesServlet
extends AbstractServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserPreferencesServlet.class);
    private static final long serialVersionUID = 1L;

    @Override
    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String[] pathElements = this.getPathInfoElements(request);
        if (pathElements != null && pathElements.length > 1) {
            this.getUserPreferences(pathElements[0], pathElements[1], request, response);
        } else {
            this.getUserList(pathElements, request, response);
        }
    }

    private void getUserPreferences(String authenticationProviderName, String userId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map preferences = null;
        PreferencesProvider preferencesProvider = this.getPreferencesProvider(authenticationProviderName);
        if (preferencesProvider == null) {
            response.sendError(404, "Preferences provider is not configured");
            return;
        }
        try {
            preferences = preferencesProvider.getPreferences(userId);
            this.sendJsonResponse(preferences, request, response);
        }
        catch (SecurityException e) {
            response.sendError(403, "Viewing of preferences is not allowed");
            return;
        }
    }

    private void getUserList(String[] pathElements, HttpServletRequest request, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> users = null;
        try {
            users = this.getUsers(pathElements);
        }
        catch (Exception e) {
            LOGGER.debug("Bad preferences request", (Throwable)e);
            response.sendError(400, e.getMessage());
        }
        this.sendJsonResponse(users, request, response);
    }

    private PreferencesProvider getPreferencesProvider(String authenticationProviderName) {
        AuthenticationProvider authenticationProvider = this.getAuthenticationProvider(authenticationProviderName);
        if (authenticationProvider == null) {
            throw new IllegalArgumentException(String.format("Authentication provider '%s' is not found", authenticationProviderName));
        }
        PreferencesProvider preferencesProvider = authenticationProvider.getPreferencesProvider();
        return preferencesProvider;
    }

    private AuthenticationProvider getAuthenticationProvider(String authenticationProviderName) {
        Broker<?> broker = this.getBroker();
        Collection authenticationProviders = broker.getAuthenticationProviders();
        for (AuthenticationProvider authenticationProvider : authenticationProviders) {
            if (!authenticationProviderName.equals(authenticationProvider.getName())) continue;
            return authenticationProvider;
        }
        return null;
    }

    private List<Map<String, Object>> getUsers(String[] pathElements) {
        ArrayList<Map<String, Object>> users = new ArrayList<Map<String, Object>>();
        String authenticationProviderName = pathElements != null && pathElements.length > 0 ? pathElements[0] : null;
        Broker<?> broker = this.getBroker();
        Collection authenticationProviders = broker.getAuthenticationProviders();
        for (AuthenticationProvider authenticationProvider : authenticationProviders) {
            PreferencesProvider preferencesProvider;
            if (authenticationProviderName != null && !authenticationProvider.getName().equals(authenticationProviderName) || (preferencesProvider = authenticationProvider.getPreferencesProvider()) == null) continue;
            Set usernames = preferencesProvider.listUserIDs();
            for (String name : usernames) {
                HashMap<String, String> userMap = new HashMap<String, String>();
                userMap.put("name", name);
                userMap.put("authenticationProvider", authenticationProvider.getName());
                users.add(userMap);
            }
        }
        return users;
    }

    @Override
    protected void doDeleteWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Broker<?> broker = this.getBroker();
        Collection authenticationProviders = broker.getAuthenticationProviders();
        HashMap<String, HashSet<String>> providerUsers = new HashMap<String, HashSet<String>>();
        HashMap<String, AuthenticationProvider> requestProviders = new HashMap<String, AuthenticationProvider>();
        for (String value : request.getParameterValues("user")) {
            String[] elements = value.split("/");
            if (elements.length != 2) {
                throw new IllegalArgumentException("Illegal user parameter " + value);
            }
            String userId = URLDecoder.decode(elements[1], "UTF-8");
            String providerName = URLDecoder.decode(elements[0], "UTF-8");
            HashSet<String> users = (HashSet<String>)providerUsers.get(providerName);
            if (users == null) {
                AuthenticationProvider provider = this.findAuthenticationProviderByName(providerName, authenticationProviders);
                if (provider == null) {
                    throw new IllegalArgumentException("Cannot find provider with name '" + providerName + "'");
                }
                users = new HashSet<String>();
                providerUsers.put(providerName, users);
                requestProviders.put(providerName, provider);
            }
            users.add(userId);
        }
        if (!providerUsers.isEmpty()) {
            for (Map.Entry entry : providerUsers.entrySet()) {
                String providerName = (String)entry.getKey();
                AuthenticationProvider provider = (AuthenticationProvider)requestProviders.get(providerName);
                Set usersToDelete = (Set)entry.getValue();
                PreferencesProvider preferencesProvider = provider.getPreferencesProvider();
                if (preferencesProvider == null || usersToDelete.isEmpty()) continue;
                String[] users = usersToDelete.toArray(new String[usersToDelete.size()]);
                try {
                    preferencesProvider.deletePreferences(users);
                }
                catch (SecurityException e) {
                    response.sendError(403, "Deletion of preferences is not allowed");
                    return;
                }
            }
        }
    }

    protected AuthenticationProvider findAuthenticationProviderByName(String providerName, Collection<AuthenticationProvider> authenticationProviders) {
        AuthenticationProvider provider = null;
        for (AuthenticationProvider authenticationProvider : authenticationProviders) {
            if (!authenticationProvider.getName().equals(providerName)) continue;
            provider = authenticationProvider;
            break;
        }
        return provider;
    }
}

