/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.ConfiguredObjectToMapConverter;
import org.apache.qpid.server.management.plugin.servlet.rest.NotFoundException;
import org.apache.qpid.server.management.plugin.servlet.rest.RequestInfo;
import org.apache.qpid.server.management.plugin.servlet.rest.RequestInfoParser;
import org.apache.qpid.server.management.plugin.servlet.rest.RestUserPreferenceHandler;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectFinder;
import org.apache.qpid.server.model.ConfiguredObjectOperation;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.IllegalStateTransitionException;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.OperationTimeoutException;
import org.apache.qpid.server.model.preferences.UserPreferences;
import org.apache.qpid.server.util.DataUrlUtils;
import org.apache.qpid.server.util.ExternalServiceException;
import org.apache.qpid.server.util.ExternalServiceTimeoutException;
import org.apache.qpid.server.util.urlstreamhandler.data.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServlet
extends AbstractServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RestServlet.class);
    public static final String DEPTH_PARAM = "depth";
    public static final String OVERSIZE_PARAM = "oversize";
    public static final String ACTUALS_PARAM = "actuals";
    public static final String SORT_PARAM = "sort";
    public static final String EXTRACT_INITIAL_CONFIG_PARAM = "extractInitialConfig";
    public static final String EXCLUDE_INHERITED_CONTEXT_PARAM = "excludeInheritedContext";
    private static final String SINGLETON_MODEL_OBJECT_RESPONSE_AS_LIST = "singletonModelObjectResponseAsList";
    public static final Set<String> RESERVED_PARAMS = new HashSet<String>(Arrays.asList("depth", "sort", "oversize", "actuals", "extractInitialConfig", "contentDispositionAttachmentFilename", "excludeInheritedContext", "singletonModelObjectResponseAsList"));
    public static final int DEFAULT_DEPTH = 0;
    public static final int DEFAULT_OVERSIZE = 120;
    private final transient ConfiguredObjectToMapConverter _objectConverter = new ConfiguredObjectToMapConverter();
    private transient RestUserPreferenceHandler _userPreferenceHandler;

    @Override
    public void init() throws ServletException {
        super.init();
        Handler.register();
        Long preferenceOperationTimeout = (Long)this.getManagementConfiguration().getContextValue(Long.class, "qpid.httpManagement.preferenceOperationTimeout");
        this._userPreferenceHandler = new RestUserPreferenceHandler(preferenceOperationTimeout == null ? 10000L : preferenceOperationTimeout);
    }

    private Collection<ConfiguredObject<?>> getTargetObjects(Class<? extends ConfiguredObject> configuredClass, ConfiguredObjectFinder finder, RequestInfo requestInfo, List<Predicate<ConfiguredObject<?>>> filterPredicateList) {
        List<String> names = requestInfo.getModelParts();
        Collection targetObjects = finder.findObjectsFromPath(names, finder.getHierarchy(configuredClass), true);
        if (targetObjects != null && !filterPredicateList.isEmpty()) {
            Iterator iter = targetObjects.iterator();
            block0: while (iter.hasNext()) {
                ConfiguredObject obj = (ConfiguredObject)iter.next();
                for (Predicate<ConfiguredObject<?>> predicate : filterPredicateList) {
                    if (predicate.apply((Object)obj)) continue;
                    iter.remove();
                    continue block0;
                }
            }
        }
        return targetObjects;
    }

    private List<Predicate<ConfiguredObject<?>>> buildFilterPredicates(HttpServletRequest request) {
        ArrayList<1> predicates = new ArrayList<1>();
        for (final String paramName : Collections.list(request.getParameterNames())) {
            if (RESERVED_PARAMS.contains(paramName)) continue;
            final List<String> allowedValues = Arrays.asList(request.getParameterValues(paramName));
            predicates.add(new Predicate<ConfiguredObject<?>>(){

                public boolean apply(ConfiguredObject<?> obj) {
                    Object value = obj.getAttribute(paramName);
                    return allowedValues.contains(String.valueOf(value));
                }
            });
        }
        return Collections.unmodifiableList(predicates);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws ServletException, IOException {
        ConfiguredObjectFinder finder = this.getConfiguredObjectFinder(managedObject);
        Class<? extends ConfiguredObject> configuredClass = this.getConfiguredClass(request, managedObject);
        if (configuredClass == null) {
            this.sendError(response, 404);
            return;
        }
        Class[] hierarchy = finder.getHierarchy(configuredClass);
        if (hierarchy == null) {
            this.sendError(response, 404);
            return;
        }
        RequestInfoParser requestInfoParser = new RequestInfoParser(hierarchy);
        RequestInfo requestInfo = requestInfoParser.parse(request);
        switch (requestInfo.getType()) {
            case OPERATION: {
                this.doOperation(requestInfo, managedObject, configuredClass, finder, request, response);
                break;
            }
            case MODEL_OBJECT: {
                Object responseObject;
                boolean singleObjectRequest;
                String attachmentFilename = request.getParameter("contentDispositionAttachmentFilename");
                if (attachmentFilename != null) {
                    this.setContentDispositionHeaderIfNecessary(response, attachmentFilename);
                }
                List<Predicate<ConfiguredObject<?>>> filterPredicateList = this.buildFilterPredicates(request);
                Collection<ConfiguredObject<?>> allObjects = this.getTargetObjects(configuredClass, finder, requestInfo, filterPredicateList);
                boolean bl = singleObjectRequest = requestInfo.isSingletonRequest() && filterPredicateList.isEmpty();
                if (allObjects == null || allObjects.isEmpty() && singleObjectRequest) {
                    this.sendJsonErrorResponse(request, response, 404, "Not Found");
                    return;
                }
                int depth = this.getIntParameterFromRequest(request, DEPTH_PARAM, 0);
                int oversizeThreshold = this.getIntParameterFromRequest(request, OVERSIZE_PARAM, 120);
                boolean actuals = this.getBooleanParameterFromRequest(request, ACTUALS_PARAM);
                String excludeInheritedContextParameter = request.getParameter(EXCLUDE_INHERITED_CONTEXT_PARAM);
                boolean excludeInheritedContext = excludeInheritedContextParameter == null || Boolean.parseBoolean(excludeInheritedContextParameter);
                boolean responseAsList = Boolean.parseBoolean(request.getParameter(SINGLETON_MODEL_OBJECT_RESPONSE_AS_LIST));
                if (!responseAsList && singleObjectRequest) {
                    if (allObjects.size() != 1) {
                        throw new IllegalStateException(String.format("Unexpected number of objects found [%d] for singleton request URI '%s'", allObjects.size(), request.getRequestURI()));
                    }
                    ConfiguredObject<?> singletonObject = allObjects.iterator().next();
                    responseObject = this._objectConverter.convertObjectToMap(singletonObject, configuredClass, new ConfiguredObjectToMapConverter.ConverterOptions(depth, actuals, oversizeThreshold, request.isSecure(), excludeInheritedContext));
                } else {
                    ArrayList<Map<String, Object>> outputList = new ArrayList<Map<String, Object>>();
                    for (ConfiguredObject<?> configuredObject : allObjects) {
                        outputList.add(this._objectConverter.convertObjectToMap(configuredObject, configuredClass, new ConfiguredObjectToMapConverter.ConverterOptions(depth, actuals, oversizeThreshold, request.isSecure(), excludeInheritedContext)));
                    }
                    responseObject = outputList;
                }
                boolean sendCachingHeaders = attachmentFilename == null;
                this.sendJsonResponse(responseObject, request, response, 200, sendCachingHeaders);
                break;
            }
            case VISIBLE_PREFERENCES: 
            case USER_PREFERENCES: {
                this.doGetUserPreferences(managedObject, configuredClass, finder, requestInfo, request, response);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected request type '%s' for path '%s'", new Object[]{requestInfo.getType(), request.getPathInfo()}));
            }
        }
    }

    private boolean isSingleObjectRequest(RequestInfo requestInfo, Class<? extends ConfiguredObject>[] hierarchy) {
        if (hierarchy.length > 0) {
            List<String> pathInfoElements = requestInfo.getModelParts();
            return pathInfoElements.size() == hierarchy.length;
        }
        return false;
    }

    private Class<? extends ConfiguredObject> getConfiguredClass(HttpServletRequest request, ConfiguredObject<?> managedObject) {
        String[] servletPathElements = request.getServletPath().split("/");
        String categoryName = servletPathElements[servletPathElements.length - 1];
        Model model = managedObject.getModel();
        for (Class category : model.getSupportedCategories()) {
            if (!category.getSimpleName().toLowerCase().equals(categoryName)) continue;
            return category;
        }
        return null;
    }

    @Override
    protected void doPut(HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws ServletException, IOException {
        this.performCreateOrUpdate(request, response, managedObject);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            super.service(request, response);
        }
        catch (Exception | NoClassDefFoundError e) {
            this.setResponseStatus(request, response, e);
        }
    }

    private void performCreateOrUpdate(HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws IOException, ServletException {
        ConfiguredObjectFinder finder = this.getConfiguredObjectFinder(managedObject);
        Class<? extends ConfiguredObject> configuredClass = this.getConfiguredClass(request, managedObject);
        Class[] hierarchy = finder.getHierarchy(configuredClass);
        RequestInfoParser requestInfoParser = new RequestInfoParser(hierarchy);
        response.setContentType("application/json");
        RequestInfo requestInfo = requestInfoParser.parse(request);
        switch (requestInfo.getType()) {
            case MODEL_OBJECT: {
                List<String> names = requestInfo.getModelParts();
                boolean isFullObjectURL = names.size() == hierarchy.length;
                Map<String, Object> providedObject = this.getRequestProvidedObject(request, requestInfo);
                if (names.isEmpty() && hierarchy.length == 0) {
                    managedObject.setAttributes(providedObject);
                    response.setStatus(200);
                    return;
                }
                ConfiguredObject theParent = managedObject;
                Class<? extends ConfiguredObject> objClass = configuredClass;
                if (hierarchy.length > 1) {
                    theParent = finder.findObjectParentsFromPath(names, hierarchy, configuredClass);
                }
                if (isFullObjectURL) {
                    String name = names.get(names.size() - 1);
                    ConfiguredObject configuredObject = theParent.getChildByName(objClass, name);
                    if (configuredObject != null) {
                        configuredObject.setAttributes(providedObject);
                        response.setStatus(200);
                        return;
                    }
                    if ("POST".equalsIgnoreCase(request.getMethod())) {
                        this.sendJsonErrorResponse(request, response, 404, String.format("%s '%s' not found", configuredClass.getSimpleName(), name));
                        return;
                    }
                    providedObject.put("name", name);
                }
                ConfiguredObject configuredObject = theParent.createChild(objClass, providedObject);
                StringBuffer requestURL = request.getRequestURL();
                if (!isFullObjectURL) {
                    requestURL.append("/").append(configuredObject.getName());
                }
                response.setHeader("Location", requestURL.toString());
                response.setStatus(201);
                break;
            }
            case OPERATION: {
                this.doOperation(requestInfo, managedObject, configuredClass, finder, request, response);
                break;
            }
            case USER_PREFERENCES: {
                this.doPostOrPutUserPreference(requestInfo, managedObject, configuredClass, finder, request, response);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected request type '%s' for path '%s'", new Object[]{requestInfo.getType(), request.getPathInfo()}));
            }
        }
    }

    private void doGetUserPreferences(ConfiguredObject<?> managedObject, Class<? extends ConfiguredObject> configuredClass, ConfiguredObjectFinder finder, RequestInfo requestInfo, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Object responseObject;
        Collection<ConfiguredObject<?>> allObjects = this.getTargetObjects(configuredClass, finder, requestInfo, Collections.emptyList());
        if (allObjects == null || allObjects.isEmpty() && this.isSingleObjectRequest(requestInfo, finder.getHierarchy(configuredClass))) {
            this.sendJsonErrorResponse(request, response, 404, "Not Found");
            return;
        }
        if (requestInfo.hasWildcard()) {
            responseObject = new ArrayList(allObjects.size());
            for (ConfiguredObject<?> target : allObjects) {
                UserPreferences userPreferences = target.getUserPreferences();
                try {
                    Object preferences = this._userPreferenceHandler.handleGET(userPreferences, requestInfo);
                    if (preferences == null || preferences instanceof Collection && ((Collection)preferences).isEmpty() || preferences instanceof Map && ((Map)preferences).isEmpty()) continue;
                    ((List)responseObject).add(preferences);
                }
                catch (NotFoundException notFoundException) {}
            }
        } else {
            ConfiguredObject<?> target = allObjects.iterator().next();
            UserPreferences userPreferences = target.getUserPreferences();
            responseObject = this._userPreferenceHandler.handleGET(userPreferences, requestInfo);
        }
        this.sendJsonResponse(responseObject, request, response);
    }

    private void doPostOrPutUserPreference(RequestInfo requestInfo, ConfiguredObject<?> managedObject, Class<? extends ConfiguredObject> configuredClass, ConfiguredObjectFinder finder, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ConfiguredObject<?> target = this.getTarget(requestInfo, managedObject, configuredClass, finder);
        Object providedObject = this.getRequestProvidedObject(request, requestInfo, Object.class);
        if ("POST".equals(request.getMethod())) {
            this._userPreferenceHandler.handlePOST(target, requestInfo, providedObject);
        } else if ("PUT".equals(request.getMethod())) {
            this._userPreferenceHandler.handlePUT(target, requestInfo, providedObject);
        } else {
            this.sendJsonErrorResponse(request, response, 500, "unexpected http method");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOperation(RequestInfo requestInfo, ConfiguredObject<?> managedObject, Class<? extends ConfiguredObject> configuredClass, ConfiguredObjectFinder finder, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Map<String, Object> operationArguments;
        ConfiguredObject<?> target = this.getTarget(requestInfo, managedObject, configuredClass, finder);
        if (target == null) {
            return;
        }
        String operationName = requestInfo.getOperationName();
        Map availableOperations = managedObject.getModel().getTypeRegistry().getOperations(target.getClass());
        ConfiguredObjectOperation operation = (ConfiguredObjectOperation)availableOperations.get(operationName);
        String requestMethod = request.getMethod();
        if (operation == null) {
            this.sendJsonErrorResponse(request, response, 404, "No such operation: " + operationName);
            return;
        }
        switch (requestMethod) {
            case "GET": {
                if (operation.isNonModifying()) {
                    operationArguments = this.getOperationArgumentsAsMap(request);
                    operationArguments.keySet().removeAll(Arrays.asList("contentDispositionAttachmentFilename"));
                    break;
                }
                response.addHeader("Allow", "POST");
                this.sendJsonErrorResponse(request, response, 405, "Operation " + operationName + " modifies the object so you must use POST.");
                return;
            }
            case "POST": {
                operationArguments = this.getRequestProvidedObject(request, requestInfo);
                break;
            }
            default: {
                response.addHeader("Allow", operation.isNonModifying() ? "POST, GET" : "POST");
                this.sendJsonErrorResponse(request, response, 405, "Operation " + operationName + " does not support the " + requestMethod + " requestMethod.");
                return;
            }
        }
        if (operation.isSecure(target, operationArguments) && !request.isSecure() && !HttpManagementUtil.getPort(request).isAllowConfidentialOperationsOnInsecureChannels()) {
            this.sendJsonErrorResponse(request, response, 403, "Operation '" + operationName + "' can only be performed over a secure (HTTPS) connection");
            return;
        }
        Object returnVal = operation.perform(target, operationArguments);
        String attachmentFilename = request.getParameter("contentDispositionAttachmentFilename");
        if (attachmentFilename != null) {
            this.setContentDispositionHeaderIfNecessary(response, attachmentFilename);
        }
        if (returnVal instanceof Content) {
            Content content = (Content)returnVal;
            try {
                this.writeTypedContent(content, request, response);
            }
            finally {
                content.release();
            }
        } else {
            ConfiguredObjectToMapConverter.ConverterOptions converterOptions = new ConfiguredObjectToMapConverter.ConverterOptions(0, false, 120, request.isSecure(), true);
            if (ConfiguredObject.class.isAssignableFrom(operation.getReturnType())) {
                returnVal = this._objectConverter.convertObjectToMap((ConfiguredObject)returnVal, operation.getReturnType(), converterOptions);
            } else if (ConfiguredObjectTypeRegistry.returnsCollectionOfConfiguredObjects((ConfiguredObjectOperation)operation)) {
                ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>();
                for (Object configuredObject : (Collection)returnVal) {
                    output.add(this._objectConverter.convertObjectToMap((ConfiguredObject)configuredObject, ConfiguredObjectTypeRegistry.getCollectionMemberType((ParameterizedType)((ParameterizedType)operation.getGenericReturnType())), converterOptions));
                }
                returnVal = output;
            }
            this.sendJsonResponse(returnVal, request, response);
        }
    }

    private ConfiguredObject<?> getTarget(RequestInfo requestInfo, ConfiguredObject<?> managedObject, Class<? extends ConfiguredObject> configuredClass, ConfiguredObjectFinder finder) throws IOException {
        ConfiguredObject target;
        List<String> names = requestInfo.getModelParts();
        Class[] hierarchy = finder.getHierarchy(configuredClass);
        if (names.isEmpty() && hierarchy.length == 0) {
            target = managedObject;
        } else {
            String name;
            ConfiguredObject theParent = managedObject;
            if (hierarchy.length > 1) {
                ConfiguredObject parent;
                theParent = parent = finder.findObjectParentsFromPath(names, hierarchy, configuredClass);
            }
            if ((target = theParent.getChildByName(configuredClass, name = names.get(names.size() - 1))) == null) {
                String errorMessage = String.format("%s '%s' not found", configuredClass.getSimpleName(), Joiner.on((String)"/").join(names));
                throw new NotFoundException(errorMessage);
            }
        }
        return target;
    }

    private Map<String, Object> getOperationArgumentsAsMap(HttpServletRequest request) {
        HashMap<String, Object> providedObject = new HashMap<String, Object>();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            String[] value = (String[])entry.getValue();
            if (value == null) continue;
            if (value.length > 1) {
                providedObject.put((String)entry.getKey(), Arrays.asList(value));
                continue;
            }
            providedObject.put((String)entry.getKey(), value[0]);
        }
        return providedObject;
    }

    private Map<String, Object> getRequestProvidedObject(HttpServletRequest request, RequestInfo requestInfo) throws IOException, ServletException {
        return this.getRequestProvidedObject(request, requestInfo, LinkedHashMap.class);
    }

    private <T> T getRequestProvidedObject(HttpServletRequest request, RequestInfo requestInfo, Class<T> expectedClass) throws IOException, ServletException {
        Object providedObject;
        ArrayList headers = Collections.list(request.getHeaderNames());
        ObjectMapper mapper = new ObjectMapper();
        if (headers.contains("Content-Type") && request.getHeader("Content-Type").startsWith("multipart/form-data")) {
            providedObject = new LinkedHashMap();
            HashMap<String, String> fileUploads = new HashMap<String, String>();
            Collection parts = request.getParts();
            for (Part part : parts) {
                if ("data".equals(part.getName()) && "application/json".equals(part.getContentType())) {
                    try {
                        providedObject = mapper.readValue(part.getInputStream(), LinkedHashMap.class);
                        continue;
                    }
                    catch (JsonProcessingException e) {
                        throw new IllegalArgumentException("Cannot parse the operation body as json", e);
                    }
                }
                byte[] data = new byte[(int)part.getSize()];
                part.getInputStream().read(data);
                String inlineURL = DataUrlUtils.getDataUrlForBytes((byte[])data);
                fileUploads.put(part.getName(), inlineURL);
            }
            ((Map)providedObject).putAll(fileUploads);
        } else {
            try {
                providedObject = mapper.readValue((InputStream)request.getInputStream(), expectedClass);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Cannot parse the operation body as json", e);
            }
        }
        return (T)providedObject;
    }

    private void setResponseStatus(HttpServletRequest request, HttpServletResponse response, Throwable e) throws IOException {
        if (e instanceof SecurityException) {
            LOGGER.debug("{}, sending {}", new Object[]{e.getClass().getName(), 403, e});
            response.setStatus(403);
        } else {
            int responseCode = 400;
            String message = e.getMessage();
            if (e instanceof AbstractConfiguredObject.DuplicateIdException || e instanceof AbstractConfiguredObject.DuplicateNameException || e instanceof IntegrityViolationException || e instanceof IllegalStateTransitionException) {
                responseCode = 409;
            } else if (e instanceof NotFoundException) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(e.getClass().getSimpleName() + " processing request", e);
                }
                responseCode = 404;
            } else if (e instanceof IllegalConfigurationException || e instanceof IllegalArgumentException) {
                LOGGER.warn("{} processing request {} from user '{}': {}", new Object[]{e.getClass().getSimpleName(), HttpManagementUtil.getRequestURL(request), HttpManagementUtil.getRequestPrincipals(request), message});
                Throwable t = e;
                int maxDepth = 10;
                while ((t = t.getCause()) != null && maxDepth-- != 0) {
                    LOGGER.warn("... caused by " + t.getClass().getSimpleName() + "  : " + t.getMessage());
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(e.getClass().getSimpleName() + " processing request", e);
                }
                responseCode = 422;
            } else if (e instanceof OperationTimeoutException) {
                message = "Timeout occurred";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Timeout during processing of request {} from user '{}'", new Object[]{HttpManagementUtil.getRequestURL(request), HttpManagementUtil.getRequestPrincipals(request), e});
                } else {
                    LOGGER.info("Timeout during processing of request {} from user '{}'", (Object)HttpManagementUtil.getRequestURL(request), (Object)HttpManagementUtil.getRequestPrincipals(request));
                }
                responseCode = 502;
            } else if (e instanceof NoClassDefFoundError) {
                message = "Not found: " + message;
                LOGGER.warn("Unexpected exception processing request ", e);
            } else if (e instanceof ExternalServiceTimeoutException) {
                responseCode = 504;
                LOGGER.warn("External request timeout ", e);
            } else if (e instanceof ExternalServiceException) {
                responseCode = 502;
                LOGGER.warn("External request failed ", e);
            } else {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException("Unexpected Exception", e);
            }
            this.sendJsonErrorResponse(request, response, responseCode, message);
        }
    }

    @Override
    protected void doDelete(HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws ServletException, IOException {
        Class[] hierarchy;
        RequestInfoParser requestInfoParser;
        RequestInfo requestInfo;
        ConfiguredObjectFinder finder = this.getConfiguredObjectFinder(managedObject);
        Class<? extends ConfiguredObject> configuredClass = this.getConfiguredClass(request, managedObject);
        Collection<ConfiguredObject<?>> allObjects = this.getTargetObjects(configuredClass, finder, requestInfo = (requestInfoParser = new RequestInfoParser(hierarchy = finder.getHierarchy(configuredClass))).parse(request), this.buildFilterPredicates(request));
        if (allObjects == null) {
            throw new NotFoundException("Not Found");
        }
        switch (requestInfo.getType()) {
            case MODEL_OBJECT: {
                for (ConfiguredObject<?> o : allObjects) {
                    o.delete();
                }
                this.sendCachingHeadersOnResponse(response);
                response.setStatus(200);
                break;
            }
            case USER_PREFERENCES: {
                if (allObjects.size() > 1) {
                    this.sendJsonErrorResponse(request, response, 400, "Deletion of user preferences using wildcards is unsupported");
                    return;
                }
                for (ConfiguredObject<?> o : allObjects) {
                    this._userPreferenceHandler.handleDELETE(o.getUserPreferences(), requestInfo);
                }
                break;
            }
            default: {
                this.sendJsonErrorResponse(request, response, 400, "Unsupported delete call");
            }
        }
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws ServletException, IOException {
        this.performCreateOrUpdate(request, response, managedObject);
    }

    private int getIntParameterFromRequest(HttpServletRequest request, String paramName, int defaultValue) {
        int intValue = defaultValue;
        String stringValue = request.getParameter(paramName);
        if (stringValue != null) {
            try {
                intValue = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Could not parse " + stringValue + " as integer for parameter " + paramName);
            }
        }
        return intValue;
    }

    private boolean getBooleanParameterFromRequest(HttpServletRequest request, String paramName) {
        return this.getBooleanParameterFromRequest(request, paramName, false);
    }

    private boolean getBooleanParameterFromRequest(HttpServletRequest request, String paramName, boolean defaultValue) {
        String value = request.getParameter(paramName);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }
}

