/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller.latest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.ManagementController;
import org.apache.qpid.server.management.plugin.ManagementException;
import org.apache.qpid.server.management.plugin.ManagementRequest;
import org.apache.qpid.server.management.plugin.ManagementResponse;
import org.apache.qpid.server.management.plugin.RequestType;
import org.apache.qpid.server.management.plugin.ResponseType;
import org.apache.qpid.server.management.plugin.controller.AbstractManagementController;
import org.apache.qpid.server.management.plugin.controller.ControllerManagementResponse;
import org.apache.qpid.server.management.plugin.controller.ConverterHelper;
import org.apache.qpid.server.management.plugin.servlet.rest.ConfiguredObjectToMapConverter;
import org.apache.qpid.server.management.plugin.servlet.rest.NotFoundException;
import org.apache.qpid.server.management.plugin.servlet.rest.RequestInfo;
import org.apache.qpid.server.management.plugin.servlet.rest.RestUserPreferenceHandler;
import org.apache.qpid.server.model.AbstractConfigurationChangeListener;
import org.apache.qpid.server.model.BrokerModel;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectFinder;
import org.apache.qpid.server.model.ConfiguredObjectOperation;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.OperationParameter;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.preferences.UserPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatestManagementController
extends AbstractManagementController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LatestManagementController.class);
    private static final String DEPTH_PARAM = "depth";
    private static final String OVERSIZE_PARAM = "oversize";
    private static final String ACTUALS_PARAM = "actuals";
    private static final String SORT_PARAM = "sort";
    private static final String EXTRACT_INITIAL_CONFIG_PARAM = "extractInitialConfig";
    private static final String EXCLUDE_INHERITED_CONTEXT_PARAM = "excludeInheritedContext";
    private static final String SINGLETON_MODEL_OBJECT_RESPONSE_AS_LIST = "singletonModelObjectResponseAsList";
    private static final Set<String> RESERVED_PARAMS = new HashSet<String>(Arrays.asList("depth", "sort", "oversize", "actuals", "extractInitialConfig", "contentDispositionAttachmentFilename", "excludeInheritedContext", "singletonModelObjectResponseAsList"));
    private static final int DEFAULT_DEPTH = 0;
    private static final int DEFAULT_OVERSIZE = 120;
    private static final Class<? extends ConfiguredObject>[] EMPTY_HIERARCHY = new Class[0];
    private final ConcurrentMap<ConfiguredObject<?>, ConfiguredObjectFinder> _configuredObjectFinders = new ConcurrentHashMap();
    private final Set<String> _supportedCategories;
    private final ConfiguredObjectToMapConverter _objectConverter = new ConfiguredObjectToMapConverter();
    private final RestUserPreferenceHandler _userPreferenceHandler;

    LatestManagementController(HttpManagementConfiguration<?> httpManagement) {
        Long preferenceOperationTimeout = (Long)httpManagement.getContextValue(Long.class, "qpid.httpManagement.preferenceOperationTimeout");
        this._userPreferenceHandler = new RestUserPreferenceHandler(preferenceOperationTimeout == null ? 10000L : preferenceOperationTimeout);
        this._supportedCategories = Collections.unmodifiableSet(BrokerModel.getInstance().getSupportedCategories().stream().map(Class::getSimpleName).collect(Collectors.toSet()));
    }

    @Override
    public String getVersion() {
        return "7.1";
    }

    public Set<String> getCategories() {
        return this._supportedCategories;
    }

    @Override
    public String getCategoryMapping(String category) {
        return String.format("/api/v%s/%s/", this.getVersion(), category.toLowerCase());
    }

    @Override
    public String getCategory(ConfiguredObject<?> managedObject) {
        return managedObject.getCategoryClass().getSimpleName();
    }

    public List<String> getCategoryHierarchy(ConfiguredObject<?> root, String category) {
        ConfiguredObjectFinder finder = this.getConfiguredObjectFinder(root);
        Class[] hierarchy = finder.getHierarchy(category.toLowerCase());
        if (hierarchy == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(hierarchy).map(Class::getSimpleName).collect(Collectors.toList());
    }

    @Override
    public ManagementController getNextVersionManagementController() {
        return null;
    }

    @Override
    protected RequestType getRequestType(ManagementRequest request) throws ManagementException {
        ConfiguredObject<?> root = request.getRoot();
        if (root == null) {
            String message = String.format("No HTTP Management alias mapping found for '%s'", request.getRequestURL());
            LOGGER.info(message);
            throw ManagementException.createNotFoundManagementException(message);
        }
        ConfiguredObjectFinder finder = this.getConfiguredObjectFinder(root);
        String category = request.getCategory();
        Class<? extends ConfiguredObject> configuredClass = this.getRequestCategoryClass(category, root.getModel());
        Class<? extends ConfiguredObject>[] hierarchy = this.getHierarchy(finder, configuredClass);
        return this.getManagementRequestType(request.getMethod(), category, request.getPath(), hierarchy);
    }

    @Override
    public Object get(ConfiguredObject<?> root, String category, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        try {
            Predicate<ConfiguredObject<?>> filterPredicate = this.buildFilterPredicates(parameters);
            boolean singleObjectRequest = this.isFullPath(root, path, category) && !this.hasFilter(parameters);
            Collection<ConfiguredObject<?>> allObjects = this.getTargetObjects(root, category, path, filterPredicate);
            if (singleObjectRequest) {
                if (allObjects.isEmpty()) {
                    throw ManagementException.createNotFoundManagementException("Not Found");
                }
                if (allObjects.size() != 1) {
                    throw ManagementException.createBadRequestManagementException(String.format("Unexpected number of objects found [%d] for singleton request URI '%s'", allObjects.size(), ManagementException.getRequestURI(path, this.getCategoryMapping(category))));
                }
                return allObjects.iterator().next();
            }
            return allObjects;
        }
        catch (RuntimeException e) {
            throw ManagementException.toManagementException(e, this.getCategoryMapping(category), path);
        }
        catch (Error e) {
            throw ManagementException.handleError(e);
        }
    }

    public ConfiguredObject<?> createOrUpdate(ConfiguredObject<?> root, String category, List<String> path, Map<String, Object> providedObject, boolean isPost) throws ManagementException {
        try {
            boolean isFullObjectURL;
            Collection hierarchy = this.getCategoryHierarchy(root, category);
            if (path.isEmpty() && hierarchy.size() == 0) {
                root.setAttributes(providedObject);
                return null;
            }
            Class<? extends ConfiguredObject> categoryClass = this.getRequestCategoryClass(category, root.getModel());
            ConfiguredObject theParent = root;
            if (hierarchy.size() > 1) {
                ConfiguredObjectFinder finder = this.getConfiguredObjectFinder(root);
                theParent = finder.findObjectParentsFromPath(path, (Class[])this.getHierarchy(finder, categoryClass), categoryClass);
            }
            boolean bl = isFullObjectURL = path.size() == hierarchy.size();
            if (isFullObjectURL) {
                String name = path.get(path.size() - 1);
                ConfiguredObject configuredObject = theParent.getChildByName(categoryClass, name);
                if (configuredObject != null) {
                    configuredObject.setAttributes(providedObject);
                    return null;
                }
                if (isPost) {
                    throw ManagementException.createNotFoundManagementException(String.format("%s '%s' not found", categoryClass.getSimpleName(), name));
                }
                providedObject.put("name", name);
            }
            return theParent.createChild(categoryClass, providedObject);
        }
        catch (RuntimeException e) {
            throw ManagementException.toManagementException(e, this.getCategoryMapping(category), path);
        }
        catch (Error e) {
            throw ManagementException.handleError(e);
        }
    }

    @Override
    public int delete(ConfiguredObject<?> root, String category, List<String> names, Map<String, List<String>> parameters) throws ManagementException {
        int counter = 0;
        try {
            Predicate<ConfiguredObject<?>> filterPredicate = this.buildFilterPredicates(parameters);
            Collection<ConfiguredObject<?>> allObjects = this.getTargetObjects(root, category, names, filterPredicate);
            if (allObjects.isEmpty()) {
                throw ManagementException.createNotFoundManagementException("Not Found");
            }
            for (ConfiguredObject<?> o : allObjects) {
                o.delete();
                ++counter;
            }
        }
        catch (RuntimeException e) {
            throw ManagementException.toManagementException(e, this.getCategoryMapping(category), names);
        }
        catch (Error e) {
            throw ManagementException.handleError(e);
        }
        return counter;
    }

    @Override
    public ManagementResponse invoke(ConfiguredObject<?> root, String category, List<String> names, String operationName, Map<String, Object> operationArguments, boolean isPost, boolean isSecureOrAllowedOnInsecureChannel) throws ManagementException {
        Object returnValue;
        ResponseType responseType = ResponseType.DATA;
        try {
            Map<String, Object> arguments;
            ConfiguredObject<?> target = this.getTarget(root, category, names);
            Map availableOperations = root.getModel().getTypeRegistry().getOperations(target.getClass());
            ConfiguredObjectOperation operation = (ConfiguredObjectOperation)availableOperations.get(operationName);
            if (operation == null) {
                throw ManagementException.createNotFoundManagementException(String.format("No such operation '%s' in '%s'", operationName, category));
            }
            if (isPost) {
                arguments = operationArguments;
            } else {
                Set supported = operation.getParameters().stream().map(OperationParameter::getName).collect(Collectors.toSet());
                arguments = operationArguments.entrySet().stream().filter(e -> !RESERVED_PARAMS.contains(e.getKey()) || supported.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            if (operation.isSecure(target, arguments) && !isSecureOrAllowedOnInsecureChannel) {
                throw ManagementException.createForbiddenManagementException(String.format("Operation '%s' can only be performed over a secure (HTTPS) connection", operationName));
            }
            if (!isPost && !operation.isNonModifying()) {
                throw ManagementException.createNotAllowedManagementException(String.format("Operation '%s' modifies the object so you must use POST.", operationName), Collections.singletonMap("Allow", "POST"));
            }
            returnValue = operation.perform(target, arguments);
            if (ConfiguredObject.class.isAssignableFrom(operation.getReturnType()) || ConfiguredObjectTypeRegistry.returnsCollectionOfConfiguredObjects((ConfiguredObjectOperation)operation)) {
                responseType = ResponseType.MODEL_OBJECT;
            }
        }
        catch (RuntimeException e2) {
            throw ManagementException.toManagementException(e2, this.getCategoryMapping(category), names);
        }
        catch (Error e3) {
            throw ManagementException.handleError(e3);
        }
        return new ControllerManagementResponse(responseType, returnValue);
    }

    @Override
    public Object getPreferences(ConfiguredObject<?> root, String category, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        Object responseObject;
        try {
            Collection hierarchy = this.getCategoryHierarchy((ConfiguredObject)root, category);
            Collection<ConfiguredObject<?>> allObjects = this.getTargetObjects(root, category, path, null);
            if (allObjects.isEmpty() && this.isFullPath(root, path, category)) {
                throw ManagementException.createNotFoundManagementException("Not Found");
            }
            RequestInfo requestInfo = RequestInfo.createPreferencesRequestInfo(path.subList(0, hierarchy.size()), path.subList(hierarchy.size() + 1, path.size()), parameters);
            if (path.contains("*")) {
                ArrayList<Object> preferencesList = new ArrayList<Object>(allObjects.size());
                responseObject = preferencesList;
                for (ConfiguredObject<?> target : allObjects) {
                    try {
                        UserPreferences userPreferences = target.getUserPreferences();
                        Object preferences = this._userPreferenceHandler.handleGET(userPreferences, requestInfo);
                        if (preferences == null || preferences instanceof Collection && ((Collection)preferences).isEmpty() || preferences instanceof Map && ((Map)preferences).isEmpty()) continue;
                        preferencesList.add(preferences);
                    }
                    catch (NotFoundException notFoundException) {}
                }
            } else {
                ConfiguredObject<?> target = allObjects.iterator().next();
                UserPreferences userPreferences = target.getUserPreferences();
                responseObject = this._userPreferenceHandler.handleGET(userPreferences, requestInfo);
            }
        }
        catch (RuntimeException e) {
            throw ManagementException.toManagementException(e, this.getCategoryMapping(category), path);
        }
        catch (Error e) {
            throw ManagementException.handleError(e);
        }
        return responseObject;
    }

    @Override
    public void setPreferences(ConfiguredObject<?> root, String category, List<String> path, Object providedObject, Map<String, List<String>> parameters, boolean isPost) throws ManagementException {
        try {
            Collection hierarchy = this.getCategoryHierarchy((ConfiguredObject)root, category);
            RequestInfo requestInfo = RequestInfo.createPreferencesRequestInfo(path.subList(0, hierarchy.size()), path.subList(hierarchy.size() + 1, path.size()), parameters);
            ConfiguredObject<?> target = this.getTarget(root, category, requestInfo.getModelParts());
            if (isPost) {
                this._userPreferenceHandler.handlePOST(target, requestInfo, providedObject);
            } else {
                this._userPreferenceHandler.handlePUT(target, requestInfo, providedObject);
            }
        }
        catch (RuntimeException e) {
            throw ManagementException.toManagementException(e, this.getCategoryMapping(category), path);
        }
        catch (Error e) {
            throw ManagementException.handleError(e);
        }
    }

    @Override
    public int deletePreferences(ConfiguredObject<?> root, String category, List<String> names, Map<String, List<String>> parameters) throws ManagementException {
        int counter = 0;
        try {
            Collection hierarchy = this.getCategoryHierarchy((ConfiguredObject)root, category);
            RequestInfo requestInfo = RequestInfo.createPreferencesRequestInfo(names.subList(0, hierarchy.size()), names.subList(hierarchy.size() + 1, names.size()), parameters);
            Collection<ConfiguredObject<?>> objects = this.getTargetObjects(root, category, requestInfo.getModelParts(), this.buildFilterPredicates(parameters));
            if (objects == null) {
                throw ManagementException.createNotFoundManagementException("Not Found");
            }
            if (objects.size() > 1) {
                throw ManagementException.createBadRequestManagementException("Deletion of user preferences using wildcards is unsupported");
            }
            for (ConfiguredObject<?> o : objects) {
                this._userPreferenceHandler.handleDELETE(o.getUserPreferences(), requestInfo);
                ++counter;
            }
        }
        catch (RuntimeException e) {
            throw ManagementException.toManagementException(e, this.getCategoryMapping(category), names);
        }
        catch (Error e) {
            throw ManagementException.handleError(e);
        }
        return counter;
    }

    @Override
    public Object formatConfiguredObject(Object content, Map<String, List<String>> parameters, boolean isSecureOrAllowedOnInsecureChannel) {
        int depth = ConverterHelper.getIntParameterFromRequest(parameters, DEPTH_PARAM, 0);
        int oversizeThreshold = ConverterHelper.getIntParameterFromRequest(parameters, OVERSIZE_PARAM, 120);
        boolean actuals = Boolean.parseBoolean(ConverterHelper.getParameter(ACTUALS_PARAM, parameters));
        String excludeInheritedContextParameter = ConverterHelper.getParameter(EXCLUDE_INHERITED_CONTEXT_PARAM, parameters);
        boolean excludeInheritedContext = excludeInheritedContextParameter == null || Boolean.parseBoolean(excludeInheritedContextParameter);
        boolean responseAsList = Boolean.parseBoolean(ConverterHelper.getParameter(SINGLETON_MODEL_OBJECT_RESPONSE_AS_LIST, parameters));
        if (content instanceof ConfiguredObject) {
            Map<String, Object> object = this.convertObject((ConfiguredObject)content, depth, actuals, oversizeThreshold, isSecureOrAllowedOnInsecureChannel, excludeInheritedContext);
            return responseAsList ? Collections.singletonList(object) : object;
        }
        if (content instanceof Collection) {
            Collection results = ((Collection)content).stream().filter(o -> o instanceof ConfiguredObject).map(ConfiguredObject.class::cast).map(o -> this.convertObject((ConfiguredObject<?>)o, depth, actuals, oversizeThreshold, isSecureOrAllowedOnInsecureChannel, excludeInheritedContext)).collect(Collectors.toSet());
            if (!results.isEmpty()) {
                return results;
            }
        }
        return content;
    }

    private Map<String, Object> convertObject(ConfiguredObject<?> configuredObject, int depth, boolean actuals, int oversizeThreshold, boolean isSecureOrConfidentialOperationAllowedOnInsecureChannel, boolean excludeInheritedContext) {
        return this._objectConverter.convertObjectToMap(configuredObject, configuredObject.getCategoryClass(), new ConfiguredObjectToMapConverter.ConverterOptions(depth, actuals, oversizeThreshold, isSecureOrConfidentialOperationAllowedOnInsecureChannel, excludeInheritedContext));
    }

    private boolean isFullPath(ConfiguredObject root, List<String> parts, String category) {
        Collection hierarchy = this.getCategoryHierarchy(root, category);
        return parts.size() == hierarchy.size() && !parts.contains("*");
    }

    private ConfiguredObjectFinder getConfiguredObjectFinder(final ConfiguredObject<?> root) {
        ConfiguredObjectFinder finder = (ConfiguredObjectFinder)this._configuredObjectFinders.get(root);
        if (finder == null) {
            finder = new ConfiguredObjectFinder(root);
            ConfiguredObjectFinder existingValue = this._configuredObjectFinders.putIfAbsent(root, finder);
            if (existingValue != null) {
                finder = existingValue;
            } else {
                AbstractConfigurationChangeListener deletionListener = new AbstractConfigurationChangeListener(){

                    public void stateChanged(ConfiguredObject<?> object, State oldState, State newState) {
                        if (newState == State.DELETED) {
                            LatestManagementController.this._configuredObjectFinders.remove(root);
                        }
                    }
                };
                root.addChangeListener((ConfigurationChangeListener)deletionListener);
                if (root.getState() == State.DELETED) {
                    this._configuredObjectFinders.remove(root);
                    root.removeChangeListener((ConfigurationChangeListener)deletionListener);
                }
            }
        }
        return finder;
    }

    private Collection<ConfiguredObject<?>> getTargetObjects(ConfiguredObject<?> root, String category, List<String> path, Predicate<ConfiguredObject<?>> filterPredicate) {
        Class<? extends ConfiguredObject> configuredClass;
        ConfiguredObjectFinder finder = this.getConfiguredObjectFinder(root);
        Collection<Object> targetObjects = finder.findObjectsFromPath(path, (Class[])this.getHierarchy(finder, configuredClass = this.getRequestCategoryClass(category, root.getModel())), true);
        if (targetObjects == null) {
            targetObjects = Collections.emptySet();
        } else if (filterPredicate != null) {
            targetObjects = targetObjects.stream().filter(filterPredicate).collect(Collectors.toList());
        }
        return targetObjects;
    }

    private Class<? extends ConfiguredObject>[] getHierarchy(ConfiguredObjectFinder finder, Class<? extends ConfiguredObject> configuredClass) {
        Class[] hierarchy = finder.getHierarchy(configuredClass);
        if (hierarchy == null) {
            return EMPTY_HIERARCHY;
        }
        return hierarchy;
    }

    private RequestType getManagementRequestType(String method, String categoryName, List<String> parts, Class<? extends ConfiguredObject>[] hierarchy) {
        String servletPath = this.getCategoryMapping(categoryName);
        if ("POST".equals(method)) {
            return this.getPostRequestType(parts, hierarchy, servletPath);
        }
        if ("PUT".equals(method)) {
            return this.getPutRequestType(parts, hierarchy, servletPath);
        }
        if ("GET".equals(method)) {
            return this.getGetRequestType(parts, hierarchy, servletPath);
        }
        if ("DELETE".equals(method)) {
            return this.getDeleteRequestType(parts, hierarchy, servletPath);
        }
        throw ManagementException.createBadRequestManagementException(String.format("Unexpected method type '%s' for path '%s/%s'", method, servletPath, String.join((CharSequence)"/", parts)));
    }

    private RequestType getDeleteRequestType(List<String> parts, Class<? extends ConfiguredObject>[] hierarchy, String servletPath) {
        if (parts.size() <= hierarchy.length) {
            return RequestType.MODEL_OBJECT;
        }
        if ("userpreferences".equals(parts.get(hierarchy.length))) {
            return RequestType.USER_PREFERENCES;
        }
        String expectedPath = this.buildExpectedPath(servletPath, Arrays.asList(hierarchy));
        throw ManagementException.createBadRequestManagementException(String.format("Invalid DELETE path '%s/%s'. Expected: '%s' or '%s/userpreferences[/<preference type>[/<preference name>]]'", servletPath, String.join((CharSequence)"/", parts), expectedPath, expectedPath));
    }

    private RequestType getGetRequestType(List<String> parts, Class<? extends ConfiguredObject>[] hierarchy, String servletPath) {
        if (parts.size() <= hierarchy.length) {
            return RequestType.MODEL_OBJECT;
        }
        if ("userpreferences".equals(parts.get(hierarchy.length))) {
            return RequestType.USER_PREFERENCES;
        }
        if ("visiblepreferences".equals(parts.get(hierarchy.length))) {
            return RequestType.VISIBLE_PREFERENCES;
        }
        if (parts.size() == hierarchy.length + 1) {
            return RequestType.OPERATION;
        }
        String expectedPath = this.buildExpectedPath(servletPath, Arrays.asList(hierarchy));
        throw new IllegalArgumentException(String.format("Invalid GET path '%s/%s'. Expected: '%s[/<operation name>]'", servletPath, String.join((CharSequence)"/", parts), expectedPath));
    }

    private RequestType getPutRequestType(List<String> parts, Class<? extends ConfiguredObject>[] hierarchy, String servletPath) {
        if (parts.size() == hierarchy.length || parts.size() == hierarchy.length - 1) {
            return RequestType.MODEL_OBJECT;
        }
        if (parts.size() > hierarchy.length && "userpreferences".equals(parts.get(hierarchy.length))) {
            return RequestType.USER_PREFERENCES;
        }
        String expectedPath = this.buildExpectedPath(servletPath, Arrays.asList(hierarchy));
        throw ManagementException.createBadRequestManagementException(String.format("Invalid PUT path '%s/%s'. Expected: '%s'", servletPath, String.join((CharSequence)"/", parts), expectedPath));
    }

    private RequestType getPostRequestType(List<String> parts, Class<? extends ConfiguredObject>[] hierarchy, String servletPath) {
        if (parts.size() == hierarchy.length || parts.size() == hierarchy.length - 1) {
            return RequestType.MODEL_OBJECT;
        }
        if (parts.size() > hierarchy.length) {
            if ("userpreferences".equals(parts.get(hierarchy.length))) {
                return RequestType.USER_PREFERENCES;
            }
            if (parts.size() == hierarchy.length + 1 && !"visiblepreferences".equals(parts.get(hierarchy.length))) {
                return RequestType.OPERATION;
            }
        }
        List<Class<? extends ConfiguredObject>> hierarchyList = Arrays.asList(hierarchy);
        String expectedFullPath = this.buildExpectedPath(servletPath, hierarchyList);
        String expectedParentPath = this.buildExpectedPath(servletPath, hierarchyList.subList(0, hierarchy.length - 1));
        throw ManagementException.createBadRequestManagementException(String.format("Invalid POST path '%s/%s'. Expected: '%s/<operation name>' or '%s' or '%s/userpreferences[/<preference type>]'", servletPath, String.join((CharSequence)"/", parts), expectedFullPath, expectedParentPath, expectedFullPath));
    }

    private Class<? extends ConfiguredObject> getRequestCategoryClass(String categoryName, Model model) {
        for (Class category : model.getSupportedCategories()) {
            if (!category.getSimpleName().toLowerCase().equals(categoryName.toLowerCase())) continue;
            return category;
        }
        throw ManagementException.createNotFoundManagementException(String.format("Category is not found for '%s'", categoryName));
    }

    private String buildExpectedPath(String servletPath, List<Class<? extends ConfiguredObject>> hierarchy) {
        StringBuilder expectedPath = new StringBuilder(servletPath);
        for (Class<? extends ConfiguredObject> part : hierarchy) {
            expectedPath.append("/<");
            expectedPath.append(part.getSimpleName().toLowerCase());
            expectedPath.append(" name>");
        }
        return expectedPath.toString();
    }

    private Predicate<ConfiguredObject<?>> buildFilterPredicates(Map<String, List<String>> parameters) {
        return parameters.entrySet().stream().filter(entry -> !RESERVED_PARAMS.contains(entry.getKey())).map(entry -> {
            String paramName = (String)entry.getKey();
            List allowedValues = (List)entry.getValue();
            return object -> {
                Object value = object.getAttribute(paramName);
                return allowedValues.contains(String.valueOf(value));
            };
        }).reduce(Predicate::and).orElse(t -> true);
    }

    private ConfiguredObject<?> getTarget(ConfiguredObject<?> root, String category, List<String> names) {
        ConfiguredObject target;
        Class<? extends ConfiguredObject> configuredClass = this.getRequestCategoryClass(category, root.getModel());
        ConfiguredObjectFinder finder = this.getConfiguredObjectFinder(root);
        Class[] hierarchy = this.getHierarchy(finder, configuredClass);
        if (names.isEmpty() && hierarchy.length == 0) {
            target = root;
        } else {
            String name;
            ConfiguredObject theParent = root;
            if (hierarchy.length > 1) {
                theParent = finder.findObjectParentsFromPath(names, hierarchy, configuredClass);
            }
            if ((target = theParent.getChildByName(configuredClass, name = names.get(names.size() - 1))) == null) {
                String errorMessage = String.format("%s '%s' not found", configuredClass.getSimpleName(), String.join((CharSequence)"/", names));
                throw ManagementException.createNotFoundManagementException(errorMessage);
            }
        }
        return target;
    }

    private boolean hasFilter(Map<String, List<String>> parameters) {
        return parameters.keySet().stream().anyMatch(parameter -> !RESERVED_PARAMS.contains(parameter));
    }
}

