/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSessionContext;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.logging.messages.ManagementConsoleMessages;
import org.apache.qpid.server.logging.messages.PortMessages;
import org.apache.qpid.server.management.plugin.DojoHelper;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.ManagementController;
import org.apache.qpid.server.management.plugin.ManagementControllerFactory;
import org.apache.qpid.server.management.plugin.RewriteServlet;
import org.apache.qpid.server.management.plugin.filter.AuthenticationCheckFilter;
import org.apache.qpid.server.management.plugin.filter.ExceptionHandlingFilter;
import org.apache.qpid.server.management.plugin.filter.ForbiddingTraceFilter;
import org.apache.qpid.server.management.plugin.filter.InteractiveAuthenticationFilter;
import org.apache.qpid.server.management.plugin.filter.LoggingFilter;
import org.apache.qpid.server.management.plugin.filter.RedirectFilter;
import org.apache.qpid.server.management.plugin.filter.RewriteRequestForUncompressedJavascript;
import org.apache.qpid.server.management.plugin.portunification.TlsOrPlainConnectionFactory;
import org.apache.qpid.server.management.plugin.servlet.FileServlet;
import org.apache.qpid.server.management.plugin.servlet.RootServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.ApiDocsServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.BrokerQueryServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.JsonValueServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.LogoutServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.MetaDataServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.QueueReportServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.RestServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.SaslServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.StructureServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.TimeZoneServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.VirtualHostQueryServlet;
import org.apache.qpid.server.model.AbstractConfigurationChangeListener;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.adapter.AbstractPluginAdapter;
import org.apache.qpid.server.model.port.HttpPort;
import org.apache.qpid.server.model.port.PortManager;
import org.apache.qpid.server.transport.PortBindFailureException;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.server.util.DaemonThreadFactory;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(category=false, type="MANAGEMENT-HTTP")
public class HttpManagement
extends AbstractPluginAdapter<HttpManagement>
implements HttpManagementConfiguration<HttpManagement>,
PortManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpManagement.class);
    public static final int DEFAULT_TIMEOUT_IN_SECONDS = 600;
    public static final String TIME_OUT = "sessionTimeout";
    public static final String HTTP_BASIC_AUTHENTICATION_ENABLED = "httpBasicAuthenticationEnabled";
    public static final String HTTPS_BASIC_AUTHENTICATION_ENABLED = "httpsBasicAuthenticationEnabled";
    public static final String HTTP_SASL_AUTHENTICATION_ENABLED = "httpSaslAuthenticationEnabled";
    public static final String HTTPS_SASL_AUTHENTICATION_ENABLED = "httpsSaslAuthenticationEnabled";
    public static final String PLUGIN_TYPE = "MANAGEMENT-HTTP";
    public static final String DEFAULT_LOGOUT_URL = "/logout.html";
    private static final String OPERATIONAL_LOGGING_NAME = "Web";
    private static final String JSESSIONID_COOKIE_PREFIX = "JSESSIONID_";
    private static final String[] STATIC_FILE_TYPES = new String[]{"*.js", "*.css", "*.html", "*.png", "*.gif", "*.jpg", "*.jpeg", "*.json", "*.txt", "*.xsl", "*.svg"};
    private Server _server;
    @ManagedAttributeField
    private boolean _httpsSaslAuthenticationEnabled;
    @ManagedAttributeField
    private boolean _httpSaslAuthenticationEnabled;
    @ManagedAttributeField
    private boolean _httpsBasicAuthenticationEnabled;
    @ManagedAttributeField
    private boolean _httpBasicAuthenticationEnabled;
    @ManagedAttributeField
    private int _sessionTimeout;
    @ManagedAttributeField
    public String _corsAllowOrigins;
    @ManagedAttributeField
    public Set<String> _corsAllowMethods;
    @ManagedAttributeField
    public String _corsAllowHeaders;
    @ManagedAttributeField
    public boolean _corsAllowCredentials;
    @ManagedAttributeField
    private boolean _compressResponses;
    private final Map<HttpPort<?>, ServerConnector> _portConnectorMap = new ConcurrentHashMap();
    private final BrokerChangeListener _brokerChangeListener = new BrokerChangeListener();
    private volatile boolean _serveUncompressedDojo;
    private volatile Long _saslExchangeExpiry;
    private volatile ThreadPoolExecutor _jettyServerExecutor;

    @ManagedObjectFactoryConstructor
    public HttpManagement(Map<String, Object> attributes, Broker broker) {
        super(attributes, broker);
    }

    protected void onOpen() {
        super.onOpen();
        this._serveUncompressedDojo = Boolean.TRUE.equals(this.getContextValue(Boolean.class, "qpid.httpManagement.serveUncompressedDojo"));
        this._saslExchangeExpiry = (Long)this.getContextValue(Long.class, "qpid.httpManagement.saslExchangeExpiry");
        this.getBroker().addChangeListener((ConfigurationChangeListener)this._brokerChangeListener);
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> doStart() {
        Collection<HttpPort<?>> httpPorts = this.getEligibleHttpPorts(this.getBroker().getPorts());
        if (httpPorts.isEmpty()) {
            LOGGER.warn("HttpManagement plugin is configured but no suitable HTTP ports are available.");
        } else {
            this.getBroker().getEventLogger().message(ManagementConsoleMessages.STARTUP((String)OPERATIONAL_LOGGING_NAME));
            this._server = this.createServer(httpPorts);
            try {
                this._server.start();
                this.logOperationalListenMessages();
            }
            catch (PortBindFailureException e) {
                this.getBroker().getEventLogger().message(PortMessages.BIND_FAILED((String)"HTTP", (Number)e.getAddress().getPort()));
                throw e;
            }
            catch (Exception e) {
                throw new ServerScopedRuntimeException("Failed to start HTTP management on ports : " + httpPorts, (Throwable)e);
            }
            this.getBroker().getEventLogger().message(ManagementConsoleMessages.READY((String)OPERATIONAL_LOGGING_NAME));
        }
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    protected ListenableFuture<Void> onClose() {
        this.getBroker().removeChangeListener((ConfigurationChangeListener)this._brokerChangeListener);
        if (this._server != null) {
            try {
                this.logOperationalShutdownMessage();
                this._server.stop();
            }
            catch (Exception e) {
                throw new ServerScopedRuntimeException("Failed to stop HTTP management", (Throwable)e);
            }
        }
        if (this._jettyServerExecutor != null) {
            this._jettyServerExecutor.shutdown();
        }
        this.getBroker().getEventLogger().message(ManagementConsoleMessages.STOPPED((String)OPERATIONAL_LOGGING_NAME));
        return Futures.immediateFuture(null);
    }

    @Override
    public int getSessionTimeout() {
        return this._sessionTimeout;
    }

    @Override
    public String getCorsAllowOrigins() {
        return this._corsAllowOrigins;
    }

    @Override
    public Set<String> getCorsAllowMethods() {
        return this._corsAllowMethods;
    }

    @Override
    public String getCorsAllowHeaders() {
        return this._corsAllowHeaders;
    }

    @Override
    public boolean getCorsAllowCredentials() {
        return this._corsAllowCredentials;
    }

    private Server createServer(Collection<HttpPort<?>> ports) {
        LOGGER.debug("Starting up web server on {}", ports);
        this._jettyServerExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DaemonThreadFactory("Jetty-Server-Thread"));
        Server server = new Server((ThreadPool)new ExecutorThreadPool(this._jettyServerExecutor));
        int lastPort = -1;
        for (HttpPort<?> port : ports) {
            ServerConnector connector = this.createConnector(port, server);
            connector.addBean((Object)new ConnectionTrackingListener());
            server.addConnector((Connector)connector);
            this._portConnectorMap.put(port, connector);
            lastPort = port.getPort();
        }
        ServletContextHandler root = new ServletContextHandler(1);
        root.setContextPath("/");
        root.setCompactPath(true);
        server.setHandler((Handler)root);
        ErrorHandler errorHandler = new ErrorHandler(){

            protected void writeErrorPageBody(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
                String uri = request.getRequestURI();
                this.writeErrorPageMessage(request, writer, code, message, uri);
                for (int i = 0; i < 20; ++i) {
                    writer.write("<br/>                                                \n");
                }
            }
        };
        root.setErrorHandler(errorHandler);
        root.getServletContext().setAttribute("Qpid.broker", (Object)this.getBroker());
        root.getServletContext().setAttribute("Qpid.managementConfiguration", (Object)this);
        root.addFilter(new FilterHolder((Filter)new ExceptionHandlingFilter()), "/*", EnumSet.allOf(DispatcherType.class));
        FilterHolder corsFilter = new FilterHolder((Filter)new CrossOriginFilter());
        corsFilter.setInitParameter("allowedOrigins", this.getCorsAllowOrigins());
        corsFilter.setInitParameter("allowedMethods", Joiner.on((String)",").join(this.getCorsAllowMethods()));
        corsFilter.setInitParameter("allowedHeaders", this.getCorsAllowHeaders());
        corsFilter.setInitParameter("allowCredentials", String.valueOf(this.getCorsAllowCredentials()));
        root.addFilter(corsFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(new FilterHolder((Filter)new ForbiddingTraceFilter()), "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder loggingFilter = new FilterHolder((Filter)new LoggingFilter());
        root.addFilter(loggingFilter, "/api/*", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(loggingFilter, "/service/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder restAuthorizationFilter = new FilterHolder((Filter)new AuthenticationCheckFilter());
        restAuthorizationFilter.setInitParameter("allowed", "/service/sasl");
        root.addFilter(restAuthorizationFilter, "/api/*", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(restAuthorizationFilter, "/apidocs/*", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(restAuthorizationFilter, "/service/*", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(new FilterHolder((Filter)new InteractiveAuthenticationFilter()), "/index.html", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(new FilterHolder((Filter)new InteractiveAuthenticationFilter()), "/", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder redirectFilter = new FilterHolder((Filter)new RedirectFilter());
        redirectFilter.setInitParameter("redirect-uri", "/index.html");
        root.addFilter(redirectFilter, "/login.html", EnumSet.of(DispatcherType.REQUEST));
        if (this._serveUncompressedDojo) {
            root.addFilter(RewriteRequestForUncompressedJavascript.class, "/dojo/dojo/*", EnumSet.of(DispatcherType.REQUEST));
            root.addFilter(RewriteRequestForUncompressedJavascript.class, "/dojo/dojox/*", EnumSet.of(DispatcherType.REQUEST));
        }
        this.addRestServlet(root);
        ServletHolder queryServlet = new ServletHolder((Servlet)new BrokerQueryServlet());
        root.addServlet(queryServlet, "/api/latest/querybroker/*");
        root.addServlet(queryServlet, "/api/v7.1/querybroker/*");
        ServletHolder vhQueryServlet = new ServletHolder((Servlet)new VirtualHostQueryServlet());
        root.addServlet(vhQueryServlet, "/api/latest/queryvhost/*");
        root.addServlet(vhQueryServlet, "/api/v7.1/queryvhost/*");
        ServletHolder apiDocsServlet = new ServletHolder((Servlet)new ApiDocsServlet());
        ServletHolder rewriteSerlvet = new ServletHolder((Servlet)new RewriteServlet("^(.*)$", "$1/"));
        for (String path : new String[]{"/apidocs", "/apidocs/latest", "/apidocs/" + this.getLatestSupportedVersion()}) {
            root.addServlet(rewriteSerlvet, path);
            root.addServlet(apiDocsServlet, path + "/");
        }
        root.addServlet(new ServletHolder((Servlet)new StructureServlet()), "/service/structure");
        root.addServlet(new ServletHolder((Servlet)new QueueReportServlet()), "/service/queuereport/*");
        root.addServlet(new ServletHolder((Servlet)new MetaDataServlet()), "/service/metadata");
        root.addServlet(new ServletHolder((Servlet)new SaslServlet()), "/service/sasl");
        root.addServlet(new ServletHolder((Servlet)new RootServlet("/", "/apidocs/", "index.html")), "/");
        root.addServlet(new ServletHolder((Servlet)new LogoutServlet()), "/logout");
        root.addServlet(new ServletHolder((Servlet)new FileServlet(DojoHelper.getDojoPath(), true)), "/dojo/dojo/*");
        root.addServlet(new ServletHolder((Servlet)new FileServlet(DojoHelper.getDijitPath(), true)), "/dojo/dijit/*");
        root.addServlet(new ServletHolder((Servlet)new FileServlet(DojoHelper.getDojoxPath(), true)), "/dojo/dojox/*");
        root.addServlet(new ServletHolder((Servlet)new FileServlet(DojoHelper.getDgridPath(), true)), "/dojo/dgrid/*");
        root.addServlet(new ServletHolder((Servlet)new FileServlet(DojoHelper.getDstorePath(), true)), "/dojo/dstore/*");
        for (String pattern : STATIC_FILE_TYPES) {
            root.addServlet(new ServletHolder((Servlet)new FileServlet()), pattern);
        }
        root.addServlet(new ServletHolder((Servlet)new TimeZoneServlet()), "/service/timezones");
        root.getSessionHandler().getSessionCookieConfig().setName(JSESSIONID_COOKIE_PREFIX + lastPort);
        root.getSessionHandler().getSessionCookieConfig().setHttpOnly(true);
        root.getSessionHandler().setMaxInactiveInterval(this.getSessionTimeout());
        return server;
    }

    public int getBoundPort(HttpPort httpPort) {
        NetworkConnector c = (NetworkConnector)this._portConnectorMap.get(httpPort);
        if (c != null) {
            return c.getLocalPort();
        }
        return -1;
    }

    public int getNumberOfAcceptors(HttpPort httpPort) {
        ServerConnector c = this._portConnectorMap.get(httpPort);
        if (c != null) {
            return c.getAcceptors();
        }
        return -1;
    }

    public int getNumberOfSelectors(HttpPort httpPort) {
        ServerConnector c = this._portConnectorMap.get(httpPort);
        if (c != null) {
            return c.getSelectorManager().getSelectorCount();
        }
        return -1;
    }

    private ServerConnector createConnector(HttpPort<?> port, Server server) {
        ConnectionFactory[] connectionFactories;
        port.setPortManager((PortManager)this);
        if (port.getState() != State.ACTIVE) {
            port.startAsync();
        }
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory();
        httpConnectionFactory.getHttpConfiguration().setSendServerVersion(false);
        httpConnectionFactory.getHttpConfiguration().setSendXPoweredBy(false);
        HttpConfiguration.Customizer requestAttributeCustomizer = (connector, httpConfiguration, request) -> HttpManagementUtil.getPortAttributeAction(port).performAction((Object)request);
        httpConnectionFactory.getHttpConfiguration().addCustomizer(requestAttributeCustomizer);
        httpConnectionFactory.getHttpConfiguration().addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        Set transports = port.getTransports();
        if (!transports.contains(Transport.SSL)) {
            connectionFactories = new ConnectionFactory[]{httpConnectionFactory};
        } else if (transports.contains(Transport.SSL)) {
            SslContextFactory sslContextFactory = this.getSslContextFactory(port);
            TlsOrPlainConnectionFactory sslConnectionFactory = port.getTransports().contains(Transport.TCP) ? new TlsOrPlainConnectionFactory(sslContextFactory, httpConnectionFactory.getProtocol()) : new SslConnectionFactory(sslContextFactory, httpConnectionFactory.getProtocol());
            connectionFactories = new ConnectionFactory[]{sslConnectionFactory, httpConnectionFactory};
        } else {
            throw new IllegalArgumentException("Unexpected transport on port " + port.getName() + ":" + transports);
        }
        ServerConnector connector2 = new ServerConnector(server, (Executor)((Object)new QBBTrackingThreadPool(port.getThreadPoolMaximum(), port.getThreadPoolMinimum())), null, null, port.getDesiredNumberOfAcceptors(), port.getDesiredNumberOfSelectors(), connectionFactories){

            public void open() throws IOException {
                try {
                    super.open();
                }
                catch (BindException e) {
                    InetSocketAddress addr = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
                    throw new PortBindFailureException(addr);
                }
            }
        };
        connector2.setAcceptQueueSize(port.getAcceptBacklogSize());
        String bindingAddress = port.getBindingAddress();
        if (bindingAddress != null && !bindingAddress.trim().equals("") && !bindingAddress.trim().equals("*")) {
            connector2.setHost(bindingAddress.trim());
        }
        connector2.setPort(port.getPort());
        if (transports.contains(Transport.SSL)) {
            connector2.addBean((Object)new SslHandshakeListener(){

                public void handshakeFailed(SslHandshakeListener.Event event, Throwable failure) {
                    SSLEngine sslEngine = event.getSSLEngine();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.info("TLS handshake failed: host='{}', port={}", new Object[]{sslEngine.getPeerHost(), sslEngine.getPeerPort(), failure});
                    } else {
                        LOGGER.info("TLS handshake failed: host='{}', port={}: {}", new Object[]{sslEngine.getPeerHost(), sslEngine.getPeerPort(), String.valueOf(failure)});
                    }
                }
            });
        }
        int acceptors = connector2.getAcceptors();
        int selectors = connector2.getSelectorManager().getSelectorCount();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created connector for http port {} with maxThreads={}, minThreads={}, acceptors={}, selectors={}, acceptBacklog={}", new Object[]{port.getName(), port.getThreadPoolMaximum(), port.getThreadPoolMinimum(), acceptors, selectors, port.getAcceptBacklogSize()});
        }
        int requiredNumberOfConnections = acceptors + 2 * selectors + 1;
        if (port.getThreadPoolMaximum() < requiredNumberOfConnections) {
            throw new IllegalConfigurationException(String.format("Insufficient number of threads is configured on http port '%s': max=%d < needed(acceptors=%d + selectors=2*%d + request=1)", port.getName(), port.getThreadPoolMaximum(), acceptors, selectors));
        }
        return connector2;
    }

    private SslContextFactory getSslContextFactory(final HttpPort<?> port) {
        KeyStore keyStore = port.getKeyStore();
        if (keyStore == null) {
            throw new IllegalConfigurationException("Key store is not configured. Cannot start management on HTTPS port without keystore");
        }
        boolean needClientCert = port.getNeedClientAuth() || port.getWantClientAuth();
        Collection trustStores = port.getTrustStores();
        if (needClientCert && trustStores.isEmpty()) {
            throw new IllegalConfigurationException(String.format("Client certificate authentication is enabled on HTTPS port '%s' but no trust store defined", this.getName()));
        }
        SSLContext sslContext = SSLUtil.createSslContext((KeyStore)keyStore, (Collection)trustStores, (String)port.getName());
        SSLSessionContext serverSessionContext = sslContext.getServerSessionContext();
        if (port.getTLSSessionCacheSize() > 0) {
            serverSessionContext.setSessionCacheSize(port.getTLSSessionCacheSize());
        }
        if (port.getTLSSessionTimeout() > 0) {
            serverSessionContext.setSessionTimeout(port.getTLSSessionTimeout());
        }
        SslContextFactory factory = new SslContextFactory(){

            public void customize(SSLEngine sslEngine) {
                super.customize(sslEngine);
                if (port.getTlsCipherSuiteWhiteList() != null && !port.getTlsCipherSuiteWhiteList().isEmpty()) {
                    SSLParameters sslParameters = sslEngine.getSSLParameters();
                    sslParameters.setUseCipherSuitesOrder(true);
                    sslEngine.setSSLParameters(sslParameters);
                }
                SSLUtil.updateEnabledCipherSuites((SSLEngine)sslEngine, (List)port.getTlsCipherSuiteWhiteList(), (List)port.getTlsCipherSuiteBlackList());
                SSLUtil.updateEnabledTlsProtocols((SSLEngine)sslEngine, (List)port.getTlsProtocolWhiteList(), (List)port.getTlsProtocolBlackList());
            }
        };
        factory.setSslContext(sslContext);
        if (port.getNeedClientAuth()) {
            factory.setNeedClientAuth(true);
        } else if (port.getWantClientAuth()) {
            factory.setWantClientAuth(true);
        }
        return factory;
    }

    private void addRestServlet(ServletContextHandler root) {
        ManagementControllerFactory factory;
        Map<String, ManagementControllerFactory> factories = ManagementControllerFactory.loadFactories();
        ApiDocsServlet apiDocsServlet = new ApiDocsServlet();
        ArrayList<String> supportedVersions = new ArrayList<String>();
        String currentVersion = "7.1";
        ManagementController managementController = null;
        do {
            if ((factory = factories.get(currentVersion)) == null) continue;
            managementController = factory.createManagementController(this, managementController);
            RestServlet managementServlet = new RestServlet();
            Collection<String> categories = managementController.getCategories();
            for (String category : categories) {
                String name = category.toLowerCase();
                String path = managementController.getCategoryMapping(name);
                ServletHolder servletHolder = new ServletHolder(path, (Servlet)managementServlet);
                servletHolder.setInitParameter("qpid.controller.version", managementController.getVersion());
                servletHolder.getRegistration().setMultipartConfig(new MultipartConfigElement("", ((Long)this.getContextValue(Long.class, "maxHttpFileUploadSize")).longValue(), -1L, ((Integer)this.getContextValue(Integer.class, "maxHttpFileUploadSize")).intValue()));
                root.addServlet(servletHolder, path + (path.endsWith("/") ? "*" : "/*"));
                if (!"7.1".equals(managementController.getVersion())) continue;
                root.addServlet(servletHolder, "/api/latest/" + name + "/*");
                ServletHolder docServletHolder = new ServletHolder(name + "docs", (Servlet)apiDocsServlet);
                root.addServlet(docServletHolder, "/apidocs/latest/" + name + "/");
                root.addServlet(docServletHolder, "/apidocs/v7.1/" + name + "/");
                root.addServlet(docServletHolder, "/apidocs/latest/" + name);
                root.addServlet(docServletHolder, "/apidocs/v7.1/" + name);
            }
            supportedVersions.add("v" + currentVersion);
            currentVersion = factory.getPreviousVersion();
        } while (factory != null);
        root.getServletContext().setAttribute("qpid.controller.chain", (Object)managementController);
        Map supported = Collections.singletonMap("supportedVersions", supportedVersions);
        ServletHolder versionsServletHolder = new ServletHolder((Servlet)new JsonValueServlet(supported));
        root.addServlet(versionsServletHolder, "/api");
        root.addServlet(versionsServletHolder, "/api/");
    }

    private String getLatestSupportedVersion() {
        return "v" + String.valueOf("7.1");
    }

    private void logOperationalListenMessages() {
        for (Map.Entry<HttpPort<?>, ServerConnector> portConnector : this._portConnectorMap.entrySet()) {
            HttpPort<?> port = portConnector.getKey();
            NetworkConnector connector = (NetworkConnector)portConnector.getValue();
            this.logOperationalListenMessages(port, connector.getLocalPort());
        }
    }

    private void logOperationalListenMessages(HttpPort<?> port, int localPort) {
        Set transports = port.getTransports();
        for (Transport transport : transports) {
            this.getBroker().getEventLogger().message(ManagementConsoleMessages.LISTENING((String)Protocol.HTTP.name(), (String)transport.name(), (Number)localPort));
        }
    }

    private void logOperationalShutdownMessage() {
        for (NetworkConnector networkConnector : this._portConnectorMap.values()) {
            this.logOperationalShutdownMessage(networkConnector.getLocalPort());
        }
    }

    private void logOperationalShutdownMessage(int localPort) {
        this.getBroker().getEventLogger().message(ManagementConsoleMessages.SHUTTING_DOWN((String)Protocol.HTTP.name(), (Number)localPort));
    }

    private Collection<HttpPort<?>> getEligibleHttpPorts(Collection<Port<?>> ports) {
        HashSet<HttpPort> httpPorts = new HashSet<HttpPort>();
        for (Port<?> port : ports) {
            if (State.ACTIVE != port.getDesiredState() || State.ERRORED == port.getState() || !port.getProtocols().contains(Protocol.HTTP)) continue;
            httpPorts.add((HttpPort)port);
        }
        return Collections.unmodifiableCollection(httpPorts);
    }

    @Override
    public boolean isHttpsSaslAuthenticationEnabled() {
        return this._httpsSaslAuthenticationEnabled;
    }

    @Override
    public boolean isHttpSaslAuthenticationEnabled() {
        return this._httpSaslAuthenticationEnabled;
    }

    @Override
    public boolean isHttpsBasicAuthenticationEnabled() {
        return this._httpsBasicAuthenticationEnabled;
    }

    @Override
    public boolean isHttpBasicAuthenticationEnabled() {
        return this._httpBasicAuthenticationEnabled;
    }

    @Override
    public boolean isCompressResponses() {
        return this._compressResponses;
    }

    @Override
    public AuthenticationProvider getAuthenticationProvider(HttpServletRequest request) {
        HttpPort<?> port = this.getPort(request);
        return port == null ? null : port.getAuthenticationProvider();
    }

    public static Set<String> getAllAvailableCorsMethodCombinations() {
        List<String> methods = Arrays.asList("OPTION", "HEAD", "GET", "POST", "PUT", "DELETE");
        HashSet combinations = new HashSet();
        int n = methods.size();
        assert (n < 31) : "Too many combination to calculate";
        for (int i = 0; i < 1 << n; ++i) {
            HashSet<String> currentCombination = new HashSet<String>();
            for (int index = 0; index < n; ++index) {
                if ((i & 1 << index) == 0) continue;
                currentCombination.add(methods.get(index));
            }
            combinations.add(currentCombination);
        }
        HashSet<String> combinationsAsString = new HashSet<String>(combinations.size());
        ObjectMapper mapper = new ObjectMapper();
        for (Set set : combinations) {
            try {
                StringWriter writer = new StringWriter();
                Throwable throwable = null;
                try {
                    mapper.writeValue((Writer)writer, (Object)set);
                    combinationsAsString.add(writer.toString());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unexpected IO Exception generating JSON string", e);
            }
        }
        return Collections.unmodifiableSet(combinationsAsString);
    }

    @Override
    public HttpPort<?> getPort(HttpServletRequest request) {
        return HttpManagementUtil.getPort(request);
    }

    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        int value;
        super.validateChange(proxyForValidation, changedAttributes);
        HttpManagementConfiguration updated = (HttpManagementConfiguration)proxyForValidation;
        if (changedAttributes.contains("name") && !this.getName().equals(updated.getName())) {
            throw new IllegalConfigurationException("Changing the name of http management plugin is not allowed");
        }
        if (changedAttributes.contains(TIME_OUT) && (value = updated.getSessionTimeout()) < 0) {
            throw new IllegalConfigurationException("Only positive integer value can be specified for the session time out attribute");
        }
    }

    @Override
    public long getSaslExchangeExpiry() {
        return this._saslExchangeExpiry;
    }

    private static class ConnectionTrackingListener
    implements Connection.Listener {
        private final Map<Connection, SettableFuture<Void>> _closeFutures = new HashMap<Connection, SettableFuture<Void>>();

        private ConnectionTrackingListener() {
        }

        public void onOpened(Connection connection) {
            this._closeFutures.put(connection, (SettableFuture<Void>)SettableFuture.create());
        }

        public void onClosed(Connection connection) {
            SettableFuture<Void> closeFuture = this._closeFutures.remove(connection);
            if (closeFuture != null) {
                closeFuture.set(null);
            }
        }

        public ListenableFuture<List<Void>> getAllClosedFuture() {
            return Futures.allAsList(this._closeFutures.values());
        }

        public int getConnectionCount() {
            return this._closeFutures.size();
        }
    }

    private class BrokerChangeListener
    extends AbstractConfigurationChangeListener {
        private BrokerChangeListener() {
        }

        public void childAdded(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            if (child instanceof HttpPort) {
                HttpPort port = (HttpPort)child;
                Server server = HttpManagement.this._server;
                if (server != null) {
                    ServerConnector connector = null;
                    try {
                        connector = HttpManagement.this.createConnector(port, server);
                        connector.addBean((Object)new ConnectionTrackingListener());
                        server.addConnector((Connector)connector);
                        connector.start();
                        HttpManagement.this._portConnectorMap.put(port, connector);
                        HttpManagement.this.logOperationalListenMessages(port, connector.getLocalPort());
                    }
                    catch (Exception e) {
                        if (connector != null) {
                            server.removeConnector((Connector)connector);
                        }
                        LOGGER.warn("HTTP management connector creation failed for http port {}", (Object)port, (Object)e);
                    }
                }
            }
        }

        public void childRemoved(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            if (child instanceof HttpPort) {
                ServerConnector connector;
                HttpPort port = (HttpPort)child;
                Server server = HttpManagement.this._server;
                if (server != null && (connector = (ServerConnector)HttpManagement.this._portConnectorMap.remove(port)) != null) {
                    final int localPort = connector.getLocalPort();
                    final ConnectionTrackingListener tracker = (ConnectionTrackingListener)connector.getBean(ConnectionTrackingListener.class);
                    connector.close();
                    connector.setIdleTimeout(1L);
                    connector.getConnectedEndPoints().forEach(endPoint -> endPoint.setIdleTimeout(1L));
                    LOGGER.debug("Connector has {} connection(s)", (Object)tracker.getConnectionCount());
                    final TaskExecutor taskExecutor = HttpManagement.this.getBroker().getTaskExecutor();
                    tracker.getAllClosedFuture().addListener(new Runnable(){

                        @Override
                        public void run() {
                            int connectionCount = tracker.getConnectionCount();
                            if (connectionCount == 0) {
                                LOGGER.debug("Stopping connector for http port {}", (Object)localPort);
                                try {
                                    connector.stop();
                                }
                                catch (Exception e) {
                                    LOGGER.warn("Failed to stop connector for http port {}", (Object)localPort, (Object)e);
                                }
                                finally {
                                    HttpManagement.this.logOperationalShutdownMessage(localPort);
                                    HttpManagement.this._server.removeConnector((Connector)connector);
                                }
                            } else {
                                LOGGER.debug("Connector still has {} connection(s)", (Object)tracker.getConnectionCount());
                                connector.getConnectedEndPoints().forEach(endPoint -> endPoint.setIdleTimeout(1L));
                                tracker.getAllClosedFuture().addListener((Runnable)this, (Executor)taskExecutor);
                            }
                        }
                    }, (Executor)taskExecutor);
                }
            }
        }
    }

    private static class QBBTrackingThreadPool
    extends QueuedThreadPool {
        private final ThreadFactory _threadFactory = QpidByteBuffer.createQpidByteBufferTrackingThreadFactory(r -> QBBTrackingThreadPool.access$301(this, r));

        public QBBTrackingThreadPool(@Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads) {
            super(maxThreads, minThreads);
        }

        protected Thread newThread(Runnable runnable) {
            return this._threadFactory.newThread(runnable);
        }
    }
}

