/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.auth;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpRequestInteractiveAuthenticator;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.security.auth.manager.UsernamePasswordAuthenticationProvider;

@PluggableService
public class UsernamePasswordInteractiveLogin
implements HttpRequestInteractiveAuthenticator {
    private static final String DEFAULT_LOGIN_URL = "/index.html";
    private static final HttpRequestInteractiveAuthenticator.LogoutHandler LOGOUT_HANDLER = new HttpRequestInteractiveAuthenticator.LogoutHandler(){

        @Override
        public void handleLogout(HttpServletResponse response) throws IOException {
            response.sendRedirect("/logout.html");
        }
    };

    @Override
    public HttpRequestInteractiveAuthenticator.AuthenticationHandler getAuthenticationHandler(HttpServletRequest request, HttpManagementConfiguration configuration) {
        if (configuration.getAuthenticationProvider(request) instanceof UsernamePasswordAuthenticationProvider) {
            return response -> request.getRequestDispatcher(DEFAULT_LOGIN_URL).forward((ServletRequest)request, (ServletResponse)response);
        }
        return null;
    }

    @Override
    public HttpRequestInteractiveAuthenticator.LogoutHandler getLogoutHandler(HttpServletRequest request, HttpManagementConfiguration configuration) {
        if (configuration.getAuthenticationProvider(request) instanceof UsernamePasswordAuthenticationProvider) {
            return LOGOUT_HANDLER;
        }
        return null;
    }

    public String getType() {
        return "UsernamePassword";
    }
}

