/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller.v6_1.category;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.management.plugin.controller.CategoryController;
import org.apache.qpid.server.management.plugin.controller.CategoryControllerFactory;
import org.apache.qpid.server.management.plugin.controller.LegacyManagementController;
import org.apache.qpid.server.management.plugin.controller.v6_1.category.BindingController;
import org.apache.qpid.server.management.plugin.controller.v6_1.category.BrokerController;
import org.apache.qpid.server.management.plugin.controller.v6_1.category.ConsumerController;
import org.apache.qpid.server.management.plugin.controller.v6_1.category.ExchangeController;
import org.apache.qpid.server.management.plugin.controller.v6_1.category.LegacyCategoryController;
import org.apache.qpid.server.management.plugin.controller.v6_1.category.PortController;
import org.apache.qpid.server.management.plugin.controller.v6_1.category.QueueController;
import org.apache.qpid.server.management.plugin.controller.v6_1.category.SessionController;
import org.apache.qpid.server.management.plugin.controller.v6_1.category.VirtualHostController;
import org.apache.qpid.server.plugin.PluggableService;

@PluggableService
public class LegacyCategoryControllerFactory
implements CategoryControllerFactory {
    static final String CATEGORY_BROKER = "Broker";
    private static final String CATEGORY_BROKER_LOGGER = "BrokerLogger";
    private static final String CATEGORY_BROKER_LOG_INCLUSION_RULE = "BrokerLogInclusionRule";
    private static final String CATEGORY_AUTHENTICATION_PROVIDER = "AuthenticationProvider";
    private static final String CATEGORY_USER = "User";
    private static final String CATEGORY_ACCESS_CONTROL_PROVIDER = "AccessControlProvider";
    private static final String CATEGORY_PLUGIN = "Plugin";
    private static final String CATEGORY_TRUST_STORE = "TrustStore";
    private static final String CATEGORY_KEY_STORE = "KeyStore";
    static final String CATEGORY_PORT = "Port";
    private static final String CATEGORY_VIRTUAL_HOST_ALIAS = "VirtualHostAlias";
    private static final String CATEGORY_GROUP_PROVIDER = "GroupProvider";
    private static final String CATEGORY_GROUP = "Group";
    private static final String CATEGORY_GROUP_MEMBER = "GroupMember";
    static final String CATEGORY_VIRTUAL_HOST_NODE = "VirtualHostNode";
    private static final String CATEGORY_REMOTE_REPLICATION_NODE = "RemoteReplicationNode";
    static final String CATEGORY_VIRTUAL_HOST = "VirtualHost";
    private static final String CATEGORY_VIRTUAL_HOST_LOGGER = "VirtualHostLogger";
    private static final String CATEGORY_VIRTUAL_HOST_LOG_INCLUSION_RULE = "VirtualHostLogInclusionRule";
    private static final String CATEGORY_VIRTUAL_HOST_ACCESS_CONTROL_PROVIDER = "VirtualHostAccessControlProvider";
    static final String CATEGORY_EXCHANGE = "Exchange";
    static final String CATEGORY_QUEUE = "Queue";
    private static final String CATEGORY_BINDING = "Binding";
    static final String CATEGORY_CONSUMER = "Consumer";
    static final String CATEGORY_CONNECTION = "Connection";
    static final String CATEGORY_SESSION = "Session";
    static final String CATEGORY_SYSTEM_CONFIG = "SystemConfig";
    static final Set<String> SUPPORTED_CATEGORIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Broker", "BrokerLogger", "BrokerLogInclusionRule", "AuthenticationProvider", "User", "AccessControlProvider", "Plugin", "TrustStore", "KeyStore", "Port", "VirtualHostAlias", "GroupProvider", "Group", "GroupMember", "VirtualHostNode", "RemoteReplicationNode", "VirtualHost", "VirtualHostLogger", "VirtualHostLogInclusionRule", "VirtualHostAccessControlProvider", "Exchange", "Queue", "Binding", "Consumer", "Connection", "Session")));
    private static final Map<String, String> DEFAULT_TYPES = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put(LegacyCategoryControllerFactory.CATEGORY_BROKER_LOGGER, LegacyCategoryControllerFactory.CATEGORY_BROKER);
            this.put(LegacyCategoryControllerFactory.CATEGORY_TRUST_STORE, "FileTrustStore");
            this.put(LegacyCategoryControllerFactory.CATEGORY_KEY_STORE, "FileKeyStore");
            this.put(LegacyCategoryControllerFactory.CATEGORY_GROUP, "ManagedGroup");
            this.put(LegacyCategoryControllerFactory.CATEGORY_GROUP_MEMBER, "ManagedGroupMember");
            this.put(LegacyCategoryControllerFactory.CATEGORY_VIRTUAL_HOST, "ProvidedStore");
            this.put(LegacyCategoryControllerFactory.CATEGORY_QUEUE, "standard");
        }
    });

    @Override
    public CategoryController createController(String type, LegacyManagementController legacyManagementController) {
        switch (type) {
            case "AccessControlProvider": {
                return new LegacyCategoryController(legacyManagementController, type, new String[]{CATEGORY_BROKER}, DEFAULT_TYPES.get(type), legacyManagementController.getTypeControllersByCategory(type));
            }
            case "Broker": {
                return new BrokerController(legacyManagementController, legacyManagementController.getTypeControllersByCategory(type));
            }
            case "BrokerLogger": {
                return new LegacyCategoryController(legacyManagementController, type, new String[]{CATEGORY_BROKER}, DEFAULT_TYPES.get(type), legacyManagementController.getTypeControllersByCategory(type));
            }
            case "BrokerLogInclusionRule": {
                return new LegacyCategoryController(legacyManagementController, type, new String[]{CATEGORY_BROKER_LOGGER}, DEFAULT_TYPES.get(type), legacyManagementController.getTypeControllersByCategory(type));
            }
            case "AuthenticationProvider": {
                return new LegacyCategoryController(legacyManagementController, type, new String[]{CATEGORY_BROKER}, DEFAULT_TYPES.get(type), legacyManagementController.getTypeControllersByCategory(type));
            }
            case "User": {
                return new LegacyCategoryController(legacyManagementController, type, new String[]{CATEGORY_AUTHENTICATION_PROVIDER}, DEFAULT_TYPES.get(type), legacyManagementController.getTypeControllersByCategory(type));
            }
            case "Port": {
                return new PortController(legacyManagementController, legacyManagementController.getTypeControllersByCategory(type));
            }
            case "VirtualHostAlias": {
                return new LegacyCategoryController(legacyManagementController, type, new String[]{CATEGORY_VIRTUAL_HOST_ALIAS}, DEFAULT_TYPES.get(type), legacyManagementController.getTypeControllersByCategory(type));
            }
            case "Plugin": {
                return new LegacyCategoryController(legacyManagementController, type, new String[]{CATEGORY_BROKER}, DEFAULT_TYPES.get(type), legacyManagementController.getTypeControllersByCategory(type));
            }
            case "TrustStore": {
                return new LegacyCategoryController(legacyManagementController, type, new String[]{CATEGORY_BROKER}, DEFAULT_TYPES.get(type), legacyManagementController.getTypeControllersByCategory(type));
            }
            case "KeyStore": {
                return new LegacyCategoryController(legacyManagementController, type, new String[]{CATEGORY_BROKER}, DEFAULT_TYPES.get(type), legacyManagementController.getTypeControllersByCategory(type));
            }
            case "GroupProvider": {
                return new LegacyCategoryController(legacyManagementController, type, new String[]{CATEGORY_BROKER}, DEFAULT_TYPES.get(type), legacyManagementController.getTypeControllersByCategory(type));
            }
            case "Group": {
                return new LegacyCategoryController(legacyManagementController, type, new String[]{CATEGORY_GROUP_PROVIDER}, null, legacyManagementController.getTypeControllersByCategory(type));
            }
            case "GroupMember": {
                return new LegacyCategoryController(legacyManagementController, type, new String[]{CATEGORY_GROUP}, DEFAULT_TYPES.get(type), legacyManagementController.getTypeControllersByCategory(type));
            }
            case "VirtualHostNode": {
                return new LegacyCategoryController(legacyManagementController, type, new String[]{CATEGORY_BROKER}, DEFAULT_TYPES.get(type), legacyManagementController.getTypeControllersByCategory(type));
            }
            case "RemoteReplicationNode": {
                return new LegacyCategoryController(legacyManagementController, type, new String[]{CATEGORY_VIRTUAL_HOST_NODE}, DEFAULT_TYPES.get(type), legacyManagementController.getTypeControllersByCategory(type));
            }
            case "VirtualHost": {
                return new VirtualHostController(legacyManagementController, legacyManagementController.getTypeControllersByCategory(type));
            }
            case "VirtualHostLogger": {
                return new LegacyCategoryController(legacyManagementController, type, new String[]{CATEGORY_VIRTUAL_HOST}, DEFAULT_TYPES.get(type), legacyManagementController.getTypeControllersByCategory(type));
            }
            case "VirtualHostLogInclusionRule": {
                return new LegacyCategoryController(legacyManagementController, type, new String[]{CATEGORY_VIRTUAL_HOST_LOGGER}, DEFAULT_TYPES.get(type), legacyManagementController.getTypeControllersByCategory(type));
            }
            case "VirtualHostAccessControlProvider": {
                return new LegacyCategoryController(legacyManagementController, type, new String[]{CATEGORY_VIRTUAL_HOST}, DEFAULT_TYPES.get(type), legacyManagementController.getTypeControllersByCategory(type));
            }
            case "Exchange": {
                return new ExchangeController(legacyManagementController, legacyManagementController.getTypeControllersByCategory(type));
            }
            case "Queue": {
                return new QueueController(legacyManagementController, legacyManagementController.getTypeControllersByCategory(type));
            }
            case "Binding": {
                return new BindingController(legacyManagementController);
            }
            case "Connection": {
                return new LegacyCategoryController(legacyManagementController, type, new String[]{CATEGORY_PORT, CATEGORY_VIRTUAL_HOST}, DEFAULT_TYPES.get(type), legacyManagementController.getTypeControllersByCategory(type));
            }
            case "Session": {
                return new SessionController(legacyManagementController, legacyManagementController.getTypeControllersByCategory(type));
            }
            case "Consumer": {
                return new ConsumerController(legacyManagementController);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported category '%s'", type));
    }

    @Override
    public Set<String> getSupportedCategories() {
        return SUPPORTED_CATEGORIES;
    }

    @Override
    public String getModelVersion() {
        return "6.1";
    }

    public String getType() {
        return LegacyCategoryControllerFactory.class.getName();
    }
}

