/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.HttpRequestInteractiveAuthenticator;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;

public class InteractiveAuthenticationFilter
implements Filter {
    private static final Collection<HttpRequestInteractiveAuthenticator> AUTHENTICATORS;
    private HttpManagementConfiguration _managementConfiguration;

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
        ServletContext servletContext = config.getServletContext();
        this._managementConfiguration = HttpManagementUtil.getManagementConfiguration(servletContext);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Subject subject = HttpManagementUtil.getAuthorisedSubject(httpRequest);
        if (subject != null && !subject.getPrincipals(AuthenticatedPrincipal.class).isEmpty()) {
            chain.doFilter(request, response);
        } else {
            HttpRequestInteractiveAuthenticator authenticator;
            HttpRequestInteractiveAuthenticator.AuthenticationHandler handler = null;
            Iterator<HttpRequestInteractiveAuthenticator> iterator = AUTHENTICATORS.iterator();
            while (iterator.hasNext() && (handler = (authenticator = iterator.next()).getAuthenticationHandler(httpRequest, this._managementConfiguration)) == null) {
            }
            if (handler != null) {
                handler.handleAuthentication(httpResponse);
            } else {
                httpResponse.sendError(403);
            }
        }
    }

    static {
        ArrayList<HttpRequestInteractiveAuthenticator> authenticators = new ArrayList<HttpRequestInteractiveAuthenticator>();
        for (HttpRequestInteractiveAuthenticator authenticator : new QpidServiceLoader().instancesOf(HttpRequestInteractiveAuthenticator.class)) {
            authenticators.add(authenticator);
        }
        AUTHENTICATORS = Collections.unmodifiableList(authenticators);
    }
}

