/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.query;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.apache.qpid.server.filter.Expression;
import org.apache.qpid.server.filter.NamedExpression;
import org.apache.qpid.server.management.plugin.servlet.query.ConfiguredObjectExpression;
import org.apache.qpid.server.management.plugin.servlet.query.ParseException;
import org.apache.qpid.server.model.ConfiguredObject;

public class ConfiguredObjectExpressionFactory {
    private static final String PARENT_ATTR = "$parent";
    private static Set<String> SPECIAL_ATTRIBUTES = new HashSet<String>(Arrays.asList("$parent"));
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final DatatypeFactory DATATYPE_FACTORY;
    private static final DateTimeFormatter ISO_DATE_TIME_FORMAT;

    public ConfiguredObjectExpression createConfiguredObjectExpression(String propertyName) {
        return new ConfiguredObjectPropertyExpression(propertyName);
    }

    public ConfiguredObjectExpression createConfiguredObjectExpression(String propertyName, ConfiguredObjectExpression expression) {
        return new ChainedConfiguredObjectExpression(propertyName, expression);
    }

    public ConfiguredObjectExpression createConfiguredObjectExpression(String propertyName, int index) {
        return new IndexedConfiguredObjectExpression(propertyName, index);
    }

    public ConfiguredObjectExpression createFunctionExpression(String functionName, List<Expression> args) throws ParseException {
        try {
            FilterFunction function = null;
            try {
                function = FilterFunction.valueOf(functionName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ParseException("Unknown function name : '" + functionName + "'");
            }
            return function.asExpression(args);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Function parameter mismatch : '" + functionName + "'", e);
        }
    }

    static {
        ISO_DATE_TIME_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendOffsetId().optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter().withChronology(IsoChronology.INSTANCE);
        try {
            DATATYPE_FACTORY = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class IndexedConfiguredObjectExpression
    implements ConfiguredObjectExpression {
        private final String _propertyName;
        private final int _index;

        public IndexedConfiguredObjectExpression(String propertyName, int index) {
            this._propertyName = propertyName;
            this._index = index;
        }

        public Object evaluate(ConfiguredObject<?> object) {
            Object propertyValue;
            Object object2 = propertyValue = object == null ? null : object.getAttribute(this._propertyName);
            if (propertyValue instanceof Collection) {
                Iterator iter = ((Collection)propertyValue).iterator();
                int pos = 0;
                while (iter.hasNext() && pos < this._index) {
                    iter.next();
                }
                if (pos == this._index && iter.hasNext()) {
                    return iter.next();
                }
            }
            return null;
        }
    }

    private static class ChainedConfiguredObjectExpression
    implements ConfiguredObjectExpression {
        private final ConfiguredObjectPropertyExpression _first;
        private final ConfiguredObjectExpression _chainedExpression;

        public ChainedConfiguredObjectExpression(String propertyName, ConfiguredObjectExpression expression) {
            this._first = new ConfiguredObjectPropertyExpression(propertyName);
            this._chainedExpression = expression;
        }

        public Object evaluate(ConfiguredObject<?> object) {
            Object propertyValue = this._first.evaluate(object);
            if (propertyValue instanceof ConfiguredObject) {
                return this._chainedExpression.evaluate((ConfiguredObject)propertyValue);
            }
            if (propertyValue instanceof Map && this._chainedExpression instanceof ConfiguredObjectPropertyExpression) {
                return ((Map)propertyValue).get(((ConfiguredObjectPropertyExpression)this._chainedExpression)._propertyName);
            }
            return null;
        }
    }

    private static class ConfiguredObjectPropertyExpression
    implements ConfiguredObjectExpression,
    NamedExpression<ConfiguredObject<?>> {
        private final String _propertyName;

        public ConfiguredObjectPropertyExpression(String propertyName) {
            this._propertyName = propertyName;
        }

        public Object evaluate(ConfiguredObject<?> object) {
            return object == null ? null : this.getValue(object);
        }

        private Object getValue(ConfiguredObject<?> object) {
            if (SPECIAL_ATTRIBUTES.contains(this._propertyName)) {
                if (ConfiguredObjectExpressionFactory.PARENT_ATTR.equals(this._propertyName)) {
                    return object.getParent();
                }
                return null;
            }
            return object.getAttributeNames().contains(this._propertyName) ? object.getAttribute(this._propertyName) : object.getStatistics().get(this._propertyName);
        }

        public String getName() {
            return this._propertyName;
        }
    }

    static enum FilterFunction {
        CONCAT{

            @Override
            ConfiguredObjectExpression asExpression(final List<Expression> args) {
                return new ConfiguredObjectExpression(){

                    public Object evaluate(ConfiguredObject<?> object) {
                        StringBuilder buf = new StringBuilder();
                        for (Expression expr : args) {
                            buf.append(expr.evaluate(object));
                        }
                        return buf.toString();
                    }
                };
            }
        }
        ,
        NOW{

            @Override
            ConfiguredObjectExpression asExpression(List<Expression> args) {
                if (args != null && !args.isEmpty()) {
                    throw new IllegalArgumentException(NOW.name() + " does not accept arguments.");
                }
                return new ConfiguredObjectExpression(){

                    public Object evaluate(ConfiguredObject<?> object) {
                        return new Date();
                    }
                };
            }
        }
        ,
        TO_DATE{

            @Override
            ConfiguredObjectExpression asExpression(final List<Expression> args) {
                if (args == null || args.size() != 1) {
                    throw new IllegalArgumentException(TO_DATE.name() + " requires a single argument.");
                }
                return new ConfiguredObjectExpression(){

                    public Object evaluate(ConfiguredObject<?> object) {
                        Object dateTime = ((Expression)args.get(0)).evaluate(object);
                        if (!(dateTime instanceof String)) {
                            throw new IllegalArgumentException(TO_DATE.name() + " requires a string argument, not a " + dateTime.getClass());
                        }
                        try {
                            return DateTimeFormatter.ISO_ZONED_DATE_TIME.parse((String)dateTime).query(this::convertToDate);
                        }
                        catch (DateTimeParseException e1) {
                            throw new IllegalArgumentException((Object)((Object)TO_DATE) + " requires an ISO-8601 format date or date/time.", e1);
                        }
                    }

                    private Date convertToDate(TemporalAccessor t) {
                        if (!t.isSupported(ChronoField.INSTANT_SECONDS)) {
                            t = LocalDateTime.of(LocalDate.from(t), LocalTime.MIN).atOffset(ZoneOffset.UTC);
                        }
                        return new Date(t.getLong(ChronoField.INSTANT_SECONDS) * 1000L + t.getLong(ChronoField.MILLI_OF_SECOND));
                    }
                };
            }
        }
        ,
        DATE_ADD{

            @Override
            ConfiguredObjectExpression asExpression(final List<Expression> args) {
                if (args == null || args.size() != 2) {
                    throw new IllegalArgumentException(DATE_ADD.name() + " requires two arguments.");
                }
                return new ConfiguredObjectExpression(){

                    public Object evaluate(ConfiguredObject<?> object) {
                        Object date = ((Expression)args.get(0)).evaluate(object);
                        Object period = ((Expression)args.get(1)).evaluate(object);
                        if (!(date instanceof Date) || !(period instanceof String)) {
                            throw new IllegalArgumentException(String.format("%s requires a (Date, String) not a (%s,%s)", new Object[]{DATE_ADD, date.getClass().getSimpleName(), period.getClass().getSimpleName()}));
                        }
                        try {
                            Date copy = new Date(((Date)date).getTime());
                            Duration duration = DATATYPE_FACTORY.newDuration((String)period);
                            duration.addTo(copy);
                            return copy;
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException((Object)((Object)DATE_ADD) + " requires an ISO-8601 format duration.", e);
                        }
                    }
                };
            }
        }
        ,
        TO_STRING{

            @Override
            ConfiguredObjectExpression asExpression(final List<Expression> args) {
                if (args == null || args.size() == 0 || args.size() > 3) {
                    throw new IllegalArgumentException(TO_STRING.name() + " requires (Object[,{printf format specifier},[{timezone name}]]).");
                }
                return new ConfiguredObjectExpression(){

                    public Object evaluate(ConfiguredObject<?> object) {
                        Object timezoneName;
                        Object obj = ((Expression)args.get(0)).evaluate(object);
                        Object format = args.size() > 1 ? ((Expression)args.get(1)).evaluate(object) : null;
                        Object object2 = timezoneName = args.size() > 2 ? ((Expression)args.get(2)).evaluate(object) : null;
                        if (obj instanceof Date) {
                            Calendar cal = timezoneName == null ? Calendar.getInstance(UTC) : Calendar.getInstance(TimeZone.getTimeZone((String)timezoneName));
                            cal.setTime((Date)obj);
                            if (format == null) {
                                return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(cal.toInstant().atZone(ZoneId.of(timezoneName == null ? "UTC" : (String)timezoneName)));
                            }
                            return String.format((String)format, cal);
                        }
                        if (format == null) {
                            return String.valueOf(obj);
                        }
                        return String.format((String)format, obj);
                    }
                };
            }
        };


        abstract ConfiguredObjectExpression asExpression(List<Expression> var1);
    }
}

