/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.GunzipOutputStream;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.model.AbstractConfigurationChangeListener;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectFinder;
import org.apache.qpid.server.model.ConfiguredObjectJacksonModule;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.CustomRestHeaders;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.RestContentHeader;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.port.HttpPort;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServlet
extends HttpServlet {
    public static final int SC_UNPROCESSABLE_ENTITY = 422;
    public static final String CONTENT_DISPOSITION_ATTACHMENT_FILENAME_PARAM = "contentDispositionAttachmentFilename";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServlet.class);
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    private transient Broker<?> _broker;
    private transient HttpManagementConfiguration _managementConfiguration;
    private final transient ConcurrentMap<ConfiguredObject<?>, ConfiguredObjectFinder> _configuredObjectFinders = new ConcurrentHashMap();

    protected AbstractServlet() {
    }

    public void init() throws ServletException {
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        this._broker = HttpManagementUtil.getBroker(servletContext);
        this._managementConfiguration = HttpManagementUtil.getManagementConfiguration(servletContext);
        super.init();
    }

    private ConfiguredObject<?> getManagedObject(HttpServletRequest request, HttpServletResponse resp) {
        HttpPort<?> port = HttpManagementUtil.getPort(request);
        NamedAddressSpace addressSpace = port.getAddressSpace(request.getServerName());
        if (addressSpace == null) {
            if (port.isManageBrokerOnNoAliasMatch()) {
                return this.getBroker();
            }
            LOGGER.info("No HTTP Management alias mapping found for host '{}' on port {}", (Object)request.getServerName(), port);
            this.sendError(resp, 404);
            return null;
        }
        if (addressSpace instanceof VirtualHost) {
            return (VirtualHost)addressSpace;
        }
        return this.getBroker();
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        ConfiguredObject<?> managedObject = this.getManagedObject(request, resp);
        if (managedObject != null) {
            this.doGet(request, resp, managedObject);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse resp, ConfiguredObject<?> managedObject) throws ServletException, IOException {
        throw new UnsupportedOperationException("GET not supported by this servlet");
    }

    protected final void doPost(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        ConfiguredObject<?> managedObject = this.getManagedObject(request, resp);
        if (managedObject != null) {
            this.doPost(request, resp, managedObject);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp, ConfiguredObject<?> managedObject) throws ServletException, IOException {
        throw new UnsupportedOperationException("POST not supported by this servlet");
    }

    protected final void doPut(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        ConfiguredObject<?> managedObject = this.getManagedObject(request, resp);
        if (managedObject != null) {
            this.doPut(request, resp, managedObject);
        }
    }

    protected void setContentDispositionHeaderIfNecessary(HttpServletResponse response, String attachmentFilename) {
        if (attachmentFilename != null) {
            String filenameRfc2183 = HttpManagementUtil.ensureFilenameIsRfc2183(attachmentFilename);
            if (filenameRfc2183.length() > 0) {
                response.setHeader(CONTENT_DISPOSITION, String.format("attachment; filename=\"%s\"", filenameRfc2183));
            } else {
                response.setHeader(CONTENT_DISPOSITION, "attachment");
            }
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp, ConfiguredObject<?> managedObject) throws ServletException, IOException {
        throw new UnsupportedOperationException("PUT not supported by this servlet");
    }

    protected final void doDelete(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        ConfiguredObject<?> managedObject = this.getManagedObject(request, resp);
        if (managedObject != null) {
            this.doDelete(request, resp, managedObject);
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp, ConfiguredObject<?> managedObject) throws ServletException, IOException {
        throw new UnsupportedOperationException("DELETE not supported by this servlet");
    }

    protected OutputStream getOutputStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return HttpManagementUtil.getOutputStream(request, response, this._managementConfiguration);
    }

    protected Broker<?> getBroker() {
        return this._broker;
    }

    protected HttpManagementConfiguration getManagementConfiguration() {
        return this._managementConfiguration;
    }

    protected void sendJsonResponse(Object object, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.sendJsonResponse(object, request, response, 200, true);
    }

    protected final void sendJsonResponse(Object object, HttpServletRequest request, HttpServletResponse response, int responseCode, boolean sendCachingHeaders) throws IOException {
        response.setStatus(responseCode);
        response.setContentType("application/json");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        if (sendCachingHeaders) {
            this.sendCachingHeadersOnResponse(response);
        }
        if (object instanceof CustomRestHeaders) {
            this.setResponseHeaders(response, (CustomRestHeaders)object);
        }
        this.writeObjectToResponse(object, request, response);
    }

    protected final void sendJsonErrorResponse(HttpServletRequest request, HttpServletResponse response, int responseCode, String message) throws IOException {
        this.sendJsonResponse(Collections.singletonMap("errorMessage", message), request, response, responseCode, false);
    }

    protected void sendError(HttpServletResponse resp, int responseCode) {
        try {
            resp.sendError(responseCode);
        }
        catch (IOException e) {
            throw new ConnectionScopedRuntimeException("Failed to send error response code " + responseCode, (Throwable)e);
        }
    }

    private void writeObjectToResponse(Object object, HttpServletRequest request, HttpServletResponse response) throws IOException {
        OutputStream stream = this.getOutputStream(request, response);
        ObjectMapper mapper = ConfiguredObjectJacksonModule.newObjectMapper((boolean)false);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.writeValue(stream, object);
    }

    protected void sendCachingHeadersOnResponse(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    protected void writeTypedContent(Content content, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map<String, Object> headers = this.getResponseHeaders(content);
        try (OutputStream os = this.getOutputStream(request, response, headers);){
            response.setStatus(200);
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                response.setHeader(entry.getKey(), String.valueOf(entry.getValue()));
            }
            content.write(os);
        }
        catch (IOException e) {
            LOGGER.warn("Unexpected exception processing request", (Throwable)e);
            this.sendJsonErrorResponse(request, response, 500, e.getMessage());
        }
    }

    private OutputStream getOutputStream(HttpServletRequest request, HttpServletResponse response, Map<String, Object> headers) throws IOException {
        boolean isGzipCompressed = "gzip".equals(headers.get("Content-Encoding".toUpperCase()));
        boolean isCompressingAccepted = HttpManagementUtil.isCompressingAccepted(request, this._managementConfiguration);
        Object stream = response.getOutputStream();
        if (isGzipCompressed) {
            if (!isCompressingAccepted) {
                stream = new GunzipOutputStream((OutputStream)stream);
                headers.remove("Content-Encoding".toUpperCase());
            }
        } else if (isCompressingAccepted) {
            stream = new GZIPOutputStream((OutputStream)stream);
            headers.put("Content-Encoding".toUpperCase(), "gzip");
        }
        return stream;
    }

    private Map<String, Object> getResponseHeaders(Object content) {
        CustomRestHeaders customRestHeaders;
        Map<RestContentHeader, Method> contentHeaderGetters;
        Map<String, Object> headers = Collections.emptyMap();
        if (content instanceof CustomRestHeaders && (contentHeaderGetters = this.getContentHeaderMethods(customRestHeaders = (CustomRestHeaders)content)) != null) {
            headers = new HashMap<String, Object>();
            for (Map.Entry<RestContentHeader, Method> entry : contentHeaderGetters.entrySet()) {
                String headerName = entry.getKey().value();
                try {
                    Object headerValue = entry.getValue().invoke((Object)customRestHeaders, new Object[0]);
                    if (headerValue == null) continue;
                    headers.put(headerName.toUpperCase(), headerValue);
                }
                catch (Exception e) {
                    LOGGER.warn("Unexpected exception whilst setting response header " + headerName, (Throwable)e);
                }
            }
        }
        return headers;
    }

    private void setResponseHeaders(HttpServletResponse response, CustomRestHeaders customRestHeaders) {
        Map<String, Object> headers = this.getResponseHeaders(customRestHeaders);
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            response.setHeader(entry.getKey(), String.valueOf(entry.getValue()));
        }
    }

    private Map<RestContentHeader, Method> getContentHeaderMethods(CustomRestHeaders content) {
        Method[] methods;
        HashMap<RestContentHeader, Method> results = new HashMap<RestContentHeader, Method>();
        for (Method method : methods = content.getClass().getMethods()) {
            if (!method.isAnnotationPresent(RestContentHeader.class)) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length > 0) {
                LOGGER.warn("Parameters are found on method " + method.getName() + " annotated with ContentHeader annotation. No parameter is allowed. Ignoring ContentHeader annotation.");
                continue;
            }
            method.setAccessible(true);
            results.put(method.getAnnotation(RestContentHeader.class), method);
        }
        return results;
    }

    protected final ConfiguredObjectFinder getConfiguredObjectFinder(final ConfiguredObject<?> root) {
        ConfiguredObjectFinder finder = (ConfiguredObjectFinder)this._configuredObjectFinders.get(root);
        if (finder == null) {
            finder = new ConfiguredObjectFinder(root);
            ConfiguredObjectFinder existingValue = this._configuredObjectFinders.putIfAbsent(root, finder);
            if (existingValue != null) {
                finder = existingValue;
            } else {
                AbstractConfigurationChangeListener deletionListener = new AbstractConfigurationChangeListener(){

                    public void stateChanged(ConfiguredObject<?> object, State oldState, State newState) {
                        if (newState == State.DELETED) {
                            AbstractServlet.this._configuredObjectFinders.remove(root);
                        }
                    }
                };
                root.addChangeListener((ConfigurationChangeListener)deletionListener);
                if (root.getState() == State.DELETED) {
                    this._configuredObjectFinders.remove(root);
                    root.removeChangeListener((ConfigurationChangeListener)deletionListener);
                }
            }
        }
        return finder;
    }
}

