/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.filter.SelectorParsingException;
import org.apache.qpid.server.management.plugin.csv.CSVFormat;
import org.apache.qpid.server.management.plugin.servlet.query.ConfiguredObjectQuery;
import org.apache.qpid.server.management.plugin.servlet.query.EvaluationException;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryServlet<X extends ConfiguredObject<?>>
extends AbstractServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryServlet.class);
    private static final CSVFormat CSV_FORMAT = new CSVFormat();

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws IOException, ServletException {
        this.performQuery(request, response, managedObject);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws IOException, ServletException {
        this.performQuery(request, response, managedObject);
    }

    private void performQuery(HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws IOException, ServletException {
        block9: {
            String categoryName;
            X parent = this.getParent(request, managedObject);
            if (parent != null && (categoryName = this.getRequestedCategory(request, managedObject)) != null) {
                Model model = parent.getModel();
                Class<ConfiguredObject> category = this.getSupportedCategory(categoryName, model);
                if (category != null) {
                    List<ConfiguredObject<?>> objects = this.getAllObjects(parent, category, request);
                    try {
                        ConfiguredObjectQuery query = new ConfiguredObjectQuery(objects, request.getParameter("select"), request.getParameter("where"), request.getParameter("orderBy"), request.getParameter("limit"), request.getParameter("offset"));
                        String attachmentFilename = request.getParameter("contentDispositionAttachmentFilename");
                        if (attachmentFilename != null) {
                            this.setContentDispositionHeaderIfNecessary(response, attachmentFilename);
                        }
                        if ("csv".equalsIgnoreCase(request.getParameter("format"))) {
                            this.sendCsvResponse(query, response);
                            break block9;
                        }
                        LinkedHashMap<String, Object> resultsObject = new LinkedHashMap<String, Object>();
                        resultsObject.put("headers", query.getHeaders());
                        resultsObject.put("results", query.getResults());
                        resultsObject.put("total", query.getTotalNumberOfRows());
                        this.sendJsonResponse(resultsObject, request, response);
                    }
                    catch (SelectorParsingException e) {
                        this.sendJsonErrorResponse(request, response, 400, e.getMessage());
                    }
                    catch (EvaluationException e) {
                        this.sendJsonErrorResponse(request, response, 422, e.getMessage());
                    }
                } else {
                    this.sendJsonErrorResponse(request, response, 404, "Unknown object type " + categoryName);
                }
            } else {
                this.sendJsonErrorResponse(request, response, 404, "Invalid path");
            }
        }
    }

    private void sendCsvResponse(ConfiguredObjectQuery query, HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.setContentType("text/csv;charset=utf-8;");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        this.sendCachingHeadersOnResponse(response);
        try (PrintWriter writer = response.getWriter();){
            CSV_FORMAT.printRecord(writer, query.getHeaders());
            CSV_FORMAT.printRecords(writer, query.getResults());
        }
    }

    protected abstract X getParent(HttpServletRequest var1, ConfiguredObject<?> var2);

    protected abstract Class<? extends ConfiguredObject> getSupportedCategory(String var1, Model var2);

    protected abstract String getRequestedCategory(HttpServletRequest var1, ConfiguredObject<?> var2);

    protected abstract List<ConfiguredObject<?>> getAllObjects(X var1, Class<? extends ConfiguredObject> var2, HttpServletRequest var3);
}

