/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;

public class GunzipOutputStream
extends InflaterOutputStream {
    private final GZIPHeader _header = new GZIPHeader();
    private final GZIPTrailer _trailer = new GZIPTrailer();
    private final byte[] _singleByteArray = new byte[1];
    private final CRC32 _crc;
    private StreamState _streamState = StreamState.HEADER_PARSING;

    public GunzipOutputStream(OutputStream targetOutputStream) {
        super(new CheckedOutputStream(targetOutputStream, new CRC32()), new Inflater(true));
        this._crc = (CRC32)((CheckedOutputStream)this.out).getChecksum();
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data, offset, length);){
            int b;
            while ((b = bais.read()) != -1) {
                if (this._streamState == StreamState.DONE) {
                    this._streamState = StreamState.HEADER_PARSING;
                    this._crc.reset();
                    this._header.reset();
                    this._trailer.reset();
                    this.inf.reset();
                }
                if (this._streamState == StreamState.HEADER_PARSING) {
                    this._header.headerByte(b);
                    if (this._header.getState() == HeaderState.DONE) {
                        this._streamState = StreamState.INFLATING;
                        continue;
                    }
                }
                if (this._streamState == StreamState.INFLATING) {
                    this._singleByteArray[0] = (byte)b;
                    super.write(this._singleByteArray, 0, 1);
                    if (this.inf.finished()) {
                        this._streamState = StreamState.TRAILER_PARSING;
                        continue;
                    }
                }
                if (this._streamState != StreamState.TRAILER_PARSING || !this._trailer.trailerByte(b)) continue;
                this._trailer.verify(this._crc);
                this._streamState = StreamState.DONE;
            }
        }
    }

    private class GZIPTrailer {
        private static final int TRAILER_SIZE = 8;
        private static final long SIZE_MASK = 0xFFFFFFFFL;
        private final byte[] _trailerBytes = new byte[8];
        private int _receivedByteIndex;

        private GZIPTrailer() {
        }

        private boolean trailerByte(int b) throws IOException {
            if (this._receivedByteIndex < 8) {
                this._trailerBytes[this._receivedByteIndex++] = (byte)(b & 0xFF);
                return this._receivedByteIndex == 8;
            }
            throw new IOException(String.format("Received too many GZIP trailer bytes. Expecting %d bytes.", 8));
        }

        private void verify(CRC32 crc) throws IOException {
            try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(this._trailerBytes));){
                long crc32 = this.readLittleEndianLong(in);
                if (crc32 != crc.getValue()) {
                    throw new IOException("crc32 mismatch. Gzip-compressed data is corrupted");
                }
                long isize = this.readLittleEndianLong(in);
                if (isize != (GunzipOutputStream.this.inf.getBytesWritten() & 0xFFFFFFFFL)) {
                    throw new IOException("Uncompressed size mismatch. Gzip-compressed data is corrupted");
                }
            }
        }

        private long readLittleEndianLong(DataInputStream inData) throws IOException {
            return (long)(inData.readUnsignedByte() | inData.readUnsignedByte() << 8 | inData.readUnsignedByte() << 16) | (long)inData.readUnsignedByte() << 24;
        }

        private void reset() {
            this._receivedByteIndex = 0;
        }
    }

    private static class GZIPHeader {
        private static final int GZIP_MAGIC_1 = 31;
        private static final int GZIP_MAGIC_2 = 139;
        private static final int SUPPORTED_COMPRESSION_METHOD = 8;
        private HeaderState _state = HeaderState.ID1;
        private byte _flags;
        private byte _xlen0;
        private int _xlen;
        private int _fExtraCounter;

        private GZIPHeader() {
        }

        private void headerByte(int headerByte) throws IOException {
            int b = headerByte & 0xFF;
            switch (this._state) {
                case ID1: {
                    if (b != 31) {
                        throw new IOException(String.format("Incorrect first magic byte: got '%X' but expected '%X'", headerByte, 31));
                    }
                    this._state = HeaderState.ID2;
                    break;
                }
                case ID2: {
                    if (b != 139) {
                        throw new IOException(String.format("Incorrect second magic byte: got '%X' but expected '%X'", headerByte, 139));
                    }
                    this._state = HeaderState.CM;
                    break;
                }
                case CM: {
                    if (b != 8) {
                        throw new IOException(String.format("Unexpected compression method : '%X'", b));
                    }
                    this._state = HeaderState.FLG;
                    break;
                }
                case FLG: {
                    this._flags = (byte)b;
                    this._state = HeaderState.MTIME_0;
                    break;
                }
                case MTIME_0: {
                    this._state = HeaderState.MTIME_1;
                    break;
                }
                case MTIME_1: {
                    this._state = HeaderState.MTIME_2;
                    break;
                }
                case MTIME_2: {
                    this._state = HeaderState.MTIME_3;
                    break;
                }
                case MTIME_3: {
                    this._state = HeaderState.XFL;
                    break;
                }
                case XFL: {
                    this._state = HeaderState.OS;
                    break;
                }
                case OS: {
                    this.adjustStateAccordingToFlags(new HeaderState[0]);
                    break;
                }
                case XLEN_0: {
                    this._xlen0 = (byte)b;
                    this._state = HeaderState.XLEN_1;
                    break;
                }
                case XLEN_1: {
                    this._xlen = b << 8 | this._xlen0;
                    this._state = HeaderState.FEXTRA;
                    break;
                }
                case FEXTRA: {
                    ++this._fExtraCounter;
                    if (this._fExtraCounter != this._xlen) break;
                    this.adjustStateAccordingToFlags(HeaderState.XLEN_0);
                    break;
                }
                case FNAME: {
                    if (b != 0) break;
                    this.adjustStateAccordingToFlags(HeaderState.XLEN_0, HeaderState.FNAME);
                    break;
                }
                case FCOMMENT: {
                    if (b != 0) break;
                    this.adjustStateAccordingToFlags(HeaderState.XLEN_0, HeaderState.FNAME, HeaderState.FCOMMENT);
                    break;
                }
                case CRC16_0: {
                    this._state = HeaderState.CRC16_1;
                    break;
                }
                case CRC16_1: {
                    this._state = HeaderState.DONE;
                    break;
                }
                default: {
                    throw new IOException("Unexpected state " + this._state);
                }
            }
        }

        private void adjustStateAccordingToFlags(HeaderState ... previousStates) {
            EnumSet<HeaderState> previous;
            EnumSet<HeaderState> enumSet = previous = previousStates.length == 0 ? EnumSet.noneOf(HeaderState.class) : EnumSet.copyOf(Arrays.asList(previousStates));
            this._state = (this._flags & 4) != 0 && !previous.contains((Object)HeaderState.XLEN_0) ? HeaderState.XLEN_0 : ((this._flags & 8) != 0 && !previous.contains((Object)HeaderState.FNAME) ? HeaderState.FNAME : ((this._flags & 0x10) != 0 && !previous.contains((Object)HeaderState.FCOMMENT) ? HeaderState.FCOMMENT : ((this._flags & 2) != 0 && !previous.contains((Object)HeaderState.CRC16_0) ? HeaderState.CRC16_0 : HeaderState.DONE)));
        }

        private HeaderState getState() {
            return this._state;
        }

        private void reset() {
            this._state = HeaderState.ID1;
            this._flags = 0;
            this._xlen0 = 0;
            this._xlen = 0;
            this._fExtraCounter = 0;
        }
    }

    private static enum HeaderState {
        ID1,
        ID2,
        CM,
        FLG,
        MTIME_0,
        MTIME_1,
        MTIME_2,
        MTIME_3,
        XFL,
        OS,
        XLEN_0,
        XLEN_1,
        FEXTRA,
        FNAME,
        FCOMMENT,
        CRC16_0,
        CRC16_1,
        DONE;

    }

    private static enum StreamState {
        HEADER_PARSING,
        INFLATING,
        TRAILER_PARSING,
        DONE;

    }
}

