/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.security.auth.Subject;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpRequestPreemptiveAuthenticator;
import org.apache.qpid.server.management.plugin.SessionInvalidatedException;
import org.apache.qpid.server.management.plugin.servlet.ServletConnectionPrincipal;
import org.apache.qpid.server.management.plugin.session.LoginLogoutReporter;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.port.HttpPort;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.Action;

public class HttpManagementUtil {
    public static final String ATTR_BROKER = "Qpid.broker";
    public static final String ATTR_MANAGEMENT_CONFIGURATION = "Qpid.managementConfiguration";
    private static final String ATTR_LOGIN_LOGOUT_REPORTER = "Qpid.loginLogoutReporter";
    private static final String ATTR_SUBJECT = "Qpid.subject";
    private static final String ATTR_INVALIDATE_FUTURE = "Qpid.invalidateFuture";
    private static final String ATTR_LOG_ACTOR = "Qpid.logActor";
    private static final String ATTR_PORT = "org.apache.qpid.server.model.Port";
    public static final String ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    public static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    public static final String GZIP_CONTENT_ENCODING = "gzip";
    private static final Collection<HttpRequestPreemptiveAuthenticator> AUTHENTICATORS;
    private static final Operation MANAGE_ACTION;

    public static String getRequestSpecificAttributeName(String name, HttpServletRequest request) {
        return name + "." + HttpManagementUtil.getPort(request).getId();
    }

    static Action<HttpServletRequest> getPortAttributeAction(Port<?> port) {
        return request -> request.setAttribute(ATTR_PORT, (Object)port);
    }

    public static HttpPort<?> getPort(HttpServletRequest request) {
        return (HttpPort)request.getAttribute(ATTR_PORT);
    }

    public static Broker<?> getBroker(ServletContext servletContext) {
        return (Broker)servletContext.getAttribute(ATTR_BROKER);
    }

    public static HttpManagementConfiguration getManagementConfiguration(ServletContext servletContext) {
        return (HttpManagementConfiguration)servletContext.getAttribute(ATTR_MANAGEMENT_CONFIGURATION);
    }

    public static Subject getAuthorisedSubject(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        try {
            return (Subject)session.getAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_SUBJECT, request));
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public static Subject createServletConnectionSubject(HttpServletRequest request, Subject original) {
        Subject subject = new Subject(false, original.getPrincipals(), original.getPublicCredentials(), original.getPrivateCredentials());
        subject.getPrincipals().add((Principal)((Object)new ServletConnectionPrincipal(request)));
        subject.setReadOnly();
        return subject;
    }

    public static void assertManagementAccess(Broker<?> broker, Subject subject) {
        Subject.doAs(subject, () -> {
            broker.authorise(MANAGE_ACTION);
            return null;
        });
    }

    public static void saveAuthorisedSubject(HttpServletRequest request, Subject subject) {
        HttpSession session = request.getSession();
        Broker<?> broker = HttpManagementUtil.getBroker(session.getServletContext());
        HttpPort<?> port = HttpManagementUtil.getPort(request);
        HttpManagementUtil.setSessionAttribute(ATTR_SUBJECT, subject, session, request);
        HttpManagementUtil.setSessionAttribute(ATTR_LOGIN_LOGOUT_REPORTER, new LoginLogoutReporter(subject, (EventLoggerProvider)broker), session, request);
        long absoluteSessionTimeout = port.getAbsoluteSessionTimeout();
        if (absoluteSessionTimeout > 0L) {
            HttpManagementUtil.scheduleAbsoluteSessionTimeout(request, session, broker, absoluteSessionTimeout);
        }
    }

    private static void scheduleAbsoluteSessionTimeout(HttpServletRequest request, HttpSession session, Broker<?> broker, long absoluteSessionTimeout) {
        final ScheduledFuture invalidateFuture = broker.scheduleTask(absoluteSessionTimeout, TimeUnit.MILLISECONDS, () -> HttpManagementUtil.invalidateSession(session));
        HttpManagementUtil.setSessionAttribute(ATTR_INVALIDATE_FUTURE, new HttpSessionBindingListener(){

            public void valueBound(HttpSessionBindingEvent event) {
            }

            public void valueUnbound(HttpSessionBindingEvent event) {
                invalidateFuture.cancel(false);
            }
        }, session, request);
    }

    public static Subject tryToAuthenticate(HttpServletRequest request, HttpManagementConfiguration managementConfig) {
        HttpRequestPreemptiveAuthenticator authenticator;
        Subject subject = null;
        Iterator<HttpRequestPreemptiveAuthenticator> iterator = AUTHENTICATORS.iterator();
        while (iterator.hasNext() && (subject = (authenticator = iterator.next()).attemptAuthentication(request, managementConfig)) == null) {
        }
        return subject;
    }

    public static OutputStream getOutputStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return HttpManagementUtil.getOutputStream(request, response, HttpManagementUtil.getManagementConfiguration(request.getServletContext()));
    }

    public static OutputStream getOutputStream(HttpServletRequest request, HttpServletResponse response, HttpManagementConfiguration managementConfiguration) throws IOException {
        Object outputStream;
        if (HttpManagementUtil.isCompressingAccepted(request, managementConfiguration)) {
            outputStream = new GZIPOutputStream((OutputStream)response.getOutputStream());
            response.setHeader(CONTENT_ENCODING_HEADER, GZIP_CONTENT_ENCODING);
        } else {
            outputStream = response.getOutputStream();
        }
        return outputStream;
    }

    public static boolean isCompressingAccepted(HttpServletRequest request, HttpManagementConfiguration managementConfiguration) {
        return managementConfiguration.isCompressResponses() && Collections.list(request.getHeaderNames()).contains(ACCEPT_ENCODING_HEADER) && request.getHeader(ACCEPT_ENCODING_HEADER).contains(GZIP_CONTENT_ENCODING);
    }

    public static String ensureFilenameIsRfc2183(String requestedFilename) {
        return requestedFilename.replaceAll("[\\P{InBasic_Latin}\\\\:/\\p{Cntrl}]", "");
    }

    public static List<String> getPathInfoElements(String servletPath, String pathInfo) {
        if (pathInfo == null || pathInfo.length() == 0) {
            return List.of();
        }
        String[] pathInfoElements = pathInfo.substring(1).split("/");
        for (int i = 0; i < pathInfoElements.length; ++i) {
            pathInfoElements[i] = URLDecoder.decode(pathInfoElements[i], StandardCharsets.UTF_8);
        }
        return Arrays.asList(pathInfoElements);
    }

    public static String getRequestURL(HttpServletRequest httpRequest) {
        StringBuilder urlBuilder = new StringBuilder(httpRequest.getRequestURL());
        String queryString = httpRequest.getQueryString();
        if (queryString != null) {
            urlBuilder.append('?').append(queryString);
        }
        String url = urlBuilder.toString();
        return url;
    }

    public static String getRequestPrincipals(HttpServletRequest httpRequest) {
        Set<Principal> principalSet;
        Subject subject;
        HttpSession session = httpRequest.getSession(false);
        if (session != null && (subject = HttpManagementUtil.getAuthorisedSubject(httpRequest)) != null && !(principalSet = subject.getPrincipals()).isEmpty()) {
            TreeSet<String> principalNames = new TreeSet<String>();
            for (Principal principal : principalSet) {
                principalNames.add(principal.getName());
            }
            return principalNames.toString();
        }
        return null;
    }

    public static void invalidateSession(HttpSession session) {
        try {
            session.invalidate();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static Object getSessionAttribute(String attributeName, HttpSession session, HttpServletRequest request) {
        String requestSpecificAttributeName = HttpManagementUtil.getRequestSpecificAttributeName(attributeName, request);
        try {
            return session.getAttribute(requestSpecificAttributeName);
        }
        catch (IllegalStateException e) {
            throw new SessionInvalidatedException();
        }
    }

    public static void setSessionAttribute(String attributeName, Object attributeValue, HttpSession session, HttpServletRequest request) {
        String requestSpecificAttributeName = HttpManagementUtil.getRequestSpecificAttributeName(attributeName, request);
        try {
            session.setAttribute(requestSpecificAttributeName, attributeValue);
        }
        catch (IllegalStateException e) {
            throw new SessionInvalidatedException();
        }
    }

    public static void removeAttribute(String attributeName, HttpSession session, HttpServletRequest request) {
        String requestSpecificAttributeName = HttpManagementUtil.getRequestSpecificAttributeName(attributeName, request);
        try {
            session.removeAttribute(requestSpecificAttributeName);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void createServletConnectionSubjectAssertManagementAccessAndSave(Broker broker, HttpServletRequest request, Subject original) {
        Subject subject = HttpManagementUtil.createServletConnectionSubject(request, original);
        HttpManagementUtil.assertManagementAccess(broker, subject);
        HttpManagementUtil.saveAuthorisedSubject(request, subject);
    }

    static {
        MANAGE_ACTION = Operation.PERFORM_ACTION((String)"manage");
        ArrayList<HttpRequestPreemptiveAuthenticator> authenticators = new ArrayList<HttpRequestPreemptiveAuthenticator>();
        for (HttpRequestPreemptiveAuthenticator authenticator : new QpidServiceLoader().instancesOf(HttpRequestPreemptiveAuthenticator.class)) {
            authenticators.add(authenticator);
        }
        AUTHENTICATORS = Collections.unmodifiableList(authenticators);
    }
}

