/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Strings;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.ManagementController;
import org.apache.qpid.server.management.plugin.ManagementException;
import org.apache.qpid.server.management.plugin.ManagementRequest;
import org.apache.qpid.server.management.plugin.ManagementResponse;
import org.apache.qpid.server.management.plugin.ResponseType;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectJacksonModule;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.port.HttpPort;
import org.apache.qpid.server.util.DataUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServlet
extends AbstractServlet {
    private static final long serialVersionUID = 1L;
    private static final String APPLICATION_JSON = "application/json";
    private static final Logger LOGGER = LoggerFactory.getLogger(RestServlet.class);
    private transient ManagementController _managementController;

    @Override
    public void init() throws ServletException {
        super.init();
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        String modelVersion = servletConfig.getInitParameter("qpid.controller.version");
        if (modelVersion == null) {
            throw new ServletException("Controller version is not specified");
        }
        ManagementController controller = (ManagementController)servletContext.getAttribute("qpid.controller.chain");
        do {
            if (!controller.getVersion().equals(modelVersion)) continue;
            this._managementController = controller;
            break;
        } while ((controller = controller.getNextVersionManagementController()) != null);
        if (this._managementController == null) {
            throw new ServletException("Controller is not found");
        }
    }

    @Override
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ConfiguredObject<?> managedObject) throws IOException {
        try {
            ServletManagementRequest request = new ServletManagementRequest(managedObject, httpServletRequest);
            ManagementController controller = this.getManagementController();
            ManagementResponse response = controller.handleGet(request);
            this.sendResponse(request, response, httpServletRequest, httpServletResponse, controller);
        }
        catch (ManagementException e) {
            LOGGER.error("Error when executing GET request", (Throwable)e);
            this.sendResponse(e, httpServletRequest, httpServletResponse);
        }
    }

    @Override
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ConfiguredObject<?> managedObject) throws IOException {
        try {
            ServletManagementRequest request = new ServletManagementRequest(managedObject, httpServletRequest);
            ManagementController controller = this.getManagementController();
            ManagementResponse response = controller.handlePost(request);
            this.sendResponse(request, response, httpServletRequest, httpServletResponse, controller);
        }
        catch (ManagementException e) {
            LOGGER.error("Error when executing POST request", (Throwable)e);
            this.sendResponse(e, httpServletRequest, httpServletResponse);
        }
    }

    @Override
    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ConfiguredObject<?> managedObject) throws IOException {
        try {
            ServletManagementRequest request = new ServletManagementRequest(managedObject, httpServletRequest);
            ManagementController controller = this.getManagementController();
            ManagementResponse response = controller.handlePut(request);
            this.sendResponse(request, response, httpServletRequest, httpServletResponse, controller);
        }
        catch (ManagementException e) {
            LOGGER.error("Error when executing PUT request", (Throwable)e);
            this.sendResponse(e, httpServletRequest, httpServletResponse);
        }
    }

    @Override
    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ConfiguredObject<?> managedObject) throws IOException {
        try {
            ServletManagementRequest request = new ServletManagementRequest(managedObject, httpServletRequest);
            ManagementController controller = this.getManagementController();
            ManagementResponse response = controller.handleDelete(request);
            this.sendResponse(request, response, httpServletRequest, httpServletResponse, controller);
        }
        catch (ManagementException e) {
            LOGGER.error("Error when executing DELETE request", (Throwable)e);
            this.sendResponse(e, httpServletRequest, httpServletResponse);
        }
    }

    private ManagementController getManagementController() {
        return this._managementController;
    }

    private void sendResponse(ManagementException managementException, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.setHeaders(response);
        this.setExceptionHeaders(managementException, response);
        response.setStatus(managementException.getStatusCode());
        this.writeJsonResponse(Map.of("errorMessage", "There was an error when performing request, see log file for details"), request, response);
    }

    private void setExceptionHeaders(ManagementException managementException, HttpServletResponse response) {
        Map<String, String> headers = managementException.getHeaders();
        if (headers != null) {
            headers.forEach((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
        }
    }

    private String toContentDispositionHeader(String attachmentFilename) {
        String filenameRfc2183 = HttpManagementUtil.ensureFilenameIsRfc2183(attachmentFilename);
        if (filenameRfc2183.length() > 0) {
            return String.format("attachment; filename=\"%s\"", filenameRfc2183);
        }
        return "attachment";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(ManagementRequest managementRequest, ManagementResponse managementResponse, HttpServletRequest request, HttpServletResponse response, ManagementController controller) throws IOException {
        Map<String, List<String>> parameters;
        this.setHeaders(response);
        Map<String, String> headers = managementResponse.getHeaders();
        if (!headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                this.addSanitizedResponseHeader(response, entry.getKey(), entry.getValue());
            }
        }
        if ((parameters = managementRequest.getParameters()).containsKey("contentDispositionAttachmentFilename")) {
            String attachmentFilename = managementRequest.getParameter("contentDispositionAttachmentFilename");
            response.setHeader("Content-Disposition", this.toContentDispositionHeader(attachmentFilename));
        }
        response.setStatus(managementResponse.getResponseCode());
        Object body = managementResponse.getBody();
        if (body instanceof Content) {
            Content content = (Content)body;
            try {
                this.writeTypedContent(content, request, response);
            }
            finally {
                content.release();
            }
        } else {
            response.setContentType(APPLICATION_JSON);
            if (body != null && managementResponse.getType() == ResponseType.MODEL_OBJECT) {
                body = controller.formatConfiguredObject(managementResponse.getBody(), parameters, managementRequest.isSecure() || managementRequest.isConfidentialOperationAllowedOnInsecureChannel());
            }
            this.writeJsonResponse(body, request, response);
        }
    }

    private void setHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
    }

    private void writeJsonResponse(Object formattedResponse, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (OutputStream stream = HttpManagementUtil.getOutputStream(request, response, this.getManagementConfiguration());){
            ObjectMapper mapper = ConfiguredObjectJacksonModule.newObjectMapper((boolean)false);
            mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            mapper.writeValue(stream, formattedResponse);
        }
    }

    private static Map<String, List<String>> parseQueryString(String queryString) {
        String[] pairs;
        if (Strings.isNullOrEmpty((String)queryString)) {
            return Map.of();
        }
        LinkedHashMap<String, List<String>> query = new LinkedHashMap<String, List<String>>();
        for (String pairString : pairs = queryString.split("&")) {
            String value;
            ArrayList<String> pair = new ArrayList<String>(Arrays.asList(pairString.split("=")));
            if (pair.size() == 1) {
                pair.add(null);
            } else if (pair.size() != 2) {
                throw new IllegalArgumentException(String.format("could not parse query string '%s'", queryString));
            }
            String key = URLDecoder.decode((String)pair.get(0), StandardCharsets.UTF_8);
            String string = value = pair.get(1) == null ? null : URLDecoder.decode((String)pair.get(1), StandardCharsets.UTF_8);
            if (!query.containsKey(key)) {
                query.put(key, new ArrayList());
            }
            ((List)query.get(key)).add(value);
        }
        return query;
    }

    private static class ServletManagementRequest
    implements ManagementRequest {
        private final HttpPort<?> _port;
        private final HttpServletRequest _request;
        private final Map<String, List<String>> _query;
        private final List<String> _path;
        private final ConfiguredObject<?> _root;
        private final String _category;
        private final Map<String, String> _headers;

        ServletManagementRequest(ConfiguredObject<?> root, HttpServletRequest request) {
            this._root = root;
            this._request = request;
            this._port = HttpManagementUtil.getPort(request);
            this._query = Collections.unmodifiableMap(RestServlet.parseQueryString(request.getQueryString()));
            String pathInfo = this._request.getPathInfo() == null ? "" : this._request.getPathInfo();
            String servletPath = request.getServletPath();
            this._path = Collections.unmodifiableList(HttpManagementUtil.getPathInfoElements(servletPath, pathInfo));
            String[] servletPathElements = servletPath.split("/");
            this._category = servletPathElements[servletPathElements.length - 1];
            Map<String, String> headers = Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(name -> name, arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
            this._headers = Collections.unmodifiableMap(headers);
        }

        @Override
        public ConfiguredObject<?> getRoot() {
            return this._root;
        }

        @Override
        public boolean isSecure() {
            return this._request.isSecure();
        }

        @Override
        public boolean isConfidentialOperationAllowedOnInsecureChannel() {
            return this._port.isAllowConfidentialOperationsOnInsecureChannels();
        }

        @Override
        public List<String> getPath() {
            return this._path;
        }

        @Override
        public String getMethod() {
            return this._request.getMethod();
        }

        @Override
        public Map<String, List<String>> getParameters() {
            return this._query;
        }

        @Override
        public String getParameter(String name) {
            List<String> values = this._query.get(name);
            return values == null || values.isEmpty() ? null : values.get(0);
        }

        @Override
        public Map<String, String> getHeaders() {
            return this._headers;
        }

        @Override
        public <T> T getBody(Class<T> type) {
            try {
                return this.parse(type);
            }
            catch (ServletException | IOException e) {
                throw ManagementException.createBadRequestManagementException("Cannot parse body", e);
            }
        }

        @Override
        public String getRequestURL() {
            return this._request.getRequestURL().toString();
        }

        private <T> T parse(Class<T> type) throws IOException, ServletException {
            LinkedHashMap providedObject;
            ObjectMapper mapper = new ObjectMapper();
            if (this._headers.containsKey("Content-Type") && this._request.getHeader("Content-Type").startsWith("multipart/form-data")) {
                Map items = new LinkedHashMap();
                HashMap<String, String> fileUploads = new HashMap<String, String>();
                Collection parts = this._request.getParts();
                for (Part part : parts) {
                    if ("data".equals(part.getName()) && RestServlet.APPLICATION_JSON.equals(part.getContentType())) {
                        items = (Map)mapper.readValue(part.getInputStream(), LinkedHashMap.class);
                        continue;
                    }
                    byte[] data = new byte[(int)part.getSize()];
                    try (InputStream inputStream = part.getInputStream();){
                        inputStream.read(data);
                    }
                    fileUploads.put(part.getName(), DataUrlUtils.getDataUrlForBytes((byte[])data));
                }
                items.putAll(fileUploads);
                providedObject = items;
            } else {
                providedObject = mapper.readValue((InputStream)this._request.getInputStream(), type);
            }
            return (T)providedObject;
        }

        @Override
        public Map<String, Object> getParametersAsFlatMap() {
            HashMap<String, Object> providedObject = new HashMap<String, Object>();
            for (Map.Entry<String, List<String>> entry : this._query.entrySet()) {
                List<String> value = entry.getValue();
                if (value == null) continue;
                if (value.size() == 1) {
                    providedObject.put(entry.getKey(), value.get(0));
                    continue;
                }
                providedObject.put(entry.getKey(), value);
            }
            return providedObject;
        }

        @Override
        public String getCategory() {
            return this._category;
        }
    }
}

