/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Arrays;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.RuntimeErrorException;
import javax.management.remote.MBeanServerForwarder;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.actors.ManagementActor;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;

public class MBeanInvocationHandlerImpl
implements InvocationHandler {
    private static final Logger _logger = Logger.getLogger(MBeanInvocationHandlerImpl.class);
    private static final String DELEGATE = "JMImplementation:type=MBeanServerDelegate";
    private MBeanServer _mbs;
    private final ManagementActor _logActor;
    private final boolean _managementRightsInferAllAccess = Boolean.valueOf(System.getProperty("qpid.broker_jmx_method_rights_infer_all_access", "true"));
    private final Broker _broker;

    MBeanInvocationHandlerImpl(Broker broker) {
        this._broker = broker;
        this._logActor = new ManagementActor(broker.getRootMessageLogger());
    }

    public static MBeanServerForwarder newProxyInstance(Broker broker) {
        MBeanInvocationHandlerImpl handler = new MBeanInvocationHandlerImpl(broker);
        Class[] interfaces = new Class[]{MBeanServerForwarder.class};
        Object proxy = Proxy.newProxyInstance(MBeanServerForwarder.class.getClassLoader(), interfaces, (InvocationHandler)handler);
        return (MBeanServerForwarder)MBeanServerForwarder.class.cast(proxy);
    }

    private boolean invokeDirectly(String methodName, Object[] args, Subject subject) {
        ObjectName mbean;
        if (subject == null) {
            return true;
        }
        if (args == null || DELEGATE.equals(args[0])) {
            return true;
        }
        if (methodName.equals("queryNames") || methodName.equals("queryMBeans")) {
            return true;
        }
        return args[0] instanceof ObjectName && !"org.apache.qpid".equalsIgnoreCase((mbean = (ObjectName)args[0]).getDomain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object e2;
        String methodName = method.getName();
        if (methodName.equals("getMBeanServer")) {
            return this._mbs;
        }
        if (methodName.equals("setMBeanServer")) {
            if (args[0] == null) {
                throw new IllegalArgumentException("Null MBeanServer");
            }
            if (this._mbs != null) {
                throw new IllegalArgumentException("MBeanServer object already initialized");
            }
            this._mbs = (MBeanServer)args[0];
            return null;
        }
        if (methodName.equals("createMBean") || methodName.equals("unregisterMBean")) {
            _logger.debug((Object)"User trying to create or unregister an MBean");
            throw new SecurityException("Access denied: " + methodName);
        }
        AccessControlContext acc = AccessController.getContext();
        Subject subject = Subject.getSubject(acc);
        if (this.invokeDirectly(methodName, args, subject)) {
            return method.invoke((Object)this._mbs, args);
        }
        try {
            AuthenticatedPrincipal.getAuthenticatedPrincipalFromSubject((Subject)subject);
        }
        catch (Exception e2) {
            throw new SecurityException("Access denied: no authenticated principal", e2);
        }
        SecurityManager.setThreadSubject((Subject)subject);
        CurrentActor.set((LogActor)this._logActor);
        try {
            e2 = this.authoriseAndInvoke(method, args);
        }
        catch (Throwable throwable) {
            try {
                CurrentActor.remove();
                throw throwable;
            }
            catch (InvocationTargetException e3) {
                Throwable targetException = e3.getCause();
                this.logTargetException(method, args, targetException);
                throw targetException;
            }
        }
        CurrentActor.remove();
        return e2;
    }

    private void logTargetException(Method method, Object[] args, Throwable targetException) {
        Throwable error = null;
        if (targetException instanceof RuntimeErrorException) {
            error = ((RuntimeErrorException)targetException).getCause();
        } else if (targetException instanceof Error) {
            error = targetException;
        }
        if (error == null) {
            _logger.debug((Object)("Exception was thrown on invoking of " + method + " with arguments " + Arrays.toString(args)), targetException);
        } else {
            _logger.error((Object)("Unexpected error occured on invoking of " + method + " with arguments " + Arrays.toString(args)), targetException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object authoriseAndInvoke(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        SecurityManager security;
        String type = this.getType(method, args);
        String vhost = this.getVirtualHost(method, args);
        int impact = this.getImpact(method, args);
        if (vhost == null) {
            security = this._broker.getSecurityManager();
        } else {
            VirtualHost virtualHost = this._broker.findVirtualHostByName(vhost);
            if (virtualHost == null) {
                throw new IllegalArgumentException("Virtual host with name '" + vhost + "' is not found.");
            }
            security = virtualHost.getSecurityManager();
        }
        String methodName = this.getMethodName(method, args);
        if (this.isAccessMethod(methodName) || impact == 0) {
            if (!security.authoriseMethod(Operation.ACCESS, type, methodName)) {
                throw new SecurityException("Permission denied: Access " + methodName);
            }
        } else if (!security.authoriseMethod(Operation.UPDATE, type, methodName)) {
            throw new SecurityException("Permission denied: Update " + methodName);
        }
        boolean oldAccessChecksDisabled = false;
        if (this._managementRightsInferAllAccess) {
            oldAccessChecksDisabled = SecurityManager.setAccessChecksDisabled((boolean)true);
        }
        try {
            Object object = method.invoke((Object)this._mbs, args);
            return object;
        }
        finally {
            if (this._managementRightsInferAllAccess) {
                SecurityManager.setAccessChecksDisabled((boolean)oldAccessChecksDisabled);
            }
        }
    }

    private String getType(Method method, Object[] args) {
        if (args[0] instanceof ObjectName) {
            ObjectName object = (ObjectName)args[0];
            String type = object.getKeyProperty("type");
            return type;
        }
        return null;
    }

    private String getVirtualHost(Method method, Object[] args) {
        if (args[0] instanceof ObjectName) {
            ObjectName object = (ObjectName)args[0];
            String vhost = object.getKeyProperty("VirtualHost");
            if (vhost != null) {
                try {
                    vhost = ObjectName.unquote(vhost);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            return vhost;
        }
        return null;
    }

    private String getMethodName(Method method, Object[] args) {
        String methodName = method.getName();
        if (args != null && args.length >= 1 && args[0] instanceof ObjectName) {
            if (methodName.equals("getAttribute")) {
                methodName = "get" + (String)args[1];
            } else if (methodName.equals("setAttribute")) {
                methodName = "set" + ((Attribute)args[1]).getName();
            } else if (methodName.equals("invoke")) {
                methodName = (String)args[1];
            }
        }
        return methodName;
    }

    private int getImpact(Method method, Object[] args) {
        if (args[0] instanceof ObjectName && method.getName().equals("invoke")) {
            String mbeanMethod;
            String string = mbeanMethod = args.length > 1 ? (String)args[1] : null;
            if (mbeanMethod == null) {
                return -1;
            }
            try {
                MBeanInfo mbeanInfo = this._mbs.getMBeanInfo((ObjectName)args[0]);
                if (mbeanInfo != null) {
                    MBeanOperationInfo[] opInfos;
                    for (MBeanOperationInfo opInfo : opInfos = mbeanInfo.getOperations()) {
                        if (!opInfo.getName().equals(mbeanMethod)) continue;
                        return opInfo.getImpact();
                    }
                }
            }
            catch (JMException ex) {
                _logger.error((Object)("Unable to determine mbean impact for method : " + mbeanMethod), (Throwable)ex);
            }
        }
        return -1;
    }

    private boolean isAccessMethod(String methodName) {
        return methodName.startsWith("query") || methodName.startsWith("get") || methodName.startsWith("is");
    }
}

