/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx;

import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import org.apache.log4j.Logger;
import org.apache.qpid.server.jmx.UsernameAccessor;
import org.apache.qpid.server.logging.RootMessageLogger;
import org.apache.qpid.server.logging.actors.ManagementActor;
import org.apache.qpid.server.logging.messages.ManagementConsoleMessages;

public class ManagementLogonLogoffReporter
implements NotificationListener,
NotificationFilter {
    private static final Logger LOGGER = Logger.getLogger(ManagementLogonLogoffReporter.class);
    private final RootMessageLogger _rootMessageLogger;
    private final UsernameAccessor _usernameAccessor;

    public ManagementLogonLogoffReporter(RootMessageLogger rootMessageLogger, UsernameAccessor usernameAccessor) {
        this._rootMessageLogger = rootMessageLogger;
        this._usernameAccessor = usernameAccessor;
    }

    public void handleNotification(Notification notification, Object handback) {
        String user;
        String connectionId = ((JMXConnectionNotification)notification).getConnectionId();
        String type = notification.getType();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Notification connectionId : " + connectionId + " type : " + type));
        }
        if ((user = this._usernameAccessor.getUsernameForConnectionId(connectionId)) == null) {
            String[] splitConnectionId = connectionId.split(" ");
            user = splitConnectionId[1];
        }
        ManagementActor logActor = new ManagementActor(this._rootMessageLogger, user);
        if ("jmx.remote.connection.opened".equals(type)) {
            logActor.message(ManagementConsoleMessages.OPEN((String)user));
        } else if ("jmx.remote.connection.closed".equals(type) || "jmx.remote.connection.failed".equals(type)) {
            logActor.message(ManagementConsoleMessages.CLOSE((String)user));
        }
    }

    public boolean isNotificationEnabled(Notification notification) {
        return notification instanceof JMXConnectionNotification && this.isLogonTypeEvent(notification);
    }

    private boolean isLogonTypeEvent(Notification notification) {
        String type = notification.getType();
        return "jmx.remote.connection.closed".equals(type) || "jmx.remote.connection.failed".equals(type) || "jmx.remote.connection.opened".equals(type);
    }
}

