/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;

public class QpidSslRMIServerSocketFactory
extends SslRMIServerSocketFactory {
    private final SSLContext _sslContext;

    public QpidSslRMIServerSocketFactory(SSLContext sslContext) throws NullPointerException {
        if (sslContext == null) {
            throw new NullPointerException("The provided SSLContext must not be null");
        }
        this._sslContext = sslContext;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        final SSLSocketFactory factory = this._sslContext.getSocketFactory();
        return new ServerSocket(port){

            public Socket accept() throws IOException {
                Socket socket = super.accept();
                SSLSocket sslSocket = (SSLSocket)factory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true);
                sslSocket.setUseClientMode(false);
                return sslSocket;
            }
        };
    }

    public boolean equals(Object object) {
        if (!(object instanceof QpidSslRMIServerSocketFactory)) {
            return false;
        }
        QpidSslRMIServerSocketFactory that = (QpidSslRMIServerSocketFactory)object;
        return this._sslContext.equals(that._sslContext);
    }

    public int hashCode() {
        return this._sslContext.hashCode();
    }
}

