/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx.mbeans;

import javax.management.NotCompliantMBeanException;
import org.apache.qpid.server.jmx.AMQManagedObject;
import org.apache.qpid.server.jmx.ManagedObjectRegistry;
import org.apache.qpid.server.model.ConfiguredObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractStatisticsGatheringMBean<T extends ConfiguredObject>
extends AMQManagedObject {
    private long _lastStatUpdateTime;
    private long _statUpdatePeriod = 5000L;
    private long _lastMessagesReceived;
    private long _lastMessagesSent;
    private long _lastBytesReceived;
    private long _lastBytesSent;
    private double _messageReceivedRate;
    private double _messageSentRate;
    private double _bytesReceivedRate;
    private double _bytesSentRate;
    private double _peakMessageReceivedRate;
    private double _peakMessageSentRate;
    private double _peakBytesReceivedRate;
    private double _peakBytesSentRate;
    private final T _configuredObject;

    protected AbstractStatisticsGatheringMBean(Class<?> managementInterface, String typeName, ManagedObjectRegistry registry, T object) throws NotCompliantMBeanException {
        super(managementInterface, typeName, registry);
        this._configuredObject = object;
        this.initStats();
    }

    protected void initStats() {
        this._lastStatUpdateTime = System.currentTimeMillis();
    }

    protected synchronized void updateStats() {
        long time = System.currentTimeMillis();
        long period = time - this._lastStatUpdateTime;
        if (period > this._statUpdatePeriod) {
            long messagesReceived = this.getStatistic("messagesIn");
            long messagesSent = this.getStatistic("messagesOut");
            long bytesReceived = this.getStatistic("bytesIn");
            long bytesSent = this.getStatistic("bytesOut");
            double messageReceivedRate = (double)(messagesReceived - this._lastMessagesReceived) / (double)period;
            double messageSentRate = (double)(messagesSent - this._lastMessagesSent) / (double)period;
            double bytesReceivedRate = (double)(bytesReceived - this._lastBytesReceived) / (double)period;
            double bytesSentRate = (double)(bytesSent - this._lastBytesSent) / (double)period;
            this._lastMessagesReceived = messagesReceived;
            this._lastMessagesSent = messagesSent;
            this._lastBytesReceived = bytesReceived;
            this._lastBytesSent = bytesSent;
            this._messageReceivedRate = messageReceivedRate;
            this._messageSentRate = messageSentRate;
            this._bytesReceivedRate = bytesReceivedRate;
            this._bytesSentRate = bytesSentRate;
            if (messageReceivedRate > this._peakMessageReceivedRate) {
                this._peakMessageReceivedRate = messageReceivedRate;
            }
            if (messageSentRate > this._peakMessageSentRate) {
                this._peakMessageSentRate = messageSentRate;
            }
            if (bytesReceivedRate > this._peakBytesReceivedRate) {
                this._peakBytesReceivedRate = bytesReceivedRate;
            }
            if (bytesSentRate > this._peakBytesSentRate) {
                this._peakBytesSentRate = bytesSentRate;
            }
        }
    }

    private long getStatistic(String name) {
        return (Long)this.getConfiguredObject().getStatistics().getStatistic(name);
    }

    public synchronized void resetStatistics() throws Exception {
        this.updateStats();
    }

    public synchronized double getPeakMessageDeliveryRate() {
        this.updateStats();
        return this._peakMessageSentRate;
    }

    public synchronized double getPeakDataDeliveryRate() {
        this.updateStats();
        return this._peakBytesSentRate;
    }

    public synchronized double getMessageDeliveryRate() {
        this.updateStats();
        return this._messageSentRate;
    }

    public synchronized double getDataDeliveryRate() {
        this.updateStats();
        return this._bytesSentRate;
    }

    public synchronized long getTotalMessagesDelivered() {
        this.updateStats();
        return this.getStatistic("messagesOut");
    }

    public synchronized long getTotalDataDelivered() {
        this.updateStats();
        return this.getStatistic("bytesOut");
    }

    protected final T getConfiguredObject() {
        return this._configuredObject;
    }

    public synchronized double getPeakMessageReceiptRate() {
        this.updateStats();
        return this._peakMessageReceivedRate;
    }

    public synchronized double getPeakDataReceiptRate() {
        this.updateStats();
        return this._peakBytesReceivedRate;
    }

    public synchronized double getMessageReceiptRate() {
        this.updateStats();
        return this._messageReceivedRate;
    }

    public synchronized double getDataReceiptRate() {
        this.updateStats();
        return this._bytesReceivedRate;
    }

    public synchronized long getTotalMessagesReceived() {
        this.updateStats();
        return this.getStatistic("messagesIn");
    }

    public synchronized long getTotalDataReceived() {
        this.updateStats();
        return this.getStatistic("bytesIn");
    }
}

