/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx.mbeans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.apache.qpid.server.jmx.AMQManagedObject;
import org.apache.qpid.server.jmx.ManagedObject;
import org.apache.qpid.server.jmx.ManagedObjectRegistry;
import org.apache.qpid.server.jmx.mbeans.ConnectionMBean;
import org.apache.qpid.server.jmx.mbeans.ExchangeMBean;
import org.apache.qpid.server.jmx.mbeans.QueueMBean;
import org.apache.qpid.server.jmx.mbeans.VirtualHostManagerMBean;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.virtualhost.ManagedVirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualHostMBean
extends AMQManagedObject
implements ManagedVirtualHost,
ConfigurationChangeListener {
    private static final Logger LOGGER = Logger.getLogger(VirtualHostMBean.class);
    private final VirtualHost _virtualHost;
    private final Map<ConfiguredObject, AMQManagedObject> _children = new HashMap<ConfiguredObject, AMQManagedObject>();
    private VirtualHostManagerMBean _managerMBean;

    public VirtualHostMBean(VirtualHost virtualHost, ManagedObjectRegistry registry) throws JMException {
        super(ManagedVirtualHost.class, "VirtualHost", registry);
        this._virtualHost = virtualHost;
        virtualHost.addChangeListener((ConfigurationChangeListener)this);
        this.initQueues();
        this.initExchanges();
        this.initConnections();
        this._managerMBean = new VirtualHostManagerMBean(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initQueues() {
        Map<ConfiguredObject, AMQManagedObject> map = this._children;
        synchronized (map) {
            for (Queue queue : this._virtualHost.getQueues()) {
                if (this._children.containsKey(queue)) continue;
                try {
                    this._children.put((ConfiguredObject)queue, new QueueMBean(queue, this));
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Cannot create queue mbean for queue " + queue.getName()), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExchanges() {
        Map<ConfiguredObject, AMQManagedObject> map = this._children;
        synchronized (map) {
            for (Exchange exchange : this._virtualHost.getExchanges()) {
                if (this._children.containsKey(exchange)) continue;
                try {
                    this._children.put((ConfiguredObject)exchange, new ExchangeMBean(exchange, this));
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Cannot create exchange mbean for exchange " + exchange.getName()), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnections() {
        Map<ConfiguredObject, AMQManagedObject> map = this._children;
        synchronized (map) {
            for (Connection conn : this._virtualHost.getConnections()) {
                if (this._children.containsKey(conn)) continue;
                try {
                    this._children.put((ConfiguredObject)conn, new ConnectionMBean(conn, this));
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Cannot create connection mbean for connection " + conn.getName()), (Throwable)e);
                }
            }
        }
    }

    @Override
    public String getObjectInstanceName() {
        return ObjectName.quote(this._virtualHost.getName());
    }

    public String getName() {
        return this._virtualHost.getName();
    }

    public void stateChanged(ConfiguredObject object, State oldState, State newState) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childAdded(ConfiguredObject object, ConfiguredObject child) {
        Map<ConfiguredObject, AMQManagedObject> map = this._children;
        synchronized (map) {
            try {
                if (child instanceof Queue) {
                    QueueMBean queueMB = new QueueMBean((Queue)child, this);
                    this._children.put(child, queueMB);
                } else if (child instanceof Exchange) {
                    ExchangeMBean exchangeMBean = new ExchangeMBean((Exchange)child, this);
                    this._children.put(child, exchangeMBean);
                } else if (child instanceof Connection) {
                    ConnectionMBean connectionMBean = new ConnectionMBean((Connection)child, this);
                    this._children.put(child, connectionMBean);
                } else {
                    LOGGER.debug((Object)("Unsupported child : " + child.getName() + " type : " + child.getClass()));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exception while creating mbean for " + child.getClass().getSimpleName() + " " + child.getName()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childRemoved(ConfiguredObject object, ConfiguredObject child) {
        Map<ConfiguredObject, AMQManagedObject> map = this._children;
        synchronized (map) {
            AMQManagedObject mbean = this._children.remove(child);
            if (mbean != null) {
                try {
                    mbean.unregister();
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Exception while unregistering mbean for " + child.getClass().getSimpleName() + " " + child.getName()), (Throwable)e);
                }
            }
        }
    }

    @Override
    public ManagedObject getParentObject() {
        return null;
    }

    protected VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<QueueMBean> getQueues() {
        ArrayList<AMQManagedObject> children;
        Map<ConfiguredObject, AMQManagedObject> map = this._children;
        synchronized (map) {
            children = new ArrayList<AMQManagedObject>(this._children.values());
        }
        ArrayList<QueueMBean> queues = new ArrayList<QueueMBean>();
        for (AMQManagedObject child : children) {
            if (!(child instanceof QueueMBean)) continue;
            queues.add((QueueMBean)child);
        }
        return queues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister() throws JMException {
        this._virtualHost.removeChangeListener((ConfigurationChangeListener)this);
        Map<ConfiguredObject, AMQManagedObject> map = this._children;
        synchronized (map) {
            for (AMQManagedObject mbean : this._children.values()) {
                if (mbean == null) continue;
                try {
                    mbean.unregister();
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Exception while unregistering mbean : " + mbean), (Throwable)e);
                }
            }
            this._children.clear();
        }
        this._managerMBean.unregister();
    }

    public void attributeSet(ConfiguredObject object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
    }
}

