/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx.mbeans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import org.apache.log4j.Logger;
import org.apache.qpid.management.common.mbeans.ManagedBroker;
import org.apache.qpid.management.common.mbeans.ManagedQueue;
import org.apache.qpid.management.common.mbeans.annotations.MBeanConstructor;
import org.apache.qpid.management.common.mbeans.annotations.MBeanDescription;
import org.apache.qpid.management.common.mbeans.annotations.MBeanOperationParameter;
import org.apache.qpid.server.jmx.ManagedObject;
import org.apache.qpid.server.jmx.mbeans.AbstractStatisticsGatheringMBean;
import org.apache.qpid.server.jmx.mbeans.MBeanUtils;
import org.apache.qpid.server.jmx.mbeans.QueueMBean;
import org.apache.qpid.server.jmx.mbeans.VirtualHostMBean;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBeanDescription(value="This MBean exposes the broker level management features")
public class VirtualHostManagerMBean
extends AbstractStatisticsGatheringMBean<VirtualHost>
implements ManagedBroker {
    private static final Logger LOGGER = Logger.getLogger(VirtualHostManagerMBean.class);
    private static final boolean _moveNonExclusiveQueueOwnerToDescription = Boolean.parseBoolean(System.getProperty("qpid.move_non_exclusive_queue_owner_to_description", Boolean.TRUE.toString()));
    private final VirtualHostMBean _virtualHostMBean;

    @MBeanConstructor(value="Creates the Broker Manager MBean")
    public VirtualHostManagerMBean(VirtualHostMBean virtualHostMBean) throws JMException {
        super(ManagedBroker.class, "VirtualHostManager", virtualHostMBean.getRegistry(), virtualHostMBean.getVirtualHost());
        this._virtualHostMBean = virtualHostMBean;
        this.register();
    }

    @Override
    public String getObjectInstanceName() {
        return ObjectName.quote(this._virtualHostMBean.getName());
    }

    @Override
    public ManagedObject getParentObject() {
        return this._virtualHostMBean;
    }

    public String[] getExchangeTypes() throws IOException {
        Collection exchangeTypes = this._virtualHostMBean.getVirtualHost().getExchangeTypes();
        return exchangeTypes.toArray(new String[exchangeTypes.size()]);
    }

    public List<String> retrieveQueueAttributeNames() throws IOException {
        return ManagedQueue.QUEUE_ATTRIBUTES;
    }

    public List<List<Object>> retrieveQueueAttributeValues(@MBeanOperationParameter(name="attributes", description="Attributes to retrieve") String[] attributes) throws IOException {
        int attributesLength = attributes.length;
        ArrayList<List<Object>> queueAttributesList = new ArrayList<List<Object>>();
        for (QueueMBean queue : this._virtualHostMBean.getQueues()) {
            if (queue == null) continue;
            ArrayList<Object> attributeValues = new ArrayList<Object>(attributesLength);
            for (int i = 0; i < attributesLength; ++i) {
                try {
                    attributeValues.add(queue.getAttribute(attributes[i]));
                    continue;
                }
                catch (Exception e) {
                    attributeValues.add("-");
                }
            }
            queueAttributesList.add(attributeValues);
        }
        return queueAttributesList;
    }

    public void createNewExchange(String name, String type, boolean durable) throws IOException, JMException, MBeanException {
        if (!((VirtualHost)this.getConfiguredObject()).getExchangeTypes().contains(type)) {
            throw new OperationsException("No such exchange type \"" + type + "\"");
        }
        try {
            ((VirtualHost)this.getConfiguredObject()).createExchange(name, State.ACTIVE, durable, LifetimePolicy.PERMANENT, 0L, type, Collections.EMPTY_MAP);
        }
        catch (IllegalArgumentException iae) {
            JMException jme = new JMException(iae.toString());
            throw new MBeanException(jme, "Error in creating exchange " + name);
        }
    }

    public void unregisterExchange(String exchangeName) throws IOException, JMException, MBeanException {
        Exchange theExchange = MBeanUtils.findExchangeFromExchangeName(this._virtualHostMBean.getVirtualHost(), exchangeName);
        try {
            theExchange.delete();
        }
        catch (IllegalStateException ex) {
            JMException jme = new JMException(ex.toString());
            throw new MBeanException(jme, "Error in unregistering exchange " + exchangeName);
        }
    }

    public void createNewQueue(String queueName, String owner, boolean durable) throws IOException, JMException, MBeanException {
        this.createNewQueue(queueName, owner, durable, Collections.EMPTY_MAP);
    }

    public void createNewQueue(String queueName, String owner, boolean durable, Map<String, Object> originalArguments) throws IOException, JMException {
        Map<String, Object> createArgs = this.processNewQueueArguments(queueName, owner, originalArguments);
        ((VirtualHost)this.getConfiguredObject()).createQueue(queueName, State.ACTIVE, durable, false, LifetimePolicy.PERMANENT, 0L, createArgs);
    }

    private Map<String, Object> processNewQueueArguments(String queueName, String owner, Map<String, Object> arguments) {
        HashMap<String, String> argumentsCopy;
        if (_moveNonExclusiveQueueOwnerToDescription && owner != null) {
            argumentsCopy = new HashMap(arguments == null ? new HashMap<String, String>() : arguments);
            if (!argumentsCopy.containsKey("x-qpid-description")) {
                LOGGER.warn((Object)("Non-exclusive owner " + owner + " for new queue " + queueName + " moved to " + "x-qpid-description"));
                argumentsCopy.put("x-qpid-description", owner);
            } else {
                LOGGER.warn((Object)("Non-exclusive owner " + owner + " for new queue " + queueName + " ignored."));
            }
        } else {
            argumentsCopy = arguments;
        }
        return argumentsCopy;
    }

    public void deleteQueue(@MBeanOperationParameter(name="Queue", description="Queue Name") String queueName) throws IOException, JMException, MBeanException {
        Queue theQueue = MBeanUtils.findQueueFromQueueName(this._virtualHostMBean.getVirtualHost(), queueName);
        theQueue.delete();
    }

    @Override
    public ObjectName getObjectName() throws MalformedObjectNameException {
        return this.getObjectNameForSingleInstanceMBean();
    }

    public boolean isStatisticsEnabled() {
        return true;
    }
}

