/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.AlreadyBoundException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.net.ssl.SSLContext;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.qpid.server.jmx.JMXManagementPlugin;
import org.apache.qpid.server.jmx.MBeanInvocationHandlerImpl;
import org.apache.qpid.server.jmx.ManagedObject;
import org.apache.qpid.server.jmx.ManagedObjectRegistry;
import org.apache.qpid.server.jmx.ManagementLogonLogoffReporter;
import org.apache.qpid.server.jmx.QpidRMIServerSocketFactory;
import org.apache.qpid.server.jmx.QpidSslRMIServerSocketFactory;
import org.apache.qpid.server.jmx.RegistryProtectingRMIServerSocketFactory;
import org.apache.qpid.server.jmx.UsernameCachingRMIJRMPServer;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.logging.messages.ManagementConsoleMessages;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.JmxPort;
import org.apache.qpid.server.model.port.RmiPort;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.jmx.JMXPasswordAuthenticator;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXManagedObjectRegistry
implements ManagedObjectRegistry {
    private static final Logger _log = LoggerFactory.getLogger(JMXManagedObjectRegistry.class);
    private static final String OPERATIONAL_LOGGING_NAME = "JMX";
    private final MBeanServer _mbeanServer;
    private JMXConnectorServer _cs;
    private Registry _rmiRegistry;
    private final Broker _broker;
    private final RmiPort _registryPort;
    private final JmxPort _connectorPort;
    private int _allocatedRmiPort;
    private int _allocatedConnectorPort;
    private DelegatingJMXServiceUrl _externalUrl;
    private DelegatingJMXServiceUrl _internalUrl;
    private String _localHostName;

    public JMXManagedObjectRegistry(Broker broker, JmxPort connectorPort, RmiPort registryPort, JMXManagementPlugin jmxManagement) {
        this._broker = broker;
        this._registryPort = registryPort;
        this._connectorPort = connectorPort;
        this._allocatedRmiPort = this._registryPort.getPort();
        this._allocatedConnectorPort = this._connectorPort.getPort();
        boolean usePlatformServer = (Boolean)jmxManagement.getAttribute("usePlatformMBeanServer");
        this._mbeanServer = usePlatformServer ? ManagementFactory.getPlatformMBeanServer() : MBeanServerFactory.createMBeanServer("org.apache.qpid");
    }

    private EventLogger getEventLogger() {
        return this._broker.getEventLogger();
    }

    @Override
    public void start() throws IOException {
        this.getEventLogger().message(ManagementConsoleMessages.STARTUP((String)OPERATIONAL_LOGGING_NAME));
        if (this.areOutOfTheBoxJMXOptionsSet()) {
            this.getEventLogger().message(ManagementConsoleMessages.READY((String)OPERATIONAL_LOGGING_NAME));
        } else {
            this.startRegistryAndConnector();
        }
    }

    private void startRegistryAndConnector() throws IOException {
        RMIServerSocketFactory ssf;
        SslRMIClientSocketFactory csf;
        boolean connectorSslEnabled = this._connectorPort.getTransports().contains(Transport.SSL);
        Action<Integer> setAllocatedConnectorPort = new Action<Integer>(){

            public void performAction(Integer port) {
                if (JMXManagedObjectRegistry.this._allocatedConnectorPort != port) {
                    JMXManagedObjectRegistry.this._allocatedConnectorPort = port;
                    if (JMXManagedObjectRegistry.this._externalUrl != null) {
                        JMXManagedObjectRegistry.this._externalUrl.setPort(port);
                    }
                    if (JMXManagedObjectRegistry.this._internalUrl != null) {
                        JMXManagedObjectRegistry.this._internalUrl.setPort(port);
                    }
                }
            }
        };
        if (connectorSslEnabled) {
            SSLContext sslContext;
            KeyStore keyStore = this._connectorPort.getKeyStore();
            try {
                sslContext = SSLUtil.tryGetSSLContext();
                sslContext.init(keyStore.getKeyManagers(), null, null);
            }
            catch (GeneralSecurityException e) {
                throw new ServerScopedRuntimeException("Unable to create SSLContext for key store", (Throwable)e);
            }
            csf = new SslRMIClientSocketFactory();
            ssf = new QpidSslRMIServerSocketFactory(sslContext, this._connectorPort.getTlsProtocolWhiteList(), this._connectorPort.getTlsProtocolBlackList(), this._connectorPort.getTlsCipherSuiteWhiteList(), this._connectorPort.getTlsCipherSuiteBlackList(), setAllocatedConnectorPort);
        } else {
            csf = null;
            ssf = new QpidRMIServerSocketFactory(setAllocatedConnectorPort);
        }
        SubjectCreator subjectCreator = this._connectorPort.getAuthenticationProvider().getSubjectCreator(connectorSslEnabled);
        if (subjectCreator == null) {
            throw new SecurityException("Can't get subject creator for " + this._connectorPort);
        }
        JMXPasswordAuthenticator rmipa = new JMXPasswordAuthenticator(subjectCreator, this._broker.getSecurityManager());
        HashMap<String, JMXPasswordAuthenticator> connectorEnv = new HashMap<String, JMXPasswordAuthenticator>();
        connectorEnv.put("jmx.remote.authenticator", rmipa);
        System.setProperty("java.rmi.server.randomIDs", "true");
        boolean useCustomSocketFactory = Boolean.parseBoolean(System.getProperty("qpid.broker_jmx_use_custom_rmi_socket_factory", Boolean.TRUE.toString()));
        this._rmiRegistry = this.createRmiRegistry(this._allocatedRmiPort, useCustomSocketFactory);
        final UsernameCachingRMIJRMPServer usernameCachingRmiServer = new UsernameCachingRMIJRMPServer(this._allocatedConnectorPort, csf, ssf, connectorEnv);
        this._localHostName = this.getLocalhost();
        this._externalUrl = new DelegatingJMXServiceUrl(new JMXServiceURL("service:jmx:rmi://" + this._localHostName + ":" + this._allocatedConnectorPort + "/jndi/rmi://" + this._localHostName + ":" + this._allocatedRmiPort + "/jmxrmi"));
        this._internalUrl = new DelegatingJMXServiceUrl(new JMXServiceURL("rmi", this._localHostName, this._allocatedConnectorPort));
        this._cs = new RMIConnectorServer(this._internalUrl, connectorEnv, usernameCachingRmiServer, this._mbeanServer){

            @Override
            public synchronized void start() throws IOException {
                try {
                    JMXManagedObjectRegistry.this._rmiRegistry.bind("jmxrmi", usernameCachingRmiServer);
                }
                catch (AlreadyBoundException abe) {
                    IOException ioe = new IOException(abe.getMessage());
                    ioe.initCause(abe);
                    throw ioe;
                }
                super.start();
            }

            @Override
            public synchronized void stop() throws IOException {
                try {
                    if (JMXManagedObjectRegistry.this._rmiRegistry != null) {
                        JMXManagedObjectRegistry.this._rmiRegistry.unbind("jmxrmi");
                    }
                }
                catch (NotBoundException nbe) {
                    _log.error("Failed to unbind jmxrmi", (Throwable)nbe);
                }
                super.stop();
            }

            @Override
            public JMXServiceURL getAddress() {
                return JMXManagedObjectRegistry.this._externalUrl;
            }
        };
        MBeanServerForwarder mbsf = MBeanInvocationHandlerImpl.newProxyInstance(this._broker);
        this._cs.setMBeanServerForwarder(mbsf);
        ManagementLogonLogoffReporter jmxManagementUserLogonLogoffReporter = new ManagementLogonLogoffReporter((EventLoggerProvider)this._broker, usernameCachingRmiServer);
        this._cs.addNotificationListener(jmxManagementUserLogonLogoffReporter, jmxManagementUserLogonLogoffReporter, null);
        this._cs.addNotificationListener(usernameCachingRmiServer, usernameCachingRmiServer, null);
        this._cs.start();
        Set connectorTransports = this._connectorPort.getTransports();
        for (Transport transport : connectorTransports) {
            this.getEventLogger().message(ManagementConsoleMessages.LISTENING((String)"JMX RMIConnectorServer", (String)transport.name(), (Number)this._allocatedConnectorPort));
        }
        this.getEventLogger().message(ManagementConsoleMessages.READY((String)OPERATIONAL_LOGGING_NAME));
    }

    private Registry createRmiRegistry(int jmxPortRegistryServer, boolean useCustomRmiRegistry) throws RemoteException {
        RMIServerSocketFactory ssf = this.getRmiServerSocketFactory(useCustomRmiRegistry, new Action<Integer>(){

            public void performAction(Integer port) {
                JMXManagedObjectRegistry.this._allocatedRmiPort = port;
            }
        });
        Registry rmiRegistry = LocateRegistry.createRegistry(jmxPortRegistryServer, null, ssf);
        this.getEventLogger().message(ManagementConsoleMessages.LISTENING((String)"RMI Registry", (String)Transport.TCP.name(), (Number)this._allocatedRmiPort));
        return rmiRegistry;
    }

    @Override
    public void registerObject(ManagedObject managedObject) throws JMException {
        this._mbeanServer.registerMBean(managedObject, managedObject.getObjectName());
    }

    @Override
    public void unregisterObject(ManagedObject managedObject) throws JMException {
        this._mbeanServer.unregisterMBean(managedObject.getObjectName());
    }

    @Override
    public void close() {
        _log.debug("close() called");
        this.closeConnectorAndRegistryServers();
        this.unregisterAllMbeans();
        this.getEventLogger().message(ManagementConsoleMessages.STOPPED((String)OPERATIONAL_LOGGING_NAME));
    }

    private void closeConnectorAndRegistryServers() {
        this.closeConnectorServer();
        this.closeRegistryServer();
    }

    private boolean areOutOfTheBoxJMXOptionsSet() {
        if (System.getProperty("com.sun.management.jmxremote") != null) {
            return true;
        }
        return System.getProperty("com.sun.management.jmxremote.port") != null;
    }

    private String getLocalhost() {
        String localHost;
        try {
            localHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            localHost = "127.0.0.1";
        }
        return localHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeRegistryServer() {
        if (this._rmiRegistry != null) {
            this.getEventLogger().message(ManagementConsoleMessages.SHUTTING_DOWN((String)"RMI Registry", (Number)this._registryPort.getPort()));
            try {
                boolean success = UnicastRemoteObject.unexportObject(this._rmiRegistry, false);
                if (!success) {
                    _log.warn("Failed to unexport object " + this._rmiRegistry);
                }
            }
            catch (NoSuchObjectException e) {
                _log.error("Exception while closing the RMI Registry: ", (Throwable)e);
            }
            finally {
                this._rmiRegistry = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnectorServer() {
        if (this._cs != null) {
            try {
                this.getEventLogger().message(ManagementConsoleMessages.SHUTTING_DOWN((String)"JMX RMIConnectorServer", (Number)this._cs.getAddress().getPort()));
                this._cs.stop();
            }
            catch (IOException e) {
                _log.error("Exception while closing the JMX ConnectorServer: ", (Throwable)e);
            }
            finally {
                this._cs = null;
            }
        }
    }

    private void unregisterAllMbeans() {
        ObjectName mbeanNameQuery = null;
        try {
            mbeanNameQuery = new ObjectName("org.apache.qpid:*");
        }
        catch (Exception e1) {
            _log.warn("Unable to generate MBean ObjectName query for close operation");
        }
        for (ObjectName name : this._mbeanServer.queryNames(mbeanNameQuery, null)) {
            try {
                this._mbeanServer.unregisterMBean(name);
            }
            catch (JMException e) {
                _log.error("Exception unregistering MBean '" + name + "': " + e.getMessage());
            }
        }
    }

    private RMIServerSocketFactory getRmiServerSocketFactory(boolean useCustomRmiRegistry, Action<Integer> assignPortAction) {
        RMIServerSocketFactory ssf;
        if (useCustomRmiRegistry) {
            _log.debug("Using registry-protecting RMIServerSocketFactory");
            ssf = new RegistryProtectingRMIServerSocketFactory(assignPortAction);
        } else {
            ssf = new QpidRMIServerSocketFactory(assignPortAction);
        }
        return ssf;
    }

    private static class DelegatingJMXServiceUrl
    extends JMXServiceURL {
        private volatile JMXServiceURL _delegate;

        public DelegatingJMXServiceUrl(JMXServiceURL delegate) throws MalformedURLException {
            super(delegate.getProtocol(), delegate.getHost(), delegate.getPort(), delegate.getURLPath());
            this._delegate = delegate;
        }

        void setPort(int port) {
            try {
                this._delegate = new JMXServiceURL(this._delegate.getProtocol(), this._delegate.getHost(), port, this._delegate.getURLPath());
            }
            catch (MalformedURLException e) {
                throw new ServerScopedRuntimeException("Unexpected exception when updating port", (Throwable)e);
            }
        }

        @Override
        public String getProtocol() {
            return this._delegate.getProtocol();
        }

        @Override
        public String getHost() {
            return this._delegate.getHost();
        }

        @Override
        public int getPort() {
            return this._delegate.getPort();
        }

        @Override
        public String getURLPath() {
            return this._delegate.getURLPath();
        }

        @Override
        public String toString() {
            return this._delegate.toString();
        }

        @Override
        public boolean equals(Object obj) {
            return this._delegate.equals(obj);
        }

        @Override
        public int hashCode() {
            return this._delegate.hashCode();
        }
    }
}

