/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.jmx.AMQManagedObject;
import org.apache.qpid.server.jmx.JMXManagedObjectRegistry;
import org.apache.qpid.server.jmx.JMXManagementPlugin;
import org.apache.qpid.server.jmx.MBeanProvider;
import org.apache.qpid.server.jmx.ManagedObject;
import org.apache.qpid.server.jmx.ManagedObjectRegistry;
import org.apache.qpid.server.jmx.mbeans.LoggingManagementMBean;
import org.apache.qpid.server.jmx.mbeans.ServerInformationMBean;
import org.apache.qpid.server.jmx.mbeans.Shutdown;
import org.apache.qpid.server.jmx.mbeans.UserManagementMBean;
import org.apache.qpid.server.jmx.mbeans.VirtualHostMBean;
import org.apache.qpid.server.logging.BrokerFileLogger;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.BrokerLogger;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.PasswordCredentialManagingAuthenticationProvider;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.model.adapter.AbstractPluginAdapter;
import org.apache.qpid.server.model.port.JmxPort;
import org.apache.qpid.server.model.port.PortManager;
import org.apache.qpid.server.model.port.RmiPort;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXManagementPluginImpl
extends AbstractPluginAdapter<JMXManagementPluginImpl>
implements JMXManagementPlugin<JMXManagementPluginImpl>,
PortManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMXManagementPluginImpl.class);
    public static final String NAME = "name";
    public static final String DEFAULT_NAME = "JMXManagement";
    private JMXManagedObjectRegistry _objectRegistry;
    private final Object _childrenLock = new Object();
    private final Map<ConfiguredObject<?>, Map<MBeanProvider, ManagedObject>> _children = new HashMap();
    @ManagedAttributeField
    private boolean _usePlatformMBeanServer;
    private boolean _allowPortActivation;
    private final Set<MBeanProvider> _mBeanProviders;
    private final ChangeListener _changeListener = new ChangeListener();
    private final PluginMBeansProvider _pluginMBeanProvider = new PluginMBeansProvider();
    private LoggingManagementMBean _loggingManagementMBean;

    @ManagedObjectFactoryConstructor
    public JMXManagementPluginImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
        this._mBeanProviders = new HashSet<MBeanProvider>();
        QpidServiceLoader qpidServiceLoader = new QpidServiceLoader();
        for (MBeanProvider provider : qpidServiceLoader.instancesOf(MBeanProvider.class)) {
            this._mBeanProviders.add(provider);
        }
    }

    @Override
    public boolean getUsePlatformMBeanServer() {
        return this._usePlatformMBeanServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> doStart() throws JMException, IOException {
        this._allowPortActivation = true;
        Broker broker = this.getBroker();
        RmiPort registryPort = this.getEligibleJmxPort(RmiPort.class, broker.getPorts(), Protocol.RMI);
        JmxPort connectorPort = this.getEligibleJmxPort(JmxPort.class, broker.getPorts(), Protocol.JMX_RMI);
        if (registryPort == null || connectorPort == null) {
            LOGGER.debug("JmxManagement plugin is configured but no suitable JMX ports are available.");
        } else {
            registryPort.setPortManager((PortManager)this);
            if (registryPort.getState() != State.ACTIVE) {
                registryPort.startAsync();
            }
            connectorPort.setPortManager((PortManager)this);
            if (connectorPort.getState() != State.ACTIVE) {
                connectorPort.startAsync();
            }
            this._objectRegistry = new JMXManagedObjectRegistry(broker, connectorPort, registryPort, this);
            broker.addChangeListener((ConfigurationChangeListener)this._changeListener);
            Object object = this._childrenLock;
            synchronized (object) {
                for (VirtualHostNode virtualHostNode : broker.getVirtualHostNodes()) {
                    this.createObjectMBeans((ConfiguredObject<?>)virtualHostNode);
                }
                Collection authenticationProviders = broker.getAuthenticationProviders();
                for (AuthenticationProvider authenticationProvider : authenticationProviders) {
                    this.createObjectMBeans((ConfiguredObject<?>)authenticationProvider);
                }
                Collection brokerLoggers = broker.getChildren(BrokerLogger.class);
                for (BrokerLogger brokerLogger : brokerLoggers) {
                    this.createObjectMBeans((ConfiguredObject<?>)brokerLogger);
                }
            }
            new Shutdown(this._objectRegistry, broker);
            new ServerInformationMBean(this._objectRegistry, broker);
            this._objectRegistry.start();
            this._allowPortActivation = false;
        }
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    private <P extends Port<?>> P getEligibleJmxPort(Class<P> type, Collection<Port<?>> ports, Protocol protocol) {
        for (Port<?> port : ports) {
            if (State.ACTIVE != port.getDesiredState() || State.ERRORED == port.getState() || !port.getProtocols().contains(protocol)) continue;
            return (P)((Port)type.cast(port));
        }
        return null;
    }

    public boolean isActivationAllowed(Port<?> port) {
        return this._allowPortActivation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onClose() {
        Object object = this._childrenLock;
        synchronized (object) {
            for (ConfiguredObject<?> object2 : this._children.keySet()) {
                this.unregisterObjectMBeans(object2);
            }
            this._children.clear();
        }
        this.getBroker().removeChangeListener((ConfigurationChangeListener)this._changeListener);
        this.closeObjectRegistry();
        this._loggingManagementMBean = null;
    }

    private void unregisterObjectMBeans(ConfiguredObject<?> object) {
        Map<MBeanProvider, ManagedObject> mbeans = this._children.get(object);
        if (mbeans != null) {
            for (ManagedObject mbean : mbeans.values()) {
                if (mbean instanceof ConfigurationChangeListener) {
                    object.removeChangeListener((ConfigurationChangeListener)mbean);
                }
                if (LOGGER.isDebugEnabled()) {
                    String mbeanName = null;
                    try {
                        mbeanName = mbean.getObjectName().toString();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    LOGGER.debug("Unregistering MBean " + mbeanName + " for configured object " + object);
                }
                try {
                    mbean.unregister();
                }
                catch (Exception e) {
                    LOGGER.error("Exception while unregistering mbean for " + object.getClass().getSimpleName() + " " + object.getName(), (Throwable)e);
                }
            }
        }
    }

    private void createAdditionalMBeansFromProvidersIfNecessary(ConfiguredObject<?> child, ManagedObjectRegistry registry) throws JMException {
        for (MBeanProvider provider : this._mBeanProviders) {
            LOGGER.debug("Consulting mbean provider : {} for child : {}", (Object)provider, child);
            ManagedObject mBean = null;
            if (provider.isChildManageableByMBean(child) && !this.providerMBeanExists(child, provider)) {
                LOGGER.debug("Provider of type {} will create mbean for {}", (Object)provider.getType(), child);
                mBean = provider.createMBean(child, registry);
                if (mBean != null) {
                    this.registerMBean(child, provider, mBean);
                }
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Provider " + provider + (mBean == null ? " did not create mBean" : " created mBean " + mBean) + " for child " + child);
        }
    }

    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        if (changedAttributes.contains(NAME)) {
            String newName = proxyForValidation.getName();
            if (!this.getName().equals(newName)) {
                throw new IllegalConfigurationException("Changing the name of jmx management plugin is not allowed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeObjectRegistry() {
        if (this._objectRegistry != null) {
            try {
                this._objectRegistry.close();
            }
            finally {
                this._objectRegistry = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedObject createObjectMBeansIfNecessary(ConfiguredObject<?> object) throws JMException {
        AMQManagedObject mbean = null;
        if (this.supportedConfiguredObject(object)) {
            Object object2 = this._childrenLock;
            synchronized (object2) {
                if (!this.providerMBeanExists(object, this._pluginMBeanProvider)) {
                    if (object instanceof VirtualHostNode) {
                        object.addChangeListener((ConfigurationChangeListener)this._changeListener);
                        VirtualHostNode virtualHostNode = (VirtualHostNode)object;
                        VirtualHost host = virtualHostNode.getVirtualHost();
                        if (host != null) {
                            this.createVirtualHostMBeanIfNecessary(host, this._objectRegistry);
                        }
                    } else if (object instanceof VirtualHost) {
                        mbean = this.createVirtualHostMBeanIfNecessary((VirtualHost)object, this._objectRegistry);
                    } else if (object instanceof PasswordCredentialManagingAuthenticationProvider) {
                        object.addChangeListener((ConfigurationChangeListener)this._changeListener);
                        mbean = new UserManagementMBean((PasswordCredentialManagingAuthenticationProvider)object, this._objectRegistry);
                        this.registerMBean(object, this._pluginMBeanProvider, mbean);
                    } else if (object instanceof BrokerFileLogger) {
                        if (this._loggingManagementMBean == null) {
                            this._loggingManagementMBean = new LoggingManagementMBean((BrokerFileLogger)object, this._objectRegistry);
                            LOGGER.info("LoggingManagementMBean created for BrokerFileLogger '{}'", (Object)object.getName());
                        } else {
                            LOGGER.warn("There are multiple BrokerFileLoggers. LoggingManagementMBean was already created. Ignoring BrokerFileLogger '{}'", (Object)object.getName());
                        }
                    }
                }
                this.createAdditionalMBeansFromProvidersIfNecessary(object, this._objectRegistry);
            }
        }
        return mbean;
    }

    private VirtualHostMBean createVirtualHostMBeanIfNecessary(VirtualHost<?, ?, ?> host, ManagedObjectRegistry _objectRegistry) throws JMException {
        if (!this.providerMBeanExists((ConfiguredObject<?>)host, this._pluginMBeanProvider)) {
            host.addChangeListener((ConfigurationChangeListener)this._changeListener);
            try {
                VirtualHostMBean mbean = new VirtualHostMBean(host, _objectRegistry);
                this.registerMBean((ConfiguredObject<?>)host, this._pluginMBeanProvider, mbean);
                return mbean;
            }
            catch (InstanceAlreadyExistsException e) {
                VirtualHostNode parent = (VirtualHostNode)host.getParent(VirtualHostNode.class);
                Set<ConfiguredObject<?>> registered = this._children.keySet();
                for (ConfiguredObject<?> object : registered) {
                    if (!(object instanceof VirtualHost) || object.getParent(VirtualHostNode.class) != parent) continue;
                    LOGGER.warn("Unexpected MBean is found for VirtualHost " + object + " belonging to node " + parent);
                }
                throw e;
            }
        }
        return null;
    }

    private void registerMBean(ConfiguredObject<?> configuredObject, MBeanProvider mBeanProvider, ManagedObject mbean) {
        Map<MBeanProvider, ManagedObject> mbeans = this._children.get(configuredObject);
        if (mbeans == null) {
            mbeans = new HashMap<MBeanProvider, ManagedObject>();
            this._children.put(configuredObject, mbeans);
        }
        mbeans.put(mBeanProvider, mbean);
    }

    private boolean providerMBeanExists(ConfiguredObject<?> configuredObject, MBeanProvider mBeanProvider) {
        Map<MBeanProvider, ManagedObject> mbeans = this._children.get(configuredObject);
        if (mbeans == null) {
            return false;
        }
        return mbeans.containsKey(mBeanProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyObjectMBeans(ConfiguredObject<?> object, boolean removeListener) {
        if (this.supportedConfiguredObject(object)) {
            Object object2 = this._childrenLock;
            synchronized (object2) {
                if (removeListener) {
                    object.removeChangeListener((ConfigurationChangeListener)this._changeListener);
                }
                this.unregisterObjectMBeans(object);
                if (this._children.remove(object) == this._loggingManagementMBean) {
                    this._loggingManagementMBean = null;
                }
                this.destroyChildrenMBeans(object);
            }
        }
    }

    private void destroyChildrenMBeans(ConfiguredObject<?> object) {
        Iterator<ConfiguredObject<?>> iterator = this._children.keySet().iterator();
        while (iterator.hasNext()) {
            ConfiguredObject<?> registeredObject = iterator.next();
            ConfiguredObject parent = registeredObject.getParent(object.getCategoryClass());
            if (parent != object) continue;
            registeredObject.removeChangeListener((ConfigurationChangeListener)this._changeListener);
            this.unregisterObjectMBeans(registeredObject);
            iterator.remove();
        }
    }

    private void createObjectMBeans(ConfiguredObject<?> object) {
        try {
            this.createObjectMBeansIfNecessary(object);
        }
        catch (JMException e) {
            LOGGER.error("Cannot create MBean for " + object, (Throwable)e);
        }
    }

    private boolean supportedConfiguredObject(ConfiguredObject<?> object) {
        return object instanceof VirtualHostNode || object instanceof VirtualHost || object instanceof PasswordCredentialManagingAuthenticationProvider || object instanceof BrokerFileLogger;
    }

    private class ChangeListener
    implements ConfigurationChangeListener {
        private ChangeListener() {
        }

        public void stateChanged(ConfiguredObject<?> object, State oldState, State newState) {
            if (newState == State.DELETED || newState == State.STOPPED || newState == State.ERRORED) {
                JMXManagementPluginImpl.this.destroyObjectMBeans(object, newState == State.DELETED);
            } else if (newState == State.ACTIVE) {
                JMXManagementPluginImpl.this.createObjectMBeans(object);
            }
        }

        public void childAdded(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            JMXManagementPluginImpl.this.createObjectMBeans(child);
        }

        public void childRemoved(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            JMXManagementPluginImpl.this.destroyObjectMBeans(child, true);
        }

        public void attributeSet(ConfiguredObject<?> object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
            if ("desiredState".equals(attributeName)) {
                this.stateChanged(object, State.valueOf((String)String.valueOf(oldAttributeValue)), State.valueOf((String)String.valueOf(newAttributeValue)));
            } else {
                JMXManagementPluginImpl.this.createObjectMBeans(object);
            }
        }

        public void bulkChangeStart(ConfiguredObject<?> object) {
        }

        public void bulkChangeEnd(ConfiguredObject<?> object) {
        }
    }

    private class PluginMBeansProvider
    implements MBeanProvider {
        private PluginMBeansProvider() {
        }

        @Override
        public boolean isChildManageableByMBean(ConfiguredObject<?> object) {
            return JMXManagementPluginImpl.this.supportedConfiguredObject(object);
        }

        @Override
        public ManagedObject createMBean(ConfiguredObject<?> object, ManagedObjectRegistry registry) throws JMException {
            return JMXManagementPluginImpl.this.createObjectMBeansIfNecessary(object);
        }

        public String getType() {
            return "INTERNAL";
        }

        public String toString() {
            return JMXManagementPluginImpl.DEFAULT_NAME;
        }
    }
}

