/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import org.apache.qpid.management.common.mbeans.annotations.MBeanAttribute;
import org.apache.qpid.management.common.mbeans.annotations.MBeanConstructor;
import org.apache.qpid.management.common.mbeans.annotations.MBeanDescription;
import org.apache.qpid.management.common.mbeans.annotations.MBeanOperation;
import org.apache.qpid.management.common.mbeans.annotations.MBeanOperationParameter;

class MBeanIntrospector {
    private static final String _defaultAttributeDescription = "Management attribute";
    private static final String _defaultOperationDescription = "Management operation";
    private static final String _defaultConstructorDescription = "MBean constructor";
    private static final String _defaultMbeanDescription = "Management interface of the MBean";

    private MBeanIntrospector() {
    }

    static MBeanAttributeInfo[] getMBeanAttributesInfo(Class interfaceClass) throws NotCompliantMBeanException {
        ArrayList<MBeanAttributeInfo> attributesList = new ArrayList<MBeanAttributeInfo>();
        for (Method method : interfaceClass.getMethods()) {
            int index;
            String desc;
            String name = method.getName();
            Class<?> resultType = method.getReturnType();
            MBeanAttributeInfo attributeInfo = null;
            if (MBeanIntrospector.isAttributeGetterMethod(method)) {
                desc = MBeanIntrospector.getAttributeDescription(method);
                attributeInfo = new MBeanAttributeInfo(name.substring(3), resultType.getName(), desc, true, false, false);
                index = MBeanIntrospector.getIndexIfAlreadyExists(attributeInfo, attributesList);
                if (index == -1) {
                    attributesList.add(attributeInfo);
                    continue;
                }
                attributeInfo = new MBeanAttributeInfo(name.substring(3), resultType.getName(), desc, true, true, false);
                attributesList.set(index, attributeInfo);
                continue;
            }
            if (MBeanIntrospector.isAttributeSetterMethod(method)) {
                desc = MBeanIntrospector.getAttributeDescription(method);
                attributeInfo = new MBeanAttributeInfo(name.substring(3), method.getParameterTypes()[0].getName(), desc, false, true, false);
                index = MBeanIntrospector.getIndexIfAlreadyExists(attributeInfo, attributesList);
                if (index == -1) {
                    attributesList.add(attributeInfo);
                    continue;
                }
                attributeInfo = new MBeanAttributeInfo(name.substring(3), method.getParameterTypes()[0].getName(), desc, true, true, false);
                attributesList.set(index, attributeInfo);
                continue;
            }
            if (!MBeanIntrospector.isAttributeBoolean(method)) continue;
            attributeInfo = new MBeanAttributeInfo(name.substring(2), resultType.getName(), MBeanIntrospector.getAttributeDescription(method), true, false, true);
            attributesList.add(attributeInfo);
        }
        return attributesList.toArray(new MBeanAttributeInfo[0]);
    }

    static MBeanOperationInfo[] getMBeanOperationsInfo(Class interfaceClass) {
        ArrayList<MBeanOperationInfo> operationsList = new ArrayList<MBeanOperationInfo>();
        for (Method method : interfaceClass.getMethods()) {
            if (MBeanIntrospector.isAttributeGetterMethod(method) || MBeanIntrospector.isAttributeSetterMethod(method) || MBeanIntrospector.isAttributeBoolean(method)) continue;
            operationsList.add(MBeanIntrospector.getOperationInfo(method));
        }
        return operationsList.toArray(new MBeanOperationInfo[0]);
    }

    private static boolean isAttributeGetterMethod(Method method) {
        return !method.getName().equals("get") && method.getName().startsWith("get") && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE);
    }

    private static boolean isAttributeSetterMethod(Method method) {
        return !method.getName().equals("set") && method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getReturnType().equals(Void.TYPE);
    }

    private static boolean isAttributeBoolean(Method method) {
        return !method.getName().equals("is") && method.getName().startsWith("is") && method.getParameterTypes().length == 0 && method.getReturnType().equals(Boolean.TYPE);
    }

    private static int getIndexIfAlreadyExists(MBeanAttributeInfo attribute, List<MBeanAttributeInfo> list) throws NotCompliantMBeanException {
        String exceptionMsg = "Conflicting attribute methods for attribute " + attribute.getName();
        for (MBeanAttributeInfo memberAttribute : list) {
            if (!attribute.getName().equals(memberAttribute.getName())) continue;
            if (!attribute.getType().equals(memberAttribute.getType())) {
                throw new NotCompliantMBeanException(exceptionMsg);
            }
            if (attribute.isReadable() && memberAttribute.isReadable() && attribute.isIs() != memberAttribute.isIs()) {
                throw new NotCompliantMBeanException(exceptionMsg);
            }
            return list.indexOf(memberAttribute);
        }
        return -1;
    }

    private static String getAttributeDescription(Method attributeMethod) {
        MBeanAttribute anno = attributeMethod.getAnnotation(MBeanAttribute.class);
        if (anno != null) {
            return anno.description();
        }
        return _defaultAttributeDescription;
    }

    private static MBeanOperationInfo getOperationInfo(Method operation) {
        MBeanOperationInfo operationInfo = null;
        Class<?> returnType = operation.getReturnType();
        MBeanParameterInfo[] paramsInfo = MBeanIntrospector.getParametersInfo(operation.getParameterAnnotations(), operation.getParameterTypes());
        String operationDesc = _defaultOperationDescription;
        int impact = 3;
        if (operation.getAnnotation(MBeanOperation.class) != null) {
            operationDesc = operation.getAnnotation(MBeanOperation.class).description();
            impact = operation.getAnnotation(MBeanOperation.class).impact();
        }
        operationInfo = new MBeanOperationInfo(operation.getName(), operationDesc, paramsInfo, returnType.getName(), impact);
        return operationInfo;
    }

    private static MBeanParameterInfo[] getParametersInfo(Annotation[][] paramsAnno, Class<?>[] paramTypes) {
        int noOfParams = paramsAnno.length;
        MBeanParameterInfo[] paramsInfo = new MBeanParameterInfo[noOfParams];
        for (int i = 0; i < noOfParams; ++i) {
            MBeanParameterInfo paramInfo = null;
            String type = paramTypes[i].getName();
            for (Annotation anno : paramsAnno[i]) {
                if (!MBeanOperationParameter.class.isInstance(anno)) continue;
                String name = ((MBeanOperationParameter)MBeanOperationParameter.class.cast(anno)).name();
                String desc = ((MBeanOperationParameter)MBeanOperationParameter.class.cast(anno)).description();
                paramInfo = new MBeanParameterInfo(name, type, desc);
            }
            if (paramInfo == null) {
                paramInfo = new MBeanParameterInfo("p " + (i + 1), type, "parameter " + (i + 1));
            }
            if (paramInfo == null) continue;
            paramsInfo[i] = paramInfo;
        }
        return paramsInfo;
    }

    static MBeanConstructorInfo[] getMBeanConstructorsInfo(Class implClass) {
        ArrayList<MBeanConstructorInfo> constructors = new ArrayList<MBeanConstructorInfo>();
        for (Constructor<?> cons : implClass.getConstructors()) {
            MBeanConstructorInfo constructorInfo = MBeanIntrospector.getMBeanConstructorInfo(cons);
            if (constructorInfo == null) continue;
            constructors.add(constructorInfo);
        }
        return constructors.toArray(new MBeanConstructorInfo[0]);
    }

    private static MBeanConstructorInfo getMBeanConstructorInfo(Constructor cons) {
        String desc = _defaultConstructorDescription;
        MBeanConstructor anno = cons.getAnnotation(MBeanConstructor.class);
        if (anno != null && MBeanConstructor.class.isInstance(anno) && (desc = ((MBeanConstructor)MBeanConstructor.class.cast(anno)).value()) == null) {
            desc = _defaultConstructorDescription;
        }
        return new MBeanConstructorInfo(cons.getName(), desc, null);
    }

    static String getMBeanDescription(Class annotatedClass) {
        MBeanDescription anno = annotatedClass.getAnnotation(MBeanDescription.class);
        if (anno != null && MBeanDescription.class.isInstance(anno)) {
            return ((MBeanDescription)MBeanDescription.class.cast(anno)).value();
        }
        return _defaultMbeanDescription;
    }
}

