/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.remote.MBeanServerForwarder;
import javax.security.auth.Subject;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.IllegalStateTransitionException;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanInvocationHandlerImpl
implements InvocationHandler {
    private static final Logger _logger = LoggerFactory.getLogger(MBeanInvocationHandlerImpl.class);
    private static final String DELEGATE = "JMImplementation:type=MBeanServerDelegate";
    private final Thread.UncaughtExceptionHandler _uncaughtExceptionHandler;
    private MBeanServer _mbs;
    private final boolean _managementRightsInferAllAccess = Boolean.valueOf(System.getProperty("qpid.broker_jmx_method_rights_infer_all_access", "true"));
    private final Broker<?> _broker;

    MBeanInvocationHandlerImpl(Broker<?> broker) {
        this._broker = broker;
        this._uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (this._uncaughtExceptionHandler == null) {
            throw new IllegalStateException("no uncaught exception handler set");
        }
    }

    public static MBeanServerForwarder newProxyInstance(Broker<?> broker) {
        MBeanInvocationHandlerImpl handler = new MBeanInvocationHandlerImpl(broker);
        Class[] interfaces = new Class[]{MBeanServerForwarder.class};
        Object proxy = Proxy.newProxyInstance(MBeanServerForwarder.class.getClassLoader(), interfaces, (InvocationHandler)handler);
        return (MBeanServerForwarder)MBeanServerForwarder.class.cast(proxy);
    }

    private boolean invokeDirectly(String methodName, Object[] args, Subject subject) {
        ObjectName mbean;
        if (subject == null) {
            return true;
        }
        if (args == null || DELEGATE.equals(args[0])) {
            return true;
        }
        if (methodName.equals("queryNames") || methodName.equals("queryMBeans")) {
            return true;
        }
        return args[0] instanceof ObjectName && !"org.apache.qpid".equalsIgnoreCase((mbean = (ObjectName)args[0]).getDomain());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("getMBeanServer")) {
            return this._mbs;
        }
        if (methodName.equals("setMBeanServer")) {
            if (args[0] == null) {
                throw new IllegalArgumentException("Null MBeanServer");
            }
            if (this._mbs != null) {
                throw new IllegalArgumentException("MBeanServer object already initialized");
            }
            this._mbs = (MBeanServer)args[0];
            return null;
        }
        if (methodName.equals("createMBean") || methodName.equals("unregisterMBean")) {
            _logger.debug("User trying to create or unregister an MBean");
            throw new SecurityException("Access denied: " + methodName);
        }
        AccessControlContext acc = AccessController.getContext();
        Subject subject = Subject.getSubject(acc);
        try {
            if (this.invokeDirectly(methodName, args, subject)) {
                return method.invoke((Object)this._mbs, args);
            }
            try {
                AuthenticatedPrincipal.getAuthenticatedPrincipalFromSubject((Subject)subject);
            }
            catch (Exception e) {
                throw new SecurityException("Access denied: no authenticated principal", e);
            }
            return this.authoriseAndInvoke(method, args);
        }
        catch (InvocationTargetException e) {
            this.handleTargetException(method, args, e.getCause());
            throw e.getCause();
        }
    }

    private void handleTargetException(Method method, Object[] args, Throwable originalException) {
        Throwable t = originalException;
        String argsAsString = Arrays.toString(args);
        if (originalException instanceof RuntimeErrorException || originalException instanceof RuntimeMBeanException) {
            t = originalException.getCause();
        }
        if (t instanceof ConnectionScopedRuntimeException || t instanceof AbstractConfiguredObject.DuplicateIdException || t instanceof AbstractConfiguredObject.DuplicateNameException || t instanceof IntegrityViolationException || t instanceof IllegalStateTransitionException || t instanceof OperationsException || t instanceof MBeanException) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Exception was thrown on invoking of {} with arguments {}", new Object[]{method, argsAsString, t});
            } else {
                _logger.info("Exception was thrown on invoking of {} with arguments {} : {}", new Object[]{method, argsAsString, t.getMessage()});
            }
        } else {
            _logger.error("Unexpected exception was thrown on invoking of {} with arguments {}", new Object[]{method, argsAsString, t});
        }
        if (t instanceof Error || t instanceof ServerScopedRuntimeException) {
            this._uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), t);
        }
    }

    private Object authoriseAndInvoke(final Method method, final Object[] args) throws Exception {
        VirtualHost virtualHost;
        String type = this.getType(method, args);
        String virtualHostName = this.getVirtualHost(method, args);
        int impact = this.getImpact(method, args);
        if (virtualHostName != null && (virtualHost = this._broker.findVirtualHostByName(virtualHostName)) == null) {
            throw new IllegalArgumentException("Virtual host with name '" + virtualHostName + "' is not found.");
        }
        String methodName = this.getMethodName(method, args);
        Operation operation = this.isAccessMethod(methodName) || impact == 0 ? Operation.ACCESS : Operation.UPDATE;
        SecurityManager security = this._broker.getSecurityManager();
        security.authoriseMethod(operation, type, methodName, virtualHostName);
        if (this._managementRightsInferAllAccess) {
            try {
                return Subject.doAs(SecurityManager.getSubjectWithAddedSystemRights(), new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IllegalAccessException, InvocationTargetException {
                        return method.invoke((Object)MBeanInvocationHandlerImpl.this._mbs, args);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (Exception)e.getCause();
            }
        }
        return method.invoke((Object)this._mbs, args);
    }

    private String getType(Method method, Object[] args) {
        if (args[0] instanceof ObjectName) {
            ObjectName object = (ObjectName)args[0];
            String type = object.getKeyProperty("type");
            return type;
        }
        return null;
    }

    private String getVirtualHost(Method method, Object[] args) {
        if (args[0] instanceof ObjectName) {
            ObjectName object = (ObjectName)args[0];
            String vhost = object.getKeyProperty("VirtualHost");
            if (vhost != null) {
                try {
                    vhost = ObjectName.unquote(vhost);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            return vhost;
        }
        return null;
    }

    private String getMethodName(Method method, Object[] args) {
        String methodName = method.getName();
        if (args != null && args.length >= 1 && args[0] instanceof ObjectName) {
            if (methodName.equals("getAttribute")) {
                methodName = "get" + (String)args[1];
            } else if (methodName.equals("setAttribute")) {
                methodName = "set" + ((Attribute)args[1]).getName();
            } else if (methodName.equals("invoke")) {
                methodName = (String)args[1];
            }
        }
        return methodName;
    }

    private int getImpact(Method method, Object[] args) {
        if (args[0] instanceof ObjectName && method.getName().equals("invoke")) {
            String mbeanMethod;
            String string = mbeanMethod = args.length > 1 ? (String)args[1] : null;
            if (mbeanMethod == null) {
                return -1;
            }
            try {
                MBeanInfo mbeanInfo = this._mbs.getMBeanInfo((ObjectName)args[0]);
                if (mbeanInfo != null) {
                    MBeanOperationInfo[] opInfos;
                    for (MBeanOperationInfo opInfo : opInfos = mbeanInfo.getOperations()) {
                        if (!opInfo.getName().equals(mbeanMethod)) continue;
                        return opInfo.getImpact();
                    }
                }
            }
            catch (JMException ex) {
                _logger.error("Unable to determine mbean impact for method : " + mbeanMethod, (Throwable)ex);
            }
        }
        return -1;
    }

    private boolean isAccessMethod(String methodName) {
        return methodName.startsWith("query") || methodName.startsWith("get") || methodName.startsWith("is");
    }
}

