/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx;

import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.security.auth.Subject;
import org.apache.qpid.server.jmx.UsernameAccessor;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.logging.messages.ManagementConsoleMessages;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.security.auth.jmx.JMXConnectionPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementLogonLogoffReporter
implements NotificationListener,
NotificationFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagementLogonLogoffReporter.class);
    private final EventLoggerProvider _eventLoggerProvider;
    private final UsernameAccessor _usernameAccessor;

    public ManagementLogonLogoffReporter(EventLoggerProvider eventLoggerProvider, UsernameAccessor usernameAccessor) {
        this._eventLoggerProvider = eventLoggerProvider;
        this._usernameAccessor = usernameAccessor;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        String user;
        AuthenticatedPrincipal authenticatedPrincipal;
        String connectionId = ((JMXConnectionNotification)notification).getConnectionId();
        final String type = notification.getType();
        LOGGER.debug("Notification connectionId : {} type : {}", (Object)connectionId, (Object)type);
        Subject subject = this._usernameAccessor.getSubjectConnectionId(connectionId);
        if (subject == null) {
            subject = new Subject();
        }
        if ((authenticatedPrincipal = AuthenticatedPrincipal.getOptionalAuthenticatedPrincipalFromSubject((Subject)subject)) != null) {
            user = authenticatedPrincipal.getName();
        } else {
            String[] splitConnectionId = connectionId.split(" ");
            user = splitConnectionId[1];
        }
        if (subject.getPrincipals(JMXConnectionPrincipal.class).isEmpty()) {
            try {
                String clientHost = RemoteServer.getClientHost();
                subject = new Subject(false, subject.getPrincipals(), subject.getPublicCredentials(), subject.getPrivateCredentials());
                subject.getPrincipals().add((Principal)new JMXConnectionPrincipal(clientHost));
                subject.setReadOnly();
            }
            catch (ServerNotActiveException e) {
                // empty catch block
            }
        }
        final String username = user;
        Subject.doAs(subject, new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if ("jmx.remote.connection.opened".equals(type)) {
                    ManagementLogonLogoffReporter.this.getEventLogger().message(ManagementConsoleMessages.OPEN((String)username));
                } else if ("jmx.remote.connection.closed".equals(type) || "jmx.remote.connection.failed".equals(type)) {
                    ManagementLogonLogoffReporter.this.getEventLogger().message(ManagementConsoleMessages.CLOSE((String)username));
                }
                return null;
            }
        });
    }

    @Override
    public boolean isNotificationEnabled(Notification notification) {
        return notification instanceof JMXConnectionNotification && this.isLogonTypeEvent(notification);
    }

    private boolean isLogonTypeEvent(Notification notification) {
        String type = notification.getType();
        return "jmx.remote.connection.closed".equals(type) || "jmx.remote.connection.failed".equals(type) || "jmx.remote.connection.opened".equals(type);
    }

    public EventLogger getEventLogger() {
        return this._eventLoggerProvider.getEventLogger();
    }
}

