/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.rmi.server.RMIServerSocketFactory;
import org.apache.qpid.server.util.Action;

class QpidRMIServerSocketFactory
implements RMIServerSocketFactory {
    private final Action<Integer> _portAllocationAction;

    public QpidRMIServerSocketFactory(Action<Integer> portAllocationAction) {
        this._portAllocationAction = portAllocationAction;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.setReuseAddress(true);
        serverSocket.bind(new InetSocketAddress(port));
        this._portAllocationAction.performAction((Object)serverSocket.getLocalPort());
        return serverSocket;
    }

    public int hashCode() {
        int prime = 37;
        return 37 * QpidRMIServerSocketFactory.class.getName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass();
    }
}

