/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;

public class QpidSslRMIServerSocketFactory
extends SslRMIServerSocketFactory {
    private final SSLContext _sslContext;
    private final List<String> _tlsProtocolWhiteList;
    private final List<String> _tlsProtocolBlackList;
    private final List<String> _tlsCipherSuiteWhiteList;
    private final List<String> _tlsCipherSuiteBlackList;
    private final Action<Integer> _portAllocationAction;

    public QpidSslRMIServerSocketFactory(SSLContext sslContext, List<String> tlsProtocolWhiteList, List<String> tlsProtocolBlackList, List<String> tlsCipherSuiteWhiteList, List<String> tlsCipherSuiteBlackList, Action<Integer> action) throws NullPointerException {
        if (sslContext == null) {
            throw new NullPointerException("The provided SSLContext must not be null");
        }
        this._sslContext = sslContext;
        this._tlsProtocolWhiteList = tlsProtocolWhiteList == null ? null : new ArrayList<String>(tlsProtocolWhiteList);
        this._tlsProtocolBlackList = tlsProtocolBlackList == null ? null : new ArrayList<String>(tlsProtocolBlackList);
        this._tlsCipherSuiteWhiteList = tlsCipherSuiteWhiteList == null ? null : new ArrayList<String>(tlsCipherSuiteWhiteList);
        this._tlsCipherSuiteBlackList = tlsCipherSuiteBlackList == null ? null : new ArrayList<String>(tlsCipherSuiteBlackList);
        this._portAllocationAction = action;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        final SSLSocketFactory factory = this._sslContext.getSocketFactory();
        ServerSocket serverSocket = new ServerSocket(){

            @Override
            public Socket accept() throws IOException {
                Socket socket = super.accept();
                SSLSocket sslSocket = (SSLSocket)factory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true);
                sslSocket.setUseClientMode(false);
                SSLUtil.updateEnabledTlsProtocols((SSLSocket)sslSocket, (List)QpidSslRMIServerSocketFactory.this._tlsProtocolWhiteList, (List)QpidSslRMIServerSocketFactory.this._tlsProtocolBlackList);
                SSLUtil.updateEnabledCipherSuites((SSLSocket)sslSocket, (List)QpidSslRMIServerSocketFactory.this._tlsCipherSuiteWhiteList, (List)QpidSslRMIServerSocketFactory.this._tlsCipherSuiteBlackList);
                return sslSocket;
            }
        };
        serverSocket.setReuseAddress(true);
        serverSocket.bind(new InetSocketAddress(port));
        this._portAllocationAction.performAction((Object)serverSocket.getLocalPort());
        return serverSocket;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof QpidSslRMIServerSocketFactory)) {
            return false;
        }
        QpidSslRMIServerSocketFactory that = (QpidSslRMIServerSocketFactory)object;
        return this._sslContext.equals(that._sslContext);
    }

    @Override
    public int hashCode() {
        return this._sslContext.hashCode();
    }
}

