/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIServerSocketFactory;
import org.apache.qpid.server.util.Action;

class RegistryProtectingRMIServerSocketFactory
implements RMIServerSocketFactory {
    private final Action<Integer> _portAllocationAction;

    RegistryProtectingRMIServerSocketFactory(Action<Integer> portAllocationAction) {
        this._portAllocationAction = portAllocationAction;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        NoLocalAddressServerSocket serverSocket = new NoLocalAddressServerSocket();
        serverSocket.setReuseAddress(true);
        serverSocket.bind(new InetSocketAddress(port));
        this._portAllocationAction.performAction((Object)serverSocket.getLocalPort());
        return serverSocket;
    }

    public int hashCode() {
        int prime = 31;
        return 31 * RegistryProtectingRMIServerSocketFactory.class.getName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass();
    }

    private static class NoLocalAddressSocket
    extends Socket {
        private NoLocalAddressSocket() {
        }

        @Override
        public InetAddress getInetAddress() {
            return null;
        }
    }

    private static class NoLocalAddressServerSocket
    extends ServerSocket {
        NoLocalAddressServerSocket() throws IOException {
        }

        @Override
        public Socket accept() throws IOException {
            NoLocalAddressSocket s = new NoLocalAddressSocket();
            super.implAccept(s);
            return s;
        }
    }
}

