/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx.mbeans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.management.JMException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.qpid.management.common.mbeans.LoggingManagement;
import org.apache.qpid.management.common.mbeans.annotations.MBeanDescription;
import org.apache.qpid.server.jmx.AMQManagedObject;
import org.apache.qpid.server.jmx.ManagedObject;
import org.apache.qpid.server.jmx.ManagedObjectRegistry;
import org.apache.qpid.server.logging.BrokerFileLogger;
import org.apache.qpid.server.logging.BrokerNameAndLevelLogInclusionRule;
import org.apache.qpid.server.logging.LogLevel;
import org.apache.qpid.server.model.BrokerLogInclusionRule;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MBeanDescription(value="Logging Management Interface")
public class LoggingManagementMBean
extends AMQManagedObject
implements LoggingManagement {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingManagementMBean.class);
    private static final TabularType LOGGER_LEVEL_TABULAR_TYPE;
    private static final CompositeType LOGGER_LEVEL_COMPOSITE_TYPE;
    private static final String UNSUPPORTED_LOG_INCLUSION_RULE_TYPE = "<UNSUPPORTED>";
    private final String[] _allAvailableLogLevels;
    private final BrokerFileLogger _brokerFileLogger;

    public LoggingManagementMBean(BrokerFileLogger brokerFileLogger, ManagedObjectRegistry registry) throws JMException {
        super(LoggingManagement.class, "LoggingManagement", registry);
        this.register();
        this._brokerFileLogger = brokerFileLogger;
        Collection validLogLevels = LogLevel.validValues();
        this._allAvailableLogLevels = validLogLevels.toArray(new String[validLogLevels.size()]);
    }

    @Override
    public String getObjectInstanceName() {
        return "LoggingManagement";
    }

    @Override
    public ManagedObject getParentObject() {
        return null;
    }

    public Integer getLog4jLogWatchInterval() {
        return -1;
    }

    public String[] getAvailableLoggerLevels() {
        return this._allAvailableLogLevels;
    }

    public TabularData viewEffectiveRuntimeLoggerLevels() {
        return this.getTabularData(this.findRulesByDurability(LogInclusionRuleDurability.EITHER));
    }

    public String getRuntimeRootLoggerLevel() {
        return this.getLogLevel("ROOT", LogInclusionRuleDurability.NONDURABLE);
    }

    public boolean setRuntimeRootLoggerLevel(String level) {
        return this.setRuntimeLoggerLevel("ROOT", level);
    }

    public boolean setRuntimeLoggerLevel(String logger, String level) {
        return this.setLogLevel(logger, level, LogInclusionRuleDurability.NONDURABLE);
    }

    public TabularData viewConfigFileLoggerLevels() {
        return this.getTabularData(this.findRulesByDurability(LogInclusionRuleDurability.DURABLE));
    }

    public String getConfigFileRootLoggerLevel() throws IOException {
        return this.getLogLevel("ROOT", LogInclusionRuleDurability.DURABLE);
    }

    public boolean setConfigFileLoggerLevel(String logger, String level) {
        return this.setLogLevel(logger, level, LogInclusionRuleDurability.DURABLE);
    }

    public boolean setConfigFileRootLoggerLevel(String level) {
        return this.setConfigFileLoggerLevel("ROOT", level);
    }

    public void reloadConfigFile() throws IOException {
        throw new UnsupportedOperationException("Reloading of configuration file is not supported.");
    }

    private TabularData createTabularDataFromLevelsMap(Map<String, String> levels) {
        TabularDataSupport loggerLevelList = new TabularDataSupport(LOGGER_LEVEL_TABULAR_TYPE);
        for (Map.Entry<String, String> entry : levels.entrySet()) {
            String loggerName = entry.getKey();
            String level = entry.getValue();
            CompositeData loggerData = this.createRow(loggerName, level);
            loggerLevelList.put(loggerData);
        }
        return loggerLevelList;
    }

    private CompositeData createRow(String loggerName, String level) {
        Object[] itemData = new Object[]{loggerName, level.toUpperCase()};
        try {
            CompositeDataSupport loggerData = new CompositeDataSupport(LOGGER_LEVEL_COMPOSITE_TYPE, COMPOSITE_ITEM_NAMES.toArray(new String[COMPOSITE_ITEM_NAMES.size()]), itemData);
            return loggerData;
        }
        catch (OpenDataException ode) {
            throw new ConnectionScopedRuntimeException((Throwable)ode);
        }
    }

    private boolean isValidLogLevel(String logLevel) {
        try {
            LogLevel.valueOf((String)logLevel);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private TabularData getTabularData(Collection<BrokerLogInclusionRule<?>> rules) {
        TreeMap<String, String> logToLevelMap = new TreeMap<String, String>();
        for (BrokerLogInclusionRule<?> rule : rules) {
            if (rule instanceof BrokerNameAndLevelLogInclusionRule) {
                BrokerNameAndLevelLogInclusionRule nameAndLevelRule = (BrokerNameAndLevelLogInclusionRule)rule;
                logToLevelMap.put(nameAndLevelRule.getLoggerName(), nameAndLevelRule.getLevel().name());
                continue;
            }
            logToLevelMap.put(UNSUPPORTED_LOG_INCLUSION_RULE_TYPE, "");
        }
        return this.createTabularDataFromLevelsMap(logToLevelMap);
    }

    private String getLogLevel(String loggerName, LogInclusionRuleDurability logInclusionRuleDurability) {
        LogLevel level = LogLevel.OFF;
        List<BrokerNameAndLevelLogInclusionRule<?>> rules = this.findRulesByLoggerNameAndDurability(loggerName, logInclusionRuleDurability);
        for (BrokerNameAndLevelLogInclusionRule<?> rule : rules) {
            LogLevel filterLevel = rule.getLevel();
            if (level.compareTo((Enum)filterLevel) <= 0) continue;
            level = filterLevel;
        }
        return level.name();
    }

    private boolean setLogLevel(String logger, String level, LogInclusionRuleDurability durability) {
        if (!this.isValidLogLevel(level)) {
            LOGGER.warn("{} is not a known level", (Object)level);
            return false;
        }
        List<BrokerNameAndLevelLogInclusionRule<?>> rules = this.findRulesByLoggerNameAndDurability(logger, durability);
        if (rules.isEmpty()) {
            LOGGER.warn("There is no logger with name '{}' and durability '{}'", (Object)logger, (Object)durability.name().toLowerCase());
            return false;
        }
        LogLevel targetLevel = LogLevel.valueOf((String)level);
        for (BrokerNameAndLevelLogInclusionRule<?> rule : rules) {
            try {
                rule.setAttributes(Collections.singletonMap("level", targetLevel));
            }
            catch (RuntimeException e) {
                LOGGER.error("Aborting setting runtime logging level due to failure", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private List<BrokerLogInclusionRule<?>> findRulesByDurability(LogInclusionRuleDurability durability) {
        Collection rules = this._brokerFileLogger.getChildren(BrokerLogInclusionRule.class);
        ArrayList results = new ArrayList();
        if (durability == LogInclusionRuleDurability.EITHER) {
            results.addAll(rules);
        } else {
            for (BrokerLogInclusionRule rule : rules) {
                if (durability != LogInclusionRuleDurability.valueOf(rule.isDurable())) continue;
                results.add(rule);
            }
        }
        return results;
    }

    private List<BrokerNameAndLevelLogInclusionRule<?>> findRulesByLoggerNameAndDurability(String loggerName, LogInclusionRuleDurability logInclusionRuleDurability) {
        ArrayList results = new ArrayList();
        List<BrokerLogInclusionRule<?>> rules = this.findRulesByDurability(logInclusionRuleDurability);
        String sanitizedLoggerName = this.sanitizeLoggerName(loggerName);
        for (BrokerLogInclusionRule brokerLogInclusionRule : rules) {
            BrokerNameAndLevelLogInclusionRule brokerNameAndLevelLogInclusionRule;
            String ruleLoggerName;
            if (!(brokerLogInclusionRule instanceof BrokerNameAndLevelLogInclusionRule) || !sanitizedLoggerName.equals(ruleLoggerName = this.sanitizeLoggerName((brokerNameAndLevelLogInclusionRule = (BrokerNameAndLevelLogInclusionRule)brokerLogInclusionRule).getLoggerName()))) continue;
            results.add(brokerNameAndLevelLogInclusionRule);
        }
        return results;
    }

    private String sanitizeLoggerName(String loggerName) {
        if (loggerName == null || "".equals(loggerName)) {
            return "ROOT";
        }
        return loggerName;
    }

    static {
        try {
            OpenType[] loggerLevelItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
            LOGGER_LEVEL_COMPOSITE_TYPE = new CompositeType("LoggerLevelList", "Logger Level Data", COMPOSITE_ITEM_NAMES.toArray(new String[COMPOSITE_ITEM_NAMES.size()]), COMPOSITE_ITEM_DESCRIPTIONS.toArray(new String[COMPOSITE_ITEM_DESCRIPTIONS.size()]), loggerLevelItemTypes);
            LOGGER_LEVEL_TABULAR_TYPE = new TabularType("LoggerLevel", "List of loggers with levels", LOGGER_LEVEL_COMPOSITE_TYPE, TABULAR_UNIQUE_INDEX.toArray(new String[TABULAR_UNIQUE_INDEX.size()]));
        }
        catch (OpenDataException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static enum LogInclusionRuleDurability {
        DURABLE,
        NONDURABLE,
        EITHER;


        public static LogInclusionRuleDurability valueOf(boolean durable) {
            return durable ? DURABLE : NONDURABLE;
        }
    }
}

