/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.jmx.mbeans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import org.apache.qpid.management.common.mbeans.ManagedBroker;
import org.apache.qpid.management.common.mbeans.ManagedQueue;
import org.apache.qpid.management.common.mbeans.annotations.MBeanConstructor;
import org.apache.qpid.management.common.mbeans.annotations.MBeanDescription;
import org.apache.qpid.management.common.mbeans.annotations.MBeanOperationParameter;
import org.apache.qpid.server.jmx.ManagedObject;
import org.apache.qpid.server.jmx.mbeans.AbstractStatisticsGatheringMBean;
import org.apache.qpid.server.jmx.mbeans.QueueMBean;
import org.apache.qpid.server.jmx.mbeans.VirtualHostMBean;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.NoFactoryForTypeException;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.queue.QueueArgumentsConverter;
import org.apache.qpid.server.virtualhost.ExchangeExistsException;
import org.apache.qpid.server.virtualhost.ExchangeIsAlternateException;
import org.apache.qpid.server.virtualhost.QueueExistsException;
import org.apache.qpid.server.virtualhost.RequiredExchangeException;
import org.apache.qpid.server.virtualhost.ReservedExchangeNameException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MBeanDescription(value="This MBean exposes the broker level management features")
public class VirtualHostManagerMBean
extends AbstractStatisticsGatheringMBean<VirtualHost>
implements ManagedBroker {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualHostManagerMBean.class);
    private static final boolean _moveNonExclusiveQueueOwnerToDescription = Boolean.parseBoolean(System.getProperty("qpid.move_non_exclusive_queue_owner_to_description", Boolean.TRUE.toString()));
    private final VirtualHostMBean _virtualHostMBean;

    @MBeanConstructor(value="Creates the Broker Manager MBean")
    public VirtualHostManagerMBean(VirtualHostMBean virtualHostMBean) throws JMException {
        super(ManagedBroker.class, "VirtualHostManager", virtualHostMBean.getRegistry(), virtualHostMBean.getVirtualHost());
        this._virtualHostMBean = virtualHostMBean;
        this.register();
    }

    @Override
    protected long getBytesOut() {
        return ((VirtualHost)this.getConfiguredObject()).getBytesOut();
    }

    @Override
    protected long getBytesIn() {
        return ((VirtualHost)this.getConfiguredObject()).getBytesIn();
    }

    @Override
    protected long getMessagesOut() {
        return ((VirtualHost)this.getConfiguredObject()).getMessagesOut();
    }

    @Override
    protected long getMessagesIn() {
        return ((VirtualHost)this.getConfiguredObject()).getMessagesIn();
    }

    @Override
    public String getObjectInstanceName() {
        return ObjectName.quote(this._virtualHostMBean.getName());
    }

    @Override
    public ManagedObject getParentObject() {
        return this._virtualHostMBean;
    }

    public String[] getExchangeTypes() throws IOException {
        Collection exchangeTypes = this._virtualHostMBean.getVirtualHost().getExchangeTypeNames();
        return exchangeTypes.toArray(new String[exchangeTypes.size()]);
    }

    public List<String> retrieveQueueAttributeNames() throws IOException {
        return ManagedQueue.QUEUE_ATTRIBUTES;
    }

    public List<List<Object>> retrieveQueueAttributeValues(@MBeanOperationParameter(name="attributes", description="Attributes to retrieve") String[] attributes) throws IOException {
        int attributesLength = attributes.length;
        ArrayList<List<Object>> queueAttributesList = new ArrayList<List<Object>>();
        for (QueueMBean queue : this._virtualHostMBean.getQueues()) {
            if (queue == null) continue;
            ArrayList<Object> attributeValues = new ArrayList<Object>(attributesLength);
            for (int i = 0; i < attributesLength; ++i) {
                try {
                    attributeValues.add(queue.getAttribute(attributes[i]));
                    continue;
                }
                catch (Exception e) {
                    attributeValues.add("-");
                }
            }
            queueAttributesList.add(attributeValues);
        }
        return queueAttributesList;
    }

    public void createNewExchange(String name, String type, boolean durable) throws IOException, JMException, MBeanException {
        if (!((VirtualHost)this.getConfiguredObject()).getExchangeTypeNames().contains(type)) {
            throw new OperationsException("No such exchange type \"" + type + "\"");
        }
        try {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("name", name);
            attributes.put("type", type);
            attributes.put("durable", durable);
            attributes.put("lifetimePolicy", LifetimePolicy.PERMANENT);
            ((VirtualHost)this.getConfiguredObject()).createExchange(attributes);
        }
        catch (ExchangeExistsException e) {
            String message = "Exchange with name '" + name + "' already exists";
            JMException jme = new JMException(message);
            throw new MBeanException(jme, "Error in creating exchange " + name);
        }
        catch (ReservedExchangeNameException e) {
            throw new UnsupportedOperationException("'" + name + "' is a reserved exchange name");
        }
        catch (NoFactoryForTypeException e) {
            JMException jme = new JMException(e.getMessage());
            throw new MBeanException(jme, "Error in creating exchange " + name);
        }
        catch (IllegalArgumentException iae) {
            JMException jme = new JMException(iae.toString());
            throw new MBeanException(jme, "Error in creating exchange " + name);
        }
    }

    public void unregisterExchange(String exchangeName) throws IOException, JMException, MBeanException {
        VirtualHost virtualHost = this._virtualHostMBean.getVirtualHost();
        Exchange exchange = (Exchange)virtualHost.getChildByName(Exchange.class, exchangeName);
        if (exchange == null) {
            throw new OperationsException("No such exchange \"" + exchangeName + "\"");
        }
        try {
            exchange.delete();
        }
        catch (ExchangeIsAlternateException | RequiredExchangeException e) {
            throw new UnsupportedOperationException(e.getMessage(), e);
        }
        catch (IllegalStateException ex) {
            JMException jme = new JMException(ex.toString());
            throw new MBeanException(jme, "Error in unregistering exchange " + exchangeName);
        }
    }

    public void createNewQueue(String queueName, String owner, boolean durable) throws IOException, JMException, MBeanException {
        this.createNewQueue(queueName, owner, durable, Collections.EMPTY_MAP);
    }

    public void createNewQueue(String queueName, String owner, boolean durable, Map<String, Object> originalArguments) throws IOException, JMException {
        Map<String, Object> createArgs = this.processNewQueueArguments(queueName, owner, originalArguments);
        Map attributes = QueueArgumentsConverter.convertWireArgsToModel(createArgs);
        attributes.put("name", queueName);
        attributes.put("durable", durable);
        attributes.put("lifetimePolicy", LifetimePolicy.PERMANENT);
        try {
            ((VirtualHost)this.getConfiguredObject()).createQueue(attributes);
        }
        catch (QueueExistsException qee) {
            throw new IllegalArgumentException("Queue with name '" + queueName + "' already exists");
        }
    }

    private Map<String, Object> processNewQueueArguments(String queueName, String owner, Map<String, Object> arguments) {
        HashMap<String, String> argumentsCopy;
        if (_moveNonExclusiveQueueOwnerToDescription && owner != null) {
            argumentsCopy = new HashMap(arguments == null ? new HashMap<String, String>() : arguments);
            if (!argumentsCopy.containsKey("x-qpid-description")) {
                LOGGER.warn("Non-exclusive owner " + owner + " for new queue " + queueName + " moved to " + "x-qpid-description");
                argumentsCopy.put("x-qpid-description", owner);
            } else {
                LOGGER.warn("Non-exclusive owner " + owner + " for new queue " + queueName + " ignored.");
            }
        } else {
            argumentsCopy = arguments;
        }
        return argumentsCopy;
    }

    public void deleteQueue(@MBeanOperationParameter(name="Queue", description="Queue Name") String queueName) throws IOException, JMException, MBeanException {
        VirtualHost virtualHost = this._virtualHostMBean.getVirtualHost();
        Queue queue = (Queue)virtualHost.getChildByName(Queue.class, queueName);
        if (queue == null) {
            throw new OperationsException("No such queue \"" + queueName + "\"");
        }
        queue.delete();
    }

    @Override
    public ObjectName getObjectName() throws MalformedObjectNameException {
        return this.getObjectNameForSingleInstanceMBean();
    }

    public boolean isStatisticsEnabled() {
        return true;
    }
}

