/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport.websocket;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.transport.AcceptingTransport;
import org.apache.qpid.server.transport.AggregateTicker;
import org.apache.qpid.server.transport.ByteBufferSender;
import org.apache.qpid.server.transport.MultiVersionProtocolEngine;
import org.apache.qpid.server.transport.MultiVersionProtocolEngineFactory;
import org.apache.qpid.server.transport.SchedulingDelayNotificationListener;
import org.apache.qpid.server.transport.ServerNetworkConnection;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebSocketProvider
implements AcceptingTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketProvider.class);
    private static final String AMQP_WEBSOCKET_SUBPROTOCOL = "amqp";
    private final Transport _transport;
    private final SSLContext _sslContext;
    private final AmqpPort<?> _port;
    private final Broker<?> _broker;
    private final Set<Protocol> _supported;
    private final Protocol _defaultSupportedProtocolReply;
    private final MultiVersionProtocolEngineFactory _factory;
    private Server _server;
    private final List<ConnectionWrapper> _activeConnections = new CopyOnWriteArrayList<ConnectionWrapper>();
    private final WebSocketIdleTimeoutChecker _idleTimeoutChecker = new WebSocketIdleTimeoutChecker();
    private final AtomicBoolean _closed = new AtomicBoolean();

    WebSocketProvider(Transport transport, SSLContext sslContext, AmqpPort<?> port, Set<Protocol> supported, Protocol defaultSupportedProtocolReply) {
        this._transport = transport;
        this._sslContext = sslContext;
        this._port = port;
        this._broker = (Broker)port.getParent();
        this._supported = supported;
        this._defaultSupportedProtocolReply = defaultSupportedProtocolReply;
        this._factory = new MultiVersionProtocolEngineFactory(this._broker, this._supported, this._defaultSupportedProtocolReply, this._port, this._transport);
    }

    public void start() {
        ServerConnector connector;
        this._idleTimeoutChecker.start();
        this._server = new Server((ThreadPool)new QBBTrackingThreadPool());
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory();
        httpConnectionFactory.getHttpConfiguration().setSendServerVersion(false);
        httpConnectionFactory.getHttpConfiguration().setSendXPoweredBy(false);
        if (this._transport == Transport.WS) {
            connector = new ServerConnector(this._server, new ConnectionFactory[]{httpConnectionFactory});
        } else if (this._transport == Transport.WSS) {
            SslContextFactory sslContextFactory = new SslContextFactory(){

                public void customize(SSLEngine sslEngine) {
                    super.customize(sslEngine);
                    SSLUtil.updateEnabledCipherSuites((SSLEngine)sslEngine, (List)WebSocketProvider.this._port.getTlsCipherSuiteWhiteList(), (List)WebSocketProvider.this._port.getTlsCipherSuiteBlackList());
                    SSLUtil.updateEnabledTlsProtocols((SSLEngine)sslEngine, (List)WebSocketProvider.this._port.getTlsProtocolWhiteList(), (List)WebSocketProvider.this._port.getTlsProtocolBlackList());
                    if (WebSocketProvider.this._port.getTlsCipherSuiteWhiteList() != null && !WebSocketProvider.this._port.getTlsCipherSuiteWhiteList().isEmpty()) {
                        SSLParameters sslParameters = sslEngine.getSSLParameters();
                        sslParameters.setUseCipherSuitesOrder(true);
                        sslEngine.setSSLParameters(sslParameters);
                    }
                }
            };
            sslContextFactory.setSslContext(this._sslContext);
            sslContextFactory.setNeedClientAuth(this._port.getNeedClientAuth());
            sslContextFactory.setWantClientAuth(this._port.getWantClientAuth());
            connector = new ServerConnector(this._server, sslContextFactory, new ConnectionFactory[]{httpConnectionFactory});
            connector.addBean((Object)new SslHandshakeListener(){

                public void handshakeFailed(SslHandshakeListener.Event event, Throwable failure) {
                    SSLEngine sslEngine = event.getSSLEngine();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.info("TLS handshake failed: host='{}', port={}", new Object[]{sslEngine.getPeerHost(), sslEngine.getPeerPort(), failure});
                    } else {
                        LOGGER.info("TLS handshake failed: host='{}', port={}: {}", new Object[]{sslEngine.getPeerHost(), sslEngine.getPeerPort(), String.valueOf(failure)});
                    }
                }
            });
        } else {
            throw new IllegalArgumentException("Unexpected transport on port " + this._port.getName() + ":" + this._transport);
        }
        String bindingAddress = this._port.getBindingAddress();
        if (bindingAddress != null && !bindingAddress.trim().equals("") && !bindingAddress.trim().equals("*")) {
            connector.setHost(bindingAddress.trim());
        }
        connector.setPort(this._port.getPort());
        this._server.addConnector((Connector)connector);
        WebSocketHandler wshandler = new WebSocketHandler(){

            public void configure(WebSocketServletFactory factory) {
                factory.setCreator((req, resp) -> {
                    resp.setAcceptedSubProtocol(WebSocketProvider.AMQP_WEBSOCKET_SUBPROTOCOL);
                    return new AmqpWebSocket();
                });
            }

            public void configurePolicy(WebSocketPolicy policy) {
                super.configurePolicy(policy);
                try {
                    Field maxBinaryMessageSize = policy.getClass().getDeclaredField("maxBinaryMessageSize");
                    maxBinaryMessageSize.setAccessible(true);
                    maxBinaryMessageSize.set(policy, 0);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    LOGGER.warn("Could not override maxBinaryMessageSize", (Throwable)e);
                }
            }
        };
        this._server.setHandler((Handler)wshandler);
        wshandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if (response.isCommitted() || baseRequest.isHandled()) {
                    return;
                }
                baseRequest.setHandled(true);
                response.setStatus(403);
            }
        });
        try {
            this._server.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServerScopedRuntimeException((Throwable)e);
        }
    }

    public void close() {
        this._closed.set(true);
        this._idleTimeoutChecker.wakeup();
        try {
            this._server.stop();
        }
        catch (Exception e) {
            LOGGER.warn("Error closing the web socket for : " + this._port.getPort(), (Throwable)e);
            this._server = null;
        }
    }

    public int getAcceptingPort() {
        Server server = this._server;
        return server == null || server.getConnectors().length == 0 || !(server.getConnectors()[0] instanceof ServerConnector) ? this._port.getPort() : ((ServerConnector)server.getConnectors()[0]).getLocalPort();
    }

    private class WebSocketIdleTimeoutChecker
    extends Thread {
        public WebSocketIdleTimeoutChecker() {
            this.setName("WebSocket Idle Checker: " + WebSocketProvider.this._port);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!WebSocketProvider.this._closed.get()) {
                ConnectionWrapper connectionToTick = null;
                long currentTime = System.currentTimeMillis();
                WebSocketIdleTimeoutChecker webSocketIdleTimeoutChecker = this;
                synchronized (webSocketIdleTimeoutChecker) {
                    long nextTick = Long.MAX_VALUE;
                    for (ConnectionWrapper connection : WebSocketProvider.this._activeConnections) {
                        MultiVersionProtocolEngine engine = connection._protocolEngine;
                        AggregateTicker ticker = engine.getAggregateTicker();
                        long tick = ticker.getTimeToNextTick(currentTime);
                        if (tick <= 0L) {
                            connectionToTick = connection;
                            nextTick = -1L;
                            break;
                        }
                        if (tick >= nextTick) continue;
                        nextTick = tick;
                    }
                    if (nextTick > 0L) {
                        try {
                            this.wait(nextTick);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                }
                if (connectionToTick == null) continue;
                connectionToTick.tick();
            }
        }

        private synchronized void wakeup() {
            this.notifyAll();
        }
    }

    private class ConnectionWrapper
    implements ServerNetworkConnection,
    ByteBufferSender {
        private final Session _connection;
        private final SocketAddress _localAddress;
        private final SocketAddress _remoteAddress;
        private final ConcurrentLinkedQueue<QpidByteBuffer> _buffers = new ConcurrentLinkedQueue();
        private final MultiVersionProtocolEngine _protocolEngine;
        private final ThreadPool _threadPool;
        private final Runnable _tickJob;
        private Certificate _certificate;
        private long _maxWriteIdleMillis;
        private long _maxReadIdleMillis;

        public ConnectionWrapper(Session connection, SocketAddress localAddress, SocketAddress remoteAddress, final MultiVersionProtocolEngine protocolEngine, ThreadPool threadPool) {
            this._connection = connection;
            this._localAddress = localAddress;
            this._remoteAddress = remoteAddress;
            this._protocolEngine = protocolEngine;
            this._threadPool = threadPool;
            this._tickJob = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ConnectionWrapper connectionWrapper = ConnectionWrapper.this;
                    synchronized (connectionWrapper) {
                        protocolEngine.getAggregateTicker().tick(System.currentTimeMillis());
                        ConnectionWrapper.this.doWrite();
                    }
                }
            };
        }

        public ByteBufferSender getSender() {
            return this;
        }

        public void start() {
        }

        public boolean isDirectBufferPreferred() {
            return false;
        }

        public void send(QpidByteBuffer msg) {
            if (msg.remaining() > 0) {
                this._buffers.add(msg.duplicate());
            }
            msg.position(msg.limit());
        }

        public void flush() {
        }

        public void close() {
            this._connection.close();
        }

        public SocketAddress getRemoteAddress() {
            return this._remoteAddress;
        }

        public SocketAddress getLocalAddress() {
            return this._localAddress;
        }

        public void setMaxWriteIdleMillis(long millis) {
            this._maxWriteIdleMillis = millis;
        }

        public void setMaxReadIdleMillis(long millis) {
            this._maxReadIdleMillis = millis;
        }

        public Principal getPeerPrincipal() {
            return this._certificate instanceof X509Certificate ? ((X509Certificate)this._certificate).getSubjectDN() : null;
        }

        public Certificate getPeerCertificate() {
            return this._certificate;
        }

        public long getMaxReadIdleMillis() {
            return this._maxReadIdleMillis;
        }

        public long getMaxWriteIdleMillis() {
            return this._maxWriteIdleMillis;
        }

        public void addSchedulingDelayNotificationListeners(SchedulingDelayNotificationListener listener) {
        }

        public void removeSchedulingDelayNotificationListeners(SchedulingDelayNotificationListener listener) {
        }

        public String getTransportInfo() {
            return this._connection.getProtocolVersion();
        }

        public long getScheduledTime() {
            return 0L;
        }

        public String getSelectedHost() {
            return null;
        }

        void setPeerCertificate(Certificate certificate) {
            this._certificate = certificate;
        }

        public synchronized void doWrite() {
            QpidByteBuffer buf;
            int size = 0;
            ArrayList<QpidByteBuffer> toBeWritten = new ArrayList<QpidByteBuffer>(this._buffers.size());
            while ((buf = this._buffers.poll()) != null) {
                size += buf.remaining();
                toBeWritten.add(buf);
            }
            byte[] data = new byte[size];
            int offset = 0;
            for (QpidByteBuffer tmp : toBeWritten) {
                int remaining = tmp.remaining();
                tmp.get(data, offset, remaining);
                tmp.dispose();
                offset += remaining;
            }
            if (size > 0) {
                try {
                    this._connection.getRemote().sendBytes(ByteBuffer.wrap(data));
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Written {} byte(s)", (Object)data.length);
                    }
                }
                catch (IOException e) {
                    LOGGER.info("Exception on write: {}", (Object)e.getMessage());
                    this.close();
                }
            }
        }

        public synchronized void doWork() {
            this._protocolEngine.clearWork();
            try {
                this._protocolEngine.setIOThread(Thread.currentThread());
                Iterator iter = this._protocolEngine.processPendingIterator();
                while (iter.hasNext()) {
                    ((Runnable)iter.next()).run();
                }
                this.doWrite();
                WebSocketProvider.this._idleTimeoutChecker.wakeup();
            }
            finally {
                this._protocolEngine.setIOThread(null);
            }
        }

        public void tick() {
            this._threadPool.execute(this._tickJob);
        }
    }

    @WebSocket
    public class AmqpWebSocket {
        private volatile QpidByteBuffer _netInputBuffer;
        private volatile MultiVersionProtocolEngine _protocolEngine;
        private volatile ConnectionWrapper _connectionWrapper;
        private volatile boolean _unexpectedByteBufferSizeReported;

        AmqpWebSocket() {
            this._netInputBuffer = QpidByteBuffer.allocateDirect((int)WebSocketProvider.this._broker.getNetworkBufferSize());
        }

        @OnWebSocketConnect
        public void onWebSocketConnect(Session session) {
            ServletUpgradeRequest upgradeRequest;
            InetSocketAddress localAddress = session.getLocalAddress();
            InetSocketAddress remoteAddress = session.getRemoteAddress();
            this._protocolEngine = WebSocketProvider.this._factory.newProtocolEngine((SocketAddress)remoteAddress);
            session.setIdleTimeout(0L);
            this._connectionWrapper = new ConnectionWrapper(session, localAddress, remoteAddress, this._protocolEngine, WebSocketProvider.this._server.getThreadPool());
            if (session.getUpgradeRequest() instanceof ServletUpgradeRequest && (upgradeRequest = (ServletUpgradeRequest)session.getUpgradeRequest()).getCertificates() != null && upgradeRequest.getCertificates().length > 0) {
                this._connectionWrapper.setPeerCertificate(upgradeRequest.getCertificates()[0]);
            }
            this._protocolEngine.setNetworkConnection((ServerNetworkConnection)this._connectionWrapper);
            this._protocolEngine.setWorkListener(object -> WebSocketProvider.this._server.getThreadPool().execute(() -> this._connectionWrapper.doWork()));
            WebSocketProvider.this._activeConnections.add(this._connectionWrapper);
            WebSocketProvider.this._idleTimeoutChecker.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @OnWebSocketMessage
        public void onWebSocketBinary(Session sess, byte[] payload, int offset, int len) {
            ConnectionWrapper connectionWrapper = this._connectionWrapper;
            synchronized (connectionWrapper) {
                this._protocolEngine.clearWork();
                try {
                    this._protocolEngine.setIOThread(Thread.currentThread());
                    Iterator iter = this._protocolEngine.processPendingIterator();
                    while (iter.hasNext()) {
                        ((Runnable)iter.next()).run();
                    }
                    int remaining = len;
                    do {
                        int chunkLen = Math.min(remaining, this._netInputBuffer.remaining());
                        this._netInputBuffer.put(payload, offset, chunkLen);
                        remaining -= chunkLen;
                        offset += chunkLen;
                        this._netInputBuffer.flip();
                        this._protocolEngine.received(this._netInputBuffer);
                        this._connectionWrapper.doWrite();
                        this.restoreApplicationBufferForWrite();
                    } while (remaining > 0);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Read {} byte(s)", (Object)len);
                    }
                }
                finally {
                    this._protocolEngine.setIOThread(null);
                }
            }
            WebSocketProvider.this._idleTimeoutChecker.wakeup();
        }

        private void restoreApplicationBufferForWrite() {
            try (QpidByteBuffer oldNetInputBuffer = this._netInputBuffer;){
                int unprocessedDataLength = this._netInputBuffer.remaining();
                this._netInputBuffer.limit(this._netInputBuffer.capacity());
                this._netInputBuffer = oldNetInputBuffer.slice();
                this._netInputBuffer.limit(unprocessedDataLength);
            }
            if (this._netInputBuffer.limit() != this._netInputBuffer.capacity()) {
                this._netInputBuffer.position(this._netInputBuffer.limit());
                this._netInputBuffer.limit(this._netInputBuffer.capacity());
            } else {
                var2_2 = null;
                try (QpidByteBuffer currentBuffer = this._netInputBuffer;){
                    int newBufSize;
                    if (currentBuffer.capacity() < WebSocketProvider.this._broker.getNetworkBufferSize()) {
                        newBufSize = WebSocketProvider.this._broker.getNetworkBufferSize();
                    } else {
                        newBufSize = currentBuffer.capacity() + WebSocketProvider.this._broker.getNetworkBufferSize();
                        this.reportUnexpectedByteBufferSizeUsage();
                    }
                    this._netInputBuffer = QpidByteBuffer.allocateDirect((int)newBufSize);
                    this._netInputBuffer.put(currentBuffer);
                }
                catch (Throwable throwable) {
                    var2_2 = throwable;
                    throw throwable;
                }
            }
        }

        private void reportUnexpectedByteBufferSizeUsage() {
            if (!this._unexpectedByteBufferSizeReported) {
                LOGGER.info("At least one frame unexpectedly does not fit into default byte buffer size ({}B) on a connection {}.", (Object)WebSocketProvider.this._broker.getNetworkBufferSize(), (Object)this.toString());
                this._unexpectedByteBufferSizeReported = true;
            }
        }

        @OnWebSocketMessage
        public void onWebSocketText(Session sess, String text) {
            LOGGER.info("Unexpected websocket text message received, closing connection");
            sess.close();
        }

        @OnWebSocketClose
        public void onWebSocketClose(int statusCode, String reason) {
            if (this._protocolEngine != null) {
                this._protocolEngine.closed();
            }
            WebSocketProvider.this._activeConnections.remove(this._connectionWrapper);
            WebSocketProvider.this._idleTimeoutChecker.wakeup();
            this._netInputBuffer.dispose();
        }
    }

    private static class QBBTrackingThreadPool
    extends QueuedThreadPool {
        private final ThreadFactory _threadFactory = QpidByteBuffer.createQpidByteBufferTrackingThreadFactory(r -> QBBTrackingThreadPool.access$401(this, r));

        private QBBTrackingThreadPool() {
        }

        protected Thread newThread(Runnable runnable) {
            return this._threadFactory.newThread(runnable);
        }
    }
}

