/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.qmf;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.qmf.QMFClass;
import org.apache.qpid.qmf.QMFCommand;
import org.apache.qpid.qmf.QMFCommandDecoder;
import org.apache.qpid.qmf.QMFMessage;
import org.apache.qpid.qmf.QMFObject;
import org.apache.qpid.qmf.QMFPackage;
import org.apache.qpid.qmf.QMFService;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.configuration.ConfigStore;
import org.apache.qpid.server.configuration.ConfiguredObject;
import org.apache.qpid.server.configuration.ExchangeConfigType;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeReferrer;
import org.apache.qpid.server.exchange.ExchangeType;
import org.apache.qpid.server.exchange.topic.TopicExchangeResult;
import org.apache.qpid.server.exchange.topic.TopicMatcherResult;
import org.apache.qpid.server.exchange.topic.TopicNormalizer;
import org.apache.qpid.server.exchange.topic.TopicParser;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.virtualhost.HouseKeepingTask;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementExchange
implements Exchange,
QMFService.Listener {
    private static final AMQShortString QPID_MANAGEMENT = new AMQShortString("qpid.management");
    private static final AMQShortString QPID_MANAGEMENT_TYPE = new AMQShortString("management");
    private VirtualHost _virtualHost;
    private final TopicParser _parser = new TopicParser();
    private final Map<AMQShortString, TopicExchangeResult> _topicExchangeResults = new ConcurrentHashMap<AMQShortString, TopicExchangeResult>();
    private final Set<Binding> _bindingSet = new CopyOnWriteArraySet<Binding>();
    private UUID _id;
    private UUID _qmfId;
    private static final String AGENT_BANK = "0";
    private int _bindingCountHigh;
    private final AtomicLong _msgReceived = new AtomicLong();
    private final AtomicLong _bytesReceived = new AtomicLong();
    private final CopyOnWriteArrayList<Exchange.BindingListener> _listeners = new CopyOnWriteArrayList();
    private long _createTime = System.currentTimeMillis();
    private final ManagementQueue _mgmtQueue = new ManagementQueue();
    public static final ExchangeType<ManagementExchange> TYPE = new ExchangeType<ManagementExchange>(){

        @Override
        public AMQShortString getName() {
            return QPID_MANAGEMENT_TYPE;
        }

        @Override
        public Class<ManagementExchange> getExchangeClass() {
            return ManagementExchange.class;
        }

        @Override
        public ManagementExchange newInstance(UUID id, VirtualHost host, AMQShortString name, boolean durable, int ticket, boolean autoDelete) throws AMQException {
            ManagementExchange exch = new ManagementExchange();
            exch.initialise(id, host, name, durable, ticket, autoDelete);
            return exch;
        }

        @Override
        public AMQShortString getDefaultExchangeName() {
            return QPID_MANAGEMENT;
        }
    };

    @Override
    public AMQShortString getNameShortString() {
        return QPID_MANAGEMENT;
    }

    @Override
    public AMQShortString getTypeShortString() {
        return QPID_MANAGEMENT_TYPE;
    }

    @Override
    public void initialise(UUID id, VirtualHost host, AMQShortString name, boolean durable, int ticket, boolean autoDelete) throws AMQException {
        if (!QPID_MANAGEMENT.equals(name)) {
            throw new AMQException("Can't create more than one Management exchange");
        }
        this._virtualHost = host;
        this._id = id;
        this._virtualHost.scheduleHouseKeepingTask(this._virtualHost.getBroker().getManagementPublishInterval().intValue(), new UpdateTask(this._virtualHost));
        this._qmfId = this.getConfigStore().createId();
        this.getConfigStore().addConfiguredObject(this);
        this.getQMFService().addListener(this);
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public UUID getQMFId() {
        return this._qmfId;
    }

    @Override
    public ExchangeConfigType getConfigType() {
        return ExchangeConfigType.getInstance();
    }

    @Override
    public ConfiguredObject getParent() {
        return this._virtualHost;
    }

    @Override
    public boolean isDurable() {
        return true;
    }

    @Override
    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    @Override
    public String getName() {
        return QPID_MANAGEMENT.toString();
    }

    @Override
    public ExchangeType getType() {
        return TYPE;
    }

    @Override
    public boolean isAutoDelete() {
        return false;
    }

    @Override
    public int getTicket() {
        return 0;
    }

    @Override
    public void close() throws AMQException {
        this.getConfigStore().removeConfiguredObject(this);
    }

    public ConfigStore getConfigStore() {
        return this.getVirtualHost().getConfigStore();
    }

    @Override
    public synchronized void addBinding(Binding b) {
        String bindingKey;
        if (this._bindingSet.add(b)) {
            AMQShortString routingKey = TopicNormalizer.normalize(new AMQShortString(b.getBindingKey()));
            TopicExchangeResult result = this._topicExchangeResults.get(routingKey);
            if (result == null) {
                result = new TopicExchangeResult();
                result.addUnfilteredQueue(b.getQueue());
                this._parser.addBinding(routingKey, result);
                this._topicExchangeResults.put(routingKey, result);
            } else {
                result.addUnfilteredQueue(b.getQueue());
            }
            result.addBinding(b);
        }
        for (Exchange.BindingListener listener : this._listeners) {
            listener.bindingAdded(this, b);
        }
        if (this._bindingSet.size() > this._bindingCountHigh) {
            this._bindingCountHigh = this._bindingSet.size();
        }
        if ((bindingKey = b.getBindingKey()).startsWith("schema.") || bindingKey.startsWith("*.") || bindingKey.startsWith("#.")) {
            this.publishAllSchema();
        }
        if (bindingKey.startsWith("console.") || bindingKey.startsWith("*.") || bindingKey.startsWith("#.")) {
            this.publishAllConsole();
        }
    }

    void publishAllConsole() {
        QMFService qmfService = this.getQMFService();
        long sampleTime = System.currentTimeMillis();
        for (QMFPackage pkg : qmfService.getSupportedSchemas()) {
            for (QMFClass qmfClass : pkg.getClasses()) {
                Collection<QMFObject> qmfObjects = qmfService.getObjects(qmfClass);
                this.publishObjectsToConsole(sampleTime, qmfObjects);
            }
        }
    }

    private QMFService getQMFService() {
        return this._virtualHost.getApplicationRegistry().getQMFService();
    }

    void publishObjectsToConsole(long sampleTime, Collection<QMFObject> qmfObjects) {
        if (!qmfObjects.isEmpty() && this.hasBindings()) {
            Object qmfClass = qmfObjects.iterator().next().getQMFClass();
            ArrayList<QMFCommand> commands = new ArrayList<QMFCommand>();
            for (QMFObject obj : qmfObjects) {
                commands.add(obj.asConfigInfoCmd(sampleTime));
                commands.add(obj.asInstrumentInfoCmd(sampleTime));
            }
            this.publishToConsole((QMFClass)qmfClass, commands);
        }
    }

    private void publishToConsole(QMFClass qmfClass, ArrayList<QMFCommand> commands) {
        if (!commands.isEmpty() && this.hasBindings()) {
            String routingKey = "console.obj.1.0." + qmfClass.getPackage().getName() + "." + qmfClass.getName();
            QMFMessage message = new QMFMessage(routingKey, commands.toArray(new QMFCommand[commands.size()]));
            Collection<TopicMatcherResult> results = this._parser.parse(new AMQShortString(routingKey));
            HashSet<AMQQueue> queues = new HashSet<AMQQueue>();
            for (TopicMatcherResult result : results) {
                TopicExchangeResult res = (TopicExchangeResult)result;
                for (Binding b : res.getBindings()) {
                    b.incrementMatches();
                }
                queues.addAll(((TopicExchangeResult)result).getUnfilteredQueues());
            }
            for (AMQQueue queue : queues) {
                try {
                    queue.enqueue(message);
                }
                catch (AMQException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    void publishAllSchema() {
    }

    @Override
    public synchronized void removeBinding(Binding binding) {
        if (this._bindingSet.remove(binding)) {
            AMQShortString bindingKey = TopicNormalizer.normalize(new AMQShortString(binding.getBindingKey()));
            TopicExchangeResult result = this._topicExchangeResults.get(bindingKey);
            result.removeBinding(binding);
            result.removeUnfilteredQueue(binding.getQueue());
        }
        for (Exchange.BindingListener listener : this._listeners) {
            listener.bindingRemoved(this, binding);
        }
    }

    @Override
    public synchronized Collection<Binding> getBindings() {
        return new ArrayList<Binding>(this._bindingSet);
    }

    public ArrayList<BaseQueue> route(InboundMessage message) {
        ArrayList<BaseQueue> queues = new ArrayList<BaseQueue>(1);
        this._msgReceived.incrementAndGet();
        this._bytesReceived.addAndGet(message.getSize());
        queues.add(this._mgmtQueue);
        return queues;
    }

    @Override
    public boolean isBound(String bindingKey, Map<String, Object> arguments, AMQQueue queue) {
        return false;
    }

    @Override
    public boolean isBound(AMQShortString routingKey, FieldTable arguments, AMQQueue queue) {
        return false;
    }

    @Override
    public boolean isBound(AMQShortString routingKey, AMQQueue queue) {
        return false;
    }

    @Override
    public boolean isBound(AMQShortString routingKey) {
        return false;
    }

    @Override
    public boolean isBound(AMQQueue queue) {
        return false;
    }

    @Override
    public boolean hasBindings() {
        return !this._bindingSet.isEmpty();
    }

    @Override
    public boolean isBound(String bindingKey, AMQQueue queue) {
        return false;
    }

    @Override
    public boolean isBound(String bindingKey) {
        return false;
    }

    @Override
    public void addCloseTask(Exchange.Task task) {
    }

    @Override
    public void removeCloseTask(Exchange.Task task) {
    }

    @Override
    public Exchange getAlternateExchange() {
        return null;
    }

    @Override
    public Map<String, Object> getArguments() {
        return null;
    }

    @Override
    public void setAlternateExchange(Exchange exchange) {
    }

    @Override
    public void removeReference(ExchangeReferrer exchange) {
    }

    @Override
    public void addReference(ExchangeReferrer exchange) {
    }

    @Override
    public boolean hasReferrers() {
        return true;
    }

    @Override
    public void objectCreated(QMFObject obj) {
        this.publishObjectsToConsole(System.currentTimeMillis(), Collections.singleton(obj));
    }

    @Override
    public void objectDeleted(QMFObject obj) {
        this.publishObjectsToConsole(System.currentTimeMillis(), Collections.singleton(obj));
    }

    @Override
    public long getBindingCount() {
        return this.getBindings().size();
    }

    @Override
    public long getBindingCountHigh() {
        return this._bindingCountHigh;
    }

    @Override
    public long getMsgReceives() {
        return this._msgReceived.get();
    }

    @Override
    public long getMsgRoutes() {
        return this.getMsgReceives();
    }

    @Override
    public long getMsgDrops() {
        return 0L;
    }

    @Override
    public long getByteReceives() {
        return this._bytesReceived.get();
    }

    @Override
    public long getByteRoutes() {
        return this.getByteReceives();
    }

    @Override
    public long getByteDrops() {
        return 0L;
    }

    @Override
    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public void addBindingListener(Exchange.BindingListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeBindingListener(Exchange.BindingListener listener) {
        this._listeners.remove(listener);
    }

    private class UpdateTask
    extends HouseKeepingTask {
        public UpdateTask(VirtualHost vhost) {
            super(vhost);
        }

        public void execute() {
            ManagementExchange.this.publishAllConsole();
            ManagementExchange.this.publishAllSchema();
        }
    }

    private class ManagementQueue
    implements BaseQueue {
        private final UUID QUEUE_ID = UUIDGenerator.generateRandomUUID();
        private final String NAME_AS_STRING = "##__mgmt_pseudo_queue__##" + this.QUEUE_ID.toString();
        private final AMQShortString NAME_AS_SHORT_STRING = new AMQShortString(this.NAME_AS_STRING);

        private ManagementQueue() {
        }

        public void enqueue(ServerMessage message) throws AMQException {
            QMFCommand cmd;
            long size = message.getSize();
            ByteBuffer buf = ByteBuffer.allocate((int)size);
            int offset = 0;
            while ((long)offset < size) {
                offset += message.getContent(buf, offset);
            }
            buf.flip();
            QMFCommandDecoder commandDecoder = new QMFCommandDecoder(ManagementExchange.this.getQMFService(), buf);
            while ((cmd = commandDecoder.decode()) != null) {
                cmd.process(ManagementExchange.this._virtualHost, message);
            }
        }

        public void enqueue(ServerMessage message, boolean sync, BaseQueue.PostEnqueueAction action) throws AMQException {
            this.enqueue(message);
        }

        public void enqueue(ServerMessage message, BaseQueue.PostEnqueueAction action) throws AMQException {
            this.enqueue(message);
        }

        public boolean isDurable() {
            return false;
        }

        public AMQShortString getNameShortString() {
            return this.NAME_AS_SHORT_STRING;
        }

        public UUID getId() {
            return this.QUEUE_ID;
        }
    }
}

