/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.qmf.schema;

import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.qmf.CompletionCode;
import org.apache.qpid.qmf.QMFClass;
import org.apache.qpid.qmf.QMFCommand;
import org.apache.qpid.qmf.QMFCommandHeader;
import org.apache.qpid.qmf.QMFEventClass;
import org.apache.qpid.qmf.QMFEventCommand;
import org.apache.qpid.qmf.QMFEventSeverity;
import org.apache.qpid.qmf.QMFGetQueryCommand;
import org.apache.qpid.qmf.QMFMethod;
import org.apache.qpid.qmf.QMFMethodInvocation;
import org.apache.qpid.qmf.QMFMethodRequestCommand;
import org.apache.qpid.qmf.QMFMethodResponseCommand;
import org.apache.qpid.qmf.QMFObject;
import org.apache.qpid.qmf.QMFObjectClass;
import org.apache.qpid.qmf.QMFOperation;
import org.apache.qpid.qmf.QMFPackage;
import org.apache.qpid.qmf.QMFProperty;
import org.apache.qpid.qmf.QMFStatistic;
import org.apache.qpid.qmf.QMFType;
import org.apache.qpid.transport.codec.BBDecoder;
import org.apache.qpid.transport.codec.BBEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerSchema
extends QMFPackage {
    private static final byte QMF_VERSION = 50;
    private static final BrokerSchema PACKAGE = new BrokerSchema();
    private static final String SCHEMA_NAME = "org.apache.qpid.broker";
    private final SystemClass _systemClass = new SystemClass();
    private final MemoryClass _memoryClass = new MemoryClass();
    private final BrokerClass _brokerClass = new BrokerClass();
    private final AgentClass _agentClass = new AgentClass();
    private final VhostClass _vhostClass = new VhostClass();
    private final QueueClass _queueClass = new QueueClass();
    private final ExchangeClass _exchangeClass = new ExchangeClass();
    private final BindingClass _bindingClass = new BindingClass();
    private final SubscriptionClass _subscriptionClass = new SubscriptionClass();
    private final ConnectionClass _connectionClass = new ConnectionClass();
    private final LinkClass _linkClass = new LinkClass();
    private final BridgeClass _bridgeClass = new BridgeClass();
    private final SessionClass _sessionClass = new SessionClass();
    private final ManagementSetupStateClass _managementSetupStateClass = new ManagementSetupStateClass();
    private final ClientConnectEventClass _clientConnectEventClass = new ClientConnectEventClass();
    private final ClientConnectFailEventClass _clientConnectFailEventClass = new ClientConnectFailEventClass();
    private final ClientDisconnectEventClass _clientDisconnectEventClass = new ClientDisconnectEventClass();
    private final BrokerLinkUpEventClass _brokerLinkUpEventClass = new BrokerLinkUpEventClass();
    private final BrokerLinkDownEventClass _brokerLinkDownEventClass = new BrokerLinkDownEventClass();
    private final QueueDeclareEventClass _queueDeclareEventClass = new QueueDeclareEventClass();
    private final QueueDeleteEventClass _queueDeleteEventClass = new QueueDeleteEventClass();
    private final ExchangeDeclareEventClass _exchangeDeclareEventClass = new ExchangeDeclareEventClass();
    private final ExchangeDeleteEventClass _exchangeDeleteEventClass = new ExchangeDeleteEventClass();
    private final BindEventClass _bindEventClass = new BindEventClass();
    private final UnbindEventClass _unbindEventClass = new UnbindEventClass();
    private final SubscribeEventClass _subscribeEventClass = new SubscribeEventClass();
    private final UnsubscribeEventClass _unsubscribeEventClass = new UnsubscribeEventClass();
    private final QueueThresholdExceededEventClass _queueThresholdExceededEventClass = new QueueThresholdExceededEventClass();

    private BrokerSchema() {
        super(SCHEMA_NAME);
        this.setClasses(Arrays.asList(this._systemClass, this._memoryClass, this._brokerClass, this._agentClass, this._vhostClass, this._queueClass, this._exchangeClass, this._bindingClass, this._subscriptionClass, this._connectionClass, this._linkClass, this._bridgeClass, this._sessionClass, this._managementSetupStateClass, this._clientConnectEventClass, this._clientConnectFailEventClass, this._clientDisconnectEventClass, this._brokerLinkUpEventClass, this._brokerLinkDownEventClass, this._queueDeclareEventClass, this._queueDeleteEventClass, this._exchangeDeclareEventClass, this._exchangeDeleteEventClass, this._bindEventClass, this._unbindEventClass, this._subscribeEventClass, this._unsubscribeEventClass, this._queueThresholdExceededEventClass));
    }

    public <T extends QMFClass> T getQMFClassInstance(Class<T> clazz) {
        for (QMFClass c : this.getClasses()) {
            if (!clazz.isInstance(c)) continue;
            return (T)c;
        }
        return null;
    }

    public static BrokerSchema getPackage() {
        return PACKAGE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class QueueThresholdExceededEvent
    extends QMFEventCommand<QueueThresholdExceededEventClass> {
        private final String _qName;
        private final Long _msgDepth;
        private final Long _byteDepth;

        private QueueThresholdExceededEvent(String qName, Long msgDepth, Long byteDepth) {
            this._qName = qName;
            this._msgDepth = msgDepth;
            this._byteDepth = byteDepth;
        }

        @Override
        public QueueThresholdExceededEventClass getEventClass() {
            return BrokerSchema.this._queueThresholdExceededEventClass;
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeStr8(this._qName);
            encoder.writeUint64(this._msgDepth.longValue());
            encoder.writeUint64(this._byteDepth.longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class QueueThresholdExceededEventClass
    extends QMFEventClass {
        private final QNameArg _qNameArg;
        private final MsgDepthArg _msgDepthArg;
        private final ByteDepthArg _byteDepthArg;

        private QueueThresholdExceededEventClass() {
            super("queueThresholdExceeded", new byte[16]);
            this._qNameArg = new QNameArg();
            this._msgDepthArg = new MsgDepthArg();
            this._byteDepthArg = new ByteDepthArg();
            this.setProperties(Arrays.asList(this._qNameArg, this._msgDepthArg, this._byteDepthArg));
        }

        @Override
        public QMFEventSeverity getSeverity() {
            return QMFEventSeverity.WARN;
        }

        public QMFEventCommand<QueueThresholdExceededEventClass> newEvent(String qName, Long msgDepth, Long byteDepth) {
            return new QueueThresholdExceededEvent(qName, msgDepth, byteDepth);
        }

        public class ByteDepthArg
        extends QMFProperty {
            private ByteDepthArg() {
                super("byteDepth", QMFType.UINT64, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Current size of queue in bytes");
            }
        }

        public class MsgDepthArg
        extends QMFProperty {
            private MsgDepthArg() {
                super("msgDepth", QMFType.UINT64, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Current size of queue in messages");
            }
        }

        public class QNameArg
        extends QMFProperty {
            private QNameArg() {
                super("qName", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Name of a queue");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UnsubscribeEvent
    extends QMFEventCommand<UnsubscribeEventClass> {
        private final String _rhost;
        private final String _user;
        private final String _dest;

        private UnsubscribeEvent(String rhost, String user, String dest) {
            this._rhost = rhost;
            this._user = user;
            this._dest = dest;
        }

        @Override
        public UnsubscribeEventClass getEventClass() {
            return BrokerSchema.this._unsubscribeEventClass;
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeStr8(this._rhost);
            encoder.writeStr8(this._user);
            encoder.writeStr8(this._dest);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UnsubscribeEventClass
    extends QMFEventClass {
        private final RhostArg _rhostArg;
        private final UserArg _userArg;
        private final DestArg _destArg;

        private UnsubscribeEventClass() {
            super("unsubscribe", new byte[16]);
            this._rhostArg = new RhostArg();
            this._userArg = new UserArg();
            this._destArg = new DestArg();
            this.setProperties(Arrays.asList(this._rhostArg, this._userArg, this._destArg));
        }

        @Override
        public QMFEventSeverity getSeverity() {
            return QMFEventSeverity.INFORM;
        }

        public QMFEventCommand<UnsubscribeEventClass> newEvent(String rhost, String user, String dest) {
            return new UnsubscribeEvent(rhost, user, dest);
        }

        public class DestArg
        extends QMFProperty {
            private DestArg() {
                super("dest", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Destination tag for a subscription");
            }
        }

        public class UserArg
        extends QMFProperty {
            private UserArg() {
                super("user", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Authentication identity");
            }
        }

        public class RhostArg
        extends QMFProperty {
            private RhostArg() {
                super("rhost", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Address (i.e. DNS name, IP address, etc.) of a remotely connected host");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SubscribeEvent
    extends QMFEventCommand<SubscribeEventClass> {
        private final String _rhost;
        private final String _user;
        private final String _qName;
        private final String _dest;
        private final Boolean _excl;
        private final Map _args;

        private SubscribeEvent(String rhost, String user, String qName, String dest, Boolean excl, Map args) {
            this._rhost = rhost;
            this._user = user;
            this._qName = qName;
            this._dest = dest;
            this._excl = excl;
            this._args = args;
        }

        @Override
        public SubscribeEventClass getEventClass() {
            return BrokerSchema.this._subscribeEventClass;
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeStr8(this._rhost);
            encoder.writeStr8(this._user);
            encoder.writeStr8(this._qName);
            encoder.writeStr8(this._dest);
            encoder.writeInt8(this._excl != false ? (byte)-1 : 0);
            encoder.writeMap(this._args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SubscribeEventClass
    extends QMFEventClass {
        private final RhostArg _rhostArg;
        private final UserArg _userArg;
        private final QNameArg _qNameArg;
        private final DestArg _destArg;
        private final ExclArg _exclArg;
        private final ArgsArg _argsArg;

        private SubscribeEventClass() {
            super("subscribe", new byte[16]);
            this._rhostArg = new RhostArg();
            this._userArg = new UserArg();
            this._qNameArg = new QNameArg();
            this._destArg = new DestArg();
            this._exclArg = new ExclArg();
            this._argsArg = new ArgsArg();
            this.setProperties(Arrays.asList(this._rhostArg, this._userArg, this._qNameArg, this._destArg, this._exclArg, this._argsArg));
        }

        @Override
        public QMFEventSeverity getSeverity() {
            return QMFEventSeverity.INFORM;
        }

        public QMFEventCommand<SubscribeEventClass> newEvent(String rhost, String user, String qName, String dest, Boolean excl, Map args) {
            return new SubscribeEvent(rhost, user, qName, dest, excl, args);
        }

        public class ArgsArg
        extends QMFProperty {
            private ArgsArg() {
                super("args", QMFType.MAP, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Supplemental arguments or parameters supplied");
            }
        }

        public class ExclArg
        extends QMFProperty {
            private ExclArg() {
                super("excl", QMFType.BOOLEAN, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Created object is exclusive for the use of the owner only");
            }
        }

        public class DestArg
        extends QMFProperty {
            private DestArg() {
                super("dest", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Destination tag for a subscription");
            }
        }

        public class QNameArg
        extends QMFProperty {
            private QNameArg() {
                super("qName", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Name of a queue");
            }
        }

        public class UserArg
        extends QMFProperty {
            private UserArg() {
                super("user", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Authentication identity");
            }
        }

        public class RhostArg
        extends QMFProperty {
            private RhostArg() {
                super("rhost", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Address (i.e. DNS name, IP address, etc.) of a remotely connected host");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UnbindEvent
    extends QMFEventCommand<UnbindEventClass> {
        private final String _rhost;
        private final String _user;
        private final String _exName;
        private final String _qName;
        private final String _key;

        private UnbindEvent(String rhost, String user, String exName, String qName, String key) {
            this._rhost = rhost;
            this._user = user;
            this._exName = exName;
            this._qName = qName;
            this._key = key;
        }

        @Override
        public UnbindEventClass getEventClass() {
            return BrokerSchema.this._unbindEventClass;
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeStr8(this._rhost);
            encoder.writeStr8(this._user);
            encoder.writeStr8(this._exName);
            encoder.writeStr8(this._qName);
            encoder.writeStr16(this._key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UnbindEventClass
    extends QMFEventClass {
        private final RhostArg _rhostArg;
        private final UserArg _userArg;
        private final ExNameArg _exNameArg;
        private final QNameArg _qNameArg;
        private final KeyArg _keyArg;

        private UnbindEventClass() {
            super("unbind", new byte[16]);
            this._rhostArg = new RhostArg();
            this._userArg = new UserArg();
            this._exNameArg = new ExNameArg();
            this._qNameArg = new QNameArg();
            this._keyArg = new KeyArg();
            this.setProperties(Arrays.asList(this._rhostArg, this._userArg, this._exNameArg, this._qNameArg, this._keyArg));
        }

        @Override
        public QMFEventSeverity getSeverity() {
            return QMFEventSeverity.INFORM;
        }

        public QMFEventCommand<UnbindEventClass> newEvent(String rhost, String user, String exName, String qName, String key) {
            return new UnbindEvent(rhost, user, exName, qName, key);
        }

        public class KeyArg
        extends QMFProperty {
            private KeyArg() {
                super("key", QMFType.STR16, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Key text used for routing or binding");
            }
        }

        public class QNameArg
        extends QMFProperty {
            private QNameArg() {
                super("qName", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Name of a queue");
            }
        }

        public class ExNameArg
        extends QMFProperty {
            private ExNameArg() {
                super("exName", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Name of an exchange");
            }
        }

        public class UserArg
        extends QMFProperty {
            private UserArg() {
                super("user", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Authentication identity");
            }
        }

        public class RhostArg
        extends QMFProperty {
            private RhostArg() {
                super("rhost", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Address (i.e. DNS name, IP address, etc.) of a remotely connected host");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BindEvent
    extends QMFEventCommand<BindEventClass> {
        private final String _rhost;
        private final String _user;
        private final String _exName;
        private final String _qName;
        private final String _key;
        private final Map _args;

        private BindEvent(String rhost, String user, String exName, String qName, String key, Map args) {
            this._rhost = rhost;
            this._user = user;
            this._exName = exName;
            this._qName = qName;
            this._key = key;
            this._args = args;
        }

        @Override
        public BindEventClass getEventClass() {
            return BrokerSchema.this._bindEventClass;
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeStr8(this._rhost);
            encoder.writeStr8(this._user);
            encoder.writeStr8(this._exName);
            encoder.writeStr8(this._qName);
            encoder.writeStr16(this._key);
            encoder.writeMap(this._args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BindEventClass
    extends QMFEventClass {
        private final RhostArg _rhostArg;
        private final UserArg _userArg;
        private final ExNameArg _exNameArg;
        private final QNameArg _qNameArg;
        private final KeyArg _keyArg;
        private final ArgsArg _argsArg;

        private BindEventClass() {
            super("bind", new byte[16]);
            this._rhostArg = new RhostArg();
            this._userArg = new UserArg();
            this._exNameArg = new ExNameArg();
            this._qNameArg = new QNameArg();
            this._keyArg = new KeyArg();
            this._argsArg = new ArgsArg();
            this.setProperties(Arrays.asList(this._rhostArg, this._userArg, this._exNameArg, this._qNameArg, this._keyArg, this._argsArg));
        }

        @Override
        public QMFEventSeverity getSeverity() {
            return QMFEventSeverity.INFORM;
        }

        public QMFEventCommand<BindEventClass> newEvent(String rhost, String user, String exName, String qName, String key, Map args) {
            return new BindEvent(rhost, user, exName, qName, key, args);
        }

        public class ArgsArg
        extends QMFProperty {
            private ArgsArg() {
                super("args", QMFType.MAP, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Supplemental arguments or parameters supplied");
            }
        }

        public class KeyArg
        extends QMFProperty {
            private KeyArg() {
                super("key", QMFType.STR16, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Key text used for routing or binding");
            }
        }

        public class QNameArg
        extends QMFProperty {
            private QNameArg() {
                super("qName", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Name of a queue");
            }
        }

        public class ExNameArg
        extends QMFProperty {
            private ExNameArg() {
                super("exName", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Name of an exchange");
            }
        }

        public class UserArg
        extends QMFProperty {
            private UserArg() {
                super("user", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Authentication identity");
            }
        }

        public class RhostArg
        extends QMFProperty {
            private RhostArg() {
                super("rhost", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Address (i.e. DNS name, IP address, etc.) of a remotely connected host");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ExchangeDeleteEvent
    extends QMFEventCommand<ExchangeDeleteEventClass> {
        private final String _rhost;
        private final String _user;
        private final String _exName;

        private ExchangeDeleteEvent(String rhost, String user, String exName) {
            this._rhost = rhost;
            this._user = user;
            this._exName = exName;
        }

        @Override
        public ExchangeDeleteEventClass getEventClass() {
            return BrokerSchema.this._exchangeDeleteEventClass;
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeStr8(this._rhost);
            encoder.writeStr8(this._user);
            encoder.writeStr8(this._exName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExchangeDeleteEventClass
    extends QMFEventClass {
        private final RhostArg _rhostArg;
        private final UserArg _userArg;
        private final ExNameArg _exNameArg;

        private ExchangeDeleteEventClass() {
            super("exchangeDelete", new byte[16]);
            this._rhostArg = new RhostArg();
            this._userArg = new UserArg();
            this._exNameArg = new ExNameArg();
            this.setProperties(Arrays.asList(this._rhostArg, this._userArg, this._exNameArg));
        }

        @Override
        public QMFEventSeverity getSeverity() {
            return QMFEventSeverity.INFORM;
        }

        public QMFEventCommand<ExchangeDeleteEventClass> newEvent(String rhost, String user, String exName) {
            return new ExchangeDeleteEvent(rhost, user, exName);
        }

        public class ExNameArg
        extends QMFProperty {
            private ExNameArg() {
                super("exName", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Name of an exchange");
            }
        }

        public class UserArg
        extends QMFProperty {
            private UserArg() {
                super("user", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Authentication identity");
            }
        }

        public class RhostArg
        extends QMFProperty {
            private RhostArg() {
                super("rhost", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Address (i.e. DNS name, IP address, etc.) of a remotely connected host");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ExchangeDeclareEvent
    extends QMFEventCommand<ExchangeDeclareEventClass> {
        private final String _rhost;
        private final String _user;
        private final String _exName;
        private final String _exType;
        private final String _altEx;
        private final Boolean _durable;
        private final Boolean _autoDel;
        private final Map _args;
        private final String _disp;

        private ExchangeDeclareEvent(String rhost, String user, String exName, String exType, String altEx, Boolean durable, Boolean autoDel, Map args, String disp) {
            this._rhost = rhost;
            this._user = user;
            this._exName = exName;
            this._exType = exType;
            this._altEx = altEx;
            this._durable = durable;
            this._autoDel = autoDel;
            this._args = args;
            this._disp = disp;
        }

        @Override
        public ExchangeDeclareEventClass getEventClass() {
            return BrokerSchema.this._exchangeDeclareEventClass;
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeStr8(this._rhost);
            encoder.writeStr8(this._user);
            encoder.writeStr8(this._exName);
            encoder.writeStr8(this._exType);
            encoder.writeStr8(this._altEx);
            encoder.writeInt8(this._durable != false ? (byte)-1 : 0);
            encoder.writeInt8(this._autoDel != false ? (byte)-1 : 0);
            encoder.writeMap(this._args);
            encoder.writeStr8(this._disp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExchangeDeclareEventClass
    extends QMFEventClass {
        private final RhostArg _rhostArg;
        private final UserArg _userArg;
        private final ExNameArg _exNameArg;
        private final ExTypeArg _exTypeArg;
        private final AltExArg _altExArg;
        private final DurableArg _durableArg;
        private final AutoDelArg _autoDelArg;
        private final ArgsArg _argsArg;
        private final DispArg _dispArg;

        private ExchangeDeclareEventClass() {
            super("exchangeDeclare", new byte[16]);
            this._rhostArg = new RhostArg();
            this._userArg = new UserArg();
            this._exNameArg = new ExNameArg();
            this._exTypeArg = new ExTypeArg();
            this._altExArg = new AltExArg();
            this._durableArg = new DurableArg();
            this._autoDelArg = new AutoDelArg();
            this._argsArg = new ArgsArg();
            this._dispArg = new DispArg();
            this.setProperties(Arrays.asList(this._rhostArg, this._userArg, this._exNameArg, this._exTypeArg, this._altExArg, this._durableArg, this._autoDelArg, this._argsArg, this._dispArg));
        }

        @Override
        public QMFEventSeverity getSeverity() {
            return QMFEventSeverity.INFORM;
        }

        public QMFEventCommand<ExchangeDeclareEventClass> newEvent(String rhost, String user, String exName, String exType, String altEx, Boolean durable, Boolean autoDel, Map args, String disp) {
            return new ExchangeDeclareEvent(rhost, user, exName, exType, altEx, durable, autoDel, args, disp);
        }

        public class DispArg
        extends QMFProperty {
            private DispArg() {
                super("disp", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Disposition of a declaration: 'created' if object was created, 'existing' if object already existed");
            }
        }

        public class ArgsArg
        extends QMFProperty {
            private ArgsArg() {
                super("args", QMFType.MAP, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Supplemental arguments or parameters supplied");
            }
        }

        public class AutoDelArg
        extends QMFProperty {
            private AutoDelArg() {
                super("autoDel", QMFType.BOOLEAN, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Created object is automatically deleted when no longer in use");
            }
        }

        public class DurableArg
        extends QMFProperty {
            private DurableArg() {
                super("durable", QMFType.BOOLEAN, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Created object is durable");
            }
        }

        public class AltExArg
        extends QMFProperty {
            private AltExArg() {
                super("altEx", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Name of the alternate exchange");
            }
        }

        public class ExTypeArg
        extends QMFProperty {
            private ExTypeArg() {
                super("exType", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Type of an exchange");
            }
        }

        public class ExNameArg
        extends QMFProperty {
            private ExNameArg() {
                super("exName", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Name of an exchange");
            }
        }

        public class UserArg
        extends QMFProperty {
            private UserArg() {
                super("user", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Authentication identity");
            }
        }

        public class RhostArg
        extends QMFProperty {
            private RhostArg() {
                super("rhost", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Address (i.e. DNS name, IP address, etc.) of a remotely connected host");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class QueueDeleteEvent
    extends QMFEventCommand<QueueDeleteEventClass> {
        private final String _rhost;
        private final String _user;
        private final String _qName;

        private QueueDeleteEvent(String rhost, String user, String qName) {
            this._rhost = rhost;
            this._user = user;
            this._qName = qName;
        }

        @Override
        public QueueDeleteEventClass getEventClass() {
            return BrokerSchema.this._queueDeleteEventClass;
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeStr8(this._rhost);
            encoder.writeStr8(this._user);
            encoder.writeStr8(this._qName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class QueueDeleteEventClass
    extends QMFEventClass {
        private final RhostArg _rhostArg;
        private final UserArg _userArg;
        private final QNameArg _qNameArg;

        private QueueDeleteEventClass() {
            super("queueDelete", new byte[16]);
            this._rhostArg = new RhostArg();
            this._userArg = new UserArg();
            this._qNameArg = new QNameArg();
            this.setProperties(Arrays.asList(this._rhostArg, this._userArg, this._qNameArg));
        }

        @Override
        public QMFEventSeverity getSeverity() {
            return QMFEventSeverity.INFORM;
        }

        public QMFEventCommand<QueueDeleteEventClass> newEvent(String rhost, String user, String qName) {
            return new QueueDeleteEvent(rhost, user, qName);
        }

        public class QNameArg
        extends QMFProperty {
            private QNameArg() {
                super("qName", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Name of a queue");
            }
        }

        public class UserArg
        extends QMFProperty {
            private UserArg() {
                super("user", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Authentication identity");
            }
        }

        public class RhostArg
        extends QMFProperty {
            private RhostArg() {
                super("rhost", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Address (i.e. DNS name, IP address, etc.) of a remotely connected host");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class QueueDeclareEvent
    extends QMFEventCommand<QueueDeclareEventClass> {
        private final String _rhost;
        private final String _user;
        private final String _qName;
        private final Boolean _durable;
        private final Boolean _excl;
        private final Boolean _autoDel;
        private final String _altEx;
        private final Map _args;
        private final String _disp;

        private QueueDeclareEvent(String rhost, String user, String qName, Boolean durable, Boolean excl, Boolean autoDel, String altEx, Map args, String disp) {
            this._rhost = rhost;
            this._user = user;
            this._qName = qName;
            this._durable = durable;
            this._excl = excl;
            this._autoDel = autoDel;
            this._altEx = altEx;
            this._args = args;
            this._disp = disp;
        }

        @Override
        public QueueDeclareEventClass getEventClass() {
            return BrokerSchema.this._queueDeclareEventClass;
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeStr8(this._rhost);
            encoder.writeStr8(this._user);
            encoder.writeStr8(this._qName);
            encoder.writeInt8(this._durable != false ? (byte)-1 : 0);
            encoder.writeInt8(this._excl != false ? (byte)-1 : 0);
            encoder.writeInt8(this._autoDel != false ? (byte)-1 : 0);
            encoder.writeStr8(this._altEx);
            encoder.writeMap(this._args);
            encoder.writeStr8(this._disp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class QueueDeclareEventClass
    extends QMFEventClass {
        private final RhostArg _rhostArg;
        private final UserArg _userArg;
        private final QNameArg _qNameArg;
        private final DurableArg _durableArg;
        private final ExclArg _exclArg;
        private final AutoDelArg _autoDelArg;
        private final AltExArg _altExArg;
        private final ArgsArg _argsArg;
        private final DispArg _dispArg;

        private QueueDeclareEventClass() {
            super("queueDeclare", new byte[16]);
            this._rhostArg = new RhostArg();
            this._userArg = new UserArg();
            this._qNameArg = new QNameArg();
            this._durableArg = new DurableArg();
            this._exclArg = new ExclArg();
            this._autoDelArg = new AutoDelArg();
            this._altExArg = new AltExArg();
            this._argsArg = new ArgsArg();
            this._dispArg = new DispArg();
            this.setProperties(Arrays.asList(this._rhostArg, this._userArg, this._qNameArg, this._durableArg, this._exclArg, this._autoDelArg, this._altExArg, this._argsArg, this._dispArg));
        }

        @Override
        public QMFEventSeverity getSeverity() {
            return QMFEventSeverity.INFORM;
        }

        public QMFEventCommand<QueueDeclareEventClass> newEvent(String rhost, String user, String qName, Boolean durable, Boolean excl, Boolean autoDel, String altEx, Map args, String disp) {
            return new QueueDeclareEvent(rhost, user, qName, durable, excl, autoDel, altEx, args, disp);
        }

        public class DispArg
        extends QMFProperty {
            private DispArg() {
                super("disp", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Disposition of a declaration: 'created' if object was created, 'existing' if object already existed");
            }
        }

        public class ArgsArg
        extends QMFProperty {
            private ArgsArg() {
                super("args", QMFType.MAP, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Supplemental arguments or parameters supplied");
            }
        }

        public class AltExArg
        extends QMFProperty {
            private AltExArg() {
                super("altEx", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Name of the alternate exchange");
            }
        }

        public class AutoDelArg
        extends QMFProperty {
            private AutoDelArg() {
                super("autoDel", QMFType.BOOLEAN, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Created object is automatically deleted when no longer in use");
            }
        }

        public class ExclArg
        extends QMFProperty {
            private ExclArg() {
                super("excl", QMFType.BOOLEAN, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Created object is exclusive for the use of the owner only");
            }
        }

        public class DurableArg
        extends QMFProperty {
            private DurableArg() {
                super("durable", QMFType.BOOLEAN, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Created object is durable");
            }
        }

        public class QNameArg
        extends QMFProperty {
            private QNameArg() {
                super("qName", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Name of a queue");
            }
        }

        public class UserArg
        extends QMFProperty {
            private UserArg() {
                super("user", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Authentication identity");
            }
        }

        public class RhostArg
        extends QMFProperty {
            private RhostArg() {
                super("rhost", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Address (i.e. DNS name, IP address, etc.) of a remotely connected host");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BrokerLinkDownEvent
    extends QMFEventCommand<BrokerLinkDownEventClass> {
        private final String _rhost;

        private BrokerLinkDownEvent(String rhost) {
            this._rhost = rhost;
        }

        @Override
        public BrokerLinkDownEventClass getEventClass() {
            return BrokerSchema.this._brokerLinkDownEventClass;
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeStr8(this._rhost);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BrokerLinkDownEventClass
    extends QMFEventClass {
        private final RhostArg _rhostArg;

        private BrokerLinkDownEventClass() {
            super("brokerLinkDown", new byte[16]);
            this._rhostArg = new RhostArg();
            this.setProperties(Arrays.asList(this._rhostArg));
        }

        @Override
        public QMFEventSeverity getSeverity() {
            return QMFEventSeverity.WARN;
        }

        public QMFEventCommand<BrokerLinkDownEventClass> newEvent(String rhost) {
            return new BrokerLinkDownEvent(rhost);
        }

        public class RhostArg
        extends QMFProperty {
            private RhostArg() {
                super("rhost", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Address (i.e. DNS name, IP address, etc.) of a remotely connected host");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BrokerLinkUpEvent
    extends QMFEventCommand<BrokerLinkUpEventClass> {
        private final String _rhost;

        private BrokerLinkUpEvent(String rhost) {
            this._rhost = rhost;
        }

        @Override
        public BrokerLinkUpEventClass getEventClass() {
            return BrokerSchema.this._brokerLinkUpEventClass;
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeStr8(this._rhost);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BrokerLinkUpEventClass
    extends QMFEventClass {
        private final RhostArg _rhostArg;

        private BrokerLinkUpEventClass() {
            super("brokerLinkUp", new byte[16]);
            this._rhostArg = new RhostArg();
            this.setProperties(Arrays.asList(this._rhostArg));
        }

        @Override
        public QMFEventSeverity getSeverity() {
            return QMFEventSeverity.INFORM;
        }

        public QMFEventCommand<BrokerLinkUpEventClass> newEvent(String rhost) {
            return new BrokerLinkUpEvent(rhost);
        }

        public class RhostArg
        extends QMFProperty {
            private RhostArg() {
                super("rhost", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Address (i.e. DNS name, IP address, etc.) of a remotely connected host");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClientDisconnectEvent
    extends QMFEventCommand<ClientDisconnectEventClass> {
        private final String _rhost;
        private final String _user;

        private ClientDisconnectEvent(String rhost, String user) {
            this._rhost = rhost;
            this._user = user;
        }

        @Override
        public ClientDisconnectEventClass getEventClass() {
            return BrokerSchema.this._clientDisconnectEventClass;
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeStr8(this._rhost);
            encoder.writeStr8(this._user);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClientDisconnectEventClass
    extends QMFEventClass {
        private final RhostArg _rhostArg;
        private final UserArg _userArg;

        private ClientDisconnectEventClass() {
            super("clientDisconnect", new byte[16]);
            this._rhostArg = new RhostArg();
            this._userArg = new UserArg();
            this.setProperties(Arrays.asList(this._rhostArg, this._userArg));
        }

        @Override
        public QMFEventSeverity getSeverity() {
            return QMFEventSeverity.INFORM;
        }

        public QMFEventCommand<ClientDisconnectEventClass> newEvent(String rhost, String user) {
            return new ClientDisconnectEvent(rhost, user);
        }

        public class UserArg
        extends QMFProperty {
            private UserArg() {
                super("user", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Authentication identity");
            }
        }

        public class RhostArg
        extends QMFProperty {
            private RhostArg() {
                super("rhost", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Address (i.e. DNS name, IP address, etc.) of a remotely connected host");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClientConnectFailEvent
    extends QMFEventCommand<ClientConnectFailEventClass> {
        private final String _rhost;
        private final String _user;
        private final String _reason;

        private ClientConnectFailEvent(String rhost, String user, String reason) {
            this._rhost = rhost;
            this._user = user;
            this._reason = reason;
        }

        @Override
        public ClientConnectFailEventClass getEventClass() {
            return BrokerSchema.this._clientConnectFailEventClass;
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeStr8(this._rhost);
            encoder.writeStr8(this._user);
            encoder.writeStr16(this._reason);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClientConnectFailEventClass
    extends QMFEventClass {
        private final RhostArg _rhostArg;
        private final UserArg _userArg;
        private final ReasonArg _reasonArg;

        private ClientConnectFailEventClass() {
            super("clientConnectFail", new byte[16]);
            this._rhostArg = new RhostArg();
            this._userArg = new UserArg();
            this._reasonArg = new ReasonArg();
            this.setProperties(Arrays.asList(this._rhostArg, this._userArg, this._reasonArg));
        }

        @Override
        public QMFEventSeverity getSeverity() {
            return QMFEventSeverity.WARN;
        }

        public QMFEventCommand<ClientConnectFailEventClass> newEvent(String rhost, String user, String reason) {
            return new ClientConnectFailEvent(rhost, user, reason);
        }

        public class ReasonArg
        extends QMFProperty {
            private ReasonArg() {
                super("reason", QMFType.STR16, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Reason for a failure");
            }
        }

        public class UserArg
        extends QMFProperty {
            private UserArg() {
                super("user", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Authentication identity");
            }
        }

        public class RhostArg
        extends QMFProperty {
            private RhostArg() {
                super("rhost", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Address (i.e. DNS name, IP address, etc.) of a remotely connected host");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClientConnectEvent
    extends QMFEventCommand<ClientConnectEventClass> {
        private final String _rhost;
        private final String _user;

        private ClientConnectEvent(String rhost, String user) {
            this._rhost = rhost;
            this._user = user;
        }

        @Override
        public ClientConnectEventClass getEventClass() {
            return BrokerSchema.this._clientConnectEventClass;
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeStr8(this._rhost);
            encoder.writeStr8(this._user);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClientConnectEventClass
    extends QMFEventClass {
        private final RhostArg _rhostArg;
        private final UserArg _userArg;

        private ClientConnectEventClass() {
            super("clientConnect", new byte[16]);
            this._rhostArg = new RhostArg();
            this._userArg = new UserArg();
            this.setProperties(Arrays.asList(this._rhostArg, this._userArg));
        }

        @Override
        public QMFEventSeverity getSeverity() {
            return QMFEventSeverity.INFORM;
        }

        public QMFEventCommand<ClientConnectEventClass> newEvent(String rhost, String user) {
            return new ClientConnectEvent(rhost, user);
        }

        public class UserArg
        extends QMFProperty {
            private UserArg() {
                super("user", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Authentication identity");
            }
        }

        public class RhostArg
        extends QMFProperty {
            private RhostArg() {
                super("rhost", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Address (i.e. DNS name, IP address, etc.) of a remotely connected host");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFManagementSetupStateGetQueryResponseCommand
    extends QMFGetQueryResponseCommand<ManagementSetupStateObject> {
        protected QMFManagementSetupStateGetQueryResponseCommand(ManagementSetupStateObject object, QMFGetQueryCommand cmd, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, cmd, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeUint64(((ManagementSetupStateObject)this.getObject()).getObjectNum().longValue());
            encoder.writeUint16(((ManagementSetupStateObject)this.getObject()).getBootSequence().intValue());
        }

        public String toString() {
            return "QMFManagementSetupStateGetQueryResponseCommand{id=" + ((ManagementSetupStateObject)this.getObject()).getId() + ", objectNum=" + ((ManagementSetupStateObject)this.getObject()).getObjectNum() + ", bootSequence=" + ((ManagementSetupStateObject)this.getObject()).getBootSequence() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFManagementSetupStateInstrumentInfoCommand
    extends QMFInstrumentInfoCommand<ManagementSetupStateObject> {
        protected QMFManagementSetupStateInstrumentInfoCommand(ManagementSetupStateObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFManagementSetupStateConfigInfoCommand
    extends QMFConfigInfoCommand<ManagementSetupStateObject> {
        protected QMFManagementSetupStateConfigInfoCommand(ManagementSetupStateObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeUint64(((ManagementSetupStateObject)this.getObject()).getObjectNum().longValue());
            encoder.writeUint16(((ManagementSetupStateObject)this.getObject()).getBootSequence().intValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ManagementSetupStateObject
    extends QMFObject<ManagementSetupStateClass, ManagementSetupStateDelegate> {
        protected ManagementSetupStateObject(ManagementSetupStateDelegate delegate) {
            super(delegate);
        }

        @Override
        public ManagementSetupStateClass getQMFClass() {
            return BrokerSchema.this._managementSetupStateClass;
        }

        @Override
        public QMFCommand asConfigInfoCmd(long sampleTime) {
            return new QMFManagementSetupStateConfigInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asInstrumentInfoCmd(long sampleTime) {
            return new QMFManagementSetupStateInstrumentInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asGetQueryResponseCmd(QMFGetQueryCommand queryCommand, long sampleTime) {
            return new QMFManagementSetupStateGetQueryResponseCommand(this, queryCommand, sampleTime);
        }

        public Long getObjectNum() {
            return ((ManagementSetupStateDelegate)this.getDelegate()).getObjectNum();
        }

        public Integer getBootSequence() {
            return ((ManagementSetupStateDelegate)this.getDelegate()).getBootSequence();
        }
    }

    public static interface ManagementSetupStateDelegate
    extends QMFObject.Delegate {
        public Long getObjectNum();

        public Integer getBootSequence();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ManagementSetupStateClass
    extends QMFObjectClass<ManagementSetupStateObject, ManagementSetupStateDelegate> {
        private final ObjectNumProperty _objectNumProperty;
        private final BootSequenceProperty _bootSequenceProperty;

        private ManagementSetupStateClass() {
            super("managementSetupState", new byte[16]);
            this._objectNumProperty = new ObjectNumProperty();
            this._bootSequenceProperty = new BootSequenceProperty();
            this.setProperties(Arrays.asList(this._objectNumProperty, this._bootSequenceProperty));
            this.setStatistics(Arrays.asList(new QMFStatistic[0]));
            this.setMethods(Arrays.asList(new QMFMethod[0]));
        }

        @Override
        public ManagementSetupStateObject newInstance(ManagementSetupStateDelegate delegate) {
            return new ManagementSetupStateObject(delegate);
        }

        public class BootSequenceProperty
        extends QMFProperty {
            private BootSequenceProperty() {
                super("bootSequence", QMFType.UINT16, QMFProperty.AccessCode.RO, false, false);
            }
        }

        public class ObjectNumProperty
        extends QMFProperty {
            private ObjectNumProperty() {
                super("objectNum", QMFType.UINT64, QMFProperty.AccessCode.RO, false, false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFSessionGetQueryResponseCommand
    extends QMFGetQueryResponseCommand<SessionObject> {
        protected QMFSessionGetQueryResponseCommand(SessionObject object, QMFGetQueryCommand cmd, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, cmd, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            byte presence0 = 0;
            if (((SessionObject)this.getObject()).getExpireTime() != null) {
                presence0 = (byte)(presence0 | 1);
            }
            if (((SessionObject)this.getObject()).getMaxClientRate() != null) {
                presence0 = (byte)(presence0 | 2);
            }
            encoder.writeUint8((short)presence0);
            encoder.writeBin128(((SessionObject)this.getObject()).getVhostRef().getId());
            encoder.writeStr8(((SessionObject)this.getObject()).getName());
            encoder.writeUint16(((SessionObject)this.getObject()).getChannelId().intValue());
            encoder.writeBin128(((SessionObject)this.getObject()).getConnectionRef().getId());
            encoder.writeUint32(((SessionObject)this.getObject()).getDetachedLifespan().longValue());
            encoder.writeInt8(((SessionObject)this.getObject()).getAttached() != false ? (byte)-1 : 0);
            if (((SessionObject)this.getObject()).getExpireTime() != null) {
                encoder.writeUint64(((SessionObject)this.getObject()).getExpireTime().longValue());
            }
            if (((SessionObject)this.getObject()).getMaxClientRate() != null) {
                encoder.writeUint32(((SessionObject)this.getObject()).getMaxClientRate().longValue());
            }
            encoder.writeUint64(((SessionObject)this.getObject()).getUnackedMessages().longValue());
            encoder.writeUint64(((SessionObject)this.getObject()).getTxnStarts().longValue());
            encoder.writeUint64(((SessionObject)this.getObject()).getTxnCommits().longValue());
            encoder.writeUint64(((SessionObject)this.getObject()).getTxnRejects().longValue());
            encoder.writeUint32(((SessionObject)this.getObject()).getTxnCount().longValue());
            encoder.writeUint32(((SessionObject)this.getObject()).getClientCredit().longValue());
        }

        public String toString() {
            return "QMFSessionGetQueryResponseCommand{id=" + ((SessionObject)this.getObject()).getId() + ", vhostRef=" + ((SessionObject)this.getObject()).getVhostRef() + ", name=" + ((SessionObject)this.getObject()).getName() + ", channelId=" + ((SessionObject)this.getObject()).getChannelId() + ", connectionRef=" + ((SessionObject)this.getObject()).getConnectionRef() + ", detachedLifespan=" + ((SessionObject)this.getObject()).getDetachedLifespan() + ", attached=" + ((SessionObject)this.getObject()).getAttached() + ", expireTime=" + ((SessionObject)this.getObject()).getExpireTime() + ", maxClientRate=" + ((SessionObject)this.getObject()).getMaxClientRate() + ", unackedMessages=" + ((SessionObject)this.getObject()).getUnackedMessages() + ", TxnStarts=" + ((SessionObject)this.getObject()).getTxnStarts() + ", TxnCommits=" + ((SessionObject)this.getObject()).getTxnCommits() + ", TxnRejects=" + ((SessionObject)this.getObject()).getTxnRejects() + ", TxnCount=" + ((SessionObject)this.getObject()).getTxnCount() + ", clientCredit=" + ((SessionObject)this.getObject()).getClientCredit() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFSessionInstrumentInfoCommand
    extends QMFInstrumentInfoCommand<SessionObject> {
        protected QMFSessionInstrumentInfoCommand(SessionObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeUint64(((SessionObject)this.getObject()).getUnackedMessages().longValue());
            encoder.writeUint64(((SessionObject)this.getObject()).getTxnStarts().longValue());
            encoder.writeUint64(((SessionObject)this.getObject()).getTxnCommits().longValue());
            encoder.writeUint64(((SessionObject)this.getObject()).getTxnRejects().longValue());
            encoder.writeUint32(((SessionObject)this.getObject()).getTxnCount().longValue());
            encoder.writeUint32(((SessionObject)this.getObject()).getClientCredit().longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFSessionConfigInfoCommand
    extends QMFConfigInfoCommand<SessionObject> {
        protected QMFSessionConfigInfoCommand(SessionObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            byte presence0 = 0;
            if (((SessionObject)this.getObject()).getExpireTime() != null) {
                presence0 = (byte)(presence0 | 1);
            }
            if (((SessionObject)this.getObject()).getMaxClientRate() != null) {
                presence0 = (byte)(presence0 | 2);
            }
            encoder.writeUint8((short)presence0);
            encoder.writeBin128(((SessionObject)this.getObject()).getVhostRef().getId());
            encoder.writeStr8(((SessionObject)this.getObject()).getName());
            encoder.writeUint16(((SessionObject)this.getObject()).getChannelId().intValue());
            encoder.writeBin128(((SessionObject)this.getObject()).getConnectionRef().getId());
            encoder.writeUint32(((SessionObject)this.getObject()).getDetachedLifespan().longValue());
            encoder.writeInt8(((SessionObject)this.getObject()).getAttached() != false ? (byte)-1 : 0);
            if (((SessionObject)this.getObject()).getExpireTime() != null) {
                encoder.writeUint64(((SessionObject)this.getObject()).getExpireTime().longValue());
            }
            if (((SessionObject)this.getObject()).getMaxClientRate() != null) {
                encoder.writeUint32(((SessionObject)this.getObject()).getMaxClientRate().longValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class SessionObject
    extends QMFObject<SessionClass, SessionDelegate> {
        protected SessionObject(SessionDelegate delegate) {
            super(delegate);
        }

        @Override
        public SessionClass getQMFClass() {
            return BrokerSchema.this._sessionClass;
        }

        @Override
        public QMFCommand asConfigInfoCmd(long sampleTime) {
            return new QMFSessionConfigInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asInstrumentInfoCmd(long sampleTime) {
            return new QMFSessionInstrumentInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asGetQueryResponseCmd(QMFGetQueryCommand queryCommand, long sampleTime) {
            return new QMFSessionGetQueryResponseCommand(this, queryCommand, sampleTime);
        }

        public SessionClass.SolicitAckMethodResponseCommand solicitAck(SessionClass.SolicitAckMethodResponseCommandFactory factory) {
            return ((SessionDelegate)this.getDelegate()).solicitAck(factory);
        }

        public SessionClass.DetachMethodResponseCommand detach(SessionClass.DetachMethodResponseCommandFactory factory) {
            return ((SessionDelegate)this.getDelegate()).detach(factory);
        }

        public SessionClass.ResetLifespanMethodResponseCommand resetLifespan(SessionClass.ResetLifespanMethodResponseCommandFactory factory) {
            return ((SessionDelegate)this.getDelegate()).resetLifespan(factory);
        }

        public SessionClass.CloseMethodResponseCommand close(SessionClass.CloseMethodResponseCommandFactory factory) {
            return ((SessionDelegate)this.getDelegate()).close(factory);
        }

        public VhostObject getVhostRef() {
            return ((SessionDelegate)this.getDelegate()).getVhostRef();
        }

        public String getName() {
            return ((SessionDelegate)this.getDelegate()).getName();
        }

        public Integer getChannelId() {
            return ((SessionDelegate)this.getDelegate()).getChannelId();
        }

        public ConnectionObject getConnectionRef() {
            return ((SessionDelegate)this.getDelegate()).getConnectionRef();
        }

        public Long getDetachedLifespan() {
            return ((SessionDelegate)this.getDelegate()).getDetachedLifespan();
        }

        public Boolean getAttached() {
            return ((SessionDelegate)this.getDelegate()).getAttached();
        }

        public Long getExpireTime() {
            return ((SessionDelegate)this.getDelegate()).getExpireTime();
        }

        public Long getMaxClientRate() {
            return ((SessionDelegate)this.getDelegate()).getMaxClientRate();
        }

        public Long getUnackedMessages() {
            return ((SessionDelegate)this.getDelegate()).getUnackedMessages();
        }

        public Long getTxnStarts() {
            return ((SessionDelegate)this.getDelegate()).getTxnStarts();
        }

        public Long getTxnCommits() {
            return ((SessionDelegate)this.getDelegate()).getTxnCommits();
        }

        public Long getTxnRejects() {
            return ((SessionDelegate)this.getDelegate()).getTxnRejects();
        }

        public Long getTxnCount() {
            return ((SessionDelegate)this.getDelegate()).getTxnCount();
        }

        public Long getClientCredit() {
            return ((SessionDelegate)this.getDelegate()).getClientCredit();
        }
    }

    public static interface SessionDelegate
    extends QMFObject.Delegate {
        public VhostObject getVhostRef();

        public String getName();

        public Integer getChannelId();

        public ConnectionObject getConnectionRef();

        public Long getDetachedLifespan();

        public Boolean getAttached();

        public Long getExpireTime();

        public Long getMaxClientRate();

        public Long getUnackedMessages();

        public Long getTxnStarts();

        public Long getTxnCommits();

        public Long getTxnRejects();

        public Long getTxnCount();

        public Long getClientCredit();

        public SessionClass.SolicitAckMethodResponseCommand solicitAck(SessionClass.SolicitAckMethodResponseCommandFactory var1);

        public SessionClass.DetachMethodResponseCommand detach(SessionClass.DetachMethodResponseCommandFactory var1);

        public SessionClass.ResetLifespanMethodResponseCommand resetLifespan(SessionClass.ResetLifespanMethodResponseCommandFactory var1);

        public SessionClass.CloseMethodResponseCommand close(SessionClass.CloseMethodResponseCommandFactory var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SessionClass
    extends QMFObjectClass<SessionObject, SessionDelegate> {
        private final VhostRefProperty _vhostRefProperty;
        private final NameProperty _nameProperty;
        private final ChannelIdProperty _channelIdProperty;
        private final ConnectionRefProperty _connectionRefProperty;
        private final DetachedLifespanProperty _detachedLifespanProperty;
        private final AttachedProperty _attachedProperty;
        private final ExpireTimeProperty _expireTimeProperty;
        private final MaxClientRateProperty _maxClientRateProperty;
        private final UnackedMessagesStatistic _unackedMessagesStatistic;
        private final TxnStartsStatistic _txnStartsStatistic;
        private final TxnCommitsStatistic _txnCommitsStatistic;
        private final TxnRejectsStatistic _txnRejectsStatistic;
        private final TxnCountStatistic _txnCountStatistic;
        private final ClientCreditStatistic _clientCreditStatistic;
        private final SolicitAckMethod _solicitAckMethod;
        private final DetachMethod _detachMethod;
        private final ResetLifespanMethod _resetLifespanMethod;
        private final CloseMethod _closeMethod;

        private SessionClass() {
            super("session", new byte[16]);
            this._vhostRefProperty = new VhostRefProperty();
            this._nameProperty = new NameProperty();
            this._channelIdProperty = new ChannelIdProperty();
            this._connectionRefProperty = new ConnectionRefProperty();
            this._detachedLifespanProperty = new DetachedLifespanProperty();
            this._attachedProperty = new AttachedProperty();
            this._expireTimeProperty = new ExpireTimeProperty();
            this._maxClientRateProperty = new MaxClientRateProperty();
            this._unackedMessagesStatistic = new UnackedMessagesStatistic();
            this._txnStartsStatistic = new TxnStartsStatistic();
            this._txnCommitsStatistic = new TxnCommitsStatistic();
            this._txnRejectsStatistic = new TxnRejectsStatistic();
            this._txnCountStatistic = new TxnCountStatistic();
            this._clientCreditStatistic = new ClientCreditStatistic();
            this._solicitAckMethod = new SolicitAckMethod();
            this._detachMethod = new DetachMethod();
            this._resetLifespanMethod = new ResetLifespanMethod();
            this._closeMethod = new CloseMethod();
            this.setProperties(Arrays.asList(this._vhostRefProperty, this._nameProperty, this._channelIdProperty, this._connectionRefProperty, this._detachedLifespanProperty, this._attachedProperty, this._expireTimeProperty, this._maxClientRateProperty));
            this.setStatistics(Arrays.asList(this._unackedMessagesStatistic, this._txnStartsStatistic, this._txnCommitsStatistic, this._txnRejectsStatistic, this._txnCountStatistic, this._clientCreditStatistic));
            this.setMethods(Arrays.asList(this._solicitAckMethod, this._detachMethod, this._resetLifespanMethod, this._closeMethod));
        }

        @Override
        public SessionObject newInstance(SessionDelegate delegate) {
            return new SessionObject(delegate);
        }

        public final class CloseMethodResponseCommand
        extends QMFMethodResponseCommand {
            private CloseMethodResponseCommand(QMFMethodRequestCommand cmd) {
                super(cmd, CompletionCode.OK, "OK");
            }

            private CloseMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
            }
        }

        public final class CloseMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private CloseMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public CloseMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new CloseMethodResponseCommand(this._requestCmd, status, null);
            }

            public CloseMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new CloseMethodResponseCommand(this._requestCmd, status, msg);
            }

            public CloseMethodResponseCommand createResponseCommand() {
                return new CloseMethodResponseCommand(this._requestCmd);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CloseMethodInvocation
        implements QMFMethodInvocation<SessionObject> {
            private CloseMethodInvocation() {
            }

            @Override
            public QMFMethodResponseCommand execute(SessionObject obj, QMFMethodRequestCommand cmd) {
                return obj.close(new CloseMethodResponseCommandFactory(cmd));
            }

            public String toString() {
                return "CloseMethod[]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class CloseMethod
        extends QMFMethod<SessionObject> {
            private CloseMethod() {
                super("close", null);
            }

            public CloseMethodInvocation parse(BBDecoder decoder) {
                return new CloseMethodInvocation();
            }
        }

        public final class ResetLifespanMethodResponseCommand
        extends QMFMethodResponseCommand {
            private ResetLifespanMethodResponseCommand(QMFMethodRequestCommand cmd) {
                super(cmd, CompletionCode.OK, "OK");
            }

            private ResetLifespanMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
            }
        }

        public final class ResetLifespanMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private ResetLifespanMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public ResetLifespanMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new ResetLifespanMethodResponseCommand(this._requestCmd, status, null);
            }

            public ResetLifespanMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new ResetLifespanMethodResponseCommand(this._requestCmd, status, msg);
            }

            public ResetLifespanMethodResponseCommand createResponseCommand() {
                return new ResetLifespanMethodResponseCommand(this._requestCmd);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ResetLifespanMethodInvocation
        implements QMFMethodInvocation<SessionObject> {
            private ResetLifespanMethodInvocation() {
            }

            @Override
            public QMFMethodResponseCommand execute(SessionObject obj, QMFMethodRequestCommand cmd) {
                return obj.resetLifespan(new ResetLifespanMethodResponseCommandFactory(cmd));
            }

            public String toString() {
                return "ResetLifespanMethod[]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetLifespanMethod
        extends QMFMethod<SessionObject> {
            private ResetLifespanMethod() {
                super("resetLifespan", null);
            }

            public ResetLifespanMethodInvocation parse(BBDecoder decoder) {
                return new ResetLifespanMethodInvocation();
            }
        }

        public final class DetachMethodResponseCommand
        extends QMFMethodResponseCommand {
            private DetachMethodResponseCommand(QMFMethodRequestCommand cmd) {
                super(cmd, CompletionCode.OK, "OK");
            }

            private DetachMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
            }
        }

        public final class DetachMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private DetachMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public DetachMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new DetachMethodResponseCommand(this._requestCmd, status, null);
            }

            public DetachMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new DetachMethodResponseCommand(this._requestCmd, status, msg);
            }

            public DetachMethodResponseCommand createResponseCommand() {
                return new DetachMethodResponseCommand(this._requestCmd);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class DetachMethodInvocation
        implements QMFMethodInvocation<SessionObject> {
            private DetachMethodInvocation() {
            }

            @Override
            public QMFMethodResponseCommand execute(SessionObject obj, QMFMethodRequestCommand cmd) {
                return obj.detach(new DetachMethodResponseCommandFactory(cmd));
            }

            public String toString() {
                return "DetachMethod[]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class DetachMethod
        extends QMFMethod<SessionObject> {
            private DetachMethod() {
                super("detach", null);
            }

            public DetachMethodInvocation parse(BBDecoder decoder) {
                return new DetachMethodInvocation();
            }
        }

        public final class SolicitAckMethodResponseCommand
        extends QMFMethodResponseCommand {
            private SolicitAckMethodResponseCommand(QMFMethodRequestCommand cmd) {
                super(cmd, CompletionCode.OK, "OK");
            }

            private SolicitAckMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
            }
        }

        public final class SolicitAckMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private SolicitAckMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public SolicitAckMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new SolicitAckMethodResponseCommand(this._requestCmd, status, null);
            }

            public SolicitAckMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new SolicitAckMethodResponseCommand(this._requestCmd, status, msg);
            }

            public SolicitAckMethodResponseCommand createResponseCommand() {
                return new SolicitAckMethodResponseCommand(this._requestCmd);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SolicitAckMethodInvocation
        implements QMFMethodInvocation<SessionObject> {
            private SolicitAckMethodInvocation() {
            }

            @Override
            public QMFMethodResponseCommand execute(SessionObject obj, QMFMethodRequestCommand cmd) {
                return obj.solicitAck(new SolicitAckMethodResponseCommandFactory(cmd));
            }

            public String toString() {
                return "SolicitAckMethod[]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SolicitAckMethod
        extends QMFMethod<SessionObject> {
            private SolicitAckMethod() {
                super("solicitAck", null);
            }

            public SolicitAckMethodInvocation parse(BBDecoder decoder) {
                return new SolicitAckMethodInvocation();
            }
        }

        public class ClientCreditStatistic
        extends QMFStatistic {
            private ClientCreditStatistic() {
                super("clientCredit", QMFType.UINT32, "message", "Client message credit");
            }
        }

        public class TxnCountStatistic
        extends QMFStatistic {
            private TxnCountStatistic() {
                super("TxnCount", QMFType.UINT32, "transaction", "Current pending transactions");
            }
        }

        public class TxnRejectsStatistic
        extends QMFStatistic {
            private TxnRejectsStatistic() {
                super("TxnRejects", QMFType.UINT64, "transaction", "Total transactions rejected");
            }
        }

        public class TxnCommitsStatistic
        extends QMFStatistic {
            private TxnCommitsStatistic() {
                super("TxnCommits", QMFType.UINT64, "transaction", "Total transactions committed");
            }
        }

        public class TxnStartsStatistic
        extends QMFStatistic {
            private TxnStartsStatistic() {
                super("TxnStarts", QMFType.UINT64, "transaction", "Total transactions started ");
            }
        }

        public class UnackedMessagesStatistic
        extends QMFStatistic {
            private UnackedMessagesStatistic() {
                super("unackedMessages", QMFType.UINT64, "message", "Unacknowledged messages in the session");
            }
        }

        public class MaxClientRateProperty
        extends QMFProperty {
            private MaxClientRateProperty() {
                super("maxClientRate", QMFType.UINT32, QMFProperty.AccessCode.RO, false, true);
                this.setUnit("msgs/sec");
            }
        }

        public class ExpireTimeProperty
        extends QMFProperty {
            private ExpireTimeProperty() {
                super("expireTime", QMFType.ABSTIME, QMFProperty.AccessCode.RO, false, true);
            }
        }

        public class AttachedProperty
        extends QMFProperty {
            private AttachedProperty() {
                super("attached", QMFType.BOOLEAN, QMFProperty.AccessCode.RO, false, false);
            }
        }

        public class DetachedLifespanProperty
        extends QMFProperty {
            private DetachedLifespanProperty() {
                super("detachedLifespan", QMFType.UINT32, QMFProperty.AccessCode.RO, false, false);
                this.setUnit("second");
            }
        }

        public class ConnectionRefProperty
        extends QMFProperty {
            private ConnectionRefProperty() {
                super("connectionRef", QMFType.OBJECTREFERENCE, QMFProperty.AccessCode.RO, false, false);
                this.setReferencedClass("connection");
            }
        }

        public class ChannelIdProperty
        extends QMFProperty {
            private ChannelIdProperty() {
                super("channelId", QMFType.UINT16, QMFProperty.AccessCode.RO, false, false);
            }
        }

        public class NameProperty
        extends QMFProperty {
            private NameProperty() {
                super("name", QMFType.STR8, QMFProperty.AccessCode.RC, true, false);
            }
        }

        public class VhostRefProperty
        extends QMFProperty {
            private VhostRefProperty() {
                super("vhostRef", QMFType.OBJECTREFERENCE, QMFProperty.AccessCode.RC, true, false);
                this.setReferencedClass("vhost");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFBridgeGetQueryResponseCommand
    extends QMFGetQueryResponseCommand<BridgeObject> {
        protected QMFBridgeGetQueryResponseCommand(BridgeObject object, QMFGetQueryCommand cmd, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, cmd, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeBin128(((BridgeObject)this.getObject()).getLinkRef().getId());
            encoder.writeStr8(((BridgeObject)this.getObject()).getName());
            encoder.writeUint16(((BridgeObject)this.getObject()).getChannelId().intValue());
            encoder.writeInt8(((BridgeObject)this.getObject()).getDurable() != false ? (byte)-1 : 0);
            encoder.writeStr8(((BridgeObject)this.getObject()).getSrc());
            encoder.writeStr8(((BridgeObject)this.getObject()).getDest());
            encoder.writeStr16(((BridgeObject)this.getObject()).getKey());
            encoder.writeInt8(((BridgeObject)this.getObject()).getSrcIsQueue() != false ? (byte)-1 : 0);
            encoder.writeInt8(((BridgeObject)this.getObject()).getSrcIsLocal() != false ? (byte)-1 : 0);
            encoder.writeStr8(((BridgeObject)this.getObject()).getTag());
            encoder.writeStr8(((BridgeObject)this.getObject()).getExcludes());
            encoder.writeInt8(((BridgeObject)this.getObject()).getDynamic() != false ? (byte)-1 : 0);
            encoder.writeUint16(((BridgeObject)this.getObject()).getSync().intValue());
        }

        public String toString() {
            return "QMFBridgeGetQueryResponseCommand{id=" + ((BridgeObject)this.getObject()).getId() + ", linkRef=" + ((BridgeObject)this.getObject()).getLinkRef() + ", name=" + ((BridgeObject)this.getObject()).getName() + ", channelId=" + ((BridgeObject)this.getObject()).getChannelId() + ", durable=" + ((BridgeObject)this.getObject()).getDurable() + ", src=" + ((BridgeObject)this.getObject()).getSrc() + ", dest=" + ((BridgeObject)this.getObject()).getDest() + ", key=" + ((BridgeObject)this.getObject()).getKey() + ", srcIsQueue=" + ((BridgeObject)this.getObject()).getSrcIsQueue() + ", srcIsLocal=" + ((BridgeObject)this.getObject()).getSrcIsLocal() + ", tag=" + ((BridgeObject)this.getObject()).getTag() + ", excludes=" + ((BridgeObject)this.getObject()).getExcludes() + ", dynamic=" + ((BridgeObject)this.getObject()).getDynamic() + ", sync=" + ((BridgeObject)this.getObject()).getSync() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFBridgeInstrumentInfoCommand
    extends QMFInstrumentInfoCommand<BridgeObject> {
        protected QMFBridgeInstrumentInfoCommand(BridgeObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFBridgeConfigInfoCommand
    extends QMFConfigInfoCommand<BridgeObject> {
        protected QMFBridgeConfigInfoCommand(BridgeObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeBin128(((BridgeObject)this.getObject()).getLinkRef().getId());
            encoder.writeStr8(((BridgeObject)this.getObject()).getName());
            encoder.writeUint16(((BridgeObject)this.getObject()).getChannelId().intValue());
            encoder.writeInt8(((BridgeObject)this.getObject()).getDurable() != false ? (byte)-1 : 0);
            encoder.writeStr8(((BridgeObject)this.getObject()).getSrc());
            encoder.writeStr8(((BridgeObject)this.getObject()).getDest());
            encoder.writeStr16(((BridgeObject)this.getObject()).getKey());
            encoder.writeInt8(((BridgeObject)this.getObject()).getSrcIsQueue() != false ? (byte)-1 : 0);
            encoder.writeInt8(((BridgeObject)this.getObject()).getSrcIsLocal() != false ? (byte)-1 : 0);
            encoder.writeStr8(((BridgeObject)this.getObject()).getTag());
            encoder.writeStr8(((BridgeObject)this.getObject()).getExcludes());
            encoder.writeInt8(((BridgeObject)this.getObject()).getDynamic() != false ? (byte)-1 : 0);
            encoder.writeUint16(((BridgeObject)this.getObject()).getSync().intValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class BridgeObject
    extends QMFObject<BridgeClass, BridgeDelegate> {
        protected BridgeObject(BridgeDelegate delegate) {
            super(delegate);
        }

        @Override
        public BridgeClass getQMFClass() {
            return BrokerSchema.this._bridgeClass;
        }

        @Override
        public QMFCommand asConfigInfoCmd(long sampleTime) {
            return new QMFBridgeConfigInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asInstrumentInfoCmd(long sampleTime) {
            return new QMFBridgeInstrumentInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asGetQueryResponseCmd(QMFGetQueryCommand queryCommand, long sampleTime) {
            return new QMFBridgeGetQueryResponseCommand(this, queryCommand, sampleTime);
        }

        public BridgeClass.CloseMethodResponseCommand close(BridgeClass.CloseMethodResponseCommandFactory factory) {
            return ((BridgeDelegate)this.getDelegate()).close(factory);
        }

        public LinkObject getLinkRef() {
            return ((BridgeDelegate)this.getDelegate()).getLinkRef();
        }

        public String getName() {
            return ((BridgeDelegate)this.getDelegate()).getName();
        }

        public Integer getChannelId() {
            return ((BridgeDelegate)this.getDelegate()).getChannelId();
        }

        public Boolean getDurable() {
            return ((BridgeDelegate)this.getDelegate()).getDurable();
        }

        public String getSrc() {
            return ((BridgeDelegate)this.getDelegate()).getSrc();
        }

        public String getDest() {
            return ((BridgeDelegate)this.getDelegate()).getDest();
        }

        public String getKey() {
            return ((BridgeDelegate)this.getDelegate()).getKey();
        }

        public Boolean getSrcIsQueue() {
            return ((BridgeDelegate)this.getDelegate()).getSrcIsQueue();
        }

        public Boolean getSrcIsLocal() {
            return ((BridgeDelegate)this.getDelegate()).getSrcIsLocal();
        }

        public String getTag() {
            return ((BridgeDelegate)this.getDelegate()).getTag();
        }

        public String getExcludes() {
            return ((BridgeDelegate)this.getDelegate()).getExcludes();
        }

        public Boolean getDynamic() {
            return ((BridgeDelegate)this.getDelegate()).getDynamic();
        }

        public Integer getSync() {
            return ((BridgeDelegate)this.getDelegate()).getSync();
        }
    }

    public static interface BridgeDelegate
    extends QMFObject.Delegate {
        public LinkObject getLinkRef();

        public String getName();

        public Integer getChannelId();

        public Boolean getDurable();

        public String getSrc();

        public String getDest();

        public String getKey();

        public Boolean getSrcIsQueue();

        public Boolean getSrcIsLocal();

        public String getTag();

        public String getExcludes();

        public Boolean getDynamic();

        public Integer getSync();

        public BridgeClass.CloseMethodResponseCommand close(BridgeClass.CloseMethodResponseCommandFactory var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BridgeClass
    extends QMFObjectClass<BridgeObject, BridgeDelegate> {
        private final LinkRefProperty _linkRefProperty;
        private final NameProperty _nameProperty;
        private final ChannelIdProperty _channelIdProperty;
        private final DurableProperty _durableProperty;
        private final SrcProperty _srcProperty;
        private final DestProperty _destProperty;
        private final KeyProperty _keyProperty;
        private final SrcIsQueueProperty _srcIsQueueProperty;
        private final SrcIsLocalProperty _srcIsLocalProperty;
        private final TagProperty _tagProperty;
        private final ExcludesProperty _excludesProperty;
        private final DynamicProperty _dynamicProperty;
        private final SyncProperty _syncProperty;
        private final CloseMethod _closeMethod;

        private BridgeClass() {
            super("bridge", new byte[16]);
            this._linkRefProperty = new LinkRefProperty();
            this._nameProperty = new NameProperty();
            this._channelIdProperty = new ChannelIdProperty();
            this._durableProperty = new DurableProperty();
            this._srcProperty = new SrcProperty();
            this._destProperty = new DestProperty();
            this._keyProperty = new KeyProperty();
            this._srcIsQueueProperty = new SrcIsQueueProperty();
            this._srcIsLocalProperty = new SrcIsLocalProperty();
            this._tagProperty = new TagProperty();
            this._excludesProperty = new ExcludesProperty();
            this._dynamicProperty = new DynamicProperty();
            this._syncProperty = new SyncProperty();
            this._closeMethod = new CloseMethod();
            this.setProperties(Arrays.asList(this._linkRefProperty, this._nameProperty, this._channelIdProperty, this._durableProperty, this._srcProperty, this._destProperty, this._keyProperty, this._srcIsQueueProperty, this._srcIsLocalProperty, this._tagProperty, this._excludesProperty, this._dynamicProperty, this._syncProperty));
            this.setStatistics(Arrays.asList(new QMFStatistic[0]));
            this.setMethods(Arrays.asList(this._closeMethod));
        }

        @Override
        public BridgeObject newInstance(BridgeDelegate delegate) {
            return new BridgeObject(delegate);
        }

        public final class CloseMethodResponseCommand
        extends QMFMethodResponseCommand {
            private CloseMethodResponseCommand(QMFMethodRequestCommand cmd) {
                super(cmd, CompletionCode.OK, "OK");
            }

            private CloseMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
            }
        }

        public final class CloseMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private CloseMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public CloseMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new CloseMethodResponseCommand(this._requestCmd, status, null);
            }

            public CloseMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new CloseMethodResponseCommand(this._requestCmd, status, msg);
            }

            public CloseMethodResponseCommand createResponseCommand() {
                return new CloseMethodResponseCommand(this._requestCmd);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CloseMethodInvocation
        implements QMFMethodInvocation<BridgeObject> {
            private CloseMethodInvocation() {
            }

            @Override
            public QMFMethodResponseCommand execute(BridgeObject obj, QMFMethodRequestCommand cmd) {
                return obj.close(new CloseMethodResponseCommandFactory(cmd));
            }

            public String toString() {
                return "CloseMethod[]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class CloseMethod
        extends QMFMethod<BridgeObject> {
            private CloseMethod() {
                super("close", null);
            }

            public CloseMethodInvocation parse(BBDecoder decoder) {
                return new CloseMethodInvocation();
            }
        }

        public class SyncProperty
        extends QMFProperty {
            private SyncProperty() {
                super("sync", QMFType.UINT16, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class DynamicProperty
        extends QMFProperty {
            private DynamicProperty() {
                super("dynamic", QMFType.BOOLEAN, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class ExcludesProperty
        extends QMFProperty {
            private ExcludesProperty() {
                super("excludes", QMFType.STR8, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class TagProperty
        extends QMFProperty {
            private TagProperty() {
                super("tag", QMFType.STR8, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class SrcIsLocalProperty
        extends QMFProperty {
            private SrcIsLocalProperty() {
                super("srcIsLocal", QMFType.BOOLEAN, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class SrcIsQueueProperty
        extends QMFProperty {
            private SrcIsQueueProperty() {
                super("srcIsQueue", QMFType.BOOLEAN, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class KeyProperty
        extends QMFProperty {
            private KeyProperty() {
                super("key", QMFType.STR16, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class DestProperty
        extends QMFProperty {
            private DestProperty() {
                super("dest", QMFType.STR8, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class SrcProperty
        extends QMFProperty {
            private SrcProperty() {
                super("src", QMFType.STR8, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class DurableProperty
        extends QMFProperty {
            private DurableProperty() {
                super("durable", QMFType.BOOLEAN, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class ChannelIdProperty
        extends QMFProperty {
            private ChannelIdProperty() {
                super("channelId", QMFType.UINT16, QMFProperty.AccessCode.RO, false, false);
            }
        }

        public class NameProperty
        extends QMFProperty {
            private NameProperty() {
                super("name", QMFType.STR8, QMFProperty.AccessCode.RC, true, false);
            }
        }

        public class LinkRefProperty
        extends QMFProperty {
            private LinkRefProperty() {
                super("linkRef", QMFType.OBJECTREFERENCE, QMFProperty.AccessCode.RC, true, false);
                this.setReferencedClass("link");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFLinkGetQueryResponseCommand
    extends QMFGetQueryResponseCommand<LinkObject> {
        protected QMFLinkGetQueryResponseCommand(LinkObject object, QMFGetQueryCommand cmd, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, cmd, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeBin128(((LinkObject)this.getObject()).getVhostRef().getId());
            encoder.writeStr8(((LinkObject)this.getObject()).getName());
            encoder.writeStr8(((LinkObject)this.getObject()).getHost());
            encoder.writeUint16(((LinkObject)this.getObject()).getPort().intValue());
            encoder.writeStr8(((LinkObject)this.getObject()).getTransport());
            encoder.writeInt8(((LinkObject)this.getObject()).getDurable() != false ? (byte)-1 : 0);
            encoder.writeBin128(((LinkObject)this.getObject()).getConnectionRef().getId());
            encoder.writeStr8(((LinkObject)this.getObject()).getState());
            encoder.writeStr16(((LinkObject)this.getObject()).getLastError());
        }

        public String toString() {
            return "QMFLinkGetQueryResponseCommand{id=" + ((LinkObject)this.getObject()).getId() + ", vhostRef=" + ((LinkObject)this.getObject()).getVhostRef() + ", name=" + ((LinkObject)this.getObject()).getName() + ", host=" + ((LinkObject)this.getObject()).getHost() + ", port=" + ((LinkObject)this.getObject()).getPort() + ", transport=" + ((LinkObject)this.getObject()).getTransport() + ", durable=" + ((LinkObject)this.getObject()).getDurable() + ", connectionRef=" + ((LinkObject)this.getObject()).getConnectionRef() + ", state=" + ((LinkObject)this.getObject()).getState() + ", lastError=" + ((LinkObject)this.getObject()).getLastError() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFLinkInstrumentInfoCommand
    extends QMFInstrumentInfoCommand<LinkObject> {
        protected QMFLinkInstrumentInfoCommand(LinkObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeStr8(((LinkObject)this.getObject()).getState());
            encoder.writeStr16(((LinkObject)this.getObject()).getLastError());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFLinkConfigInfoCommand
    extends QMFConfigInfoCommand<LinkObject> {
        protected QMFLinkConfigInfoCommand(LinkObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeBin128(((LinkObject)this.getObject()).getVhostRef().getId());
            encoder.writeStr8(((LinkObject)this.getObject()).getName());
            encoder.writeStr8(((LinkObject)this.getObject()).getHost());
            encoder.writeUint16(((LinkObject)this.getObject()).getPort().intValue());
            encoder.writeStr8(((LinkObject)this.getObject()).getTransport());
            encoder.writeInt8(((LinkObject)this.getObject()).getDurable() != false ? (byte)-1 : 0);
            encoder.writeBin128(((LinkObject)this.getObject()).getConnectionRef().getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class LinkObject
    extends QMFObject<LinkClass, LinkDelegate> {
        protected LinkObject(LinkDelegate delegate) {
            super(delegate);
        }

        @Override
        public LinkClass getQMFClass() {
            return BrokerSchema.this._linkClass;
        }

        @Override
        public QMFCommand asConfigInfoCmd(long sampleTime) {
            return new QMFLinkConfigInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asInstrumentInfoCmd(long sampleTime) {
            return new QMFLinkInstrumentInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asGetQueryResponseCmd(QMFGetQueryCommand queryCommand, long sampleTime) {
            return new QMFLinkGetQueryResponseCommand(this, queryCommand, sampleTime);
        }

        public LinkClass.CloseMethodResponseCommand close(LinkClass.CloseMethodResponseCommandFactory factory) {
            return ((LinkDelegate)this.getDelegate()).close(factory);
        }

        public LinkClass.BridgeMethodResponseCommand bridge(LinkClass.BridgeMethodResponseCommandFactory factory, Boolean durable, String src, String dest, String key, String tag, String excludes, Boolean srcIsQueue, Boolean srcIsLocal, Boolean dynamic, Integer sync) {
            return ((LinkDelegate)this.getDelegate()).bridge(factory, durable, src, dest, key, tag, excludes, srcIsQueue, srcIsLocal, dynamic, sync);
        }

        public VhostObject getVhostRef() {
            return ((LinkDelegate)this.getDelegate()).getVhostRef();
        }

        public String getName() {
            return ((LinkDelegate)this.getDelegate()).getName();
        }

        public String getHost() {
            return ((LinkDelegate)this.getDelegate()).getHost();
        }

        public Integer getPort() {
            return ((LinkDelegate)this.getDelegate()).getPort();
        }

        public String getTransport() {
            return ((LinkDelegate)this.getDelegate()).getTransport();
        }

        public Boolean getDurable() {
            return ((LinkDelegate)this.getDelegate()).getDurable();
        }

        public ConnectionObject getConnectionRef() {
            return ((LinkDelegate)this.getDelegate()).getConnectionRef();
        }

        public String getState() {
            return ((LinkDelegate)this.getDelegate()).getState();
        }

        public String getLastError() {
            return ((LinkDelegate)this.getDelegate()).getLastError();
        }
    }

    public static interface LinkDelegate
    extends QMFObject.Delegate {
        public VhostObject getVhostRef();

        public String getName();

        public String getHost();

        public Integer getPort();

        public String getTransport();

        public Boolean getDurable();

        public ConnectionObject getConnectionRef();

        public String getState();

        public String getLastError();

        public LinkClass.CloseMethodResponseCommand close(LinkClass.CloseMethodResponseCommandFactory var1);

        public LinkClass.BridgeMethodResponseCommand bridge(LinkClass.BridgeMethodResponseCommandFactory var1, Boolean var2, String var3, String var4, String var5, String var6, String var7, Boolean var8, Boolean var9, Boolean var10, Integer var11);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LinkClass
    extends QMFObjectClass<LinkObject, LinkDelegate> {
        private final VhostRefProperty _vhostRefProperty;
        private final NameProperty _nameProperty;
        private final HostProperty _hostProperty;
        private final PortProperty _portProperty;
        private final TransportProperty _transportProperty;
        private final DurableProperty _durableProperty;
        private final ConnectionRefProperty _connectionRefProperty;
        private final StateStatistic _stateStatistic;
        private final LastErrorStatistic _lastErrorStatistic;
        private final CloseMethod _closeMethod;
        private final BridgeMethod _bridgeMethod;

        private LinkClass() {
            super("link", new byte[16]);
            this._vhostRefProperty = new VhostRefProperty();
            this._nameProperty = new NameProperty();
            this._hostProperty = new HostProperty();
            this._portProperty = new PortProperty();
            this._transportProperty = new TransportProperty();
            this._durableProperty = new DurableProperty();
            this._connectionRefProperty = new ConnectionRefProperty();
            this._stateStatistic = new StateStatistic();
            this._lastErrorStatistic = new LastErrorStatistic();
            this._closeMethod = new CloseMethod();
            this._bridgeMethod = new BridgeMethod();
            this.setProperties(Arrays.asList(this._vhostRefProperty, this._nameProperty, this._hostProperty, this._portProperty, this._transportProperty, this._durableProperty, this._connectionRefProperty));
            this.setStatistics(Arrays.asList(this._stateStatistic, this._lastErrorStatistic));
            this.setMethods(Arrays.asList(this._closeMethod, this._bridgeMethod));
        }

        @Override
        public LinkObject newInstance(LinkDelegate delegate) {
            return new LinkObject(delegate);
        }

        public final class BridgeMethodResponseCommand
        extends QMFMethodResponseCommand {
            private BridgeMethodResponseCommand(QMFMethodRequestCommand cmd) {
                super(cmd, CompletionCode.OK, "OK");
            }

            private BridgeMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
            }
        }

        public final class BridgeMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private BridgeMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public BridgeMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new BridgeMethodResponseCommand(this._requestCmd, status, null);
            }

            public BridgeMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new BridgeMethodResponseCommand(this._requestCmd, status, msg);
            }

            public BridgeMethodResponseCommand createResponseCommand() {
                return new BridgeMethodResponseCommand(this._requestCmd);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class BridgeMethodInvocation
        implements QMFMethodInvocation<LinkObject> {
            private final Boolean _durable;
            private final String _src;
            private final String _dest;
            private final String _key;
            private final String _tag;
            private final String _excludes;
            private final Boolean _srcIsQueue;
            private final Boolean _srcIsLocal;
            private final Boolean _dynamic;
            private final Integer _sync;

            private BridgeMethodInvocation(Boolean durable, String src, String dest, String key, String tag, String excludes, Boolean srcIsQueue, Boolean srcIsLocal, Boolean dynamic, Integer sync) {
                this._durable = durable;
                this._src = src;
                this._dest = dest;
                this._key = key;
                this._tag = tag;
                this._excludes = excludes;
                this._srcIsQueue = srcIsQueue;
                this._srcIsLocal = srcIsLocal;
                this._dynamic = dynamic;
                this._sync = sync;
            }

            @Override
            public QMFMethodResponseCommand execute(LinkObject obj, QMFMethodRequestCommand cmd) {
                return obj.bridge(new BridgeMethodResponseCommandFactory(cmd), this._durable, this._src, this._dest, this._key, this._tag, this._excludes, this._srcIsQueue, this._srcIsLocal, this._dynamic, this._sync);
            }

            public String toString() {
                return "BridgeMethod[durable = " + this._durable + ", " + "src = " + this._src + ", " + "dest = " + this._dest + ", " + "key = " + this._key + ", " + "tag = " + this._tag + ", " + "excludes = " + this._excludes + ", " + "srcIsQueue = " + this._srcIsQueue + ", " + "srcIsLocal = " + this._srcIsLocal + ", " + "dynamic = " + this._dynamic + ", " + "sync = " + this._sync + "]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class BridgeMethod
        extends QMFMethod<LinkObject> {
            private BridgeMethod() {
                super("bridge", "Bridge messages over the link");
                QMFMethod.Argument durable = new QMFMethod.Argument("durable", QMFType.BOOLEAN);
                durable.setDirection(QMFMethod.Direction.I);
                this.addArgument(durable);
                QMFMethod.Argument src = new QMFMethod.Argument("src", QMFType.STR8);
                src.setDirection(QMFMethod.Direction.I);
                this.addArgument(src);
                QMFMethod.Argument dest = new QMFMethod.Argument("dest", QMFType.STR8);
                dest.setDirection(QMFMethod.Direction.I);
                this.addArgument(dest);
                QMFMethod.Argument key = new QMFMethod.Argument("key", QMFType.STR16);
                key.setDirection(QMFMethod.Direction.I);
                this.addArgument(key);
                QMFMethod.Argument tag = new QMFMethod.Argument("tag", QMFType.STR8);
                tag.setDirection(QMFMethod.Direction.I);
                this.addArgument(tag);
                QMFMethod.Argument excludes = new QMFMethod.Argument("excludes", QMFType.STR8);
                excludes.setDirection(QMFMethod.Direction.I);
                this.addArgument(excludes);
                QMFMethod.Argument srcIsQueue = new QMFMethod.Argument("srcIsQueue", QMFType.BOOLEAN);
                srcIsQueue.setDirection(QMFMethod.Direction.I);
                this.addArgument(srcIsQueue);
                QMFMethod.Argument srcIsLocal = new QMFMethod.Argument("srcIsLocal", QMFType.BOOLEAN);
                srcIsLocal.setDirection(QMFMethod.Direction.I);
                this.addArgument(srcIsLocal);
                QMFMethod.Argument dynamic = new QMFMethod.Argument("dynamic", QMFType.BOOLEAN);
                dynamic.setDirection(QMFMethod.Direction.I);
                this.addArgument(dynamic);
                QMFMethod.Argument sync = new QMFMethod.Argument("sync", QMFType.UINT16);
                sync.setDirection(QMFMethod.Direction.I);
                this.addArgument(sync);
            }

            public BridgeMethodInvocation parse(BBDecoder decoder) {
                Boolean durable = decoder.readInt8() != 0;
                String src = decoder.readStr8();
                String dest = decoder.readStr8();
                String key = decoder.readStr16();
                String tag = decoder.readStr8();
                String excludes = decoder.readStr8();
                Boolean srcIsQueue = decoder.readInt8() != 0;
                Boolean srcIsLocal = decoder.readInt8() != 0;
                Boolean dynamic = decoder.readInt8() != 0;
                Integer sync = decoder.readUint16();
                return new BridgeMethodInvocation(durable, src, dest, key, tag, excludes, srcIsQueue, srcIsLocal, dynamic, sync);
            }
        }

        public final class CloseMethodResponseCommand
        extends QMFMethodResponseCommand {
            private CloseMethodResponseCommand(QMFMethodRequestCommand cmd) {
                super(cmd, CompletionCode.OK, "OK");
            }

            private CloseMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
            }
        }

        public final class CloseMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private CloseMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public CloseMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new CloseMethodResponseCommand(this._requestCmd, status, null);
            }

            public CloseMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new CloseMethodResponseCommand(this._requestCmd, status, msg);
            }

            public CloseMethodResponseCommand createResponseCommand() {
                return new CloseMethodResponseCommand(this._requestCmd);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CloseMethodInvocation
        implements QMFMethodInvocation<LinkObject> {
            private CloseMethodInvocation() {
            }

            @Override
            public QMFMethodResponseCommand execute(LinkObject obj, QMFMethodRequestCommand cmd) {
                return obj.close(new CloseMethodResponseCommandFactory(cmd));
            }

            public String toString() {
                return "CloseMethod[]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class CloseMethod
        extends QMFMethod<LinkObject> {
            private CloseMethod() {
                super("close", null);
            }

            public CloseMethodInvocation parse(BBDecoder decoder) {
                return new CloseMethodInvocation();
            }
        }

        public class LastErrorStatistic
        extends QMFStatistic {
            private LastErrorStatistic() {
                super("lastError", QMFType.STR16, null, "Reason link is not operational");
            }
        }

        public class StateStatistic
        extends QMFStatistic {
            private StateStatistic() {
                super("state", QMFType.STR8, null, "Operational state of the link");
            }
        }

        public class ConnectionRefProperty
        extends QMFProperty {
            private ConnectionRefProperty() {
                super("connectionRef", QMFType.OBJECTREFERENCE, QMFProperty.AccessCode.RO, false, false);
                this.setReferencedClass("connection");
            }
        }

        public class DurableProperty
        extends QMFProperty {
            private DurableProperty() {
                super("durable", QMFType.BOOLEAN, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class TransportProperty
        extends QMFProperty {
            private TransportProperty() {
                super("transport", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
            }
        }

        public class PortProperty
        extends QMFProperty {
            private PortProperty() {
                super("port", QMFType.UINT16, QMFProperty.AccessCode.RO, false, false);
            }
        }

        public class HostProperty
        extends QMFProperty {
            private HostProperty() {
                super("host", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
            }
        }

        public class NameProperty
        extends QMFProperty {
            private NameProperty() {
                super("name", QMFType.STR8, QMFProperty.AccessCode.RC, true, false);
            }
        }

        public class VhostRefProperty
        extends QMFProperty {
            private VhostRefProperty() {
                super("vhostRef", QMFType.OBJECTREFERENCE, QMFProperty.AccessCode.RC, true, false);
                this.setReferencedClass("vhost");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFConnectionGetQueryResponseCommand
    extends QMFGetQueryResponseCommand<ConnectionObject> {
        protected QMFConnectionGetQueryResponseCommand(ConnectionObject object, QMFGetQueryCommand cmd, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, cmd, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            byte presence0 = 0;
            if (((ConnectionObject)this.getObject()).getRemoteProcessName() != null) {
                presence0 = (byte)(presence0 | 1);
            }
            if (((ConnectionObject)this.getObject()).getRemotePid() != null) {
                presence0 = (byte)(presence0 | 2);
            }
            if (((ConnectionObject)this.getObject()).getRemoteParentPid() != null) {
                presence0 = (byte)(presence0 | 4);
            }
            encoder.writeUint8((short)presence0);
            encoder.writeBin128(((ConnectionObject)this.getObject()).getVhostRef().getId());
            encoder.writeStr8(((ConnectionObject)this.getObject()).getAddress());
            encoder.writeInt8(((ConnectionObject)this.getObject()).getIncoming() != false ? (byte)-1 : 0);
            encoder.writeInt8(((ConnectionObject)this.getObject()).getSystemConnection() != false ? (byte)-1 : 0);
            encoder.writeInt8(((ConnectionObject)this.getObject()).getUserProxyAuth() != false ? (byte)-1 : 0);
            encoder.writeInt8(((ConnectionObject)this.getObject()).getFederationLink() != false ? (byte)-1 : 0);
            encoder.writeStr8(((ConnectionObject)this.getObject()).getAuthIdentity());
            if (((ConnectionObject)this.getObject()).getRemoteProcessName() != null) {
                encoder.writeStr16(((ConnectionObject)this.getObject()).getRemoteProcessName());
            }
            if (((ConnectionObject)this.getObject()).getRemotePid() != null) {
                encoder.writeUint32(((ConnectionObject)this.getObject()).getRemotePid().longValue());
            }
            if (((ConnectionObject)this.getObject()).getRemoteParentPid() != null) {
                encoder.writeUint32(((ConnectionObject)this.getObject()).getRemoteParentPid().longValue());
            }
            encoder.writeInt8(((ConnectionObject)this.getObject()).getShadow() != false ? (byte)-1 : 0);
            encoder.writeStr8(((ConnectionObject)this.getObject()).getSaslMechanism());
            encoder.writeUint16(((ConnectionObject)this.getObject()).getSaslSsf().intValue());
            encoder.writeInt8(((ConnectionObject)this.getObject()).getClosing() != false ? (byte)-1 : 0);
            encoder.writeUint64(((ConnectionObject)this.getObject()).getFramesFromClient().longValue());
            encoder.writeUint64(((ConnectionObject)this.getObject()).getFramesToClient().longValue());
            encoder.writeUint64(((ConnectionObject)this.getObject()).getBytesFromClient().longValue());
            encoder.writeUint64(((ConnectionObject)this.getObject()).getBytesToClient().longValue());
            encoder.writeUint64(((ConnectionObject)this.getObject()).getMsgsFromClient().longValue());
            encoder.writeUint64(((ConnectionObject)this.getObject()).getMsgsToClient().longValue());
        }

        public String toString() {
            return "QMFConnectionGetQueryResponseCommand{id=" + ((ConnectionObject)this.getObject()).getId() + ", vhostRef=" + ((ConnectionObject)this.getObject()).getVhostRef() + ", address=" + ((ConnectionObject)this.getObject()).getAddress() + ", incoming=" + ((ConnectionObject)this.getObject()).getIncoming() + ", SystemConnection=" + ((ConnectionObject)this.getObject()).getSystemConnection() + ", userProxyAuth=" + ((ConnectionObject)this.getObject()).getUserProxyAuth() + ", federationLink=" + ((ConnectionObject)this.getObject()).getFederationLink() + ", authIdentity=" + ((ConnectionObject)this.getObject()).getAuthIdentity() + ", remoteProcessName=" + ((ConnectionObject)this.getObject()).getRemoteProcessName() + ", remotePid=" + ((ConnectionObject)this.getObject()).getRemotePid() + ", remoteParentPid=" + ((ConnectionObject)this.getObject()).getRemoteParentPid() + ", shadow=" + ((ConnectionObject)this.getObject()).getShadow() + ", saslMechanism=" + ((ConnectionObject)this.getObject()).getSaslMechanism() + ", saslSsf=" + ((ConnectionObject)this.getObject()).getSaslSsf() + ", closing=" + ((ConnectionObject)this.getObject()).getClosing() + ", framesFromClient=" + ((ConnectionObject)this.getObject()).getFramesFromClient() + ", framesToClient=" + ((ConnectionObject)this.getObject()).getFramesToClient() + ", bytesFromClient=" + ((ConnectionObject)this.getObject()).getBytesFromClient() + ", bytesToClient=" + ((ConnectionObject)this.getObject()).getBytesToClient() + ", msgsFromClient=" + ((ConnectionObject)this.getObject()).getMsgsFromClient() + ", msgsToClient=" + ((ConnectionObject)this.getObject()).getMsgsToClient() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFConnectionInstrumentInfoCommand
    extends QMFInstrumentInfoCommand<ConnectionObject> {
        protected QMFConnectionInstrumentInfoCommand(ConnectionObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeInt8(((ConnectionObject)this.getObject()).getClosing() != false ? (byte)-1 : 0);
            encoder.writeUint64(((ConnectionObject)this.getObject()).getFramesFromClient().longValue());
            encoder.writeUint64(((ConnectionObject)this.getObject()).getFramesToClient().longValue());
            encoder.writeUint64(((ConnectionObject)this.getObject()).getBytesFromClient().longValue());
            encoder.writeUint64(((ConnectionObject)this.getObject()).getBytesToClient().longValue());
            encoder.writeUint64(((ConnectionObject)this.getObject()).getMsgsFromClient().longValue());
            encoder.writeUint64(((ConnectionObject)this.getObject()).getMsgsToClient().longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFConnectionConfigInfoCommand
    extends QMFConfigInfoCommand<ConnectionObject> {
        protected QMFConnectionConfigInfoCommand(ConnectionObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            byte presence0 = 0;
            if (((ConnectionObject)this.getObject()).getRemoteProcessName() != null) {
                presence0 = (byte)(presence0 | 1);
            }
            if (((ConnectionObject)this.getObject()).getRemotePid() != null) {
                presence0 = (byte)(presence0 | 2);
            }
            if (((ConnectionObject)this.getObject()).getRemoteParentPid() != null) {
                presence0 = (byte)(presence0 | 4);
            }
            encoder.writeUint8((short)presence0);
            encoder.writeBin128(((ConnectionObject)this.getObject()).getVhostRef().getId());
            encoder.writeStr8(((ConnectionObject)this.getObject()).getAddress());
            encoder.writeInt8(((ConnectionObject)this.getObject()).getIncoming() != false ? (byte)-1 : 0);
            encoder.writeInt8(((ConnectionObject)this.getObject()).getSystemConnection() != false ? (byte)-1 : 0);
            encoder.writeInt8(((ConnectionObject)this.getObject()).getUserProxyAuth() != false ? (byte)-1 : 0);
            encoder.writeInt8(((ConnectionObject)this.getObject()).getFederationLink() != false ? (byte)-1 : 0);
            encoder.writeStr8(((ConnectionObject)this.getObject()).getAuthIdentity());
            if (((ConnectionObject)this.getObject()).getRemoteProcessName() != null) {
                encoder.writeStr16(((ConnectionObject)this.getObject()).getRemoteProcessName());
            }
            if (((ConnectionObject)this.getObject()).getRemotePid() != null) {
                encoder.writeUint32(((ConnectionObject)this.getObject()).getRemotePid().longValue());
            }
            if (((ConnectionObject)this.getObject()).getRemoteParentPid() != null) {
                encoder.writeUint32(((ConnectionObject)this.getObject()).getRemoteParentPid().longValue());
            }
            encoder.writeInt8(((ConnectionObject)this.getObject()).getShadow() != false ? (byte)-1 : 0);
            encoder.writeStr8(((ConnectionObject)this.getObject()).getSaslMechanism());
            encoder.writeUint16(((ConnectionObject)this.getObject()).getSaslSsf().intValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ConnectionObject
    extends QMFObject<ConnectionClass, ConnectionDelegate> {
        protected ConnectionObject(ConnectionDelegate delegate) {
            super(delegate);
        }

        @Override
        public ConnectionClass getQMFClass() {
            return BrokerSchema.this._connectionClass;
        }

        @Override
        public QMFCommand asConfigInfoCmd(long sampleTime) {
            return new QMFConnectionConfigInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asInstrumentInfoCmd(long sampleTime) {
            return new QMFConnectionInstrumentInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asGetQueryResponseCmd(QMFGetQueryCommand queryCommand, long sampleTime) {
            return new QMFConnectionGetQueryResponseCommand(this, queryCommand, sampleTime);
        }

        public ConnectionClass.CloseMethodResponseCommand close(ConnectionClass.CloseMethodResponseCommandFactory factory) {
            return ((ConnectionDelegate)this.getDelegate()).close(factory);
        }

        public VhostObject getVhostRef() {
            return ((ConnectionDelegate)this.getDelegate()).getVhostRef();
        }

        public String getAddress() {
            return ((ConnectionDelegate)this.getDelegate()).getAddress();
        }

        public Boolean getIncoming() {
            return ((ConnectionDelegate)this.getDelegate()).getIncoming();
        }

        public Boolean getSystemConnection() {
            return ((ConnectionDelegate)this.getDelegate()).getSystemConnection();
        }

        public Boolean getUserProxyAuth() {
            return ((ConnectionDelegate)this.getDelegate()).getUserProxyAuth();
        }

        public Boolean getFederationLink() {
            return ((ConnectionDelegate)this.getDelegate()).getFederationLink();
        }

        public String getAuthIdentity() {
            return ((ConnectionDelegate)this.getDelegate()).getAuthIdentity();
        }

        public String getRemoteProcessName() {
            return ((ConnectionDelegate)this.getDelegate()).getRemoteProcessName();
        }

        public Long getRemotePid() {
            return ((ConnectionDelegate)this.getDelegate()).getRemotePid();
        }

        public Long getRemoteParentPid() {
            return ((ConnectionDelegate)this.getDelegate()).getRemoteParentPid();
        }

        public Boolean getShadow() {
            return ((ConnectionDelegate)this.getDelegate()).getShadow();
        }

        public String getSaslMechanism() {
            return ((ConnectionDelegate)this.getDelegate()).getSaslMechanism();
        }

        public Integer getSaslSsf() {
            return ((ConnectionDelegate)this.getDelegate()).getSaslSsf();
        }

        public Boolean getClosing() {
            return ((ConnectionDelegate)this.getDelegate()).getClosing();
        }

        public Long getFramesFromClient() {
            return ((ConnectionDelegate)this.getDelegate()).getFramesFromClient();
        }

        public Long getFramesToClient() {
            return ((ConnectionDelegate)this.getDelegate()).getFramesToClient();
        }

        public Long getBytesFromClient() {
            return ((ConnectionDelegate)this.getDelegate()).getBytesFromClient();
        }

        public Long getBytesToClient() {
            return ((ConnectionDelegate)this.getDelegate()).getBytesToClient();
        }

        public Long getMsgsFromClient() {
            return ((ConnectionDelegate)this.getDelegate()).getMsgsFromClient();
        }

        public Long getMsgsToClient() {
            return ((ConnectionDelegate)this.getDelegate()).getMsgsToClient();
        }
    }

    public static interface ConnectionDelegate
    extends QMFObject.Delegate {
        public VhostObject getVhostRef();

        public String getAddress();

        public Boolean getIncoming();

        public Boolean getSystemConnection();

        public Boolean getUserProxyAuth();

        public Boolean getFederationLink();

        public String getAuthIdentity();

        public String getRemoteProcessName();

        public Long getRemotePid();

        public Long getRemoteParentPid();

        public Boolean getShadow();

        public String getSaslMechanism();

        public Integer getSaslSsf();

        public Boolean getClosing();

        public Long getFramesFromClient();

        public Long getFramesToClient();

        public Long getBytesFromClient();

        public Long getBytesToClient();

        public Long getMsgsFromClient();

        public Long getMsgsToClient();

        public ConnectionClass.CloseMethodResponseCommand close(ConnectionClass.CloseMethodResponseCommandFactory var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConnectionClass
    extends QMFObjectClass<ConnectionObject, ConnectionDelegate> {
        private final VhostRefProperty _vhostRefProperty;
        private final AddressProperty _addressProperty;
        private final IncomingProperty _incomingProperty;
        private final SystemConnectionProperty _systemConnectionProperty;
        private final UserProxyAuthProperty _userProxyAuthProperty;
        private final FederationLinkProperty _federationLinkProperty;
        private final AuthIdentityProperty _authIdentityProperty;
        private final RemoteProcessNameProperty _remoteProcessNameProperty;
        private final RemotePidProperty _remotePidProperty;
        private final RemoteParentPidProperty _remoteParentPidProperty;
        private final ShadowProperty _shadowProperty;
        private final SaslMechanismProperty _saslMechanismProperty;
        private final SaslSsfProperty _saslSsfProperty;
        private final ClosingStatistic _closingStatistic;
        private final FramesFromClientStatistic _framesFromClientStatistic;
        private final FramesToClientStatistic _framesToClientStatistic;
        private final BytesFromClientStatistic _bytesFromClientStatistic;
        private final BytesToClientStatistic _bytesToClientStatistic;
        private final MsgsFromClientStatistic _msgsFromClientStatistic;
        private final MsgsToClientStatistic _msgsToClientStatistic;
        private final CloseMethod _closeMethod;

        private ConnectionClass() {
            super("connection", new byte[16]);
            this._vhostRefProperty = new VhostRefProperty();
            this._addressProperty = new AddressProperty();
            this._incomingProperty = new IncomingProperty();
            this._systemConnectionProperty = new SystemConnectionProperty();
            this._userProxyAuthProperty = new UserProxyAuthProperty();
            this._federationLinkProperty = new FederationLinkProperty();
            this._authIdentityProperty = new AuthIdentityProperty();
            this._remoteProcessNameProperty = new RemoteProcessNameProperty();
            this._remotePidProperty = new RemotePidProperty();
            this._remoteParentPidProperty = new RemoteParentPidProperty();
            this._shadowProperty = new ShadowProperty();
            this._saslMechanismProperty = new SaslMechanismProperty();
            this._saslSsfProperty = new SaslSsfProperty();
            this._closingStatistic = new ClosingStatistic();
            this._framesFromClientStatistic = new FramesFromClientStatistic();
            this._framesToClientStatistic = new FramesToClientStatistic();
            this._bytesFromClientStatistic = new BytesFromClientStatistic();
            this._bytesToClientStatistic = new BytesToClientStatistic();
            this._msgsFromClientStatistic = new MsgsFromClientStatistic();
            this._msgsToClientStatistic = new MsgsToClientStatistic();
            this._closeMethod = new CloseMethod();
            this.setProperties(Arrays.asList(this._vhostRefProperty, this._addressProperty, this._incomingProperty, this._systemConnectionProperty, this._userProxyAuthProperty, this._federationLinkProperty, this._authIdentityProperty, this._remoteProcessNameProperty, this._remotePidProperty, this._remoteParentPidProperty, this._shadowProperty, this._saslMechanismProperty, this._saslSsfProperty));
            this.setStatistics(Arrays.asList(this._closingStatistic, this._framesFromClientStatistic, this._framesToClientStatistic, this._bytesFromClientStatistic, this._bytesToClientStatistic, this._msgsFromClientStatistic, this._msgsToClientStatistic));
            this.setMethods(Arrays.asList(this._closeMethod));
        }

        @Override
        public ConnectionObject newInstance(ConnectionDelegate delegate) {
            return new ConnectionObject(delegate);
        }

        public final class CloseMethodResponseCommand
        extends QMFMethodResponseCommand {
            private CloseMethodResponseCommand(QMFMethodRequestCommand cmd) {
                super(cmd, CompletionCode.OK, "OK");
            }

            private CloseMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
            }
        }

        public final class CloseMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private CloseMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public CloseMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new CloseMethodResponseCommand(this._requestCmd, status, null);
            }

            public CloseMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new CloseMethodResponseCommand(this._requestCmd, status, msg);
            }

            public CloseMethodResponseCommand createResponseCommand() {
                return new CloseMethodResponseCommand(this._requestCmd);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CloseMethodInvocation
        implements QMFMethodInvocation<ConnectionObject> {
            private CloseMethodInvocation() {
            }

            @Override
            public QMFMethodResponseCommand execute(ConnectionObject obj, QMFMethodRequestCommand cmd) {
                return obj.close(new CloseMethodResponseCommandFactory(cmd));
            }

            public String toString() {
                return "CloseMethod[]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class CloseMethod
        extends QMFMethod<ConnectionObject> {
            private CloseMethod() {
                super("close", null);
            }

            public CloseMethodInvocation parse(BBDecoder decoder) {
                return new CloseMethodInvocation();
            }
        }

        public class MsgsToClientStatistic
        extends QMFStatistic {
            private MsgsToClientStatistic() {
                super("msgsToClient", QMFType.UINT64, null, null);
            }
        }

        public class MsgsFromClientStatistic
        extends QMFStatistic {
            private MsgsFromClientStatistic() {
                super("msgsFromClient", QMFType.UINT64, null, null);
            }
        }

        public class BytesToClientStatistic
        extends QMFStatistic {
            private BytesToClientStatistic() {
                super("bytesToClient", QMFType.UINT64, null, null);
            }
        }

        public class BytesFromClientStatistic
        extends QMFStatistic {
            private BytesFromClientStatistic() {
                super("bytesFromClient", QMFType.UINT64, null, null);
            }
        }

        public class FramesToClientStatistic
        extends QMFStatistic {
            private FramesToClientStatistic() {
                super("framesToClient", QMFType.UINT64, null, null);
            }
        }

        public class FramesFromClientStatistic
        extends QMFStatistic {
            private FramesFromClientStatistic() {
                super("framesFromClient", QMFType.UINT64, null, null);
            }
        }

        public class ClosingStatistic
        extends QMFStatistic {
            private ClosingStatistic() {
                super("closing", QMFType.BOOLEAN, null, "This client is closing by management request");
            }
        }

        public class SaslSsfProperty
        extends QMFProperty {
            private SaslSsfProperty() {
                super("saslSsf", QMFType.UINT16, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("SASL security strength factor");
            }
        }

        public class SaslMechanismProperty
        extends QMFProperty {
            private SaslMechanismProperty() {
                super("saslMechanism", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("SASL mechanism");
            }
        }

        public class ShadowProperty
        extends QMFProperty {
            private ShadowProperty() {
                super("shadow", QMFType.BOOLEAN, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("True for shadow connections");
            }
        }

        public class RemoteParentPidProperty
        extends QMFProperty {
            private RemoteParentPidProperty() {
                super("remoteParentPid", QMFType.UINT32, QMFProperty.AccessCode.RO, false, true);
                this.setDescription("Parent Process ID of remote client");
            }
        }

        public class RemotePidProperty
        extends QMFProperty {
            private RemotePidProperty() {
                super("remotePid", QMFType.UINT32, QMFProperty.AccessCode.RO, false, true);
                this.setDescription("Process ID of remote client");
            }
        }

        public class RemoteProcessNameProperty
        extends QMFProperty {
            private RemoteProcessNameProperty() {
                super("remoteProcessName", QMFType.STR16, QMFProperty.AccessCode.RO, false, true);
                this.setDescription("Name of executable running as remote client");
            }
        }

        public class AuthIdentityProperty
        extends QMFProperty {
            private AuthIdentityProperty() {
                super("authIdentity", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("authId of connection if authentication enabled");
            }
        }

        public class FederationLinkProperty
        extends QMFProperty {
            private FederationLinkProperty() {
                super("federationLink", QMFType.BOOLEAN, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Is this a federation link");
            }
        }

        public class UserProxyAuthProperty
        extends QMFProperty {
            private UserProxyAuthProperty() {
                super("userProxyAuth", QMFType.BOOLEAN, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Authorization to proxy for users not on broker");
            }
        }

        public class SystemConnectionProperty
        extends QMFProperty {
            private SystemConnectionProperty() {
                super("SystemConnection", QMFType.BOOLEAN, QMFProperty.AccessCode.RC, false, false);
                this.setDescription("Infrastructure/ Inter-system connection (Cluster, Federation, ...)");
            }
        }

        public class IncomingProperty
        extends QMFProperty {
            private IncomingProperty() {
                super("incoming", QMFType.BOOLEAN, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class AddressProperty
        extends QMFProperty {
            private AddressProperty() {
                super("address", QMFType.STR8, QMFProperty.AccessCode.RC, true, false);
            }
        }

        public class VhostRefProperty
        extends QMFProperty {
            private VhostRefProperty() {
                super("vhostRef", QMFType.OBJECTREFERENCE, QMFProperty.AccessCode.RC, true, false);
                this.setReferencedClass("vhost");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFSubscriptionGetQueryResponseCommand
    extends QMFGetQueryResponseCommand<SubscriptionObject> {
        protected QMFSubscriptionGetQueryResponseCommand(SubscriptionObject object, QMFGetQueryCommand cmd, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, cmd, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeBin128(((SubscriptionObject)this.getObject()).getSessionRef().getId());
            encoder.writeBin128(((SubscriptionObject)this.getObject()).getQueueRef().getId());
            encoder.writeStr8(((SubscriptionObject)this.getObject()).getName());
            encoder.writeInt8(((SubscriptionObject)this.getObject()).getBrowsing() != false ? (byte)-1 : 0);
            encoder.writeInt8(((SubscriptionObject)this.getObject()).getAcknowledged() != false ? (byte)-1 : 0);
            encoder.writeInt8(((SubscriptionObject)this.getObject()).getExclusive() != false ? (byte)-1 : 0);
            encoder.writeStr8(((SubscriptionObject)this.getObject()).getCreditMode());
            encoder.writeMap(((SubscriptionObject)this.getObject()).getArguments());
            encoder.writeUint64(((SubscriptionObject)this.getObject()).getDelivered().longValue());
        }

        public String toString() {
            return "QMFSubscriptionGetQueryResponseCommand{id=" + ((SubscriptionObject)this.getObject()).getId() + ", sessionRef=" + ((SubscriptionObject)this.getObject()).getSessionRef() + ", queueRef=" + ((SubscriptionObject)this.getObject()).getQueueRef() + ", name=" + ((SubscriptionObject)this.getObject()).getName() + ", browsing=" + ((SubscriptionObject)this.getObject()).getBrowsing() + ", acknowledged=" + ((SubscriptionObject)this.getObject()).getAcknowledged() + ", exclusive=" + ((SubscriptionObject)this.getObject()).getExclusive() + ", creditMode=" + ((SubscriptionObject)this.getObject()).getCreditMode() + ", arguments=" + ((SubscriptionObject)this.getObject()).getArguments() + ", delivered=" + ((SubscriptionObject)this.getObject()).getDelivered() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFSubscriptionInstrumentInfoCommand
    extends QMFInstrumentInfoCommand<SubscriptionObject> {
        protected QMFSubscriptionInstrumentInfoCommand(SubscriptionObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeUint64(((SubscriptionObject)this.getObject()).getDelivered().longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFSubscriptionConfigInfoCommand
    extends QMFConfigInfoCommand<SubscriptionObject> {
        protected QMFSubscriptionConfigInfoCommand(SubscriptionObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeBin128(((SubscriptionObject)this.getObject()).getSessionRef().getId());
            encoder.writeBin128(((SubscriptionObject)this.getObject()).getQueueRef().getId());
            encoder.writeStr8(((SubscriptionObject)this.getObject()).getName());
            encoder.writeInt8(((SubscriptionObject)this.getObject()).getBrowsing() != false ? (byte)-1 : 0);
            encoder.writeInt8(((SubscriptionObject)this.getObject()).getAcknowledged() != false ? (byte)-1 : 0);
            encoder.writeInt8(((SubscriptionObject)this.getObject()).getExclusive() != false ? (byte)-1 : 0);
            encoder.writeStr8(((SubscriptionObject)this.getObject()).getCreditMode());
            encoder.writeMap(((SubscriptionObject)this.getObject()).getArguments());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class SubscriptionObject
    extends QMFObject<SubscriptionClass, SubscriptionDelegate> {
        protected SubscriptionObject(SubscriptionDelegate delegate) {
            super(delegate);
        }

        @Override
        public SubscriptionClass getQMFClass() {
            return BrokerSchema.this._subscriptionClass;
        }

        @Override
        public QMFCommand asConfigInfoCmd(long sampleTime) {
            return new QMFSubscriptionConfigInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asInstrumentInfoCmd(long sampleTime) {
            return new QMFSubscriptionInstrumentInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asGetQueryResponseCmd(QMFGetQueryCommand queryCommand, long sampleTime) {
            return new QMFSubscriptionGetQueryResponseCommand(this, queryCommand, sampleTime);
        }

        public SessionObject getSessionRef() {
            return ((SubscriptionDelegate)this.getDelegate()).getSessionRef();
        }

        public QueueObject getQueueRef() {
            return ((SubscriptionDelegate)this.getDelegate()).getQueueRef();
        }

        public String getName() {
            return ((SubscriptionDelegate)this.getDelegate()).getName();
        }

        public Boolean getBrowsing() {
            return ((SubscriptionDelegate)this.getDelegate()).getBrowsing();
        }

        public Boolean getAcknowledged() {
            return ((SubscriptionDelegate)this.getDelegate()).getAcknowledged();
        }

        public Boolean getExclusive() {
            return ((SubscriptionDelegate)this.getDelegate()).getExclusive();
        }

        public String getCreditMode() {
            return ((SubscriptionDelegate)this.getDelegate()).getCreditMode();
        }

        public Map getArguments() {
            return ((SubscriptionDelegate)this.getDelegate()).getArguments();
        }

        public Long getDelivered() {
            return ((SubscriptionDelegate)this.getDelegate()).getDelivered();
        }
    }

    public static interface SubscriptionDelegate
    extends QMFObject.Delegate {
        public SessionObject getSessionRef();

        public QueueObject getQueueRef();

        public String getName();

        public Boolean getBrowsing();

        public Boolean getAcknowledged();

        public Boolean getExclusive();

        public String getCreditMode();

        public Map getArguments();

        public Long getDelivered();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SubscriptionClass
    extends QMFObjectClass<SubscriptionObject, SubscriptionDelegate> {
        private final SessionRefProperty _sessionRefProperty;
        private final QueueRefProperty _queueRefProperty;
        private final NameProperty _nameProperty;
        private final BrowsingProperty _browsingProperty;
        private final AcknowledgedProperty _acknowledgedProperty;
        private final ExclusiveProperty _exclusiveProperty;
        private final CreditModeProperty _creditModeProperty;
        private final ArgumentsProperty _argumentsProperty;
        private final DeliveredStatistic _deliveredStatistic;

        private SubscriptionClass() {
            super("subscription", new byte[16]);
            this._sessionRefProperty = new SessionRefProperty();
            this._queueRefProperty = new QueueRefProperty();
            this._nameProperty = new NameProperty();
            this._browsingProperty = new BrowsingProperty();
            this._acknowledgedProperty = new AcknowledgedProperty();
            this._exclusiveProperty = new ExclusiveProperty();
            this._creditModeProperty = new CreditModeProperty();
            this._argumentsProperty = new ArgumentsProperty();
            this._deliveredStatistic = new DeliveredStatistic();
            this.setProperties(Arrays.asList(this._sessionRefProperty, this._queueRefProperty, this._nameProperty, this._browsingProperty, this._acknowledgedProperty, this._exclusiveProperty, this._creditModeProperty, this._argumentsProperty));
            this.setStatistics(Arrays.asList(this._deliveredStatistic));
            this.setMethods(Arrays.asList(new QMFMethod[0]));
        }

        @Override
        public SubscriptionObject newInstance(SubscriptionDelegate delegate) {
            return new SubscriptionObject(delegate);
        }

        public class DeliveredStatistic
        extends QMFStatistic {
            private DeliveredStatistic() {
                super("delivered", QMFType.UINT64, "message", "Messages delivered");
            }
        }

        public class ArgumentsProperty
        extends QMFProperty {
            private ArgumentsProperty() {
                super("arguments", QMFType.MAP, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class CreditModeProperty
        extends QMFProperty {
            private CreditModeProperty() {
                super("creditMode", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("WINDOW or CREDIT");
            }
        }

        public class ExclusiveProperty
        extends QMFProperty {
            private ExclusiveProperty() {
                super("exclusive", QMFType.BOOLEAN, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class AcknowledgedProperty
        extends QMFProperty {
            private AcknowledgedProperty() {
                super("acknowledged", QMFType.BOOLEAN, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class BrowsingProperty
        extends QMFProperty {
            private BrowsingProperty() {
                super("browsing", QMFType.BOOLEAN, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class NameProperty
        extends QMFProperty {
            private NameProperty() {
                super("name", QMFType.STR8, QMFProperty.AccessCode.RC, true, false);
            }
        }

        public class QueueRefProperty
        extends QMFProperty {
            private QueueRefProperty() {
                super("queueRef", QMFType.OBJECTREFERENCE, QMFProperty.AccessCode.RC, true, false);
                this.setReferencedClass("queue");
            }
        }

        public class SessionRefProperty
        extends QMFProperty {
            private SessionRefProperty() {
                super("sessionRef", QMFType.OBJECTREFERENCE, QMFProperty.AccessCode.RC, true, false);
                this.setReferencedClass("session");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFBindingGetQueryResponseCommand
    extends QMFGetQueryResponseCommand<BindingObject> {
        protected QMFBindingGetQueryResponseCommand(BindingObject object, QMFGetQueryCommand cmd, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, cmd, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            byte presence0 = 0;
            if (((BindingObject)this.getObject()).getOrigin() != null) {
                presence0 = (byte)(presence0 | 1);
            }
            encoder.writeUint8((short)presence0);
            encoder.writeBin128(((BindingObject)this.getObject()).getExchangeRef().getId());
            encoder.writeBin128(((BindingObject)this.getObject()).getQueueRef().getId());
            encoder.writeStr16(((BindingObject)this.getObject()).getBindingKey());
            encoder.writeMap(((BindingObject)this.getObject()).getArguments());
            if (((BindingObject)this.getObject()).getOrigin() != null) {
                encoder.writeStr8(((BindingObject)this.getObject()).getOrigin());
            }
            encoder.writeUint64(((BindingObject)this.getObject()).getMsgMatched().longValue());
        }

        public String toString() {
            return "QMFBindingGetQueryResponseCommand{id=" + ((BindingObject)this.getObject()).getId() + ", exchangeRef=" + ((BindingObject)this.getObject()).getExchangeRef() + ", queueRef=" + ((BindingObject)this.getObject()).getQueueRef() + ", bindingKey=" + ((BindingObject)this.getObject()).getBindingKey() + ", arguments=" + ((BindingObject)this.getObject()).getArguments() + ", origin=" + ((BindingObject)this.getObject()).getOrigin() + ", msgMatched=" + ((BindingObject)this.getObject()).getMsgMatched() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFBindingInstrumentInfoCommand
    extends QMFInstrumentInfoCommand<BindingObject> {
        protected QMFBindingInstrumentInfoCommand(BindingObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeUint64(((BindingObject)this.getObject()).getMsgMatched().longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFBindingConfigInfoCommand
    extends QMFConfigInfoCommand<BindingObject> {
        protected QMFBindingConfigInfoCommand(BindingObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            byte presence0 = 0;
            if (((BindingObject)this.getObject()).getOrigin() != null) {
                presence0 = (byte)(presence0 | 1);
            }
            encoder.writeUint8((short)presence0);
            encoder.writeBin128(((BindingObject)this.getObject()).getExchangeRef().getId());
            encoder.writeBin128(((BindingObject)this.getObject()).getQueueRef().getId());
            encoder.writeStr16(((BindingObject)this.getObject()).getBindingKey());
            encoder.writeMap(((BindingObject)this.getObject()).getArguments());
            if (((BindingObject)this.getObject()).getOrigin() != null) {
                encoder.writeStr8(((BindingObject)this.getObject()).getOrigin());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class BindingObject
    extends QMFObject<BindingClass, BindingDelegate> {
        protected BindingObject(BindingDelegate delegate) {
            super(delegate);
        }

        @Override
        public BindingClass getQMFClass() {
            return BrokerSchema.this._bindingClass;
        }

        @Override
        public QMFCommand asConfigInfoCmd(long sampleTime) {
            return new QMFBindingConfigInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asInstrumentInfoCmd(long sampleTime) {
            return new QMFBindingInstrumentInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asGetQueryResponseCmd(QMFGetQueryCommand queryCommand, long sampleTime) {
            return new QMFBindingGetQueryResponseCommand(this, queryCommand, sampleTime);
        }

        public ExchangeObject getExchangeRef() {
            return ((BindingDelegate)this.getDelegate()).getExchangeRef();
        }

        public QueueObject getQueueRef() {
            return ((BindingDelegate)this.getDelegate()).getQueueRef();
        }

        public String getBindingKey() {
            return ((BindingDelegate)this.getDelegate()).getBindingKey();
        }

        public Map getArguments() {
            return ((BindingDelegate)this.getDelegate()).getArguments();
        }

        public String getOrigin() {
            return ((BindingDelegate)this.getDelegate()).getOrigin();
        }

        public Long getMsgMatched() {
            return ((BindingDelegate)this.getDelegate()).getMsgMatched();
        }
    }

    public static interface BindingDelegate
    extends QMFObject.Delegate {
        public ExchangeObject getExchangeRef();

        public QueueObject getQueueRef();

        public String getBindingKey();

        public Map getArguments();

        public String getOrigin();

        public Long getMsgMatched();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BindingClass
    extends QMFObjectClass<BindingObject, BindingDelegate> {
        private final ExchangeRefProperty _exchangeRefProperty;
        private final QueueRefProperty _queueRefProperty;
        private final BindingKeyProperty _bindingKeyProperty;
        private final ArgumentsProperty _argumentsProperty;
        private final OriginProperty _originProperty;
        private final MsgMatchedStatistic _msgMatchedStatistic;

        private BindingClass() {
            super("binding", new byte[16]);
            this._exchangeRefProperty = new ExchangeRefProperty();
            this._queueRefProperty = new QueueRefProperty();
            this._bindingKeyProperty = new BindingKeyProperty();
            this._argumentsProperty = new ArgumentsProperty();
            this._originProperty = new OriginProperty();
            this._msgMatchedStatistic = new MsgMatchedStatistic();
            this.setProperties(Arrays.asList(this._exchangeRefProperty, this._queueRefProperty, this._bindingKeyProperty, this._argumentsProperty, this._originProperty));
            this.setStatistics(Arrays.asList(this._msgMatchedStatistic));
            this.setMethods(Arrays.asList(new QMFMethod[0]));
        }

        @Override
        public BindingObject newInstance(BindingDelegate delegate) {
            return new BindingObject(delegate);
        }

        public class MsgMatchedStatistic
        extends QMFStatistic {
            private MsgMatchedStatistic() {
                super("msgMatched", QMFType.UINT64, null, null);
            }
        }

        public class OriginProperty
        extends QMFProperty {
            private OriginProperty() {
                super("origin", QMFType.STR8, QMFProperty.AccessCode.RO, false, true);
            }
        }

        public class ArgumentsProperty
        extends QMFProperty {
            private ArgumentsProperty() {
                super("arguments", QMFType.MAP, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class BindingKeyProperty
        extends QMFProperty {
            private BindingKeyProperty() {
                super("bindingKey", QMFType.STR16, QMFProperty.AccessCode.RC, true, false);
            }
        }

        public class QueueRefProperty
        extends QMFProperty {
            private QueueRefProperty() {
                super("queueRef", QMFType.OBJECTREFERENCE, QMFProperty.AccessCode.RC, true, false);
                this.setReferencedClass("queue");
            }
        }

        public class ExchangeRefProperty
        extends QMFProperty {
            private ExchangeRefProperty() {
                super("exchangeRef", QMFType.OBJECTREFERENCE, QMFProperty.AccessCode.RC, true, false);
                this.setReferencedClass("exchange");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFExchangeGetQueryResponseCommand
    extends QMFGetQueryResponseCommand<ExchangeObject> {
        protected QMFExchangeGetQueryResponseCommand(ExchangeObject object, QMFGetQueryCommand cmd, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, cmd, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            byte presence0 = 0;
            if (((ExchangeObject)this.getObject()).getAltExchange() != null) {
                presence0 = (byte)(presence0 | 1);
            }
            encoder.writeUint8((short)presence0);
            encoder.writeBin128(((ExchangeObject)this.getObject()).getVhostRef().getId());
            encoder.writeStr8(((ExchangeObject)this.getObject()).getName());
            encoder.writeStr8(((ExchangeObject)this.getObject()).getType());
            encoder.writeInt8(((ExchangeObject)this.getObject()).getDurable() != false ? (byte)-1 : 0);
            encoder.writeInt8(((ExchangeObject)this.getObject()).getAutoDelete() != false ? (byte)-1 : 0);
            if (((ExchangeObject)this.getObject()).getAltExchange() != null) {
                encoder.writeBin128(((ExchangeObject)this.getObject()).getAltExchange().getId());
            }
            encoder.writeMap(((ExchangeObject)this.getObject()).getArguments());
            encoder.writeUint32(((ExchangeObject)this.getObject()).getProducerCount().longValue());
            encoder.writeUint32(((ExchangeObject)this.getObject()).getProducerCountHigh().longValue());
            encoder.writeUint32(((ExchangeObject)this.getObject()).getProducerCountLow().longValue());
            encoder.writeUint32(((ExchangeObject)this.getObject()).getBindingCount().longValue());
            encoder.writeUint32(((ExchangeObject)this.getObject()).getBindingCountHigh().longValue());
            encoder.writeUint32(((ExchangeObject)this.getObject()).getBindingCountLow().longValue());
            encoder.writeUint64(((ExchangeObject)this.getObject()).getMsgReceives().longValue());
            encoder.writeUint64(((ExchangeObject)this.getObject()).getMsgDrops().longValue());
            encoder.writeUint64(((ExchangeObject)this.getObject()).getMsgRoutes().longValue());
            encoder.writeUint64(((ExchangeObject)this.getObject()).getByteReceives().longValue());
            encoder.writeUint64(((ExchangeObject)this.getObject()).getByteDrops().longValue());
            encoder.writeUint64(((ExchangeObject)this.getObject()).getByteRoutes().longValue());
        }

        public String toString() {
            return "QMFExchangeGetQueryResponseCommand{id=" + ((ExchangeObject)this.getObject()).getId() + ", vhostRef=" + ((ExchangeObject)this.getObject()).getVhostRef() + ", name=" + ((ExchangeObject)this.getObject()).getName() + ", type=" + ((ExchangeObject)this.getObject()).getType() + ", durable=" + ((ExchangeObject)this.getObject()).getDurable() + ", autoDelete=" + ((ExchangeObject)this.getObject()).getAutoDelete() + ", altExchange=" + ((ExchangeObject)this.getObject()).getAltExchange() + ", arguments=" + ((ExchangeObject)this.getObject()).getArguments() + ", msgReceives=" + ((ExchangeObject)this.getObject()).getMsgReceives() + ", msgDrops=" + ((ExchangeObject)this.getObject()).getMsgDrops() + ", msgRoutes=" + ((ExchangeObject)this.getObject()).getMsgRoutes() + ", byteReceives=" + ((ExchangeObject)this.getObject()).getByteReceives() + ", byteDrops=" + ((ExchangeObject)this.getObject()).getByteDrops() + ", byteRoutes=" + ((ExchangeObject)this.getObject()).getByteRoutes() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFExchangeInstrumentInfoCommand
    extends QMFInstrumentInfoCommand<ExchangeObject> {
        protected QMFExchangeInstrumentInfoCommand(ExchangeObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeUint32(((ExchangeObject)this.getObject()).getProducerCount().longValue());
            encoder.writeUint32(((ExchangeObject)this.getObject()).getProducerCountHigh().longValue());
            encoder.writeUint32(((ExchangeObject)this.getObject()).getProducerCountLow().longValue());
            encoder.writeUint32(((ExchangeObject)this.getObject()).getBindingCount().longValue());
            encoder.writeUint32(((ExchangeObject)this.getObject()).getBindingCountHigh().longValue());
            encoder.writeUint32(((ExchangeObject)this.getObject()).getBindingCountLow().longValue());
            encoder.writeUint64(((ExchangeObject)this.getObject()).getMsgReceives().longValue());
            encoder.writeUint64(((ExchangeObject)this.getObject()).getMsgDrops().longValue());
            encoder.writeUint64(((ExchangeObject)this.getObject()).getMsgRoutes().longValue());
            encoder.writeUint64(((ExchangeObject)this.getObject()).getByteReceives().longValue());
            encoder.writeUint64(((ExchangeObject)this.getObject()).getByteDrops().longValue());
            encoder.writeUint64(((ExchangeObject)this.getObject()).getByteRoutes().longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFExchangeConfigInfoCommand
    extends QMFConfigInfoCommand<ExchangeObject> {
        protected QMFExchangeConfigInfoCommand(ExchangeObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            byte presence0 = 0;
            if (((ExchangeObject)this.getObject()).getAltExchange() != null) {
                presence0 = (byte)(presence0 | 1);
            }
            encoder.writeUint8((short)presence0);
            encoder.writeBin128(((ExchangeObject)this.getObject()).getVhostRef().getId());
            encoder.writeStr8(((ExchangeObject)this.getObject()).getName());
            encoder.writeStr8(((ExchangeObject)this.getObject()).getType());
            encoder.writeInt8(((ExchangeObject)this.getObject()).getDurable() != false ? (byte)-1 : 0);
            encoder.writeInt8(((ExchangeObject)this.getObject()).getAutoDelete() != false ? (byte)-1 : 0);
            if (((ExchangeObject)this.getObject()).getAltExchange() != null) {
                encoder.writeBin128(((ExchangeObject)this.getObject()).getAltExchange().getId());
            }
            encoder.writeMap(((ExchangeObject)this.getObject()).getArguments());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ExchangeObject
    extends QMFObject<ExchangeClass, ExchangeDelegate> {
        protected ExchangeObject(ExchangeDelegate delegate) {
            super(delegate);
        }

        @Override
        public ExchangeClass getQMFClass() {
            return BrokerSchema.this._exchangeClass;
        }

        @Override
        public QMFCommand asConfigInfoCmd(long sampleTime) {
            return new QMFExchangeConfigInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asInstrumentInfoCmd(long sampleTime) {
            return new QMFExchangeInstrumentInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asGetQueryResponseCmd(QMFGetQueryCommand queryCommand, long sampleTime) {
            return new QMFExchangeGetQueryResponseCommand(this, queryCommand, sampleTime);
        }

        public VhostObject getVhostRef() {
            return ((ExchangeDelegate)this.getDelegate()).getVhostRef();
        }

        public String getName() {
            return ((ExchangeDelegate)this.getDelegate()).getName();
        }

        public String getType() {
            return ((ExchangeDelegate)this.getDelegate()).getType();
        }

        public Boolean getDurable() {
            return ((ExchangeDelegate)this.getDelegate()).getDurable();
        }

        public Boolean getAutoDelete() {
            return ((ExchangeDelegate)this.getDelegate()).getAutoDelete();
        }

        public ExchangeObject getAltExchange() {
            return ((ExchangeDelegate)this.getDelegate()).getAltExchange();
        }

        public Map getArguments() {
            return ((ExchangeDelegate)this.getDelegate()).getArguments();
        }

        public Long getProducerCount() {
            return ((ExchangeDelegate)this.getDelegate()).getProducerCount();
        }

        public Long getProducerCountHigh() {
            return ((ExchangeDelegate)this.getDelegate()).getProducerCountHigh();
        }

        public Long getProducerCountLow() {
            return ((ExchangeDelegate)this.getDelegate()).getProducerCountLow();
        }

        public Long getBindingCount() {
            return ((ExchangeDelegate)this.getDelegate()).getBindingCount();
        }

        public Long getBindingCountHigh() {
            return ((ExchangeDelegate)this.getDelegate()).getBindingCountHigh();
        }

        public Long getBindingCountLow() {
            return ((ExchangeDelegate)this.getDelegate()).getBindingCountLow();
        }

        public Long getMsgReceives() {
            return ((ExchangeDelegate)this.getDelegate()).getMsgReceives();
        }

        public Long getMsgDrops() {
            return ((ExchangeDelegate)this.getDelegate()).getMsgDrops();
        }

        public Long getMsgRoutes() {
            return ((ExchangeDelegate)this.getDelegate()).getMsgRoutes();
        }

        public Long getByteReceives() {
            return ((ExchangeDelegate)this.getDelegate()).getByteReceives();
        }

        public Long getByteDrops() {
            return ((ExchangeDelegate)this.getDelegate()).getByteDrops();
        }

        public Long getByteRoutes() {
            return ((ExchangeDelegate)this.getDelegate()).getByteRoutes();
        }
    }

    public static interface ExchangeDelegate
    extends QMFObject.Delegate {
        public VhostObject getVhostRef();

        public String getName();

        public String getType();

        public Boolean getDurable();

        public Boolean getAutoDelete();

        public ExchangeObject getAltExchange();

        public Map getArguments();

        public Long getProducerCount();

        public Long getProducerCountHigh();

        public Long getProducerCountLow();

        public Long getBindingCount();

        public Long getBindingCountHigh();

        public Long getBindingCountLow();

        public Long getMsgReceives();

        public Long getMsgDrops();

        public Long getMsgRoutes();

        public Long getByteReceives();

        public Long getByteDrops();

        public Long getByteRoutes();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExchangeClass
    extends QMFObjectClass<ExchangeObject, ExchangeDelegate> {
        private final VhostRefProperty _vhostRefProperty;
        private final NameProperty _nameProperty;
        private final TypeProperty _typeProperty;
        private final DurableProperty _durableProperty;
        private final AutoDeleteProperty _autoDeleteProperty;
        private final AltExchangeProperty _altExchangeProperty;
        private final ArgumentsProperty _argumentsProperty;
        private final ProducerCountStatistic _producerCountStatistic;
        private final ProducerCountHighStatistic _producerCountHighStatistic;
        private final ProducerCountLowStatistic _producerCountLowStatistic;
        private final BindingCountStatistic _bindingCountStatistic;
        private final BindingCountHighStatistic _bindingCountHighStatistic;
        private final BindingCountLowStatistic _bindingCountLowStatistic;
        private final MsgReceivesStatistic _msgReceivesStatistic;
        private final MsgDropsStatistic _msgDropsStatistic;
        private final MsgRoutesStatistic _msgRoutesStatistic;
        private final ByteReceivesStatistic _byteReceivesStatistic;
        private final ByteDropsStatistic _byteDropsStatistic;
        private final ByteRoutesStatistic _byteRoutesStatistic;

        private ExchangeClass() {
            super("exchange", new byte[16]);
            this._vhostRefProperty = new VhostRefProperty();
            this._nameProperty = new NameProperty();
            this._typeProperty = new TypeProperty();
            this._durableProperty = new DurableProperty();
            this._autoDeleteProperty = new AutoDeleteProperty();
            this._altExchangeProperty = new AltExchangeProperty();
            this._argumentsProperty = new ArgumentsProperty();
            this._producerCountStatistic = new ProducerCountStatistic();
            this._producerCountHighStatistic = new ProducerCountHighStatistic();
            this._producerCountLowStatistic = new ProducerCountLowStatistic();
            this._bindingCountStatistic = new BindingCountStatistic();
            this._bindingCountHighStatistic = new BindingCountHighStatistic();
            this._bindingCountLowStatistic = new BindingCountLowStatistic();
            this._msgReceivesStatistic = new MsgReceivesStatistic();
            this._msgDropsStatistic = new MsgDropsStatistic();
            this._msgRoutesStatistic = new MsgRoutesStatistic();
            this._byteReceivesStatistic = new ByteReceivesStatistic();
            this._byteDropsStatistic = new ByteDropsStatistic();
            this._byteRoutesStatistic = new ByteRoutesStatistic();
            this.setProperties(Arrays.asList(this._vhostRefProperty, this._nameProperty, this._typeProperty, this._durableProperty, this._autoDeleteProperty, this._altExchangeProperty, this._argumentsProperty));
            this.setStatistics(Arrays.asList(this._producerCountStatistic, this._producerCountHighStatistic, this._producerCountLowStatistic, this._bindingCountStatistic, this._bindingCountHighStatistic, this._bindingCountLowStatistic, this._msgReceivesStatistic, this._msgDropsStatistic, this._msgRoutesStatistic, this._byteReceivesStatistic, this._byteDropsStatistic, this._byteRoutesStatistic));
            this.setMethods(Arrays.asList(new QMFMethod[0]));
        }

        @Override
        public ExchangeObject newInstance(ExchangeDelegate delegate) {
            return new ExchangeObject(delegate);
        }

        public class ByteRoutesStatistic
        extends QMFStatistic {
            private ByteRoutesStatistic() {
                super("byteRoutes", QMFType.UINT64, null, "Total routed bytes");
            }
        }

        public class ByteDropsStatistic
        extends QMFStatistic {
            private ByteDropsStatistic() {
                super("byteDrops", QMFType.UINT64, null, "Total bytes dropped (no matching key)");
            }
        }

        public class ByteReceivesStatistic
        extends QMFStatistic {
            private ByteReceivesStatistic() {
                super("byteReceives", QMFType.UINT64, null, "Total bytes received");
            }
        }

        public class MsgRoutesStatistic
        extends QMFStatistic {
            private MsgRoutesStatistic() {
                super("msgRoutes", QMFType.UINT64, null, "Total routed messages");
            }
        }

        public class MsgDropsStatistic
        extends QMFStatistic {
            private MsgDropsStatistic() {
                super("msgDrops", QMFType.UINT64, null, "Total messages dropped (no matching key)");
            }
        }

        public class MsgReceivesStatistic
        extends QMFStatistic {
            private MsgReceivesStatistic() {
                super("msgReceives", QMFType.UINT64, null, "Total messages received");
            }
        }

        public class BindingCountLowStatistic
        extends QMFStatistic {
            private BindingCountLowStatistic() {
                super("bindingCountLow", QMFType.UINT32, null, "Current bindings (Low)");
            }
        }

        public class BindingCountHighStatistic
        extends QMFStatistic {
            private BindingCountHighStatistic() {
                super("bindingCountHigh", QMFType.UINT32, null, "Current bindings (High)");
            }
        }

        public class BindingCountStatistic
        extends QMFStatistic {
            private BindingCountStatistic() {
                super("bindingCount", QMFType.UINT32, null, "Current bindings");
            }
        }

        public class ProducerCountLowStatistic
        extends QMFStatistic {
            private ProducerCountLowStatistic() {
                super("producerCountLow", QMFType.UINT32, null, "Current producers on exchange (Low)");
            }
        }

        public class ProducerCountHighStatistic
        extends QMFStatistic {
            private ProducerCountHighStatistic() {
                super("producerCountHigh", QMFType.UINT32, null, "Current producers on exchange (High)");
            }
        }

        public class ProducerCountStatistic
        extends QMFStatistic {
            private ProducerCountStatistic() {
                super("producerCount", QMFType.UINT32, null, "Current producers on exchange");
            }
        }

        public class ArgumentsProperty
        extends QMFProperty {
            private ArgumentsProperty() {
                super("arguments", QMFType.MAP, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Arguments supplied in exchange.declare");
            }
        }

        public class AltExchangeProperty
        extends QMFProperty {
            private AltExchangeProperty() {
                super("altExchange", QMFType.OBJECTREFERENCE, QMFProperty.AccessCode.RO, false, true);
                this.setReferencedClass("exchange");
            }
        }

        public class AutoDeleteProperty
        extends QMFProperty {
            private AutoDeleteProperty() {
                super("autoDelete", QMFType.BOOLEAN, QMFProperty.AccessCode.RO, false, false);
            }
        }

        public class DurableProperty
        extends QMFProperty {
            private DurableProperty() {
                super("durable", QMFType.BOOLEAN, QMFProperty.AccessCode.RO, false, false);
            }
        }

        public class TypeProperty
        extends QMFProperty {
            private TypeProperty() {
                super("type", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
            }
        }

        public class NameProperty
        extends QMFProperty {
            private NameProperty() {
                super("name", QMFType.STR8, QMFProperty.AccessCode.RC, true, false);
            }
        }

        public class VhostRefProperty
        extends QMFProperty {
            private VhostRefProperty() {
                super("vhostRef", QMFType.OBJECTREFERENCE, QMFProperty.AccessCode.RC, true, false);
                this.setReferencedClass("vhost");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFQueueGetQueryResponseCommand
    extends QMFGetQueryResponseCommand<QueueObject> {
        protected QMFQueueGetQueryResponseCommand(QueueObject object, QMFGetQueryCommand cmd, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, cmd, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            byte presence0 = 0;
            if (((QueueObject)this.getObject()).getAltExchange() != null) {
                presence0 = (byte)(presence0 | 1);
            }
            encoder.writeUint8((short)presence0);
            encoder.writeBin128(((QueueObject)this.getObject()).getVhostRef().getId());
            encoder.writeStr8(((QueueObject)this.getObject()).getName());
            encoder.writeInt8(((QueueObject)this.getObject()).getDurable() != false ? (byte)-1 : 0);
            encoder.writeInt8(((QueueObject)this.getObject()).getAutoDelete() != false ? (byte)-1 : 0);
            encoder.writeInt8(((QueueObject)this.getObject()).getExclusive() != false ? (byte)-1 : 0);
            encoder.writeMap(((QueueObject)this.getObject()).getArguments());
            if (((QueueObject)this.getObject()).getAltExchange() != null) {
                encoder.writeBin128(((QueueObject)this.getObject()).getAltExchange().getId());
            }
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgTotalEnqueues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgTotalDequeues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgTxnEnqueues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgTxnDequeues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgPersistEnqueues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgPersistDequeues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgDepth().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getByteDepth().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getByteTotalEnqueues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getByteTotalDequeues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getByteTxnEnqueues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getByteTxnDequeues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getBytePersistEnqueues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getBytePersistDequeues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgFtdEnqueues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgFtdDequeues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getByteFtdEnqueues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getByteFtdDequeues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgFtdDepth().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getByteFtdDepth().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getReleases().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getAcquires().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getDiscardsTtl().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getDiscardsRing().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getDiscardsLvq().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getDiscardsOverflow().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getDiscardsSubscriber().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getDiscardsPurge().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getReroutes().longValue());
            encoder.writeUint32(((QueueObject)this.getObject()).getConsumerCount().longValue());
            encoder.writeUint32(((QueueObject)this.getObject()).getConsumerCountHigh().longValue());
            encoder.writeUint32(((QueueObject)this.getObject()).getConsumerCountLow().longValue());
            encoder.writeUint32(((QueueObject)this.getObject()).getBindingCount().longValue());
            encoder.writeUint32(((QueueObject)this.getObject()).getBindingCountHigh().longValue());
            encoder.writeUint32(((QueueObject)this.getObject()).getBindingCountLow().longValue());
            encoder.writeUint32(((QueueObject)this.getObject()).getUnackedMessages().longValue());
            encoder.writeUint32(((QueueObject)this.getObject()).getUnackedMessagesHigh().longValue());
            encoder.writeUint32(((QueueObject)this.getObject()).getUnackedMessagesLow().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMessageLatencySamples().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMessageLatencyMin().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMessageLatencyMax().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMessageLatencyAverage().longValue());
            encoder.writeInt8(((QueueObject)this.getObject()).getFlowStopped() != false ? (byte)-1 : 0);
            encoder.writeUint32(((QueueObject)this.getObject()).getFlowStoppedCount().longValue());
        }

        public String toString() {
            return "QMFQueueGetQueryResponseCommand{id=" + ((QueueObject)this.getObject()).getId() + ", vhostRef=" + ((QueueObject)this.getObject()).getVhostRef() + ", name=" + ((QueueObject)this.getObject()).getName() + ", durable=" + ((QueueObject)this.getObject()).getDurable() + ", autoDelete=" + ((QueueObject)this.getObject()).getAutoDelete() + ", exclusive=" + ((QueueObject)this.getObject()).getExclusive() + ", arguments=" + ((QueueObject)this.getObject()).getArguments() + ", altExchange=" + ((QueueObject)this.getObject()).getAltExchange() + ", msgTotalEnqueues=" + ((QueueObject)this.getObject()).getMsgTotalEnqueues() + ", msgTotalDequeues=" + ((QueueObject)this.getObject()).getMsgTotalDequeues() + ", msgTxnEnqueues=" + ((QueueObject)this.getObject()).getMsgTxnEnqueues() + ", msgTxnDequeues=" + ((QueueObject)this.getObject()).getMsgTxnDequeues() + ", msgPersistEnqueues=" + ((QueueObject)this.getObject()).getMsgPersistEnqueues() + ", msgPersistDequeues=" + ((QueueObject)this.getObject()).getMsgPersistDequeues() + ", msgDepth=" + ((QueueObject)this.getObject()).getMsgDepth() + ", byteDepth=" + ((QueueObject)this.getObject()).getByteDepth() + ", byteTotalEnqueues=" + ((QueueObject)this.getObject()).getByteTotalEnqueues() + ", byteTotalDequeues=" + ((QueueObject)this.getObject()).getByteTotalDequeues() + ", byteTxnEnqueues=" + ((QueueObject)this.getObject()).getByteTxnEnqueues() + ", byteTxnDequeues=" + ((QueueObject)this.getObject()).getByteTxnDequeues() + ", bytePersistEnqueues=" + ((QueueObject)this.getObject()).getBytePersistEnqueues() + ", bytePersistDequeues=" + ((QueueObject)this.getObject()).getBytePersistDequeues() + ", msgFtdEnqueues=" + ((QueueObject)this.getObject()).getMsgFtdEnqueues() + ", msgFtdDequeues=" + ((QueueObject)this.getObject()).getMsgFtdDequeues() + ", byteFtdEnqueues=" + ((QueueObject)this.getObject()).getByteFtdEnqueues() + ", byteFtdDequeues=" + ((QueueObject)this.getObject()).getByteFtdDequeues() + ", msgFtdDepth=" + ((QueueObject)this.getObject()).getMsgFtdDepth() + ", byteFtdDepth=" + ((QueueObject)this.getObject()).getByteFtdDepth() + ", releases=" + ((QueueObject)this.getObject()).getReleases() + ", acquires=" + ((QueueObject)this.getObject()).getAcquires() + ", discardsTtl=" + ((QueueObject)this.getObject()).getDiscardsTtl() + ", discardsRing=" + ((QueueObject)this.getObject()).getDiscardsRing() + ", discardsLvq=" + ((QueueObject)this.getObject()).getDiscardsLvq() + ", discardsOverflow=" + ((QueueObject)this.getObject()).getDiscardsOverflow() + ", discardsSubscriber=" + ((QueueObject)this.getObject()).getDiscardsSubscriber() + ", discardsPurge=" + ((QueueObject)this.getObject()).getDiscardsPurge() + ", reroutes=" + ((QueueObject)this.getObject()).getReroutes() + ", flowStopped=" + ((QueueObject)this.getObject()).getFlowStopped() + ", flowStoppedCount=" + ((QueueObject)this.getObject()).getFlowStoppedCount() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFQueueInstrumentInfoCommand
    extends QMFInstrumentInfoCommand<QueueObject> {
        protected QMFQueueInstrumentInfoCommand(QueueObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgTotalEnqueues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgTotalDequeues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgTxnEnqueues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgTxnDequeues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgPersistEnqueues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgPersistDequeues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgDepth().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getByteDepth().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getByteTotalEnqueues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getByteTotalDequeues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getByteTxnEnqueues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getByteTxnDequeues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getBytePersistEnqueues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getBytePersistDequeues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgFtdEnqueues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgFtdDequeues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getByteFtdEnqueues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getByteFtdDequeues().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMsgFtdDepth().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getByteFtdDepth().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getReleases().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getAcquires().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getDiscardsTtl().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getDiscardsRing().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getDiscardsLvq().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getDiscardsOverflow().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getDiscardsSubscriber().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getDiscardsPurge().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getReroutes().longValue());
            encoder.writeUint32(((QueueObject)this.getObject()).getConsumerCount().longValue());
            encoder.writeUint32(((QueueObject)this.getObject()).getConsumerCountHigh().longValue());
            encoder.writeUint32(((QueueObject)this.getObject()).getConsumerCountLow().longValue());
            encoder.writeUint32(((QueueObject)this.getObject()).getBindingCount().longValue());
            encoder.writeUint32(((QueueObject)this.getObject()).getBindingCountHigh().longValue());
            encoder.writeUint32(((QueueObject)this.getObject()).getBindingCountLow().longValue());
            encoder.writeUint32(((QueueObject)this.getObject()).getUnackedMessages().longValue());
            encoder.writeUint32(((QueueObject)this.getObject()).getUnackedMessagesHigh().longValue());
            encoder.writeUint32(((QueueObject)this.getObject()).getUnackedMessagesLow().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMessageLatencySamples().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMessageLatencyMin().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMessageLatencyMax().longValue());
            encoder.writeUint64(((QueueObject)this.getObject()).getMessageLatencyAverage().longValue());
            encoder.writeInt8(((QueueObject)this.getObject()).getFlowStopped() != false ? (byte)-1 : 0);
            encoder.writeUint32(((QueueObject)this.getObject()).getFlowStoppedCount().longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFQueueConfigInfoCommand
    extends QMFConfigInfoCommand<QueueObject> {
        protected QMFQueueConfigInfoCommand(QueueObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            byte presence0 = 0;
            if (((QueueObject)this.getObject()).getAltExchange() != null) {
                presence0 = (byte)(presence0 | 1);
            }
            encoder.writeUint8((short)presence0);
            encoder.writeBin128(((QueueObject)this.getObject()).getVhostRef().getId());
            encoder.writeStr8(((QueueObject)this.getObject()).getName());
            encoder.writeInt8(((QueueObject)this.getObject()).getDurable() != false ? (byte)-1 : 0);
            encoder.writeInt8(((QueueObject)this.getObject()).getAutoDelete() != false ? (byte)-1 : 0);
            encoder.writeInt8(((QueueObject)this.getObject()).getExclusive() != false ? (byte)-1 : 0);
            encoder.writeMap(((QueueObject)this.getObject()).getArguments());
            if (((QueueObject)this.getObject()).getAltExchange() != null) {
                encoder.writeBin128(((QueueObject)this.getObject()).getAltExchange().getId());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QueueObject
    extends QMFObject<QueueClass, QueueDelegate> {
        protected QueueObject(QueueDelegate delegate) {
            super(delegate);
        }

        @Override
        public QueueClass getQMFClass() {
            return BrokerSchema.this._queueClass;
        }

        @Override
        public QMFCommand asConfigInfoCmd(long sampleTime) {
            return new QMFQueueConfigInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asInstrumentInfoCmd(long sampleTime) {
            return new QMFQueueInstrumentInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asGetQueryResponseCmd(QMFGetQueryCommand queryCommand, long sampleTime) {
            return new QMFQueueGetQueryResponseCommand(this, queryCommand, sampleTime);
        }

        public QueueClass.PurgeMethodResponseCommand purge(QueueClass.PurgeMethodResponseCommandFactory factory, Long request, Map filter) {
            return ((QueueDelegate)this.getDelegate()).purge(factory, request, filter);
        }

        public QueueClass.RerouteMethodResponseCommand reroute(QueueClass.RerouteMethodResponseCommandFactory factory, Long request, Boolean useAltExchange, String exchange, Map filter) {
            return ((QueueDelegate)this.getDelegate()).reroute(factory, request, useAltExchange, exchange, filter);
        }

        public VhostObject getVhostRef() {
            return ((QueueDelegate)this.getDelegate()).getVhostRef();
        }

        public String getName() {
            return ((QueueDelegate)this.getDelegate()).getName();
        }

        public Boolean getDurable() {
            return ((QueueDelegate)this.getDelegate()).getDurable();
        }

        public Boolean getAutoDelete() {
            return ((QueueDelegate)this.getDelegate()).getAutoDelete();
        }

        public Boolean getExclusive() {
            return ((QueueDelegate)this.getDelegate()).getExclusive();
        }

        public Map getArguments() {
            return ((QueueDelegate)this.getDelegate()).getArguments();
        }

        public ExchangeObject getAltExchange() {
            return ((QueueDelegate)this.getDelegate()).getAltExchange();
        }

        public Long getMsgTotalEnqueues() {
            return ((QueueDelegate)this.getDelegate()).getMsgTotalEnqueues();
        }

        public Long getMsgTotalDequeues() {
            return ((QueueDelegate)this.getDelegate()).getMsgTotalDequeues();
        }

        public Long getMsgTxnEnqueues() {
            return ((QueueDelegate)this.getDelegate()).getMsgTxnEnqueues();
        }

        public Long getMsgTxnDequeues() {
            return ((QueueDelegate)this.getDelegate()).getMsgTxnDequeues();
        }

        public Long getMsgPersistEnqueues() {
            return ((QueueDelegate)this.getDelegate()).getMsgPersistEnqueues();
        }

        public Long getMsgPersistDequeues() {
            return ((QueueDelegate)this.getDelegate()).getMsgPersistDequeues();
        }

        public Long getMsgDepth() {
            return ((QueueDelegate)this.getDelegate()).getMsgDepth();
        }

        public Long getByteDepth() {
            return ((QueueDelegate)this.getDelegate()).getByteDepth();
        }

        public Long getByteTotalEnqueues() {
            return ((QueueDelegate)this.getDelegate()).getByteTotalEnqueues();
        }

        public Long getByteTotalDequeues() {
            return ((QueueDelegate)this.getDelegate()).getByteTotalDequeues();
        }

        public Long getByteTxnEnqueues() {
            return ((QueueDelegate)this.getDelegate()).getByteTxnEnqueues();
        }

        public Long getByteTxnDequeues() {
            return ((QueueDelegate)this.getDelegate()).getByteTxnDequeues();
        }

        public Long getBytePersistEnqueues() {
            return ((QueueDelegate)this.getDelegate()).getBytePersistEnqueues();
        }

        public Long getBytePersistDequeues() {
            return ((QueueDelegate)this.getDelegate()).getBytePersistDequeues();
        }

        public Long getMsgFtdEnqueues() {
            return ((QueueDelegate)this.getDelegate()).getMsgFtdEnqueues();
        }

        public Long getMsgFtdDequeues() {
            return ((QueueDelegate)this.getDelegate()).getMsgFtdDequeues();
        }

        public Long getByteFtdEnqueues() {
            return ((QueueDelegate)this.getDelegate()).getByteFtdEnqueues();
        }

        public Long getByteFtdDequeues() {
            return ((QueueDelegate)this.getDelegate()).getByteFtdDequeues();
        }

        public Long getMsgFtdDepth() {
            return ((QueueDelegate)this.getDelegate()).getMsgFtdDepth();
        }

        public Long getByteFtdDepth() {
            return ((QueueDelegate)this.getDelegate()).getByteFtdDepth();
        }

        public Long getReleases() {
            return ((QueueDelegate)this.getDelegate()).getReleases();
        }

        public Long getAcquires() {
            return ((QueueDelegate)this.getDelegate()).getAcquires();
        }

        public Long getDiscardsTtl() {
            return ((QueueDelegate)this.getDelegate()).getDiscardsTtl();
        }

        public Long getDiscardsRing() {
            return ((QueueDelegate)this.getDelegate()).getDiscardsRing();
        }

        public Long getDiscardsLvq() {
            return ((QueueDelegate)this.getDelegate()).getDiscardsLvq();
        }

        public Long getDiscardsOverflow() {
            return ((QueueDelegate)this.getDelegate()).getDiscardsOverflow();
        }

        public Long getDiscardsSubscriber() {
            return ((QueueDelegate)this.getDelegate()).getDiscardsSubscriber();
        }

        public Long getDiscardsPurge() {
            return ((QueueDelegate)this.getDelegate()).getDiscardsPurge();
        }

        public Long getReroutes() {
            return ((QueueDelegate)this.getDelegate()).getReroutes();
        }

        public Long getConsumerCount() {
            return ((QueueDelegate)this.getDelegate()).getConsumerCount();
        }

        public Long getConsumerCountHigh() {
            return ((QueueDelegate)this.getDelegate()).getConsumerCountHigh();
        }

        public Long getConsumerCountLow() {
            return ((QueueDelegate)this.getDelegate()).getConsumerCountLow();
        }

        public Long getBindingCount() {
            return ((QueueDelegate)this.getDelegate()).getBindingCount();
        }

        public Long getBindingCountHigh() {
            return ((QueueDelegate)this.getDelegate()).getBindingCountHigh();
        }

        public Long getBindingCountLow() {
            return ((QueueDelegate)this.getDelegate()).getBindingCountLow();
        }

        public Long getUnackedMessages() {
            return ((QueueDelegate)this.getDelegate()).getUnackedMessages();
        }

        public Long getUnackedMessagesHigh() {
            return ((QueueDelegate)this.getDelegate()).getUnackedMessagesHigh();
        }

        public Long getUnackedMessagesLow() {
            return ((QueueDelegate)this.getDelegate()).getUnackedMessagesLow();
        }

        public Long getMessageLatencySamples() {
            return ((QueueDelegate)this.getDelegate()).getMessageLatencySamples();
        }

        public Long getMessageLatencyMin() {
            return ((QueueDelegate)this.getDelegate()).getMessageLatencyMin();
        }

        public Long getMessageLatencyMax() {
            return ((QueueDelegate)this.getDelegate()).getMessageLatencyMax();
        }

        public Long getMessageLatencyAverage() {
            return ((QueueDelegate)this.getDelegate()).getMessageLatencyAverage();
        }

        public Boolean getFlowStopped() {
            return ((QueueDelegate)this.getDelegate()).getFlowStopped();
        }

        public Long getFlowStoppedCount() {
            return ((QueueDelegate)this.getDelegate()).getFlowStoppedCount();
        }
    }

    public static interface QueueDelegate
    extends QMFObject.Delegate {
        public VhostObject getVhostRef();

        public String getName();

        public Boolean getDurable();

        public Boolean getAutoDelete();

        public Boolean getExclusive();

        public Map getArguments();

        public ExchangeObject getAltExchange();

        public Long getMsgTotalEnqueues();

        public Long getMsgTotalDequeues();

        public Long getMsgTxnEnqueues();

        public Long getMsgTxnDequeues();

        public Long getMsgPersistEnqueues();

        public Long getMsgPersistDequeues();

        public Long getMsgDepth();

        public Long getByteDepth();

        public Long getByteTotalEnqueues();

        public Long getByteTotalDequeues();

        public Long getByteTxnEnqueues();

        public Long getByteTxnDequeues();

        public Long getBytePersistEnqueues();

        public Long getBytePersistDequeues();

        public Long getMsgFtdEnqueues();

        public Long getMsgFtdDequeues();

        public Long getByteFtdEnqueues();

        public Long getByteFtdDequeues();

        public Long getMsgFtdDepth();

        public Long getByteFtdDepth();

        public Long getReleases();

        public Long getAcquires();

        public Long getDiscardsTtl();

        public Long getDiscardsRing();

        public Long getDiscardsLvq();

        public Long getDiscardsOverflow();

        public Long getDiscardsSubscriber();

        public Long getDiscardsPurge();

        public Long getReroutes();

        public Long getConsumerCount();

        public Long getConsumerCountHigh();

        public Long getConsumerCountLow();

        public Long getBindingCount();

        public Long getBindingCountHigh();

        public Long getBindingCountLow();

        public Long getUnackedMessages();

        public Long getUnackedMessagesHigh();

        public Long getUnackedMessagesLow();

        public Long getMessageLatencySamples();

        public Long getMessageLatencyMin();

        public Long getMessageLatencyMax();

        public Long getMessageLatencyAverage();

        public Boolean getFlowStopped();

        public Long getFlowStoppedCount();

        public QueueClass.PurgeMethodResponseCommand purge(QueueClass.PurgeMethodResponseCommandFactory var1, Long var2, Map var3);

        public QueueClass.RerouteMethodResponseCommand reroute(QueueClass.RerouteMethodResponseCommandFactory var1, Long var2, Boolean var3, String var4, Map var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class QueueClass
    extends QMFObjectClass<QueueObject, QueueDelegate> {
        private final VhostRefProperty _vhostRefProperty;
        private final NameProperty _nameProperty;
        private final DurableProperty _durableProperty;
        private final AutoDeleteProperty _autoDeleteProperty;
        private final ExclusiveProperty _exclusiveProperty;
        private final ArgumentsProperty _argumentsProperty;
        private final AltExchangeProperty _altExchangeProperty;
        private final MsgTotalEnqueuesStatistic _msgTotalEnqueuesStatistic;
        private final MsgTotalDequeuesStatistic _msgTotalDequeuesStatistic;
        private final MsgTxnEnqueuesStatistic _msgTxnEnqueuesStatistic;
        private final MsgTxnDequeuesStatistic _msgTxnDequeuesStatistic;
        private final MsgPersistEnqueuesStatistic _msgPersistEnqueuesStatistic;
        private final MsgPersistDequeuesStatistic _msgPersistDequeuesStatistic;
        private final MsgDepthStatistic _msgDepthStatistic;
        private final ByteDepthStatistic _byteDepthStatistic;
        private final ByteTotalEnqueuesStatistic _byteTotalEnqueuesStatistic;
        private final ByteTotalDequeuesStatistic _byteTotalDequeuesStatistic;
        private final ByteTxnEnqueuesStatistic _byteTxnEnqueuesStatistic;
        private final ByteTxnDequeuesStatistic _byteTxnDequeuesStatistic;
        private final BytePersistEnqueuesStatistic _bytePersistEnqueuesStatistic;
        private final BytePersistDequeuesStatistic _bytePersistDequeuesStatistic;
        private final MsgFtdEnqueuesStatistic _msgFtdEnqueuesStatistic;
        private final MsgFtdDequeuesStatistic _msgFtdDequeuesStatistic;
        private final ByteFtdEnqueuesStatistic _byteFtdEnqueuesStatistic;
        private final ByteFtdDequeuesStatistic _byteFtdDequeuesStatistic;
        private final MsgFtdDepthStatistic _msgFtdDepthStatistic;
        private final ByteFtdDepthStatistic _byteFtdDepthStatistic;
        private final ReleasesStatistic _releasesStatistic;
        private final AcquiresStatistic _acquiresStatistic;
        private final DiscardsTtlStatistic _discardsTtlStatistic;
        private final DiscardsRingStatistic _discardsRingStatistic;
        private final DiscardsLvqStatistic _discardsLvqStatistic;
        private final DiscardsOverflowStatistic _discardsOverflowStatistic;
        private final DiscardsSubscriberStatistic _discardsSubscriberStatistic;
        private final DiscardsPurgeStatistic _discardsPurgeStatistic;
        private final ReroutesStatistic _reroutesStatistic;
        private final ConsumerCountStatistic _consumerCountStatistic;
        private final ConsumerCountHighStatistic _consumerCountHighStatistic;
        private final ConsumerCountLowStatistic _consumerCountLowStatistic;
        private final BindingCountStatistic _bindingCountStatistic;
        private final BindingCountHighStatistic _bindingCountHighStatistic;
        private final BindingCountLowStatistic _bindingCountLowStatistic;
        private final UnackedMessagesStatistic _unackedMessagesStatistic;
        private final UnackedMessagesHighStatistic _unackedMessagesHighStatistic;
        private final UnackedMessagesLowStatistic _unackedMessagesLowStatistic;
        private final MessageLatencySamplesStatistic _messageLatencySamplesStatistic;
        private final MessageLatencyMaxStatistic _messageLatencyMaxStatistic;
        private final MessageLatencyMinStatistic _messageLatencyMinStatistic;
        private final MessageLatencyAverageStatistic _messageLatencyAverageStatistic;
        private final FlowStoppedStatistic _flowStoppedStatistic;
        private final FlowStoppedCountStatistic _flowStoppedCountStatistic;
        private final PurgeMethod _purgeMethod;
        private final RerouteMethod _rerouteMethod;

        private QueueClass() {
            super("queue", new byte[16]);
            this._vhostRefProperty = new VhostRefProperty();
            this._nameProperty = new NameProperty();
            this._durableProperty = new DurableProperty();
            this._autoDeleteProperty = new AutoDeleteProperty();
            this._exclusiveProperty = new ExclusiveProperty();
            this._argumentsProperty = new ArgumentsProperty();
            this._altExchangeProperty = new AltExchangeProperty();
            this._msgTotalEnqueuesStatistic = new MsgTotalEnqueuesStatistic();
            this._msgTotalDequeuesStatistic = new MsgTotalDequeuesStatistic();
            this._msgTxnEnqueuesStatistic = new MsgTxnEnqueuesStatistic();
            this._msgTxnDequeuesStatistic = new MsgTxnDequeuesStatistic();
            this._msgPersistEnqueuesStatistic = new MsgPersistEnqueuesStatistic();
            this._msgPersistDequeuesStatistic = new MsgPersistDequeuesStatistic();
            this._msgDepthStatistic = new MsgDepthStatistic();
            this._byteDepthStatistic = new ByteDepthStatistic();
            this._byteTotalEnqueuesStatistic = new ByteTotalEnqueuesStatistic();
            this._byteTotalDequeuesStatistic = new ByteTotalDequeuesStatistic();
            this._byteTxnEnqueuesStatistic = new ByteTxnEnqueuesStatistic();
            this._byteTxnDequeuesStatistic = new ByteTxnDequeuesStatistic();
            this._bytePersistEnqueuesStatistic = new BytePersistEnqueuesStatistic();
            this._bytePersistDequeuesStatistic = new BytePersistDequeuesStatistic();
            this._msgFtdEnqueuesStatistic = new MsgFtdEnqueuesStatistic();
            this._msgFtdDequeuesStatistic = new MsgFtdDequeuesStatistic();
            this._byteFtdEnqueuesStatistic = new ByteFtdEnqueuesStatistic();
            this._byteFtdDequeuesStatistic = new ByteFtdDequeuesStatistic();
            this._msgFtdDepthStatistic = new MsgFtdDepthStatistic();
            this._byteFtdDepthStatistic = new ByteFtdDepthStatistic();
            this._releasesStatistic = new ReleasesStatistic();
            this._acquiresStatistic = new AcquiresStatistic();
            this._discardsTtlStatistic = new DiscardsTtlStatistic();
            this._discardsRingStatistic = new DiscardsRingStatistic();
            this._discardsLvqStatistic = new DiscardsLvqStatistic();
            this._discardsOverflowStatistic = new DiscardsOverflowStatistic();
            this._discardsSubscriberStatistic = new DiscardsSubscriberStatistic();
            this._discardsPurgeStatistic = new DiscardsPurgeStatistic();
            this._reroutesStatistic = new ReroutesStatistic();
            this._consumerCountStatistic = new ConsumerCountStatistic();
            this._consumerCountHighStatistic = new ConsumerCountHighStatistic();
            this._consumerCountLowStatistic = new ConsumerCountLowStatistic();
            this._bindingCountStatistic = new BindingCountStatistic();
            this._bindingCountHighStatistic = new BindingCountHighStatistic();
            this._bindingCountLowStatistic = new BindingCountLowStatistic();
            this._unackedMessagesStatistic = new UnackedMessagesStatistic();
            this._unackedMessagesHighStatistic = new UnackedMessagesHighStatistic();
            this._unackedMessagesLowStatistic = new UnackedMessagesLowStatistic();
            this._messageLatencySamplesStatistic = new MessageLatencySamplesStatistic();
            this._messageLatencyMaxStatistic = new MessageLatencyMaxStatistic();
            this._messageLatencyMinStatistic = new MessageLatencyMinStatistic();
            this._messageLatencyAverageStatistic = new MessageLatencyAverageStatistic();
            this._flowStoppedStatistic = new FlowStoppedStatistic();
            this._flowStoppedCountStatistic = new FlowStoppedCountStatistic();
            this._purgeMethod = new PurgeMethod();
            this._rerouteMethod = new RerouteMethod();
            this.setProperties(Arrays.asList(this._vhostRefProperty, this._nameProperty, this._durableProperty, this._autoDeleteProperty, this._exclusiveProperty, this._argumentsProperty, this._altExchangeProperty));
            this.setStatistics(Arrays.asList(this._msgTotalEnqueuesStatistic, this._msgTotalDequeuesStatistic, this._msgTxnEnqueuesStatistic, this._msgTxnDequeuesStatistic, this._msgPersistEnqueuesStatistic, this._msgPersistDequeuesStatistic, this._msgDepthStatistic, this._byteDepthStatistic, this._byteTotalEnqueuesStatistic, this._byteTotalDequeuesStatistic, this._byteTxnEnqueuesStatistic, this._byteTxnDequeuesStatistic, this._bytePersistEnqueuesStatistic, this._bytePersistDequeuesStatistic, this._msgFtdEnqueuesStatistic, this._msgFtdDequeuesStatistic, this._byteFtdEnqueuesStatistic, this._byteFtdDequeuesStatistic, this._msgFtdDepthStatistic, this._byteFtdDepthStatistic, this._releasesStatistic, this._acquiresStatistic, this._discardsTtlStatistic, this._discardsRingStatistic, this._discardsLvqStatistic, this._discardsOverflowStatistic, this._discardsSubscriberStatistic, this._discardsPurgeStatistic, this._reroutesStatistic, this._consumerCountStatistic, this._consumerCountHighStatistic, this._consumerCountLowStatistic, this._bindingCountStatistic, this._bindingCountHighStatistic, this._bindingCountLowStatistic, this._unackedMessagesStatistic, this._unackedMessagesHighStatistic, this._unackedMessagesLowStatistic, this._messageLatencySamplesStatistic, this._messageLatencyMaxStatistic, this._messageLatencyMinStatistic, this._messageLatencyAverageStatistic, this._flowStoppedStatistic, this._flowStoppedCountStatistic));
            this.setMethods(Arrays.asList(this._purgeMethod, this._rerouteMethod));
        }

        @Override
        public QueueObject newInstance(QueueDelegate delegate) {
            return new QueueObject(delegate);
        }

        public final class RerouteMethodResponseCommand
        extends QMFMethodResponseCommand {
            private RerouteMethodResponseCommand(QMFMethodRequestCommand cmd) {
                super(cmd, CompletionCode.OK, "OK");
            }

            private RerouteMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
            }
        }

        public final class RerouteMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private RerouteMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public RerouteMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new RerouteMethodResponseCommand(this._requestCmd, status, null);
            }

            public RerouteMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new RerouteMethodResponseCommand(this._requestCmd, status, msg);
            }

            public RerouteMethodResponseCommand createResponseCommand() {
                return new RerouteMethodResponseCommand(this._requestCmd);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class RerouteMethodInvocation
        implements QMFMethodInvocation<QueueObject> {
            private final Long _request;
            private final Boolean _useAltExchange;
            private final String _exchange;
            private final Map _filter;

            private RerouteMethodInvocation(Long request, Boolean useAltExchange, String exchange, Map filter) {
                this._request = request;
                this._useAltExchange = useAltExchange;
                this._exchange = exchange;
                this._filter = filter;
            }

            @Override
            public QMFMethodResponseCommand execute(QueueObject obj, QMFMethodRequestCommand cmd) {
                return obj.reroute(new RerouteMethodResponseCommandFactory(cmd), this._request, this._useAltExchange, this._exchange, this._filter);
            }

            public String toString() {
                return "RerouteMethod[request = " + this._request + ", " + "useAltExchange = " + this._useAltExchange + ", " + "exchange = " + this._exchange + ", " + "filter = " + this._filter + "]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class RerouteMethod
        extends QMFMethod<QueueObject> {
            private RerouteMethod() {
                super("reroute", "Remove all or some messages on this queue and route them to an exchange");
                QMFMethod.Argument request = new QMFMethod.Argument("request", QMFType.UINT32);
                request.setDescription("0 for all messages or n>0 for n messages");
                request.setDirection(QMFMethod.Direction.I);
                this.addArgument(request);
                QMFMethod.Argument useAltExchange = new QMFMethod.Argument("useAltExchange", QMFType.BOOLEAN);
                useAltExchange.setDescription("Iff true, use the queue's configured alternate exchange; iff false, use exchange named in the 'exchange' argument");
                useAltExchange.setDirection(QMFMethod.Direction.I);
                this.addArgument(useAltExchange);
                QMFMethod.Argument exchange = new QMFMethod.Argument("exchange", QMFType.STR8);
                exchange.setDescription("Name of the exchange to route the messages through");
                exchange.setDirection(QMFMethod.Direction.I);
                this.addArgument(exchange);
                QMFMethod.Argument filter = new QMFMethod.Argument("filter", QMFType.MAP);
                filter.setDescription("if specified, reroute only those messages matching this filter");
                filter.setDirection(QMFMethod.Direction.I);
                this.addArgument(filter);
            }

            public RerouteMethodInvocation parse(BBDecoder decoder) {
                Long request = decoder.readUint32();
                Boolean useAltExchange = decoder.readInt8() != 0;
                String exchange = decoder.readStr8();
                Map filter = decoder.readMap();
                return new RerouteMethodInvocation(request, useAltExchange, exchange, filter);
            }
        }

        public final class PurgeMethodResponseCommand
        extends QMFMethodResponseCommand {
            private PurgeMethodResponseCommand(QMFMethodRequestCommand cmd) {
                super(cmd, CompletionCode.OK, "OK");
            }

            private PurgeMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
            }
        }

        public final class PurgeMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private PurgeMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public PurgeMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new PurgeMethodResponseCommand(this._requestCmd, status, null);
            }

            public PurgeMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new PurgeMethodResponseCommand(this._requestCmd, status, msg);
            }

            public PurgeMethodResponseCommand createResponseCommand() {
                return new PurgeMethodResponseCommand(this._requestCmd);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class PurgeMethodInvocation
        implements QMFMethodInvocation<QueueObject> {
            private final Long _request;
            private final Map _filter;

            private PurgeMethodInvocation(Long request, Map filter) {
                this._request = request;
                this._filter = filter;
            }

            @Override
            public QMFMethodResponseCommand execute(QueueObject obj, QMFMethodRequestCommand cmd) {
                return obj.purge(new PurgeMethodResponseCommandFactory(cmd), this._request, this._filter);
            }

            public String toString() {
                return "PurgeMethod[request = " + this._request + ", " + "filter = " + this._filter + "]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class PurgeMethod
        extends QMFMethod<QueueObject> {
            private PurgeMethod() {
                super("purge", "Discard all or some messages on a queue");
                QMFMethod.Argument request = new QMFMethod.Argument("request", QMFType.UINT32);
                request.setDescription("0 for all messages or n>0 for n messages");
                request.setDirection(QMFMethod.Direction.I);
                this.addArgument(request);
                QMFMethod.Argument filter = new QMFMethod.Argument("filter", QMFType.MAP);
                filter.setDescription("if specified, purge only those messages matching this filter");
                filter.setDirection(QMFMethod.Direction.I);
                this.addArgument(filter);
            }

            public PurgeMethodInvocation parse(BBDecoder decoder) {
                Long request = decoder.readUint32();
                Map filter = decoder.readMap();
                return new PurgeMethodInvocation(request, filter);
            }
        }

        public class FlowStoppedCountStatistic
        extends QMFStatistic {
            private FlowStoppedCountStatistic() {
                super("flowStoppedCount", QMFType.UINT32, null, "Number of times flow control was activated for this queue");
            }
        }

        public class FlowStoppedStatistic
        extends QMFStatistic {
            private FlowStoppedStatistic() {
                super("flowStopped", QMFType.BOOLEAN, null, "Flow control active.");
            }
        }

        public class MessageLatencyAverageStatistic
        extends QMFStatistic {
            private MessageLatencyAverageStatistic() {
                super("messageLatencyAverage", QMFType.DELTATIME, "nanosecond", "Broker latency through this queue (Average)");
            }
        }

        public class MessageLatencyMinStatistic
        extends QMFStatistic {
            private MessageLatencyMinStatistic() {
                super("messageLatencyMin", QMFType.DELTATIME, "nanosecond", "Broker latency through this queue (Min)");
            }
        }

        public class MessageLatencyMaxStatistic
        extends QMFStatistic {
            private MessageLatencyMaxStatistic() {
                super("messageLatencyMax", QMFType.DELTATIME, "nanosecond", "Broker latency through this queue (Max)");
            }
        }

        public class MessageLatencySamplesStatistic
        extends QMFStatistic {
            private MessageLatencySamplesStatistic() {
                super("messageLatencySamples", QMFType.DELTATIME, "nanosecond", "Broker latency through this queue (Samples)");
            }
        }

        public class UnackedMessagesLowStatistic
        extends QMFStatistic {
            private UnackedMessagesLowStatistic() {
                super("unackedMessagesLow", QMFType.UINT32, "message", "Messages consumed but not yet acked (Low)");
            }
        }

        public class UnackedMessagesHighStatistic
        extends QMFStatistic {
            private UnackedMessagesHighStatistic() {
                super("unackedMessagesHigh", QMFType.UINT32, "message", "Messages consumed but not yet acked (High)");
            }
        }

        public class UnackedMessagesStatistic
        extends QMFStatistic {
            private UnackedMessagesStatistic() {
                super("unackedMessages", QMFType.UINT32, "message", "Messages consumed but not yet acked");
            }
        }

        public class BindingCountLowStatistic
        extends QMFStatistic {
            private BindingCountLowStatistic() {
                super("bindingCountLow", QMFType.UINT32, "binding", "Current bindings (Low)");
            }
        }

        public class BindingCountHighStatistic
        extends QMFStatistic {
            private BindingCountHighStatistic() {
                super("bindingCountHigh", QMFType.UINT32, "binding", "Current bindings (High)");
            }
        }

        public class BindingCountStatistic
        extends QMFStatistic {
            private BindingCountStatistic() {
                super("bindingCount", QMFType.UINT32, "binding", "Current bindings");
            }
        }

        public class ConsumerCountLowStatistic
        extends QMFStatistic {
            private ConsumerCountLowStatistic() {
                super("consumerCountLow", QMFType.UINT32, "consumer", "Current consumers on queue (Low)");
            }
        }

        public class ConsumerCountHighStatistic
        extends QMFStatistic {
            private ConsumerCountHighStatistic() {
                super("consumerCountHigh", QMFType.UINT32, "consumer", "Current consumers on queue (High)");
            }
        }

        public class ConsumerCountStatistic
        extends QMFStatistic {
            private ConsumerCountStatistic() {
                super("consumerCount", QMFType.UINT32, "consumer", "Current consumers on queue");
            }
        }

        public class ReroutesStatistic
        extends QMFStatistic {
            private ReroutesStatistic() {
                super("reroutes", QMFType.UINT64, "message", "Messages dequeued to management re-route");
            }
        }

        public class DiscardsPurgeStatistic
        extends QMFStatistic {
            private DiscardsPurgeStatistic() {
                super("discardsPurge", QMFType.UINT64, "message", "Messages discarded due to management purge");
            }
        }

        public class DiscardsSubscriberStatistic
        extends QMFStatistic {
            private DiscardsSubscriberStatistic() {
                super("discardsSubscriber", QMFType.UINT64, "message", "Messages discarded due to subscriber reject");
            }
        }

        public class DiscardsOverflowStatistic
        extends QMFStatistic {
            private DiscardsOverflowStatistic() {
                super("discardsOverflow", QMFType.UINT64, "message", "Messages discarded due to reject-policy overflow");
            }
        }

        public class DiscardsLvqStatistic
        extends QMFStatistic {
            private DiscardsLvqStatistic() {
                super("discardsLvq", QMFType.UINT64, "message", "Messages discarded due to LVQ insert");
            }
        }

        public class DiscardsRingStatistic
        extends QMFStatistic {
            private DiscardsRingStatistic() {
                super("discardsRing", QMFType.UINT64, "message", "Messages discarded due to ring-queue overflow");
            }
        }

        public class DiscardsTtlStatistic
        extends QMFStatistic {
            private DiscardsTtlStatistic() {
                super("discardsTtl", QMFType.UINT64, "message", "Messages discarded due to TTL expiration");
            }
        }

        public class AcquiresStatistic
        extends QMFStatistic {
            private AcquiresStatistic() {
                super("acquires", QMFType.UINT64, "message", "Messages acquired from the queue");
            }
        }

        public class ReleasesStatistic
        extends QMFStatistic {
            private ReleasesStatistic() {
                super("releases", QMFType.UINT64, "message", "Acquired messages reinserted into the queue");
            }
        }

        public class ByteFtdDepthStatistic
        extends QMFStatistic {
            private ByteFtdDepthStatistic() {
                super("byteFtdDepth", QMFType.UINT64, "octet", "Current number of bytes flowed-to-disk");
            }
        }

        public class MsgFtdDepthStatistic
        extends QMFStatistic {
            private MsgFtdDepthStatistic() {
                super("msgFtdDepth", QMFType.UINT64, "message", "Current number of messages flowed-to-disk");
            }
        }

        public class ByteFtdDequeuesStatistic
        extends QMFStatistic {
            private ByteFtdDequeuesStatistic() {
                super("byteFtdDequeues", QMFType.UINT64, "octet", "Total bytes dequeued from the broker having been flowed-to-disk");
            }
        }

        public class ByteFtdEnqueuesStatistic
        extends QMFStatistic {
            private ByteFtdEnqueuesStatistic() {
                super("byteFtdEnqueues", QMFType.UINT64, "octet", "Total bytes released from memory and flowed-to-disk on broker");
            }
        }

        public class MsgFtdDequeuesStatistic
        extends QMFStatistic {
            private MsgFtdDequeuesStatistic() {
                super("msgFtdDequeues", QMFType.UINT64, "message", "Total message bodies dequeued from the broker having been flowed-to-disk");
            }
        }

        public class MsgFtdEnqueuesStatistic
        extends QMFStatistic {
            private MsgFtdEnqueuesStatistic() {
                super("msgFtdEnqueues", QMFType.UINT64, "message", "Total message bodies released from memory and flowed-to-disk on broker");
            }
        }

        public class BytePersistDequeuesStatistic
        extends QMFStatistic {
            private BytePersistDequeuesStatistic() {
                super("bytePersistDequeues", QMFType.UINT64, "octet", "Persistent messages dequeued");
            }
        }

        public class BytePersistEnqueuesStatistic
        extends QMFStatistic {
            private BytePersistEnqueuesStatistic() {
                super("bytePersistEnqueues", QMFType.UINT64, "octet", "Persistent messages enqueued");
            }
        }

        public class ByteTxnDequeuesStatistic
        extends QMFStatistic {
            private ByteTxnDequeuesStatistic() {
                super("byteTxnDequeues", QMFType.UINT64, "octet", "Transactional messages dequeued");
            }
        }

        public class ByteTxnEnqueuesStatistic
        extends QMFStatistic {
            private ByteTxnEnqueuesStatistic() {
                super("byteTxnEnqueues", QMFType.UINT64, "octet", "Transactional messages enqueued");
            }
        }

        public class ByteTotalDequeuesStatistic
        extends QMFStatistic {
            private ByteTotalDequeuesStatistic() {
                super("byteTotalDequeues", QMFType.UINT64, "octet", "Total messages dequeued");
            }
        }

        public class ByteTotalEnqueuesStatistic
        extends QMFStatistic {
            private ByteTotalEnqueuesStatistic() {
                super("byteTotalEnqueues", QMFType.UINT64, "octet", "Total messages enqueued");
            }
        }

        public class ByteDepthStatistic
        extends QMFStatistic {
            private ByteDepthStatistic() {
                super("byteDepth", QMFType.UINT64, "octet", "Current size of queue in bytes");
            }
        }

        public class MsgDepthStatistic
        extends QMFStatistic {
            private MsgDepthStatistic() {
                super("msgDepth", QMFType.UINT64, "message", "Current size of queue in messages");
            }
        }

        public class MsgPersistDequeuesStatistic
        extends QMFStatistic {
            private MsgPersistDequeuesStatistic() {
                super("msgPersistDequeues", QMFType.UINT64, "message", "Persistent messages dequeued");
            }
        }

        public class MsgPersistEnqueuesStatistic
        extends QMFStatistic {
            private MsgPersistEnqueuesStatistic() {
                super("msgPersistEnqueues", QMFType.UINT64, "message", "Persistent messages enqueued");
            }
        }

        public class MsgTxnDequeuesStatistic
        extends QMFStatistic {
            private MsgTxnDequeuesStatistic() {
                super("msgTxnDequeues", QMFType.UINT64, "message", "Transactional messages dequeued");
            }
        }

        public class MsgTxnEnqueuesStatistic
        extends QMFStatistic {
            private MsgTxnEnqueuesStatistic() {
                super("msgTxnEnqueues", QMFType.UINT64, "message", "Transactional messages enqueued");
            }
        }

        public class MsgTotalDequeuesStatistic
        extends QMFStatistic {
            private MsgTotalDequeuesStatistic() {
                super("msgTotalDequeues", QMFType.UINT64, "message", "Total messages dequeued");
            }
        }

        public class MsgTotalEnqueuesStatistic
        extends QMFStatistic {
            private MsgTotalEnqueuesStatistic() {
                super("msgTotalEnqueues", QMFType.UINT64, "message", "Total messages enqueued");
            }
        }

        public class AltExchangeProperty
        extends QMFProperty {
            private AltExchangeProperty() {
                super("altExchange", QMFType.OBJECTREFERENCE, QMFProperty.AccessCode.RO, false, true);
                this.setReferencedClass("exchange");
            }
        }

        public class ArgumentsProperty
        extends QMFProperty {
            private ArgumentsProperty() {
                super("arguments", QMFType.MAP, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Arguments supplied in queue.declare");
            }
        }

        public class ExclusiveProperty
        extends QMFProperty {
            private ExclusiveProperty() {
                super("exclusive", QMFType.BOOLEAN, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class AutoDeleteProperty
        extends QMFProperty {
            private AutoDeleteProperty() {
                super("autoDelete", QMFType.BOOLEAN, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class DurableProperty
        extends QMFProperty {
            private DurableProperty() {
                super("durable", QMFType.BOOLEAN, QMFProperty.AccessCode.RC, false, false);
            }
        }

        public class NameProperty
        extends QMFProperty {
            private NameProperty() {
                super("name", QMFType.STR8, QMFProperty.AccessCode.RC, true, false);
            }
        }

        public class VhostRefProperty
        extends QMFProperty {
            private VhostRefProperty() {
                super("vhostRef", QMFType.OBJECTREFERENCE, QMFProperty.AccessCode.RC, true, false);
                this.setReferencedClass("vhost");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFVhostGetQueryResponseCommand
    extends QMFGetQueryResponseCommand<VhostObject> {
        protected QMFVhostGetQueryResponseCommand(VhostObject object, QMFGetQueryCommand cmd, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, cmd, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeBin128(((VhostObject)this.getObject()).getBrokerRef().getId());
            encoder.writeStr8(((VhostObject)this.getObject()).getName());
            encoder.writeStr8(((VhostObject)this.getObject()).getFederationTag());
        }

        public String toString() {
            return "QMFVhostGetQueryResponseCommand{id=" + ((VhostObject)this.getObject()).getId() + ", brokerRef=" + ((VhostObject)this.getObject()).getBrokerRef() + ", name=" + ((VhostObject)this.getObject()).getName() + ", federationTag=" + ((VhostObject)this.getObject()).getFederationTag() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFVhostInstrumentInfoCommand
    extends QMFInstrumentInfoCommand<VhostObject> {
        protected QMFVhostInstrumentInfoCommand(VhostObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFVhostConfigInfoCommand
    extends QMFConfigInfoCommand<VhostObject> {
        protected QMFVhostConfigInfoCommand(VhostObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeBin128(((VhostObject)this.getObject()).getBrokerRef().getId());
            encoder.writeStr8(((VhostObject)this.getObject()).getName());
            encoder.writeStr8(((VhostObject)this.getObject()).getFederationTag());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class VhostObject
    extends QMFObject<VhostClass, VhostDelegate> {
        protected VhostObject(VhostDelegate delegate) {
            super(delegate);
        }

        @Override
        public VhostClass getQMFClass() {
            return BrokerSchema.this._vhostClass;
        }

        @Override
        public QMFCommand asConfigInfoCmd(long sampleTime) {
            return new QMFVhostConfigInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asInstrumentInfoCmd(long sampleTime) {
            return new QMFVhostInstrumentInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asGetQueryResponseCmd(QMFGetQueryCommand queryCommand, long sampleTime) {
            return new QMFVhostGetQueryResponseCommand(this, queryCommand, sampleTime);
        }

        public BrokerObject getBrokerRef() {
            return ((VhostDelegate)this.getDelegate()).getBrokerRef();
        }

        public String getName() {
            return ((VhostDelegate)this.getDelegate()).getName();
        }

        public String getFederationTag() {
            return ((VhostDelegate)this.getDelegate()).getFederationTag();
        }
    }

    public static interface VhostDelegate
    extends QMFObject.Delegate {
        public BrokerObject getBrokerRef();

        public String getName();

        public String getFederationTag();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VhostClass
    extends QMFObjectClass<VhostObject, VhostDelegate> {
        private final BrokerRefProperty _brokerRefProperty;
        private final NameProperty _nameProperty;
        private final FederationTagProperty _federationTagProperty;

        private VhostClass() {
            super("vhost", new byte[16]);
            this._brokerRefProperty = new BrokerRefProperty();
            this._nameProperty = new NameProperty();
            this._federationTagProperty = new FederationTagProperty();
            this.setProperties(Arrays.asList(this._brokerRefProperty, this._nameProperty, this._federationTagProperty));
            this.setStatistics(Arrays.asList(new QMFStatistic[0]));
            this.setMethods(Arrays.asList(new QMFMethod[0]));
        }

        @Override
        public VhostObject newInstance(VhostDelegate delegate) {
            return new VhostObject(delegate);
        }

        public class FederationTagProperty
        extends QMFProperty {
            private FederationTagProperty() {
                super("federationTag", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
            }
        }

        public class NameProperty
        extends QMFProperty {
            private NameProperty() {
                super("name", QMFType.STR8, QMFProperty.AccessCode.RC, true, false);
            }
        }

        public class BrokerRefProperty
        extends QMFProperty {
            private BrokerRefProperty() {
                super("brokerRef", QMFType.OBJECTREFERENCE, QMFProperty.AccessCode.RC, true, false);
                this.setReferencedClass("broker");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFAgentGetQueryResponseCommand
    extends QMFGetQueryResponseCommand<AgentObject> {
        protected QMFAgentGetQueryResponseCommand(AgentObject object, QMFGetQueryCommand cmd, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, cmd, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeBin128(((AgentObject)this.getObject()).getConnectionRef().getId());
            encoder.writeStr8(((AgentObject)this.getObject()).getLabel());
            encoder.writeBin128(((AgentObject)this.getObject()).getRegisteredTo().getId());
            encoder.writeUuid(((AgentObject)this.getObject()).getSystemId());
            encoder.writeUint32(((AgentObject)this.getObject()).getBrokerBank().longValue());
            encoder.writeUint32(((AgentObject)this.getObject()).getAgentBank().longValue());
        }

        public String toString() {
            return "QMFAgentGetQueryResponseCommand{id=" + ((AgentObject)this.getObject()).getId() + ", connectionRef=" + ((AgentObject)this.getObject()).getConnectionRef() + ", label=" + ((AgentObject)this.getObject()).getLabel() + ", registeredTo=" + ((AgentObject)this.getObject()).getRegisteredTo() + ", systemId=" + ((AgentObject)this.getObject()).getSystemId() + ", brokerBank=" + ((AgentObject)this.getObject()).getBrokerBank() + ", agentBank=" + ((AgentObject)this.getObject()).getAgentBank() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFAgentInstrumentInfoCommand
    extends QMFInstrumentInfoCommand<AgentObject> {
        protected QMFAgentInstrumentInfoCommand(AgentObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFAgentConfigInfoCommand
    extends QMFConfigInfoCommand<AgentObject> {
        protected QMFAgentConfigInfoCommand(AgentObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeBin128(((AgentObject)this.getObject()).getConnectionRef().getId());
            encoder.writeStr8(((AgentObject)this.getObject()).getLabel());
            encoder.writeBin128(((AgentObject)this.getObject()).getRegisteredTo().getId());
            encoder.writeUuid(((AgentObject)this.getObject()).getSystemId());
            encoder.writeUint32(((AgentObject)this.getObject()).getBrokerBank().longValue());
            encoder.writeUint32(((AgentObject)this.getObject()).getAgentBank().longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class AgentObject
    extends QMFObject<AgentClass, AgentDelegate> {
        protected AgentObject(AgentDelegate delegate) {
            super(delegate);
        }

        @Override
        public AgentClass getQMFClass() {
            return BrokerSchema.this._agentClass;
        }

        @Override
        public QMFCommand asConfigInfoCmd(long sampleTime) {
            return new QMFAgentConfigInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asInstrumentInfoCmd(long sampleTime) {
            return new QMFAgentInstrumentInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asGetQueryResponseCmd(QMFGetQueryCommand queryCommand, long sampleTime) {
            return new QMFAgentGetQueryResponseCommand(this, queryCommand, sampleTime);
        }

        public ConnectionObject getConnectionRef() {
            return ((AgentDelegate)this.getDelegate()).getConnectionRef();
        }

        public String getLabel() {
            return ((AgentDelegate)this.getDelegate()).getLabel();
        }

        public BrokerObject getRegisteredTo() {
            return ((AgentDelegate)this.getDelegate()).getRegisteredTo();
        }

        public UUID getSystemId() {
            return ((AgentDelegate)this.getDelegate()).getSystemId();
        }

        public Long getBrokerBank() {
            return ((AgentDelegate)this.getDelegate()).getBrokerBank();
        }

        public Long getAgentBank() {
            return ((AgentDelegate)this.getDelegate()).getAgentBank();
        }
    }

    public static interface AgentDelegate
    extends QMFObject.Delegate {
        public ConnectionObject getConnectionRef();

        public String getLabel();

        public BrokerObject getRegisteredTo();

        public UUID getSystemId();

        public Long getBrokerBank();

        public Long getAgentBank();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AgentClass
    extends QMFObjectClass<AgentObject, AgentDelegate> {
        private final ConnectionRefProperty _connectionRefProperty;
        private final LabelProperty _labelProperty;
        private final RegisteredToProperty _registeredToProperty;
        private final SystemIdProperty _systemIdProperty;
        private final BrokerBankProperty _brokerBankProperty;
        private final AgentBankProperty _agentBankProperty;

        private AgentClass() {
            super("agent", new byte[16]);
            this._connectionRefProperty = new ConnectionRefProperty();
            this._labelProperty = new LabelProperty();
            this._registeredToProperty = new RegisteredToProperty();
            this._systemIdProperty = new SystemIdProperty();
            this._brokerBankProperty = new BrokerBankProperty();
            this._agentBankProperty = new AgentBankProperty();
            this.setProperties(Arrays.asList(this._connectionRefProperty, this._labelProperty, this._registeredToProperty, this._systemIdProperty, this._brokerBankProperty, this._agentBankProperty));
            this.setStatistics(Arrays.asList(new QMFStatistic[0]));
            this.setMethods(Arrays.asList(new QMFMethod[0]));
        }

        @Override
        public AgentObject newInstance(AgentDelegate delegate) {
            return new AgentObject(delegate);
        }

        public class AgentBankProperty
        extends QMFProperty {
            private AgentBankProperty() {
                super("agentBank", QMFType.UINT32, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Assigned object-id agent bank");
            }
        }

        public class BrokerBankProperty
        extends QMFProperty {
            private BrokerBankProperty() {
                super("brokerBank", QMFType.UINT32, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Assigned object-id broker bank");
            }
        }

        public class SystemIdProperty
        extends QMFProperty {
            private SystemIdProperty() {
                super("systemId", QMFType.UUID, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Identifier of system where agent resides");
            }
        }

        public class RegisteredToProperty
        extends QMFProperty {
            private RegisteredToProperty() {
                super("registeredTo", QMFType.OBJECTREFERENCE, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Broker agent is registered to");
                this.setReferencedClass("broker");
            }
        }

        public class LabelProperty
        extends QMFProperty {
            private LabelProperty() {
                super("label", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Label for agent");
            }
        }

        public class ConnectionRefProperty
        extends QMFProperty {
            private ConnectionRefProperty() {
                super("connectionRef", QMFType.OBJECTREFERENCE, QMFProperty.AccessCode.RO, true, false);
                this.setReferencedClass("connection");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFBrokerGetQueryResponseCommand
    extends QMFGetQueryResponseCommand<BrokerObject> {
        protected QMFBrokerGetQueryResponseCommand(BrokerObject object, QMFGetQueryCommand cmd, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, cmd, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            byte presence0 = 0;
            if (((BrokerObject)this.getObject()).getDataDir() != null) {
                presence0 = (byte)(presence0 | 1);
            }
            encoder.writeUint8((short)presence0);
            encoder.writeStr8(((BrokerObject)this.getObject()).getName());
            encoder.writeBin128(((BrokerObject)this.getObject()).getSystemRef().getId());
            encoder.writeUint16(((BrokerObject)this.getObject()).getPort().intValue());
            encoder.writeUint16(((BrokerObject)this.getObject()).getWorkerThreads().intValue());
            encoder.writeUint16(((BrokerObject)this.getObject()).getConnBacklog().intValue());
            encoder.writeUint32(((BrokerObject)this.getObject()).getStagingThreshold().longValue());
            encoder.writeInt8(((BrokerObject)this.getObject()).getMgmtPublish() != false ? (byte)-1 : 0);
            encoder.writeUint16(((BrokerObject)this.getObject()).getMgmtPubInterval().intValue());
            encoder.writeStr8(((BrokerObject)this.getObject()).getVersion());
            if (((BrokerObject)this.getObject()).getDataDir() != null) {
                encoder.writeStr16(((BrokerObject)this.getObject()).getDataDir());
            }
            encoder.writeUint64(((BrokerObject)this.getObject()).getUptime().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getQueueCount().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgTotalEnqueues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgTotalDequeues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getByteTotalEnqueues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getByteTotalDequeues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgDepth().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getByteDepth().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgPersistEnqueues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgPersistDequeues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getBytePersistEnqueues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getBytePersistDequeues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgTxnEnqueues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgTxnDequeues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getByteTxnEnqueues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getByteTxnDequeues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgFtdEnqueues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgFtdDequeues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getByteFtdEnqueues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getByteFtdDequeues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgFtdDepth().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getByteFtdDepth().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getReleases().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getAcquires().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getDiscardsNoRoute().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getDiscardsTtl().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getDiscardsRing().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getDiscardsLvq().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getDiscardsOverflow().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getDiscardsSubscriber().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getDiscardsPurge().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getReroutes().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getAbandoned().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getAbandonedViaAlt().longValue());
        }

        public String toString() {
            return "QMFBrokerGetQueryResponseCommand{id=" + ((BrokerObject)this.getObject()).getId() + ", name=" + ((BrokerObject)this.getObject()).getName() + ", systemRef=" + ((BrokerObject)this.getObject()).getSystemRef() + ", port=" + ((BrokerObject)this.getObject()).getPort() + ", workerThreads=" + ((BrokerObject)this.getObject()).getWorkerThreads() + ", connBacklog=" + ((BrokerObject)this.getObject()).getConnBacklog() + ", stagingThreshold=" + ((BrokerObject)this.getObject()).getStagingThreshold() + ", mgmtPublish=" + ((BrokerObject)this.getObject()).getMgmtPublish() + ", mgmtPubInterval=" + ((BrokerObject)this.getObject()).getMgmtPubInterval() + ", version=" + ((BrokerObject)this.getObject()).getVersion() + ", dataDir=" + ((BrokerObject)this.getObject()).getDataDir() + ", uptime=" + ((BrokerObject)this.getObject()).getUptime() + ", queueCount=" + ((BrokerObject)this.getObject()).getQueueCount() + ", msgTotalEnqueues=" + ((BrokerObject)this.getObject()).getMsgTotalEnqueues() + ", msgTotalDequeues=" + ((BrokerObject)this.getObject()).getMsgTotalDequeues() + ", byteTotalEnqueues=" + ((BrokerObject)this.getObject()).getByteTotalEnqueues() + ", byteTotalDequeues=" + ((BrokerObject)this.getObject()).getByteTotalDequeues() + ", msgDepth=" + ((BrokerObject)this.getObject()).getMsgDepth() + ", byteDepth=" + ((BrokerObject)this.getObject()).getByteDepth() + ", msgPersistEnqueues=" + ((BrokerObject)this.getObject()).getMsgPersistEnqueues() + ", msgPersistDequeues=" + ((BrokerObject)this.getObject()).getMsgPersistDequeues() + ", bytePersistEnqueues=" + ((BrokerObject)this.getObject()).getBytePersistEnqueues() + ", bytePersistDequeues=" + ((BrokerObject)this.getObject()).getBytePersistDequeues() + ", msgTxnEnqueues=" + ((BrokerObject)this.getObject()).getMsgTxnEnqueues() + ", msgTxnDequeues=" + ((BrokerObject)this.getObject()).getMsgTxnDequeues() + ", byteTxnEnqueues=" + ((BrokerObject)this.getObject()).getByteTxnEnqueues() + ", byteTxnDequeues=" + ((BrokerObject)this.getObject()).getByteTxnDequeues() + ", msgFtdEnqueues=" + ((BrokerObject)this.getObject()).getMsgFtdEnqueues() + ", msgFtdDequeues=" + ((BrokerObject)this.getObject()).getMsgFtdDequeues() + ", byteFtdEnqueues=" + ((BrokerObject)this.getObject()).getByteFtdEnqueues() + ", byteFtdDequeues=" + ((BrokerObject)this.getObject()).getByteFtdDequeues() + ", msgFtdDepth=" + ((BrokerObject)this.getObject()).getMsgFtdDepth() + ", byteFtdDepth=" + ((BrokerObject)this.getObject()).getByteFtdDepth() + ", releases=" + ((BrokerObject)this.getObject()).getReleases() + ", acquires=" + ((BrokerObject)this.getObject()).getAcquires() + ", discardsNoRoute=" + ((BrokerObject)this.getObject()).getDiscardsNoRoute() + ", discardsTtl=" + ((BrokerObject)this.getObject()).getDiscardsTtl() + ", discardsRing=" + ((BrokerObject)this.getObject()).getDiscardsRing() + ", discardsLvq=" + ((BrokerObject)this.getObject()).getDiscardsLvq() + ", discardsOverflow=" + ((BrokerObject)this.getObject()).getDiscardsOverflow() + ", discardsSubscriber=" + ((BrokerObject)this.getObject()).getDiscardsSubscriber() + ", discardsPurge=" + ((BrokerObject)this.getObject()).getDiscardsPurge() + ", reroutes=" + ((BrokerObject)this.getObject()).getReroutes() + ", abandoned=" + ((BrokerObject)this.getObject()).getAbandoned() + ", abandonedViaAlt=" + ((BrokerObject)this.getObject()).getAbandonedViaAlt() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFBrokerInstrumentInfoCommand
    extends QMFInstrumentInfoCommand<BrokerObject> {
        protected QMFBrokerInstrumentInfoCommand(BrokerObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeUint64(((BrokerObject)this.getObject()).getUptime().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getQueueCount().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgTotalEnqueues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgTotalDequeues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getByteTotalEnqueues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getByteTotalDequeues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgDepth().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getByteDepth().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgPersistEnqueues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgPersistDequeues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getBytePersistEnqueues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getBytePersistDequeues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgTxnEnqueues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgTxnDequeues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getByteTxnEnqueues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getByteTxnDequeues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgFtdEnqueues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgFtdDequeues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getByteFtdEnqueues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getByteFtdDequeues().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getMsgFtdDepth().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getByteFtdDepth().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getReleases().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getAcquires().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getDiscardsNoRoute().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getDiscardsTtl().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getDiscardsRing().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getDiscardsLvq().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getDiscardsOverflow().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getDiscardsSubscriber().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getDiscardsPurge().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getReroutes().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getAbandoned().longValue());
            encoder.writeUint64(((BrokerObject)this.getObject()).getAbandonedViaAlt().longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFBrokerConfigInfoCommand
    extends QMFConfigInfoCommand<BrokerObject> {
        protected QMFBrokerConfigInfoCommand(BrokerObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            byte presence0 = 0;
            if (((BrokerObject)this.getObject()).getDataDir() != null) {
                presence0 = (byte)(presence0 | 1);
            }
            encoder.writeUint8((short)presence0);
            encoder.writeStr8(((BrokerObject)this.getObject()).getName());
            encoder.writeBin128(((BrokerObject)this.getObject()).getSystemRef().getId());
            encoder.writeUint16(((BrokerObject)this.getObject()).getPort().intValue());
            encoder.writeUint16(((BrokerObject)this.getObject()).getWorkerThreads().intValue());
            encoder.writeUint16(((BrokerObject)this.getObject()).getConnBacklog().intValue());
            encoder.writeUint32(((BrokerObject)this.getObject()).getStagingThreshold().longValue());
            encoder.writeInt8(((BrokerObject)this.getObject()).getMgmtPublish() != false ? (byte)-1 : 0);
            encoder.writeUint16(((BrokerObject)this.getObject()).getMgmtPubInterval().intValue());
            encoder.writeStr8(((BrokerObject)this.getObject()).getVersion());
            if (((BrokerObject)this.getObject()).getDataDir() != null) {
                encoder.writeStr16(((BrokerObject)this.getObject()).getDataDir());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class BrokerObject
    extends QMFObject<BrokerClass, BrokerDelegate> {
        protected BrokerObject(BrokerDelegate delegate) {
            super(delegate);
        }

        @Override
        public BrokerClass getQMFClass() {
            return BrokerSchema.this._brokerClass;
        }

        @Override
        public QMFCommand asConfigInfoCmd(long sampleTime) {
            return new QMFBrokerConfigInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asInstrumentInfoCmd(long sampleTime) {
            return new QMFBrokerInstrumentInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asGetQueryResponseCmd(QMFGetQueryCommand queryCommand, long sampleTime) {
            return new QMFBrokerGetQueryResponseCommand(this, queryCommand, sampleTime);
        }

        public BrokerClass.EchoMethodResponseCommand echo(BrokerClass.EchoMethodResponseCommandFactory factory, Long sequence, String body) {
            return ((BrokerDelegate)this.getDelegate()).echo(factory, sequence, body);
        }

        public BrokerClass.ConnectMethodResponseCommand connect(BrokerClass.ConnectMethodResponseCommandFactory factory, String host, Long port, Boolean durable, String authMechanism, String username, String password, String transport) {
            return ((BrokerDelegate)this.getDelegate()).connect(factory, host, port, durable, authMechanism, username, password, transport);
        }

        public BrokerClass.QueueMoveMessagesMethodResponseCommand queueMoveMessages(BrokerClass.QueueMoveMessagesMethodResponseCommandFactory factory, String srcQueue, String destQueue, Long qty, Map filter) {
            return ((BrokerDelegate)this.getDelegate()).queueMoveMessages(factory, srcQueue, destQueue, qty, filter);
        }

        public BrokerClass.SetLogLevelMethodResponseCommand setLogLevel(BrokerClass.SetLogLevelMethodResponseCommandFactory factory, String level) {
            return ((BrokerDelegate)this.getDelegate()).setLogLevel(factory, level);
        }

        public BrokerClass.GetLogLevelMethodResponseCommand getLogLevel(BrokerClass.GetLogLevelMethodResponseCommandFactory factory) {
            return ((BrokerDelegate)this.getDelegate()).getLogLevel(factory);
        }

        public BrokerClass.GetTimestampConfigMethodResponseCommand getTimestampConfig(BrokerClass.GetTimestampConfigMethodResponseCommandFactory factory) {
            return ((BrokerDelegate)this.getDelegate()).getTimestampConfig(factory);
        }

        public BrokerClass.SetTimestampConfigMethodResponseCommand setTimestampConfig(BrokerClass.SetTimestampConfigMethodResponseCommandFactory factory, Boolean receive) {
            return ((BrokerDelegate)this.getDelegate()).setTimestampConfig(factory, receive);
        }

        public BrokerClass.CreateMethodResponseCommand create(BrokerClass.CreateMethodResponseCommandFactory factory, String type, String name, Map properties, Boolean strict) {
            return ((BrokerDelegate)this.getDelegate()).create(factory, type, name, properties, strict);
        }

        public BrokerClass.DeleteMethodResponseCommand delete(BrokerClass.DeleteMethodResponseCommandFactory factory, String type, String name, Map options) {
            return ((BrokerDelegate)this.getDelegate()).delete(factory, type, name, options);
        }

        public BrokerClass.QueryMethodResponseCommand query(BrokerClass.QueryMethodResponseCommandFactory factory, String type, String name) {
            return ((BrokerDelegate)this.getDelegate()).query(factory, type, name);
        }

        public String getName() {
            return ((BrokerDelegate)this.getDelegate()).getName();
        }

        public SystemObject getSystemRef() {
            return ((BrokerDelegate)this.getDelegate()).getSystemRef();
        }

        public Integer getPort() {
            return ((BrokerDelegate)this.getDelegate()).getPort();
        }

        public Integer getWorkerThreads() {
            return ((BrokerDelegate)this.getDelegate()).getWorkerThreads();
        }

        public Integer getConnBacklog() {
            return ((BrokerDelegate)this.getDelegate()).getConnBacklog();
        }

        public Long getStagingThreshold() {
            return ((BrokerDelegate)this.getDelegate()).getStagingThreshold();
        }

        public Boolean getMgmtPublish() {
            return ((BrokerDelegate)this.getDelegate()).getMgmtPublish();
        }

        public Integer getMgmtPubInterval() {
            return ((BrokerDelegate)this.getDelegate()).getMgmtPubInterval();
        }

        public String getVersion() {
            return ((BrokerDelegate)this.getDelegate()).getVersion();
        }

        public String getDataDir() {
            return ((BrokerDelegate)this.getDelegate()).getDataDir();
        }

        public Long getUptime() {
            return ((BrokerDelegate)this.getDelegate()).getUptime();
        }

        public Long getQueueCount() {
            return ((BrokerDelegate)this.getDelegate()).getQueueCount();
        }

        public Long getMsgTotalEnqueues() {
            return ((BrokerDelegate)this.getDelegate()).getMsgTotalEnqueues();
        }

        public Long getMsgTotalDequeues() {
            return ((BrokerDelegate)this.getDelegate()).getMsgTotalDequeues();
        }

        public Long getByteTotalEnqueues() {
            return ((BrokerDelegate)this.getDelegate()).getByteTotalEnqueues();
        }

        public Long getByteTotalDequeues() {
            return ((BrokerDelegate)this.getDelegate()).getByteTotalDequeues();
        }

        public Long getMsgDepth() {
            return ((BrokerDelegate)this.getDelegate()).getMsgDepth();
        }

        public Long getByteDepth() {
            return ((BrokerDelegate)this.getDelegate()).getByteDepth();
        }

        public Long getMsgPersistEnqueues() {
            return ((BrokerDelegate)this.getDelegate()).getMsgPersistEnqueues();
        }

        public Long getMsgPersistDequeues() {
            return ((BrokerDelegate)this.getDelegate()).getMsgPersistDequeues();
        }

        public Long getBytePersistEnqueues() {
            return ((BrokerDelegate)this.getDelegate()).getBytePersistEnqueues();
        }

        public Long getBytePersistDequeues() {
            return ((BrokerDelegate)this.getDelegate()).getBytePersistDequeues();
        }

        public Long getMsgTxnEnqueues() {
            return ((BrokerDelegate)this.getDelegate()).getMsgTxnEnqueues();
        }

        public Long getMsgTxnDequeues() {
            return ((BrokerDelegate)this.getDelegate()).getMsgTxnDequeues();
        }

        public Long getByteTxnEnqueues() {
            return ((BrokerDelegate)this.getDelegate()).getByteTxnEnqueues();
        }

        public Long getByteTxnDequeues() {
            return ((BrokerDelegate)this.getDelegate()).getByteTxnDequeues();
        }

        public Long getMsgFtdEnqueues() {
            return ((BrokerDelegate)this.getDelegate()).getMsgFtdEnqueues();
        }

        public Long getMsgFtdDequeues() {
            return ((BrokerDelegate)this.getDelegate()).getMsgFtdDequeues();
        }

        public Long getByteFtdEnqueues() {
            return ((BrokerDelegate)this.getDelegate()).getByteFtdEnqueues();
        }

        public Long getByteFtdDequeues() {
            return ((BrokerDelegate)this.getDelegate()).getByteFtdDequeues();
        }

        public Long getMsgFtdDepth() {
            return ((BrokerDelegate)this.getDelegate()).getMsgFtdDepth();
        }

        public Long getByteFtdDepth() {
            return ((BrokerDelegate)this.getDelegate()).getByteFtdDepth();
        }

        public Long getReleases() {
            return ((BrokerDelegate)this.getDelegate()).getReleases();
        }

        public Long getAcquires() {
            return ((BrokerDelegate)this.getDelegate()).getAcquires();
        }

        public Long getDiscardsNoRoute() {
            return ((BrokerDelegate)this.getDelegate()).getDiscardsNoRoute();
        }

        public Long getDiscardsTtl() {
            return ((BrokerDelegate)this.getDelegate()).getDiscardsTtl();
        }

        public Long getDiscardsRing() {
            return ((BrokerDelegate)this.getDelegate()).getDiscardsRing();
        }

        public Long getDiscardsLvq() {
            return ((BrokerDelegate)this.getDelegate()).getDiscardsLvq();
        }

        public Long getDiscardsOverflow() {
            return ((BrokerDelegate)this.getDelegate()).getDiscardsOverflow();
        }

        public Long getDiscardsSubscriber() {
            return ((BrokerDelegate)this.getDelegate()).getDiscardsSubscriber();
        }

        public Long getDiscardsPurge() {
            return ((BrokerDelegate)this.getDelegate()).getDiscardsPurge();
        }

        public Long getReroutes() {
            return ((BrokerDelegate)this.getDelegate()).getReroutes();
        }

        public Long getAbandoned() {
            return ((BrokerDelegate)this.getDelegate()).getAbandoned();
        }

        public Long getAbandonedViaAlt() {
            return ((BrokerDelegate)this.getDelegate()).getAbandonedViaAlt();
        }
    }

    public static interface BrokerDelegate
    extends QMFObject.Delegate {
        public String getName();

        public SystemObject getSystemRef();

        public Integer getPort();

        public Integer getWorkerThreads();

        public Integer getConnBacklog();

        public Long getStagingThreshold();

        public Boolean getMgmtPublish();

        public Integer getMgmtPubInterval();

        public String getVersion();

        public String getDataDir();

        public Long getUptime();

        public Long getQueueCount();

        public Long getMsgTotalEnqueues();

        public Long getMsgTotalDequeues();

        public Long getByteTotalEnqueues();

        public Long getByteTotalDequeues();

        public Long getMsgDepth();

        public Long getByteDepth();

        public Long getMsgPersistEnqueues();

        public Long getMsgPersistDequeues();

        public Long getBytePersistEnqueues();

        public Long getBytePersistDequeues();

        public Long getMsgTxnEnqueues();

        public Long getMsgTxnDequeues();

        public Long getByteTxnEnqueues();

        public Long getByteTxnDequeues();

        public Long getMsgFtdEnqueues();

        public Long getMsgFtdDequeues();

        public Long getByteFtdEnqueues();

        public Long getByteFtdDequeues();

        public Long getMsgFtdDepth();

        public Long getByteFtdDepth();

        public Long getReleases();

        public Long getAcquires();

        public Long getDiscardsNoRoute();

        public Long getDiscardsTtl();

        public Long getDiscardsRing();

        public Long getDiscardsLvq();

        public Long getDiscardsOverflow();

        public Long getDiscardsSubscriber();

        public Long getDiscardsPurge();

        public Long getReroutes();

        public Long getAbandoned();

        public Long getAbandonedViaAlt();

        public BrokerClass.EchoMethodResponseCommand echo(BrokerClass.EchoMethodResponseCommandFactory var1, Long var2, String var3);

        public BrokerClass.ConnectMethodResponseCommand connect(BrokerClass.ConnectMethodResponseCommandFactory var1, String var2, Long var3, Boolean var4, String var5, String var6, String var7, String var8);

        public BrokerClass.QueueMoveMessagesMethodResponseCommand queueMoveMessages(BrokerClass.QueueMoveMessagesMethodResponseCommandFactory var1, String var2, String var3, Long var4, Map var5);

        public BrokerClass.SetLogLevelMethodResponseCommand setLogLevel(BrokerClass.SetLogLevelMethodResponseCommandFactory var1, String var2);

        public BrokerClass.GetLogLevelMethodResponseCommand getLogLevel(BrokerClass.GetLogLevelMethodResponseCommandFactory var1);

        public BrokerClass.GetTimestampConfigMethodResponseCommand getTimestampConfig(BrokerClass.GetTimestampConfigMethodResponseCommandFactory var1);

        public BrokerClass.SetTimestampConfigMethodResponseCommand setTimestampConfig(BrokerClass.SetTimestampConfigMethodResponseCommandFactory var1, Boolean var2);

        public BrokerClass.CreateMethodResponseCommand create(BrokerClass.CreateMethodResponseCommandFactory var1, String var2, String var3, Map var4, Boolean var5);

        public BrokerClass.DeleteMethodResponseCommand delete(BrokerClass.DeleteMethodResponseCommandFactory var1, String var2, String var3, Map var4);

        public BrokerClass.QueryMethodResponseCommand query(BrokerClass.QueryMethodResponseCommandFactory var1, String var2, String var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BrokerClass
    extends QMFObjectClass<BrokerObject, BrokerDelegate> {
        private final NameProperty _nameProperty;
        private final SystemRefProperty _systemRefProperty;
        private final PortProperty _portProperty;
        private final WorkerThreadsProperty _workerThreadsProperty;
        private final ConnBacklogProperty _connBacklogProperty;
        private final StagingThresholdProperty _stagingThresholdProperty;
        private final MgmtPublishProperty _mgmtPublishProperty;
        private final MgmtPubIntervalProperty _mgmtPubIntervalProperty;
        private final VersionProperty _versionProperty;
        private final DataDirProperty _dataDirProperty;
        private final UptimeStatistic _uptimeStatistic;
        private final QueueCountStatistic _queueCountStatistic;
        private final MsgTotalEnqueuesStatistic _msgTotalEnqueuesStatistic;
        private final MsgTotalDequeuesStatistic _msgTotalDequeuesStatistic;
        private final ByteTotalEnqueuesStatistic _byteTotalEnqueuesStatistic;
        private final ByteTotalDequeuesStatistic _byteTotalDequeuesStatistic;
        private final MsgDepthStatistic _msgDepthStatistic;
        private final ByteDepthStatistic _byteDepthStatistic;
        private final MsgPersistEnqueuesStatistic _msgPersistEnqueuesStatistic;
        private final MsgPersistDequeuesStatistic _msgPersistDequeuesStatistic;
        private final BytePersistEnqueuesStatistic _bytePersistEnqueuesStatistic;
        private final BytePersistDequeuesStatistic _bytePersistDequeuesStatistic;
        private final MsgTxnEnqueuesStatistic _msgTxnEnqueuesStatistic;
        private final MsgTxnDequeuesStatistic _msgTxnDequeuesStatistic;
        private final ByteTxnEnqueuesStatistic _byteTxnEnqueuesStatistic;
        private final ByteTxnDequeuesStatistic _byteTxnDequeuesStatistic;
        private final MsgFtdEnqueuesStatistic _msgFtdEnqueuesStatistic;
        private final MsgFtdDequeuesStatistic _msgFtdDequeuesStatistic;
        private final ByteFtdEnqueuesStatistic _byteFtdEnqueuesStatistic;
        private final ByteFtdDequeuesStatistic _byteFtdDequeuesStatistic;
        private final MsgFtdDepthStatistic _msgFtdDepthStatistic;
        private final ByteFtdDepthStatistic _byteFtdDepthStatistic;
        private final ReleasesStatistic _releasesStatistic;
        private final AcquiresStatistic _acquiresStatistic;
        private final DiscardsNoRouteStatistic _discardsNoRouteStatistic;
        private final DiscardsTtlStatistic _discardsTtlStatistic;
        private final DiscardsRingStatistic _discardsRingStatistic;
        private final DiscardsLvqStatistic _discardsLvqStatistic;
        private final DiscardsOverflowStatistic _discardsOverflowStatistic;
        private final DiscardsSubscriberStatistic _discardsSubscriberStatistic;
        private final DiscardsPurgeStatistic _discardsPurgeStatistic;
        private final ReroutesStatistic _reroutesStatistic;
        private final AbandonedStatistic _abandonedStatistic;
        private final AbandonedViaAltStatistic _abandonedViaAltStatistic;
        private final EchoMethod _echoMethod;
        private final ConnectMethod _connectMethod;
        private final QueueMoveMessagesMethod _queueMoveMessagesMethod;
        private final SetLogLevelMethod _setLogLevelMethod;
        private final GetLogLevelMethod _getLogLevelMethod;
        private final GetTimestampConfigMethod _getTimestampConfigMethod;
        private final SetTimestampConfigMethod _setTimestampConfigMethod;
        private final CreateMethod _createMethod;
        private final DeleteMethod _deleteMethod;
        private final QueryMethod _queryMethod;

        private BrokerClass() {
            super("broker", new byte[16]);
            this._nameProperty = new NameProperty();
            this._systemRefProperty = new SystemRefProperty();
            this._portProperty = new PortProperty();
            this._workerThreadsProperty = new WorkerThreadsProperty();
            this._connBacklogProperty = new ConnBacklogProperty();
            this._stagingThresholdProperty = new StagingThresholdProperty();
            this._mgmtPublishProperty = new MgmtPublishProperty();
            this._mgmtPubIntervalProperty = new MgmtPubIntervalProperty();
            this._versionProperty = new VersionProperty();
            this._dataDirProperty = new DataDirProperty();
            this._uptimeStatistic = new UptimeStatistic();
            this._queueCountStatistic = new QueueCountStatistic();
            this._msgTotalEnqueuesStatistic = new MsgTotalEnqueuesStatistic();
            this._msgTotalDequeuesStatistic = new MsgTotalDequeuesStatistic();
            this._byteTotalEnqueuesStatistic = new ByteTotalEnqueuesStatistic();
            this._byteTotalDequeuesStatistic = new ByteTotalDequeuesStatistic();
            this._msgDepthStatistic = new MsgDepthStatistic();
            this._byteDepthStatistic = new ByteDepthStatistic();
            this._msgPersistEnqueuesStatistic = new MsgPersistEnqueuesStatistic();
            this._msgPersistDequeuesStatistic = new MsgPersistDequeuesStatistic();
            this._bytePersistEnqueuesStatistic = new BytePersistEnqueuesStatistic();
            this._bytePersistDequeuesStatistic = new BytePersistDequeuesStatistic();
            this._msgTxnEnqueuesStatistic = new MsgTxnEnqueuesStatistic();
            this._msgTxnDequeuesStatistic = new MsgTxnDequeuesStatistic();
            this._byteTxnEnqueuesStatistic = new ByteTxnEnqueuesStatistic();
            this._byteTxnDequeuesStatistic = new ByteTxnDequeuesStatistic();
            this._msgFtdEnqueuesStatistic = new MsgFtdEnqueuesStatistic();
            this._msgFtdDequeuesStatistic = new MsgFtdDequeuesStatistic();
            this._byteFtdEnqueuesStatistic = new ByteFtdEnqueuesStatistic();
            this._byteFtdDequeuesStatistic = new ByteFtdDequeuesStatistic();
            this._msgFtdDepthStatistic = new MsgFtdDepthStatistic();
            this._byteFtdDepthStatistic = new ByteFtdDepthStatistic();
            this._releasesStatistic = new ReleasesStatistic();
            this._acquiresStatistic = new AcquiresStatistic();
            this._discardsNoRouteStatistic = new DiscardsNoRouteStatistic();
            this._discardsTtlStatistic = new DiscardsTtlStatistic();
            this._discardsRingStatistic = new DiscardsRingStatistic();
            this._discardsLvqStatistic = new DiscardsLvqStatistic();
            this._discardsOverflowStatistic = new DiscardsOverflowStatistic();
            this._discardsSubscriberStatistic = new DiscardsSubscriberStatistic();
            this._discardsPurgeStatistic = new DiscardsPurgeStatistic();
            this._reroutesStatistic = new ReroutesStatistic();
            this._abandonedStatistic = new AbandonedStatistic();
            this._abandonedViaAltStatistic = new AbandonedViaAltStatistic();
            this._echoMethod = new EchoMethod();
            this._connectMethod = new ConnectMethod();
            this._queueMoveMessagesMethod = new QueueMoveMessagesMethod();
            this._setLogLevelMethod = new SetLogLevelMethod();
            this._getLogLevelMethod = new GetLogLevelMethod();
            this._getTimestampConfigMethod = new GetTimestampConfigMethod();
            this._setTimestampConfigMethod = new SetTimestampConfigMethod();
            this._createMethod = new CreateMethod();
            this._deleteMethod = new DeleteMethod();
            this._queryMethod = new QueryMethod();
            this.setProperties(Arrays.asList(this._nameProperty, this._systemRefProperty, this._portProperty, this._workerThreadsProperty, this._connBacklogProperty, this._stagingThresholdProperty, this._mgmtPublishProperty, this._mgmtPubIntervalProperty, this._versionProperty, this._dataDirProperty));
            this.setStatistics(Arrays.asList(this._uptimeStatistic, this._queueCountStatistic, this._msgTotalEnqueuesStatistic, this._msgTotalDequeuesStatistic, this._byteTotalEnqueuesStatistic, this._byteTotalDequeuesStatistic, this._msgDepthStatistic, this._byteDepthStatistic, this._msgPersistEnqueuesStatistic, this._msgPersistDequeuesStatistic, this._bytePersistEnqueuesStatistic, this._bytePersistDequeuesStatistic, this._msgTxnEnqueuesStatistic, this._msgTxnDequeuesStatistic, this._byteTxnEnqueuesStatistic, this._byteTxnDequeuesStatistic, this._msgFtdEnqueuesStatistic, this._msgFtdDequeuesStatistic, this._byteFtdEnqueuesStatistic, this._byteFtdDequeuesStatistic, this._msgFtdDepthStatistic, this._byteFtdDepthStatistic, this._releasesStatistic, this._acquiresStatistic, this._discardsNoRouteStatistic, this._discardsTtlStatistic, this._discardsRingStatistic, this._discardsLvqStatistic, this._discardsOverflowStatistic, this._discardsSubscriberStatistic, this._discardsPurgeStatistic, this._reroutesStatistic, this._abandonedStatistic, this._abandonedViaAltStatistic));
            this.setMethods(Arrays.asList(this._echoMethod, this._connectMethod, this._queueMoveMessagesMethod, this._setLogLevelMethod, this._getLogLevelMethod, this._getTimestampConfigMethod, this._setTimestampConfigMethod, this._createMethod, this._deleteMethod, this._queryMethod));
        }

        @Override
        public BrokerObject newInstance(BrokerDelegate delegate) {
            return new BrokerObject(delegate);
        }

        public final class QueryMethodResponseCommand
        extends QMFMethodResponseCommand {
            private final Map _results;

            private QueryMethodResponseCommand(QMFMethodRequestCommand cmd, Map results) {
                super(cmd, CompletionCode.OK, "OK");
                this._results = results;
            }

            private QueryMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
                this._results = null;
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
                if (this.getStatus().equals((Object)CompletionCode.OK)) {
                    encoder.writeMap(this._results);
                }
            }
        }

        public final class QueryMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private QueryMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public QueryMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new QueryMethodResponseCommand(this._requestCmd, status, null);
            }

            public QueryMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new QueryMethodResponseCommand(this._requestCmd, status, msg);
            }

            public QueryMethodResponseCommand createResponseCommand(Map results) {
                return new QueryMethodResponseCommand(this._requestCmd, results);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class QueryMethodInvocation
        implements QMFMethodInvocation<BrokerObject> {
            private final String _type;
            private final String _name;

            private QueryMethodInvocation(String type, String name) {
                this._type = type;
                this._name = name;
            }

            @Override
            public QMFMethodResponseCommand execute(BrokerObject obj, QMFMethodRequestCommand cmd) {
                return obj.query(new QueryMethodResponseCommandFactory(cmd), this._type, this._name);
            }

            public String toString() {
                return "QueryMethod[type = " + this._type + ", " + "name = " + this._name + "]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class QueryMethod
        extends QMFMethod<BrokerObject> {
            private QueryMethod() {
                super("query", "Query the current state of an object.");
                QMFMethod.Argument type = new QMFMethod.Argument("type", QMFType.STR8);
                type.setDescription("The type of object to query.");
                type.setDirection(QMFMethod.Direction.I);
                this.addArgument(type);
                QMFMethod.Argument name = new QMFMethod.Argument("name", QMFType.STR8);
                name.setDescription("The name of the object to query");
                name.setDirection(QMFMethod.Direction.I);
                this.addArgument(name);
                QMFMethod.Argument results = new QMFMethod.Argument("results", QMFType.MAP);
                results.setDescription("A snapshot of the object's state.");
                results.setDirection(QMFMethod.Direction.O);
                this.addArgument(results);
            }

            public QueryMethodInvocation parse(BBDecoder decoder) {
                String type = decoder.readStr8();
                String name = decoder.readStr8();
                return new QueryMethodInvocation(type, name);
            }
        }

        public final class DeleteMethodResponseCommand
        extends QMFMethodResponseCommand {
            private DeleteMethodResponseCommand(QMFMethodRequestCommand cmd) {
                super(cmd, CompletionCode.OK, "OK");
            }

            private DeleteMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
            }
        }

        public final class DeleteMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private DeleteMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public DeleteMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new DeleteMethodResponseCommand(this._requestCmd, status, null);
            }

            public DeleteMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new DeleteMethodResponseCommand(this._requestCmd, status, msg);
            }

            public DeleteMethodResponseCommand createResponseCommand() {
                return new DeleteMethodResponseCommand(this._requestCmd);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class DeleteMethodInvocation
        implements QMFMethodInvocation<BrokerObject> {
            private final String _type;
            private final String _name;
            private final Map _options;

            private DeleteMethodInvocation(String type, String name, Map options) {
                this._type = type;
                this._name = name;
                this._options = options;
            }

            @Override
            public QMFMethodResponseCommand execute(BrokerObject obj, QMFMethodRequestCommand cmd) {
                return obj.delete(new DeleteMethodResponseCommandFactory(cmd), this._type, this._name, this._options);
            }

            public String toString() {
                return "DeleteMethod[type = " + this._type + ", " + "name = " + this._name + ", " + "options = " + this._options + "]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class DeleteMethod
        extends QMFMethod<BrokerObject> {
            private DeleteMethod() {
                super("delete", "Delete an object of the specified type");
                QMFMethod.Argument type = new QMFMethod.Argument("type", QMFType.STR8);
                type.setDescription("The type of object to delete");
                type.setDirection(QMFMethod.Direction.I);
                this.addArgument(type);
                QMFMethod.Argument name = new QMFMethod.Argument("name", QMFType.STR8);
                name.setDescription("The name of the object to delete");
                name.setDirection(QMFMethod.Direction.I);
                this.addArgument(name);
                QMFMethod.Argument options = new QMFMethod.Argument("options", QMFType.MAP);
                options.setDescription("Type specific object options for deletion");
                options.setDirection(QMFMethod.Direction.I);
                this.addArgument(options);
            }

            public DeleteMethodInvocation parse(BBDecoder decoder) {
                String type = decoder.readStr8();
                String name = decoder.readStr8();
                Map options = decoder.readMap();
                return new DeleteMethodInvocation(type, name, options);
            }
        }

        public final class CreateMethodResponseCommand
        extends QMFMethodResponseCommand {
            private CreateMethodResponseCommand(QMFMethodRequestCommand cmd) {
                super(cmd, CompletionCode.OK, "OK");
            }

            private CreateMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
            }
        }

        public final class CreateMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private CreateMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public CreateMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new CreateMethodResponseCommand(this._requestCmd, status, null);
            }

            public CreateMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new CreateMethodResponseCommand(this._requestCmd, status, msg);
            }

            public CreateMethodResponseCommand createResponseCommand() {
                return new CreateMethodResponseCommand(this._requestCmd);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CreateMethodInvocation
        implements QMFMethodInvocation<BrokerObject> {
            private final String _type;
            private final String _name;
            private final Map _properties;
            private final Boolean _strict;

            private CreateMethodInvocation(String type, String name, Map properties, Boolean strict) {
                this._type = type;
                this._name = name;
                this._properties = properties;
                this._strict = strict;
            }

            @Override
            public QMFMethodResponseCommand execute(BrokerObject obj, QMFMethodRequestCommand cmd) {
                return obj.create(new CreateMethodResponseCommandFactory(cmd), this._type, this._name, this._properties, this._strict);
            }

            public String toString() {
                return "CreateMethod[type = " + this._type + ", " + "name = " + this._name + ", " + "properties = " + this._properties + ", " + "strict = " + this._strict + "]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class CreateMethod
        extends QMFMethod<BrokerObject> {
            private CreateMethod() {
                super("create", "Create an object of the specified type");
                QMFMethod.Argument type = new QMFMethod.Argument("type", QMFType.STR8);
                type.setDescription("The type of object to create");
                type.setDirection(QMFMethod.Direction.I);
                this.addArgument(type);
                QMFMethod.Argument name = new QMFMethod.Argument("name", QMFType.STR8);
                name.setDescription("The name of the object to create");
                name.setDirection(QMFMethod.Direction.I);
                this.addArgument(name);
                QMFMethod.Argument properties = new QMFMethod.Argument("properties", QMFType.MAP);
                properties.setDescription("Type specific object properties");
                properties.setDirection(QMFMethod.Direction.I);
                this.addArgument(properties);
                QMFMethod.Argument strict = new QMFMethod.Argument("strict", QMFType.BOOLEAN);
                strict.setDescription("If specified, treat unrecognised object properties as an error");
                strict.setDirection(QMFMethod.Direction.I);
                this.addArgument(strict);
            }

            public CreateMethodInvocation parse(BBDecoder decoder) {
                String type = decoder.readStr8();
                String name = decoder.readStr8();
                Map properties = decoder.readMap();
                Boolean strict = decoder.readInt8() != 0;
                return new CreateMethodInvocation(type, name, properties, strict);
            }
        }

        public final class SetTimestampConfigMethodResponseCommand
        extends QMFMethodResponseCommand {
            private SetTimestampConfigMethodResponseCommand(QMFMethodRequestCommand cmd) {
                super(cmd, CompletionCode.OK, "OK");
            }

            private SetTimestampConfigMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
            }
        }

        public final class SetTimestampConfigMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private SetTimestampConfigMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public SetTimestampConfigMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new SetTimestampConfigMethodResponseCommand(this._requestCmd, status, null);
            }

            public SetTimestampConfigMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new SetTimestampConfigMethodResponseCommand(this._requestCmd, status, msg);
            }

            public SetTimestampConfigMethodResponseCommand createResponseCommand() {
                return new SetTimestampConfigMethodResponseCommand(this._requestCmd);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SetTimestampConfigMethodInvocation
        implements QMFMethodInvocation<BrokerObject> {
            private final Boolean _receive;

            private SetTimestampConfigMethodInvocation(Boolean receive) {
                this._receive = receive;
            }

            @Override
            public QMFMethodResponseCommand execute(BrokerObject obj, QMFMethodRequestCommand cmd) {
                return obj.setTimestampConfig(new SetTimestampConfigMethodResponseCommandFactory(cmd), this._receive);
            }

            public String toString() {
                return "SetTimestampConfigMethod[receive = " + this._receive + "]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetTimestampConfigMethod
        extends QMFMethod<BrokerObject> {
            private SetTimestampConfigMethod() {
                super("setTimestampConfig", "Set the message timestamping configuration");
                QMFMethod.Argument receive = new QMFMethod.Argument("receive", QMFType.BOOLEAN);
                receive.setDescription("Set true to enable timestamping received messages.");
                receive.setDirection(QMFMethod.Direction.I);
                this.addArgument(receive);
            }

            public SetTimestampConfigMethodInvocation parse(BBDecoder decoder) {
                Boolean receive = decoder.readInt8() != 0;
                return new SetTimestampConfigMethodInvocation(receive);
            }
        }

        public final class GetTimestampConfigMethodResponseCommand
        extends QMFMethodResponseCommand {
            private final Boolean _receive;

            private GetTimestampConfigMethodResponseCommand(QMFMethodRequestCommand cmd, Boolean receive) {
                super(cmd, CompletionCode.OK, "OK");
                this._receive = receive;
            }

            private GetTimestampConfigMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
                this._receive = null;
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
                if (this.getStatus().equals((Object)CompletionCode.OK)) {
                    encoder.writeInt8(this._receive != false ? (byte)-1 : 0);
                }
            }
        }

        public final class GetTimestampConfigMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private GetTimestampConfigMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public GetTimestampConfigMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new GetTimestampConfigMethodResponseCommand(this._requestCmd, status, null);
            }

            public GetTimestampConfigMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new GetTimestampConfigMethodResponseCommand(this._requestCmd, status, msg);
            }

            public GetTimestampConfigMethodResponseCommand createResponseCommand(Boolean receive) {
                return new GetTimestampConfigMethodResponseCommand(this._requestCmd, receive);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class GetTimestampConfigMethodInvocation
        implements QMFMethodInvocation<BrokerObject> {
            private GetTimestampConfigMethodInvocation() {
            }

            @Override
            public QMFMethodResponseCommand execute(BrokerObject obj, QMFMethodRequestCommand cmd) {
                return obj.getTimestampConfig(new GetTimestampConfigMethodResponseCommandFactory(cmd));
            }

            public String toString() {
                return "GetTimestampConfigMethod[]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetTimestampConfigMethod
        extends QMFMethod<BrokerObject> {
            private GetTimestampConfigMethod() {
                super("getTimestampConfig", "Get the message timestamping configuration");
                QMFMethod.Argument receive = new QMFMethod.Argument("receive", QMFType.BOOLEAN);
                receive.setDescription("True if received messages are timestamped.");
                receive.setDirection(QMFMethod.Direction.O);
                this.addArgument(receive);
            }

            public GetTimestampConfigMethodInvocation parse(BBDecoder decoder) {
                return new GetTimestampConfigMethodInvocation();
            }
        }

        public final class GetLogLevelMethodResponseCommand
        extends QMFMethodResponseCommand {
            private final String _level;

            private GetLogLevelMethodResponseCommand(QMFMethodRequestCommand cmd, String level) {
                super(cmd, CompletionCode.OK, "OK");
                this._level = level;
            }

            private GetLogLevelMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
                this._level = null;
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
                if (this.getStatus().equals((Object)CompletionCode.OK)) {
                    encoder.writeStr8(this._level);
                }
            }
        }

        public final class GetLogLevelMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private GetLogLevelMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public GetLogLevelMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new GetLogLevelMethodResponseCommand(this._requestCmd, status, null);
            }

            public GetLogLevelMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new GetLogLevelMethodResponseCommand(this._requestCmd, status, msg);
            }

            public GetLogLevelMethodResponseCommand createResponseCommand(String level) {
                return new GetLogLevelMethodResponseCommand(this._requestCmd, level);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class GetLogLevelMethodInvocation
        implements QMFMethodInvocation<BrokerObject> {
            private GetLogLevelMethodInvocation() {
            }

            @Override
            public QMFMethodResponseCommand execute(BrokerObject obj, QMFMethodRequestCommand cmd) {
                return obj.getLogLevel(new GetLogLevelMethodResponseCommandFactory(cmd));
            }

            public String toString() {
                return "GetLogLevelMethod[]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetLogLevelMethod
        extends QMFMethod<BrokerObject> {
            private GetLogLevelMethod() {
                super("getLogLevel", "Get the current log level");
                QMFMethod.Argument level = new QMFMethod.Argument("level", QMFType.STR8);
                level.setDirection(QMFMethod.Direction.O);
                this.addArgument(level);
            }

            public GetLogLevelMethodInvocation parse(BBDecoder decoder) {
                return new GetLogLevelMethodInvocation();
            }
        }

        public final class SetLogLevelMethodResponseCommand
        extends QMFMethodResponseCommand {
            private SetLogLevelMethodResponseCommand(QMFMethodRequestCommand cmd) {
                super(cmd, CompletionCode.OK, "OK");
            }

            private SetLogLevelMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
            }
        }

        public final class SetLogLevelMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private SetLogLevelMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public SetLogLevelMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new SetLogLevelMethodResponseCommand(this._requestCmd, status, null);
            }

            public SetLogLevelMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new SetLogLevelMethodResponseCommand(this._requestCmd, status, msg);
            }

            public SetLogLevelMethodResponseCommand createResponseCommand() {
                return new SetLogLevelMethodResponseCommand(this._requestCmd);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SetLogLevelMethodInvocation
        implements QMFMethodInvocation<BrokerObject> {
            private final String _level;

            private SetLogLevelMethodInvocation(String level) {
                this._level = level;
            }

            @Override
            public QMFMethodResponseCommand execute(BrokerObject obj, QMFMethodRequestCommand cmd) {
                return obj.setLogLevel(new SetLogLevelMethodResponseCommandFactory(cmd), this._level);
            }

            public String toString() {
                return "SetLogLevelMethod[level = " + this._level + "]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetLogLevelMethod
        extends QMFMethod<BrokerObject> {
            private SetLogLevelMethod() {
                super("setLogLevel", "Set the log level");
                QMFMethod.Argument level = new QMFMethod.Argument("level", QMFType.STR8);
                level.setDirection(QMFMethod.Direction.I);
                this.addArgument(level);
            }

            public SetLogLevelMethodInvocation parse(BBDecoder decoder) {
                String level = decoder.readStr8();
                return new SetLogLevelMethodInvocation(level);
            }
        }

        public final class QueueMoveMessagesMethodResponseCommand
        extends QMFMethodResponseCommand {
            private QueueMoveMessagesMethodResponseCommand(QMFMethodRequestCommand cmd) {
                super(cmd, CompletionCode.OK, "OK");
            }

            private QueueMoveMessagesMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
            }
        }

        public final class QueueMoveMessagesMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private QueueMoveMessagesMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public QueueMoveMessagesMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new QueueMoveMessagesMethodResponseCommand(this._requestCmd, status, null);
            }

            public QueueMoveMessagesMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new QueueMoveMessagesMethodResponseCommand(this._requestCmd, status, msg);
            }

            public QueueMoveMessagesMethodResponseCommand createResponseCommand() {
                return new QueueMoveMessagesMethodResponseCommand(this._requestCmd);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class QueueMoveMessagesMethodInvocation
        implements QMFMethodInvocation<BrokerObject> {
            private final String _srcQueue;
            private final String _destQueue;
            private final Long _qty;
            private final Map _filter;

            private QueueMoveMessagesMethodInvocation(String srcQueue, String destQueue, Long qty, Map filter) {
                this._srcQueue = srcQueue;
                this._destQueue = destQueue;
                this._qty = qty;
                this._filter = filter;
            }

            @Override
            public QMFMethodResponseCommand execute(BrokerObject obj, QMFMethodRequestCommand cmd) {
                return obj.queueMoveMessages(new QueueMoveMessagesMethodResponseCommandFactory(cmd), this._srcQueue, this._destQueue, this._qty, this._filter);
            }

            public String toString() {
                return "QueueMoveMessagesMethod[srcQueue = " + this._srcQueue + ", " + "destQueue = " + this._destQueue + ", " + "qty = " + this._qty + ", " + "filter = " + this._filter + "]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class QueueMoveMessagesMethod
        extends QMFMethod<BrokerObject> {
            private QueueMoveMessagesMethod() {
                super("queueMoveMessages", "Move messages from one queue to another");
                QMFMethod.Argument srcQueue = new QMFMethod.Argument("srcQueue", QMFType.STR8);
                srcQueue.setDescription("Source queue");
                srcQueue.setDirection(QMFMethod.Direction.I);
                this.addArgument(srcQueue);
                QMFMethod.Argument destQueue = new QMFMethod.Argument("destQueue", QMFType.STR8);
                destQueue.setDescription("Destination queue");
                destQueue.setDirection(QMFMethod.Direction.I);
                this.addArgument(destQueue);
                QMFMethod.Argument qty = new QMFMethod.Argument("qty", QMFType.UINT32);
                qty.setDescription("# of messages to move. 0 means all messages");
                qty.setDirection(QMFMethod.Direction.I);
                this.addArgument(qty);
                QMFMethod.Argument filter = new QMFMethod.Argument("filter", QMFType.MAP);
                filter.setDescription("if specified, move only those messages matching this filter");
                filter.setDirection(QMFMethod.Direction.I);
                this.addArgument(filter);
            }

            public QueueMoveMessagesMethodInvocation parse(BBDecoder decoder) {
                String srcQueue = decoder.readStr8();
                String destQueue = decoder.readStr8();
                Long qty = decoder.readUint32();
                Map filter = decoder.readMap();
                return new QueueMoveMessagesMethodInvocation(srcQueue, destQueue, qty, filter);
            }
        }

        public final class ConnectMethodResponseCommand
        extends QMFMethodResponseCommand {
            private ConnectMethodResponseCommand(QMFMethodRequestCommand cmd) {
                super(cmd, CompletionCode.OK, "OK");
            }

            private ConnectMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
            }
        }

        public final class ConnectMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private ConnectMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public ConnectMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new ConnectMethodResponseCommand(this._requestCmd, status, null);
            }

            public ConnectMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new ConnectMethodResponseCommand(this._requestCmd, status, msg);
            }

            public ConnectMethodResponseCommand createResponseCommand() {
                return new ConnectMethodResponseCommand(this._requestCmd);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ConnectMethodInvocation
        implements QMFMethodInvocation<BrokerObject> {
            private final String _host;
            private final Long _port;
            private final Boolean _durable;
            private final String _authMechanism;
            private final String _username;
            private final String _password;
            private final String _transport;

            private ConnectMethodInvocation(String host, Long port, Boolean durable, String authMechanism, String username, String password, String transport) {
                this._host = host;
                this._port = port;
                this._durable = durable;
                this._authMechanism = authMechanism;
                this._username = username;
                this._password = password;
                this._transport = transport;
            }

            @Override
            public QMFMethodResponseCommand execute(BrokerObject obj, QMFMethodRequestCommand cmd) {
                return obj.connect(new ConnectMethodResponseCommandFactory(cmd), this._host, this._port, this._durable, this._authMechanism, this._username, this._password, this._transport);
            }

            public String toString() {
                return "ConnectMethod[host = " + this._host + ", " + "port = " + this._port + ", " + "durable = " + this._durable + ", " + "authMechanism = " + this._authMechanism + ", " + "username = " + this._username + ", " + "password = " + this._password + ", " + "transport = " + this._transport + "]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ConnectMethod
        extends QMFMethod<BrokerObject> {
            private ConnectMethod() {
                super("connect", "Establish a connection to another broker");
                QMFMethod.Argument host = new QMFMethod.Argument("host", QMFType.STR8);
                host.setDirection(QMFMethod.Direction.I);
                this.addArgument(host);
                QMFMethod.Argument port = new QMFMethod.Argument("port", QMFType.UINT32);
                port.setDirection(QMFMethod.Direction.I);
                this.addArgument(port);
                QMFMethod.Argument durable = new QMFMethod.Argument("durable", QMFType.BOOLEAN);
                durable.setDirection(QMFMethod.Direction.I);
                this.addArgument(durable);
                QMFMethod.Argument authMechanism = new QMFMethod.Argument("authMechanism", QMFType.STR8);
                authMechanism.setDirection(QMFMethod.Direction.I);
                this.addArgument(authMechanism);
                QMFMethod.Argument username = new QMFMethod.Argument("username", QMFType.STR8);
                username.setDirection(QMFMethod.Direction.I);
                this.addArgument(username);
                QMFMethod.Argument password = new QMFMethod.Argument("password", QMFType.STR8);
                password.setDirection(QMFMethod.Direction.I);
                this.addArgument(password);
                QMFMethod.Argument transport = new QMFMethod.Argument("transport", QMFType.STR8);
                transport.setDirection(QMFMethod.Direction.I);
                this.addArgument(transport);
            }

            public ConnectMethodInvocation parse(BBDecoder decoder) {
                String host = decoder.readStr8();
                Long port = decoder.readUint32();
                Boolean durable = decoder.readInt8() != 0;
                String authMechanism = decoder.readStr8();
                String username = decoder.readStr8();
                String password = decoder.readStr8();
                String transport = decoder.readStr8();
                return new ConnectMethodInvocation(host, port, durable, authMechanism, username, password, transport);
            }
        }

        public final class EchoMethodResponseCommand
        extends QMFMethodResponseCommand {
            private final Long _sequence;
            private final String _body;

            private EchoMethodResponseCommand(QMFMethodRequestCommand cmd, Long sequence, String body) {
                super(cmd, CompletionCode.OK, "OK");
                this._sequence = sequence;
                this._body = body;
            }

            private EchoMethodResponseCommand(QMFMethodRequestCommand cmd, CompletionCode status, String msg) {
                super(cmd, status, msg);
                this._sequence = null;
                this._body = null;
            }

            public void encode(BBEncoder encoder) {
                super.encode(encoder);
                if (this.getStatus().equals((Object)CompletionCode.OK)) {
                    encoder.writeUint32(this._sequence.longValue());
                    encoder.writeStr16(this._body);
                }
            }
        }

        public final class EchoMethodResponseCommandFactory {
            private final QMFMethodRequestCommand _requestCmd;

            private EchoMethodResponseCommandFactory(QMFMethodRequestCommand cmd) {
                this._requestCmd = cmd;
            }

            public EchoMethodResponseCommand createResponseCommand(CompletionCode status) {
                return new EchoMethodResponseCommand(this._requestCmd, status, null);
            }

            public EchoMethodResponseCommand createResponseCommand(CompletionCode status, String msg) {
                return new EchoMethodResponseCommand(this._requestCmd, status, msg);
            }

            public EchoMethodResponseCommand createResponseCommand(Long sequence, String body) {
                return new EchoMethodResponseCommand(this._requestCmd, sequence, body);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EchoMethodInvocation
        implements QMFMethodInvocation<BrokerObject> {
            private final Long _sequence;
            private final String _body;

            private EchoMethodInvocation(Long sequence, String body) {
                this._sequence = sequence;
                this._body = body;
            }

            @Override
            public QMFMethodResponseCommand execute(BrokerObject obj, QMFMethodRequestCommand cmd) {
                return obj.echo(new EchoMethodResponseCommandFactory(cmd), this._sequence, this._body);
            }

            public String toString() {
                return "EchoMethod[sequence = " + this._sequence + ", " + "body = " + this._body + "]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class EchoMethod
        extends QMFMethod<BrokerObject> {
            private EchoMethod() {
                super("echo", "Request a response to test the path to the management broker");
                QMFMethod.Argument sequence = new QMFMethod.Argument("sequence", QMFType.UINT32);
                sequence.setDirection(QMFMethod.Direction.IO);
                this.addArgument(sequence);
                QMFMethod.Argument body = new QMFMethod.Argument("body", QMFType.STR16);
                body.setDirection(QMFMethod.Direction.IO);
                this.addArgument(body);
            }

            public EchoMethodInvocation parse(BBDecoder decoder) {
                Long sequence = decoder.readUint32();
                String body = decoder.readStr16();
                return new EchoMethodInvocation(sequence, body);
            }
        }

        public class AbandonedViaAltStatistic
        extends QMFStatistic {
            private AbandonedViaAltStatistic() {
                super("abandonedViaAlt", QMFType.UINT64, "message", "Messages routed to alternate exchange from a deleted queue");
            }
        }

        public class AbandonedStatistic
        extends QMFStatistic {
            private AbandonedStatistic() {
                super("abandoned", QMFType.UINT64, "message", "Messages left in a deleted queue");
            }
        }

        public class ReroutesStatistic
        extends QMFStatistic {
            private ReroutesStatistic() {
                super("reroutes", QMFType.UINT64, "message", "Messages dequeued to management re-route");
            }
        }

        public class DiscardsPurgeStatistic
        extends QMFStatistic {
            private DiscardsPurgeStatistic() {
                super("discardsPurge", QMFType.UINT64, "message", "Messages discarded due to management purge");
            }
        }

        public class DiscardsSubscriberStatistic
        extends QMFStatistic {
            private DiscardsSubscriberStatistic() {
                super("discardsSubscriber", QMFType.UINT64, "message", "Messages discarded due to subscriber reject");
            }
        }

        public class DiscardsOverflowStatistic
        extends QMFStatistic {
            private DiscardsOverflowStatistic() {
                super("discardsOverflow", QMFType.UINT64, "message", "Messages discarded due to reject-policy overflow");
            }
        }

        public class DiscardsLvqStatistic
        extends QMFStatistic {
            private DiscardsLvqStatistic() {
                super("discardsLvq", QMFType.UINT64, "message", "Messages discarded due to LVQ insert");
            }
        }

        public class DiscardsRingStatistic
        extends QMFStatistic {
            private DiscardsRingStatistic() {
                super("discardsRing", QMFType.UINT64, "message", "Messages discarded due to ring-queue overflow");
            }
        }

        public class DiscardsTtlStatistic
        extends QMFStatistic {
            private DiscardsTtlStatistic() {
                super("discardsTtl", QMFType.UINT64, "message", "Messages discarded due to TTL expiration");
            }
        }

        public class DiscardsNoRouteStatistic
        extends QMFStatistic {
            private DiscardsNoRouteStatistic() {
                super("discardsNoRoute", QMFType.UINT64, "message", "Messages discarded due to no-route from exchange");
            }
        }

        public class AcquiresStatistic
        extends QMFStatistic {
            private AcquiresStatistic() {
                super("acquires", QMFType.UINT64, "message", "Messages acquired from the queue");
            }
        }

        public class ReleasesStatistic
        extends QMFStatistic {
            private ReleasesStatistic() {
                super("releases", QMFType.UINT64, "message", "Acquired messages reinserted into the queue");
            }
        }

        public class ByteFtdDepthStatistic
        extends QMFStatistic {
            private ByteFtdDepthStatistic() {
                super("byteFtdDepth", QMFType.UINT64, "octet", "Current number of bytes flowed-to-disk");
            }
        }

        public class MsgFtdDepthStatistic
        extends QMFStatistic {
            private MsgFtdDepthStatistic() {
                super("msgFtdDepth", QMFType.UINT64, "message", "Current number of messages flowed-to-disk");
            }
        }

        public class ByteFtdDequeuesStatistic
        extends QMFStatistic {
            private ByteFtdDequeuesStatistic() {
                super("byteFtdDequeues", QMFType.UINT64, "octet", "Total bytes dequeued from the broker having been flowed-to-disk");
            }
        }

        public class ByteFtdEnqueuesStatistic
        extends QMFStatistic {
            private ByteFtdEnqueuesStatistic() {
                super("byteFtdEnqueues", QMFType.UINT64, "octet", "Total bytes released from memory and flowed-to-disk on broker");
            }
        }

        public class MsgFtdDequeuesStatistic
        extends QMFStatistic {
            private MsgFtdDequeuesStatistic() {
                super("msgFtdDequeues", QMFType.UINT64, "message", "Total message bodies dequeued from the broker having been flowed-to-disk");
            }
        }

        public class MsgFtdEnqueuesStatistic
        extends QMFStatistic {
            private MsgFtdEnqueuesStatistic() {
                super("msgFtdEnqueues", QMFType.UINT64, "message", "Total message bodies released from memory and flowed-to-disk on broker");
            }
        }

        public class ByteTxnDequeuesStatistic
        extends QMFStatistic {
            private ByteTxnDequeuesStatistic() {
                super("byteTxnDequeues", QMFType.UINT64, "octet", "Total transactional bytes dequeued from broker");
            }
        }

        public class ByteTxnEnqueuesStatistic
        extends QMFStatistic {
            private ByteTxnEnqueuesStatistic() {
                super("byteTxnEnqueues", QMFType.UINT64, "octet", "Total transactional bytes enqueued to broker");
            }
        }

        public class MsgTxnDequeuesStatistic
        extends QMFStatistic {
            private MsgTxnDequeuesStatistic() {
                super("msgTxnDequeues", QMFType.UINT64, "message", "Total transactional messages dequeued from broker");
            }
        }

        public class MsgTxnEnqueuesStatistic
        extends QMFStatistic {
            private MsgTxnEnqueuesStatistic() {
                super("msgTxnEnqueues", QMFType.UINT64, "message", "Total transactional messages enqueued to broker");
            }
        }

        public class BytePersistDequeuesStatistic
        extends QMFStatistic {
            private BytePersistDequeuesStatistic() {
                super("bytePersistDequeues", QMFType.UINT64, "octet", "Total persistent bytes dequeued from broker");
            }
        }

        public class BytePersistEnqueuesStatistic
        extends QMFStatistic {
            private BytePersistEnqueuesStatistic() {
                super("bytePersistEnqueues", QMFType.UINT64, "octet", "Total persistent bytes enqueued to broker");
            }
        }

        public class MsgPersistDequeuesStatistic
        extends QMFStatistic {
            private MsgPersistDequeuesStatistic() {
                super("msgPersistDequeues", QMFType.UINT64, "message", "Total persistent messages dequeued from broker");
            }
        }

        public class MsgPersistEnqueuesStatistic
        extends QMFStatistic {
            private MsgPersistEnqueuesStatistic() {
                super("msgPersistEnqueues", QMFType.UINT64, "message", "Total persistent messages enqueued to broker");
            }
        }

        public class ByteDepthStatistic
        extends QMFStatistic {
            private ByteDepthStatistic() {
                super("byteDepth", QMFType.UINT64, "octet", "Current number of bytes on queues in broker");
            }
        }

        public class MsgDepthStatistic
        extends QMFStatistic {
            private MsgDepthStatistic() {
                super("msgDepth", QMFType.UINT64, "message", "Current number of messages on queues in broker");
            }
        }

        public class ByteTotalDequeuesStatistic
        extends QMFStatistic {
            private ByteTotalDequeuesStatistic() {
                super("byteTotalDequeues", QMFType.UINT64, "octet", "Total bytes dequeued from broker");
            }
        }

        public class ByteTotalEnqueuesStatistic
        extends QMFStatistic {
            private ByteTotalEnqueuesStatistic() {
                super("byteTotalEnqueues", QMFType.UINT64, "octet", "Total bytes enqueued to broker");
            }
        }

        public class MsgTotalDequeuesStatistic
        extends QMFStatistic {
            private MsgTotalDequeuesStatistic() {
                super("msgTotalDequeues", QMFType.UINT64, "message", "Total messages dequeued from broker");
            }
        }

        public class MsgTotalEnqueuesStatistic
        extends QMFStatistic {
            private MsgTotalEnqueuesStatistic() {
                super("msgTotalEnqueues", QMFType.UINT64, "message", "Total messages enqueued to broker");
            }
        }

        public class QueueCountStatistic
        extends QMFStatistic {
            private QueueCountStatistic() {
                super("queueCount", QMFType.UINT64, "queue", "Number of queues in the broker");
            }
        }

        public class UptimeStatistic
        extends QMFStatistic {
            private UptimeStatistic() {
                super("uptime", QMFType.DELTATIME, null, null);
            }
        }

        public class DataDirProperty
        extends QMFProperty {
            private DataDirProperty() {
                super("dataDir", QMFType.STR16, QMFProperty.AccessCode.RO, false, true);
                this.setDescription("Persistent configuration storage location");
            }
        }

        public class VersionProperty
        extends QMFProperty {
            private VersionProperty() {
                super("version", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Running software version");
            }
        }

        public class MgmtPubIntervalProperty
        extends QMFProperty {
            private MgmtPubIntervalProperty() {
                super("mgmtPubInterval", QMFType.UINT16, QMFProperty.AccessCode.RW, false, false);
                this.setDescription("Interval for management broadcasts");
                this.setMin(1);
                this.setUnit("second");
            }
        }

        public class MgmtPublishProperty
        extends QMFProperty {
            private MgmtPublishProperty() {
                super("mgmtPublish", QMFType.BOOLEAN, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Broker's management agent sends unsolicited data on the publish interval");
            }
        }

        public class StagingThresholdProperty
        extends QMFProperty {
            private StagingThresholdProperty() {
                super("stagingThreshold", QMFType.UINT32, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Broker stages messages over this size to disk");
            }
        }

        public class ConnBacklogProperty
        extends QMFProperty {
            private ConnBacklogProperty() {
                super("connBacklog", QMFType.UINT16, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Connection backlog limit for listening socket");
            }
        }

        public class WorkerThreadsProperty
        extends QMFProperty {
            private WorkerThreadsProperty() {
                super("workerThreads", QMFType.UINT16, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Thread pool size");
            }
        }

        public class PortProperty
        extends QMFProperty {
            private PortProperty() {
                super("port", QMFType.UINT16, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("TCP Port for AMQP Service");
            }
        }

        public class SystemRefProperty
        extends QMFProperty {
            private SystemRefProperty() {
                super("systemRef", QMFType.OBJECTREFERENCE, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("System ID");
                this.setReferencedClass("system");
            }
        }

        public class NameProperty
        extends QMFProperty {
            private NameProperty() {
                super("name", QMFType.STR8, QMFProperty.AccessCode.RC, true, false);
                this.setDescription("Index for the broker at this agent");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFMemoryGetQueryResponseCommand
    extends QMFGetQueryResponseCommand<MemoryObject> {
        protected QMFMemoryGetQueryResponseCommand(MemoryObject object, QMFGetQueryCommand cmd, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, cmd, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            byte presence0 = 0;
            if (((MemoryObject)this.getObject()).getMalloc_arena() != null) {
                presence0 = (byte)(presence0 | 1);
            }
            if (((MemoryObject)this.getObject()).getMalloc_ordblks() != null) {
                presence0 = (byte)(presence0 | 2);
            }
            if (((MemoryObject)this.getObject()).getMalloc_hblks() != null) {
                presence0 = (byte)(presence0 | 4);
            }
            if (((MemoryObject)this.getObject()).getMalloc_hblkhd() != null) {
                presence0 = (byte)(presence0 | 8);
            }
            if (((MemoryObject)this.getObject()).getMalloc_uordblks() != null) {
                presence0 = (byte)(presence0 | 0x10);
            }
            if (((MemoryObject)this.getObject()).getMalloc_fordblks() != null) {
                presence0 = (byte)(presence0 | 0x20);
            }
            if (((MemoryObject)this.getObject()).getMalloc_keepcost() != null) {
                presence0 = (byte)(presence0 | 0x40);
            }
            encoder.writeUint8((short)presence0);
            encoder.writeStr8(((MemoryObject)this.getObject()).getName());
            if (((MemoryObject)this.getObject()).getMalloc_arena() != null) {
                encoder.writeUint64(((MemoryObject)this.getObject()).getMalloc_arena().longValue());
            }
            if (((MemoryObject)this.getObject()).getMalloc_ordblks() != null) {
                encoder.writeUint64(((MemoryObject)this.getObject()).getMalloc_ordblks().longValue());
            }
            if (((MemoryObject)this.getObject()).getMalloc_hblks() != null) {
                encoder.writeUint64(((MemoryObject)this.getObject()).getMalloc_hblks().longValue());
            }
            if (((MemoryObject)this.getObject()).getMalloc_hblkhd() != null) {
                encoder.writeUint64(((MemoryObject)this.getObject()).getMalloc_hblkhd().longValue());
            }
            if (((MemoryObject)this.getObject()).getMalloc_uordblks() != null) {
                encoder.writeUint64(((MemoryObject)this.getObject()).getMalloc_uordblks().longValue());
            }
            if (((MemoryObject)this.getObject()).getMalloc_fordblks() != null) {
                encoder.writeUint64(((MemoryObject)this.getObject()).getMalloc_fordblks().longValue());
            }
            if (((MemoryObject)this.getObject()).getMalloc_keepcost() != null) {
                encoder.writeUint64(((MemoryObject)this.getObject()).getMalloc_keepcost().longValue());
            }
        }

        public String toString() {
            return "QMFMemoryGetQueryResponseCommand{id=" + ((MemoryObject)this.getObject()).getId() + ", name=" + ((MemoryObject)this.getObject()).getName() + ", malloc_arena=" + ((MemoryObject)this.getObject()).getMalloc_arena() + ", malloc_ordblks=" + ((MemoryObject)this.getObject()).getMalloc_ordblks() + ", malloc_hblks=" + ((MemoryObject)this.getObject()).getMalloc_hblks() + ", malloc_hblkhd=" + ((MemoryObject)this.getObject()).getMalloc_hblkhd() + ", malloc_uordblks=" + ((MemoryObject)this.getObject()).getMalloc_uordblks() + ", malloc_fordblks=" + ((MemoryObject)this.getObject()).getMalloc_fordblks() + ", malloc_keepcost=" + ((MemoryObject)this.getObject()).getMalloc_keepcost() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFMemoryInstrumentInfoCommand
    extends QMFInstrumentInfoCommand<MemoryObject> {
        protected QMFMemoryInstrumentInfoCommand(MemoryObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFMemoryConfigInfoCommand
    extends QMFConfigInfoCommand<MemoryObject> {
        protected QMFMemoryConfigInfoCommand(MemoryObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            byte presence0 = 0;
            if (((MemoryObject)this.getObject()).getMalloc_arena() != null) {
                presence0 = (byte)(presence0 | 1);
            }
            if (((MemoryObject)this.getObject()).getMalloc_ordblks() != null) {
                presence0 = (byte)(presence0 | 2);
            }
            if (((MemoryObject)this.getObject()).getMalloc_hblks() != null) {
                presence0 = (byte)(presence0 | 4);
            }
            if (((MemoryObject)this.getObject()).getMalloc_hblkhd() != null) {
                presence0 = (byte)(presence0 | 8);
            }
            if (((MemoryObject)this.getObject()).getMalloc_uordblks() != null) {
                presence0 = (byte)(presence0 | 0x10);
            }
            if (((MemoryObject)this.getObject()).getMalloc_fordblks() != null) {
                presence0 = (byte)(presence0 | 0x20);
            }
            if (((MemoryObject)this.getObject()).getMalloc_keepcost() != null) {
                presence0 = (byte)(presence0 | 0x40);
            }
            encoder.writeUint8((short)presence0);
            encoder.writeStr8(((MemoryObject)this.getObject()).getName());
            if (((MemoryObject)this.getObject()).getMalloc_arena() != null) {
                encoder.writeUint64(((MemoryObject)this.getObject()).getMalloc_arena().longValue());
            }
            if (((MemoryObject)this.getObject()).getMalloc_ordblks() != null) {
                encoder.writeUint64(((MemoryObject)this.getObject()).getMalloc_ordblks().longValue());
            }
            if (((MemoryObject)this.getObject()).getMalloc_hblks() != null) {
                encoder.writeUint64(((MemoryObject)this.getObject()).getMalloc_hblks().longValue());
            }
            if (((MemoryObject)this.getObject()).getMalloc_hblkhd() != null) {
                encoder.writeUint64(((MemoryObject)this.getObject()).getMalloc_hblkhd().longValue());
            }
            if (((MemoryObject)this.getObject()).getMalloc_uordblks() != null) {
                encoder.writeUint64(((MemoryObject)this.getObject()).getMalloc_uordblks().longValue());
            }
            if (((MemoryObject)this.getObject()).getMalloc_fordblks() != null) {
                encoder.writeUint64(((MemoryObject)this.getObject()).getMalloc_fordblks().longValue());
            }
            if (((MemoryObject)this.getObject()).getMalloc_keepcost() != null) {
                encoder.writeUint64(((MemoryObject)this.getObject()).getMalloc_keepcost().longValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class MemoryObject
    extends QMFObject<MemoryClass, MemoryDelegate> {
        protected MemoryObject(MemoryDelegate delegate) {
            super(delegate);
        }

        @Override
        public MemoryClass getQMFClass() {
            return BrokerSchema.this._memoryClass;
        }

        @Override
        public QMFCommand asConfigInfoCmd(long sampleTime) {
            return new QMFMemoryConfigInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asInstrumentInfoCmd(long sampleTime) {
            return new QMFMemoryInstrumentInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asGetQueryResponseCmd(QMFGetQueryCommand queryCommand, long sampleTime) {
            return new QMFMemoryGetQueryResponseCommand(this, queryCommand, sampleTime);
        }

        public String getName() {
            return ((MemoryDelegate)this.getDelegate()).getName();
        }

        public Long getMalloc_arena() {
            return ((MemoryDelegate)this.getDelegate()).getMalloc_arena();
        }

        public Long getMalloc_ordblks() {
            return ((MemoryDelegate)this.getDelegate()).getMalloc_ordblks();
        }

        public Long getMalloc_hblks() {
            return ((MemoryDelegate)this.getDelegate()).getMalloc_hblks();
        }

        public Long getMalloc_hblkhd() {
            return ((MemoryDelegate)this.getDelegate()).getMalloc_hblkhd();
        }

        public Long getMalloc_uordblks() {
            return ((MemoryDelegate)this.getDelegate()).getMalloc_uordblks();
        }

        public Long getMalloc_fordblks() {
            return ((MemoryDelegate)this.getDelegate()).getMalloc_fordblks();
        }

        public Long getMalloc_keepcost() {
            return ((MemoryDelegate)this.getDelegate()).getMalloc_keepcost();
        }
    }

    public static interface MemoryDelegate
    extends QMFObject.Delegate {
        public String getName();

        public Long getMalloc_arena();

        public Long getMalloc_ordblks();

        public Long getMalloc_hblks();

        public Long getMalloc_hblkhd();

        public Long getMalloc_uordblks();

        public Long getMalloc_fordblks();

        public Long getMalloc_keepcost();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MemoryClass
    extends QMFObjectClass<MemoryObject, MemoryDelegate> {
        private final NameProperty _nameProperty;
        private final Malloc_arenaProperty _malloc_arenaProperty;
        private final Malloc_ordblksProperty _malloc_ordblksProperty;
        private final Malloc_hblksProperty _malloc_hblksProperty;
        private final Malloc_hblkhdProperty _malloc_hblkhdProperty;
        private final Malloc_uordblksProperty _malloc_uordblksProperty;
        private final Malloc_fordblksProperty _malloc_fordblksProperty;
        private final Malloc_keepcostProperty _malloc_keepcostProperty;

        private MemoryClass() {
            super("memory", new byte[16]);
            this._nameProperty = new NameProperty();
            this._malloc_arenaProperty = new Malloc_arenaProperty();
            this._malloc_ordblksProperty = new Malloc_ordblksProperty();
            this._malloc_hblksProperty = new Malloc_hblksProperty();
            this._malloc_hblkhdProperty = new Malloc_hblkhdProperty();
            this._malloc_uordblksProperty = new Malloc_uordblksProperty();
            this._malloc_fordblksProperty = new Malloc_fordblksProperty();
            this._malloc_keepcostProperty = new Malloc_keepcostProperty();
            this.setProperties(Arrays.asList(this._nameProperty, this._malloc_arenaProperty, this._malloc_ordblksProperty, this._malloc_hblksProperty, this._malloc_hblkhdProperty, this._malloc_uordblksProperty, this._malloc_fordblksProperty, this._malloc_keepcostProperty));
            this.setStatistics(Arrays.asList(new QMFStatistic[0]));
            this.setMethods(Arrays.asList(new QMFMethod[0]));
        }

        @Override
        public MemoryObject newInstance(MemoryDelegate delegate) {
            return new MemoryObject(delegate);
        }

        public class Malloc_keepcostProperty
        extends QMFProperty {
            private Malloc_keepcostProperty() {
                super("malloc_keepcost", QMFType.UINT64, QMFProperty.AccessCode.RO, false, true);
                this.setDescription("The size of the top-most releasable chunk that normally borders the end of the heap");
            }
        }

        public class Malloc_fordblksProperty
        extends QMFProperty {
            private Malloc_fordblksProperty() {
                super("malloc_fordblks", QMFType.UINT64, QMFProperty.AccessCode.RO, false, true);
                this.setDescription("Total size of memory occupied by free (not in use) chunks");
            }
        }

        public class Malloc_uordblksProperty
        extends QMFProperty {
            private Malloc_uordblksProperty() {
                super("malloc_uordblks", QMFType.UINT64, QMFProperty.AccessCode.RO, false, true);
                this.setDescription("Total size of memory occupied by chunks handed out by `malloc'");
            }
        }

        public class Malloc_hblkhdProperty
        extends QMFProperty {
            private Malloc_hblkhdProperty() {
                super("malloc_hblkhd", QMFType.UINT64, QMFProperty.AccessCode.RO, false, true);
                this.setDescription("Total size of memory allocated with `mmap', in bytes");
            }
        }

        public class Malloc_hblksProperty
        extends QMFProperty {
            private Malloc_hblksProperty() {
                super("malloc_hblks", QMFType.UINT64, QMFProperty.AccessCode.RO, false, true);
                this.setDescription("Total number of chunks allocated with `mmap'");
            }
        }

        public class Malloc_ordblksProperty
        extends QMFProperty {
            private Malloc_ordblksProperty() {
                super("malloc_ordblks", QMFType.UINT64, QMFProperty.AccessCode.RO, false, true);
                this.setDescription("The number of chunks not in use");
            }
        }

        public class Malloc_arenaProperty
        extends QMFProperty {
            private Malloc_arenaProperty() {
                super("malloc_arena", QMFType.UINT64, QMFProperty.AccessCode.RO, false, true);
                this.setDescription("Total size of memory allocated with `sbrk' by `malloc', in bytes");
            }
        }

        public class NameProperty
        extends QMFProperty {
            private NameProperty() {
                super("name", QMFType.STR8, QMFProperty.AccessCode.RC, true, false);
                this.setDescription("Index for the broker at this agent");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFSystemGetQueryResponseCommand
    extends QMFGetQueryResponseCommand<SystemObject> {
        protected QMFSystemGetQueryResponseCommand(SystemObject object, QMFGetQueryCommand cmd, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, cmd, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeUuid(((SystemObject)this.getObject()).getSystemId());
            encoder.writeStr8(((SystemObject)this.getObject()).getOsName());
            encoder.writeStr8(((SystemObject)this.getObject()).getNodeName());
            encoder.writeStr8(((SystemObject)this.getObject()).getRelease());
            encoder.writeStr8(((SystemObject)this.getObject()).getVersion());
            encoder.writeStr8(((SystemObject)this.getObject()).getMachine());
        }

        public String toString() {
            return "QMFSystemGetQueryResponseCommand{id=" + ((SystemObject)this.getObject()).getId() + ", systemId=" + ((SystemObject)this.getObject()).getSystemId() + ", osName=" + ((SystemObject)this.getObject()).getOsName() + ", nodeName=" + ((SystemObject)this.getObject()).getNodeName() + ", release=" + ((SystemObject)this.getObject()).getRelease() + ", version=" + ((SystemObject)this.getObject()).getVersion() + ", machine=" + ((SystemObject)this.getObject()).getMachine() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFSystemInstrumentInfoCommand
    extends QMFInstrumentInfoCommand<SystemObject> {
        protected QMFSystemInstrumentInfoCommand(SystemObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class QMFSystemConfigInfoCommand
    extends QMFConfigInfoCommand<SystemObject> {
        protected QMFSystemConfigInfoCommand(SystemObject object, long sampleTime) {
            super(BrokerSchema.this, (QMFObject)object, sampleTime);
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeUuid(((SystemObject)this.getObject()).getSystemId());
            encoder.writeStr8(((SystemObject)this.getObject()).getOsName());
            encoder.writeStr8(((SystemObject)this.getObject()).getNodeName());
            encoder.writeStr8(((SystemObject)this.getObject()).getRelease());
            encoder.writeStr8(((SystemObject)this.getObject()).getVersion());
            encoder.writeStr8(((SystemObject)this.getObject()).getMachine());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class SystemObject
    extends QMFObject<SystemClass, SystemDelegate> {
        protected SystemObject(SystemDelegate delegate) {
            super(delegate);
        }

        @Override
        public SystemClass getQMFClass() {
            return BrokerSchema.this._systemClass;
        }

        @Override
        public QMFCommand asConfigInfoCmd(long sampleTime) {
            return new QMFSystemConfigInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asInstrumentInfoCmd(long sampleTime) {
            return new QMFSystemInstrumentInfoCommand(this, sampleTime);
        }

        @Override
        public QMFCommand asGetQueryResponseCmd(QMFGetQueryCommand queryCommand, long sampleTime) {
            return new QMFSystemGetQueryResponseCommand(this, queryCommand, sampleTime);
        }

        public UUID getSystemId() {
            return ((SystemDelegate)this.getDelegate()).getSystemId();
        }

        public String getOsName() {
            return ((SystemDelegate)this.getDelegate()).getOsName();
        }

        public String getNodeName() {
            return ((SystemDelegate)this.getDelegate()).getNodeName();
        }

        public String getRelease() {
            return ((SystemDelegate)this.getDelegate()).getRelease();
        }

        public String getVersion() {
            return ((SystemDelegate)this.getDelegate()).getVersion();
        }

        public String getMachine() {
            return ((SystemDelegate)this.getDelegate()).getMachine();
        }
    }

    public static interface SystemDelegate
    extends QMFObject.Delegate {
        public UUID getSystemId();

        public String getOsName();

        public String getNodeName();

        public String getRelease();

        public String getVersion();

        public String getMachine();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SystemClass
    extends QMFObjectClass<SystemObject, SystemDelegate> {
        private final SystemIdProperty _systemIdProperty;
        private final OsNameProperty _osNameProperty;
        private final NodeNameProperty _nodeNameProperty;
        private final ReleaseProperty _releaseProperty;
        private final VersionProperty _versionProperty;
        private final MachineProperty _machineProperty;

        private SystemClass() {
            super("system", new byte[16]);
            this._systemIdProperty = new SystemIdProperty();
            this._osNameProperty = new OsNameProperty();
            this._nodeNameProperty = new NodeNameProperty();
            this._releaseProperty = new ReleaseProperty();
            this._versionProperty = new VersionProperty();
            this._machineProperty = new MachineProperty();
            this.setProperties(Arrays.asList(this._systemIdProperty, this._osNameProperty, this._nodeNameProperty, this._releaseProperty, this._versionProperty, this._machineProperty));
            this.setStatistics(Arrays.asList(new QMFStatistic[0]));
            this.setMethods(Arrays.asList(new QMFMethod[0]));
        }

        @Override
        public SystemObject newInstance(SystemDelegate delegate) {
            return new SystemObject(delegate);
        }

        public class MachineProperty
        extends QMFProperty {
            private MachineProperty() {
                super("machine", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
            }
        }

        public class VersionProperty
        extends QMFProperty {
            private VersionProperty() {
                super("version", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
            }
        }

        public class ReleaseProperty
        extends QMFProperty {
            private ReleaseProperty() {
                super("release", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
            }
        }

        public class NodeNameProperty
        extends QMFProperty {
            private NodeNameProperty() {
                super("nodeName", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Node Name");
            }
        }

        public class OsNameProperty
        extends QMFProperty {
            private OsNameProperty() {
                super("osName", QMFType.STR8, QMFProperty.AccessCode.RO, false, false);
                this.setDescription("Operating System Name");
            }
        }

        public class SystemIdProperty
        extends QMFProperty {
            private SystemIdProperty() {
                super("systemId", QMFType.UUID, QMFProperty.AccessCode.RC, true, false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class QMFGetQueryResponseCommand<T extends QMFObject>
    extends QMFInfoCommand<T> {
        final /* synthetic */ BrokerSchema this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        protected QMFGetQueryResponseCommand(T cmd, QMFGetQueryCommand sampleTime, long l2) {
            void object;
            this.this$0 = (BrokerSchema)l;
            super((BrokerSchema)l, cmd, QMFOperation.GET_QUERY_RESPONSE, (QMFObject)object, (long)sampleTime);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class QMFInstrumentInfoCommand<T extends QMFObject>
    extends QMFInfoCommand<T> {
        final /* synthetic */ BrokerSchema this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        protected QMFInstrumentInfoCommand(T sampleTime, long l2) {
            void object;
            this.this$0 = (BrokerSchema)l;
            super((BrokerSchema)l, QMFOperation.INSTRUMENTATION_INDICATION, (QMFObject)object, sampleTime);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class QMFConfigInfoCommand<T extends QMFObject>
    extends QMFInfoCommand<T> {
        final /* synthetic */ BrokerSchema this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        protected QMFConfigInfoCommand(T sampleTime, long l2) {
            void object;
            this.this$0 = (BrokerSchema)l;
            super((BrokerSchema)l, QMFOperation.CONFIG_INDICATION, (QMFObject)object, sampleTime);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class QMFInfoCommand<T extends QMFObject>
    extends QMFCommand {
        private final T _object;
        private final long _sampleTime;
        final /* synthetic */ BrokerSchema this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        protected QMFInfoCommand(QMFCommand op, QMFOperation object, T sampleTime, long l2) {
            this((BrokerSchema)l, trigger.getHeader().getVersion(), trigger.getHeader().getSeq(), (QMFOperation)((Object)op), (QMFObject)((Object)object), (long)sampleTime);
            void trigger;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        protected QMFInfoCommand(QMFOperation object, T sampleTime, long l2) {
            this((BrokerSchema)l, 50, 0, (QMFOperation)op, (QMFObject)((Object)object), (long)sampleTime);
            void op;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private QMFInfoCommand(byte seq, int op, QMFOperation object, T sampleTime, long l2) {
            void qmfVersion;
            this.this$0 = (BrokerSchema)l;
            super(new QMFCommandHeader((byte)qmfVersion, seq, (QMFOperation)op));
            this._object = object;
            this._sampleTime = (long)sampleTime;
        }

        public T getObject() {
            return this._object;
        }

        @Override
        public void encode(BBEncoder encoder) {
            super.encode(encoder);
            encoder.writeStr8(BrokerSchema.SCHEMA_NAME);
            encoder.writeStr8(((QMFClass)((QMFObject)this._object).getQMFClass()).getName());
            encoder.writeBin128(new byte[16]);
            encoder.writeUint64(this._sampleTime * 1000000L);
            encoder.writeUint64(((QMFObject)this._object).getCreateTime() * 1000000L);
            encoder.writeUint64(((QMFObject)this._object).getDeleteTime() * 1000000L);
            encoder.writeBin128(((QMFObject)this._object).getId());
        }
    }
}

