/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.apache.qpid.common.Closeable;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.connection.IConnectionRegistry;
import org.apache.qpid.server.protocol.AMQConnectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionRegistry
implements IConnectionRegistry,
Closeable {
    private List<AMQConnectionModel> _registry = new CopyOnWriteArrayList<AMQConnectionModel>();
    private Logger _logger = Logger.getLogger(ConnectionRegistry.class);
    private final Collection<IConnectionRegistry.RegistryChangeListener> _listeners = new ArrayList<IConnectionRegistry.RegistryChangeListener>();

    @Override
    public void initialise() {
    }

    @Override
    public void close() {
        this.close("Broker is shutting down");
    }

    @Override
    public void close(String replyText) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)("Closing connection registry :" + this._registry.size() + " connections."));
        }
        while (!this._registry.isEmpty()) {
            AMQConnectionModel connection = this._registry.get(0);
            this.closeConnection(connection, AMQConstant.CONNECTION_FORCED, replyText);
        }
    }

    private void closeConnection(AMQConnectionModel connection, AMQConstant cause, String message) {
        try {
            connection.close(cause, message);
        }
        catch (Exception e) {
            this._logger.warn((Object)"Exception closing connection", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConnection(AMQConnectionModel connnection) {
        Object object = this;
        synchronized (object) {
            this._registry.add(connnection);
            Collection<IConnectionRegistry.RegistryChangeListener> collection = this._listeners;
            synchronized (collection) {
                for (IConnectionRegistry.RegistryChangeListener listener : this._listeners) {
                    listener.connectionRegistered(connnection);
                }
            }
        }
        object = this._listeners;
        synchronized (object) {
            for (IConnectionRegistry.RegistryChangeListener listener : this._listeners) {
                listener.connectionRegistered(connnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterConnection(AMQConnectionModel connnection) {
        Object object = this;
        synchronized (object) {
            this._registry.remove(connnection);
            Collection<IConnectionRegistry.RegistryChangeListener> collection = this._listeners;
            synchronized (collection) {
                for (IConnectionRegistry.RegistryChangeListener listener : this._listeners) {
                    listener.connectionUnregistered(connnection);
                }
            }
        }
        object = this._listeners;
        synchronized (object) {
            for (IConnectionRegistry.RegistryChangeListener listener : this._listeners) {
                listener.connectionUnregistered(connnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegistryChangeListener(IConnectionRegistry.RegistryChangeListener listener) {
        Collection<IConnectionRegistry.RegistryChangeListener> collection = this._listeners;
        synchronized (collection) {
            this._listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AMQConnectionModel> getConnections() {
        ConnectionRegistry connectionRegistry = this;
        synchronized (connectionRegistry) {
            return new ArrayList<AMQConnectionModel>(this._registry);
        }
    }
}

