/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import org.apache.log4j.Logger;
import org.apache.qpid.filter.BooleanExpression;
import org.apache.qpid.filter.FilterableMessage;
import org.apache.qpid.filter.SelectorParsingException;
import org.apache.qpid.filter.selector.ParseException;
import org.apache.qpid.filter.selector.SelectorParser;
import org.apache.qpid.filter.selector.TokenMgrError;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.queue.Filterable;

public class JMSSelectorFilter
implements MessageFilter {
    private static final Logger _logger = Logger.getLogger(JMSSelectorFilter.class);
    private String _selector;
    private BooleanExpression _matcher;

    public JMSSelectorFilter(String selector) throws ParseException, TokenMgrError, SelectorParsingException {
        this._selector = selector;
        this._matcher = new SelectorParser().parse(selector);
    }

    public boolean matches(Filterable message) {
        boolean match = this._matcher.matches(this.wrap(message));
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(message + " match(" + match + ") selector(" + System.identityHashCode(this._selector) + "):" + this._selector));
        }
        return match;
    }

    private FilterableMessage wrap(final Filterable message) {
        return new FilterableMessage(){

            public boolean isPersistent() {
                return message.isPersistent();
            }

            public boolean isRedelivered() {
                return message.isRedelivered();
            }

            public Object getHeader(String name) {
                return message.getMessageHeader().getHeader(name);
            }

            public String getReplyTo() {
                return message.getMessageHeader().getReplyTo();
            }

            public String getType() {
                return message.getMessageHeader().getType();
            }

            public byte getPriority() {
                return message.getMessageHeader().getPriority();
            }

            public String getMessageId() {
                return message.getMessageHeader().getMessageId();
            }

            public long getTimestamp() {
                return message.getMessageHeader().getTimestamp();
            }

            public String getCorrelationId() {
                return message.getMessageHeader().getCorrelationId();
            }

            public long getExpiration() {
                return message.getMessageHeader().getExpiration();
            }
        };
    }

    public String getSelector() {
        return this._selector;
    }

    public String toString() {
        return "JMSSelector(" + this._selector + ")";
    }
}

