/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AccessRequestBody;
import org.apache.qpid.framing.AccessRequestOkBody;
import org.apache.qpid.framing.BasicAckBody;
import org.apache.qpid.framing.BasicCancelBody;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.apache.qpid.framing.BasicConsumeBody;
import org.apache.qpid.framing.BasicConsumeOkBody;
import org.apache.qpid.framing.BasicDeliverBody;
import org.apache.qpid.framing.BasicGetBody;
import org.apache.qpid.framing.BasicGetEmptyBody;
import org.apache.qpid.framing.BasicGetOkBody;
import org.apache.qpid.framing.BasicPublishBody;
import org.apache.qpid.framing.BasicQosBody;
import org.apache.qpid.framing.BasicQosOkBody;
import org.apache.qpid.framing.BasicRecoverBody;
import org.apache.qpid.framing.BasicRejectBody;
import org.apache.qpid.framing.BasicReturnBody;
import org.apache.qpid.framing.ChannelCloseBody;
import org.apache.qpid.framing.ChannelCloseOkBody;
import org.apache.qpid.framing.ChannelFlowBody;
import org.apache.qpid.framing.ChannelFlowOkBody;
import org.apache.qpid.framing.ChannelOpenBody;
import org.apache.qpid.framing.ChannelOpenOkBody;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.ConnectionCloseOkBody;
import org.apache.qpid.framing.ConnectionOpenBody;
import org.apache.qpid.framing.ConnectionOpenOkBody;
import org.apache.qpid.framing.ConnectionRedirectBody;
import org.apache.qpid.framing.ConnectionSecureBody;
import org.apache.qpid.framing.ConnectionSecureOkBody;
import org.apache.qpid.framing.ConnectionStartBody;
import org.apache.qpid.framing.ConnectionStartOkBody;
import org.apache.qpid.framing.ConnectionTuneBody;
import org.apache.qpid.framing.ConnectionTuneOkBody;
import org.apache.qpid.framing.DtxSelectBody;
import org.apache.qpid.framing.DtxSelectOkBody;
import org.apache.qpid.framing.DtxStartBody;
import org.apache.qpid.framing.DtxStartOkBody;
import org.apache.qpid.framing.ExchangeBoundBody;
import org.apache.qpid.framing.ExchangeBoundOkBody;
import org.apache.qpid.framing.ExchangeDeclareBody;
import org.apache.qpid.framing.ExchangeDeclareOkBody;
import org.apache.qpid.framing.ExchangeDeleteBody;
import org.apache.qpid.framing.ExchangeDeleteOkBody;
import org.apache.qpid.framing.FileAckBody;
import org.apache.qpid.framing.FileCancelBody;
import org.apache.qpid.framing.FileCancelOkBody;
import org.apache.qpid.framing.FileConsumeBody;
import org.apache.qpid.framing.FileConsumeOkBody;
import org.apache.qpid.framing.FileDeliverBody;
import org.apache.qpid.framing.FileOpenBody;
import org.apache.qpid.framing.FileOpenOkBody;
import org.apache.qpid.framing.FilePublishBody;
import org.apache.qpid.framing.FileQosBody;
import org.apache.qpid.framing.FileQosOkBody;
import org.apache.qpid.framing.FileRejectBody;
import org.apache.qpid.framing.FileReturnBody;
import org.apache.qpid.framing.FileStageBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.QueueBindBody;
import org.apache.qpid.framing.QueueBindOkBody;
import org.apache.qpid.framing.QueueDeclareBody;
import org.apache.qpid.framing.QueueDeclareOkBody;
import org.apache.qpid.framing.QueueDeleteBody;
import org.apache.qpid.framing.QueueDeleteOkBody;
import org.apache.qpid.framing.QueuePurgeBody;
import org.apache.qpid.framing.QueuePurgeOkBody;
import org.apache.qpid.framing.StreamCancelBody;
import org.apache.qpid.framing.StreamCancelOkBody;
import org.apache.qpid.framing.StreamConsumeBody;
import org.apache.qpid.framing.StreamConsumeOkBody;
import org.apache.qpid.framing.StreamDeliverBody;
import org.apache.qpid.framing.StreamPublishBody;
import org.apache.qpid.framing.StreamQosBody;
import org.apache.qpid.framing.StreamQosOkBody;
import org.apache.qpid.framing.StreamReturnBody;
import org.apache.qpid.framing.TunnelRequestBody;
import org.apache.qpid.framing.TxCommitBody;
import org.apache.qpid.framing.TxCommitOkBody;
import org.apache.qpid.framing.TxRollbackBody;
import org.apache.qpid.framing.TxRollbackOkBody;
import org.apache.qpid.framing.TxSelectBody;
import org.apache.qpid.framing.TxSelectOkBody;
import org.apache.qpid.server.handler.AccessRequestHandler;
import org.apache.qpid.server.handler.BasicAckMethodHandler;
import org.apache.qpid.server.handler.BasicCancelMethodHandler;
import org.apache.qpid.server.handler.BasicConsumeMethodHandler;
import org.apache.qpid.server.handler.BasicGetMethodHandler;
import org.apache.qpid.server.handler.BasicPublishMethodHandler;
import org.apache.qpid.server.handler.BasicQosHandler;
import org.apache.qpid.server.handler.BasicRecoverMethodHandler;
import org.apache.qpid.server.handler.BasicRejectMethodHandler;
import org.apache.qpid.server.handler.ChannelCloseHandler;
import org.apache.qpid.server.handler.ChannelCloseOkHandler;
import org.apache.qpid.server.handler.ChannelFlowHandler;
import org.apache.qpid.server.handler.ChannelOpenHandler;
import org.apache.qpid.server.handler.ConnectionCloseMethodHandler;
import org.apache.qpid.server.handler.ConnectionCloseOkMethodHandler;
import org.apache.qpid.server.handler.ConnectionOpenMethodHandler;
import org.apache.qpid.server.handler.ConnectionSecureOkMethodHandler;
import org.apache.qpid.server.handler.ConnectionStartOkMethodHandler;
import org.apache.qpid.server.handler.ConnectionTuneOkMethodHandler;
import org.apache.qpid.server.handler.ExchangeBoundHandler;
import org.apache.qpid.server.handler.ExchangeDeclareHandler;
import org.apache.qpid.server.handler.ExchangeDeleteHandler;
import org.apache.qpid.server.handler.QueueBindHandler;
import org.apache.qpid.server.handler.QueueDeclareHandler;
import org.apache.qpid.server.handler.QueueDeleteHandler;
import org.apache.qpid.server.handler.QueuePurgeHandler;
import org.apache.qpid.server.handler.ServerMethodDispatcherImpl_0_9;
import org.apache.qpid.server.handler.ServerMethodDispatcherImpl_0_91;
import org.apache.qpid.server.handler.ServerMethodDispatcherImpl_8_0;
import org.apache.qpid.server.handler.TxCommitHandler;
import org.apache.qpid.server.handler.TxRollbackHandler;
import org.apache.qpid.server.handler.TxSelectHandler;
import org.apache.qpid.server.handler.UnexpectedMethodException;
import org.apache.qpid.server.state.AMQStateManager;

public class ServerMethodDispatcherImpl
implements MethodDispatcher {
    private final AMQStateManager _stateManager;
    private static final Map<ProtocolVersion, DispatcherFactory> _dispatcherFactories = new HashMap<ProtocolVersion, DispatcherFactory>();
    private static final AccessRequestHandler _accessRequestHandler;
    private static final ChannelCloseHandler _channelCloseHandler;
    private static final ChannelOpenHandler _channelOpenHandler;
    private static final ChannelCloseOkHandler _channelCloseOkHandler;
    private static final ConnectionCloseMethodHandler _connectionCloseMethodHandler;
    private static final ConnectionCloseOkMethodHandler _connectionCloseOkMethodHandler;
    private static final ConnectionOpenMethodHandler _connectionOpenMethodHandler;
    private static final ConnectionTuneOkMethodHandler _connectionTuneOkMethodHandler;
    private static final ConnectionSecureOkMethodHandler _connectionSecureOkMethodHandler;
    private static final ConnectionStartOkMethodHandler _connectionStartOkMethodHandler;
    private static final ExchangeDeclareHandler _exchangeDeclareHandler;
    private static final ExchangeDeleteHandler _exchangeDeleteHandler;
    private static final ExchangeBoundHandler _exchangeBoundHandler;
    private static final BasicAckMethodHandler _basicAckMethodHandler;
    private static final BasicRecoverMethodHandler _basicRecoverMethodHandler;
    private static final BasicConsumeMethodHandler _basicConsumeMethodHandler;
    private static final BasicGetMethodHandler _basicGetMethodHandler;
    private static final BasicCancelMethodHandler _basicCancelMethodHandler;
    private static final BasicPublishMethodHandler _basicPublishMethodHandler;
    private static final BasicQosHandler _basicQosHandler;
    private static final QueueBindHandler _queueBindHandler;
    private static final QueueDeclareHandler _queueDeclareHandler;
    private static final QueueDeleteHandler _queueDeleteHandler;
    private static final QueuePurgeHandler _queuePurgeHandler;
    private static final ChannelFlowHandler _channelFlowHandler;
    private static final TxSelectHandler _txSelectHandler;
    private static final TxCommitHandler _txCommitHandler;
    private static final TxRollbackHandler _txRollbackHandler;
    private static final BasicRejectMethodHandler _basicRejectMethodHandler;

    public static MethodDispatcher createMethodDispatcher(AMQStateManager stateManager, ProtocolVersion protocolVersion) {
        return _dispatcherFactories.get(protocolVersion).createMethodDispatcher(stateManager);
    }

    public ServerMethodDispatcherImpl(AMQStateManager stateManager) {
        this._stateManager = stateManager;
    }

    protected AMQStateManager getStateManager() {
        return this._stateManager;
    }

    public boolean dispatchAccessRequest(AccessRequestBody body, int channelId) throws AMQException {
        _accessRequestHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchBasicAck(BasicAckBody body, int channelId) throws AMQException {
        _basicAckMethodHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchBasicCancel(BasicCancelBody body, int channelId) throws AMQException {
        _basicCancelMethodHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchBasicConsume(BasicConsumeBody body, int channelId) throws AMQException {
        _basicConsumeMethodHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchBasicGet(BasicGetBody body, int channelId) throws AMQException {
        _basicGetMethodHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchBasicPublish(BasicPublishBody body, int channelId) throws AMQException {
        _basicPublishMethodHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchBasicQos(BasicQosBody body, int channelId) throws AMQException {
        _basicQosHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchBasicRecover(BasicRecoverBody body, int channelId) throws AMQException {
        _basicRecoverMethodHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchBasicReject(BasicRejectBody body, int channelId) throws AMQException {
        _basicRejectMethodHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchChannelOpen(ChannelOpenBody body, int channelId) throws AMQException {
        _channelOpenHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchAccessRequestOk(AccessRequestOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchBasicCancelOk(BasicCancelOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchBasicConsumeOk(BasicConsumeOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchBasicDeliver(BasicDeliverBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchBasicGetEmpty(BasicGetEmptyBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchBasicGetOk(BasicGetOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchBasicQosOk(BasicQosOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchBasicReturn(BasicReturnBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchChannelClose(ChannelCloseBody body, int channelId) throws AMQException {
        _channelCloseHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchChannelCloseOk(ChannelCloseOkBody body, int channelId) throws AMQException {
        _channelCloseOkHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchChannelFlow(ChannelFlowBody body, int channelId) throws AMQException {
        _channelFlowHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchChannelFlowOk(ChannelFlowOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchChannelOpenOk(ChannelOpenOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchConnectionOpen(ConnectionOpenBody body, int channelId) throws AMQException {
        _connectionOpenMethodHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchConnectionClose(ConnectionCloseBody body, int channelId) throws AMQException {
        _connectionCloseMethodHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchConnectionCloseOk(ConnectionCloseOkBody body, int channelId) throws AMQException {
        _connectionCloseOkMethodHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchConnectionOpenOk(ConnectionOpenOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchConnectionRedirect(ConnectionRedirectBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchConnectionSecure(ConnectionSecureBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchConnectionStart(ConnectionStartBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchConnectionTune(ConnectionTuneBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchDtxSelectOk(DtxSelectOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchDtxStartOk(DtxStartOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchExchangeBoundOk(ExchangeBoundOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchExchangeDeclareOk(ExchangeDeclareOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchExchangeDeleteOk(ExchangeDeleteOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchFileCancelOk(FileCancelOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchFileConsumeOk(FileConsumeOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchFileDeliver(FileDeliverBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchFileOpen(FileOpenBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchFileOpenOk(FileOpenOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchFileQosOk(FileQosOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchFileReturn(FileReturnBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchFileStage(FileStageBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchQueueBindOk(QueueBindOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchQueueDeclareOk(QueueDeclareOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchQueueDeleteOk(QueueDeleteOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchQueuePurgeOk(QueuePurgeOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchStreamCancelOk(StreamCancelOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchStreamConsumeOk(StreamConsumeOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchStreamDeliver(StreamDeliverBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchStreamQosOk(StreamQosOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchStreamReturn(StreamReturnBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchTxCommitOk(TxCommitOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchTxRollbackOk(TxRollbackOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchTxSelectOk(TxSelectOkBody body, int channelId) throws AMQException {
        throw new UnexpectedMethodException((AMQMethodBody)body);
    }

    public boolean dispatchConnectionSecureOk(ConnectionSecureOkBody body, int channelId) throws AMQException {
        _connectionSecureOkMethodHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchConnectionStartOk(ConnectionStartOkBody body, int channelId) throws AMQException {
        _connectionStartOkMethodHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchConnectionTuneOk(ConnectionTuneOkBody body, int channelId) throws AMQException {
        _connectionTuneOkMethodHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchDtxSelect(DtxSelectBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchDtxStart(DtxStartBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchExchangeBound(ExchangeBoundBody body, int channelId) throws AMQException {
        _exchangeBoundHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchExchangeDeclare(ExchangeDeclareBody body, int channelId) throws AMQException {
        _exchangeDeclareHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchExchangeDelete(ExchangeDeleteBody body, int channelId) throws AMQException {
        _exchangeDeleteHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchFileAck(FileAckBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchFileCancel(FileCancelBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchFileConsume(FileConsumeBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchFilePublish(FilePublishBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchFileQos(FileQosBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchFileReject(FileRejectBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchQueueBind(QueueBindBody body, int channelId) throws AMQException {
        _queueBindHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchQueueDeclare(QueueDeclareBody body, int channelId) throws AMQException {
        _queueDeclareHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchQueueDelete(QueueDeleteBody body, int channelId) throws AMQException {
        _queueDeleteHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchQueuePurge(QueuePurgeBody body, int channelId) throws AMQException {
        _queuePurgeHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchStreamCancel(StreamCancelBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchStreamConsume(StreamConsumeBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchStreamPublish(StreamPublishBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchStreamQos(StreamQosBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchTunnelRequest(TunnelRequestBody body, int channelId) throws AMQException {
        return false;
    }

    public boolean dispatchTxCommit(TxCommitBody body, int channelId) throws AMQException {
        _txCommitHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchTxRollback(TxRollbackBody body, int channelId) throws AMQException {
        _txRollbackHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    public boolean dispatchTxSelect(TxSelectBody body, int channelId) throws AMQException {
        _txSelectHandler.methodReceived(this._stateManager, body, channelId);
        return true;
    }

    static {
        _dispatcherFactories.put(ProtocolVersion.v8_0, new DispatcherFactory(){

            public MethodDispatcher createMethodDispatcher(AMQStateManager stateManager) {
                return new ServerMethodDispatcherImpl_8_0(stateManager);
            }
        });
        _dispatcherFactories.put(ProtocolVersion.v0_9, new DispatcherFactory(){

            public MethodDispatcher createMethodDispatcher(AMQStateManager stateManager) {
                return new ServerMethodDispatcherImpl_0_9(stateManager);
            }
        });
        _dispatcherFactories.put(ProtocolVersion.v0_91, new DispatcherFactory(){

            public MethodDispatcher createMethodDispatcher(AMQStateManager stateManager) {
                return new ServerMethodDispatcherImpl_0_91(stateManager);
            }
        });
        _accessRequestHandler = AccessRequestHandler.getInstance();
        _channelCloseHandler = ChannelCloseHandler.getInstance();
        _channelOpenHandler = ChannelOpenHandler.getInstance();
        _channelCloseOkHandler = ChannelCloseOkHandler.getInstance();
        _connectionCloseMethodHandler = ConnectionCloseMethodHandler.getInstance();
        _connectionCloseOkMethodHandler = ConnectionCloseOkMethodHandler.getInstance();
        _connectionOpenMethodHandler = ConnectionOpenMethodHandler.getInstance();
        _connectionTuneOkMethodHandler = ConnectionTuneOkMethodHandler.getInstance();
        _connectionSecureOkMethodHandler = ConnectionSecureOkMethodHandler.getInstance();
        _connectionStartOkMethodHandler = ConnectionStartOkMethodHandler.getInstance();
        _exchangeDeclareHandler = ExchangeDeclareHandler.getInstance();
        _exchangeDeleteHandler = ExchangeDeleteHandler.getInstance();
        _exchangeBoundHandler = ExchangeBoundHandler.getInstance();
        _basicAckMethodHandler = BasicAckMethodHandler.getInstance();
        _basicRecoverMethodHandler = BasicRecoverMethodHandler.getInstance();
        _basicConsumeMethodHandler = BasicConsumeMethodHandler.getInstance();
        _basicGetMethodHandler = BasicGetMethodHandler.getInstance();
        _basicCancelMethodHandler = BasicCancelMethodHandler.getInstance();
        _basicPublishMethodHandler = BasicPublishMethodHandler.getInstance();
        _basicQosHandler = BasicQosHandler.getInstance();
        _queueBindHandler = QueueBindHandler.getInstance();
        _queueDeclareHandler = QueueDeclareHandler.getInstance();
        _queueDeleteHandler = QueueDeleteHandler.getInstance();
        _queuePurgeHandler = QueuePurgeHandler.getInstance();
        _channelFlowHandler = ChannelFlowHandler.getInstance();
        _txSelectHandler = TxSelectHandler.getInstance();
        _txCommitHandler = TxCommitHandler.getInstance();
        _txRollbackHandler = TxRollbackHandler.getInstance();
        _basicRejectMethodHandler = BasicRejectMethodHandler.getInstance();
    }

    private static interface DispatcherFactory {
        public MethodDispatcher createMethodDispatcher(AMQStateManager var1);
    }
}

