/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging;

import java.util.Iterator;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogRecorder
implements Appender,
Iterable<Record> {
    private ErrorHandler _errorHandler;
    private Filter _filter;
    private String _name;
    private long _recordId;
    private final int _bufferSize = 4096;
    private final int _mask = 4095;
    private Record[] _records = new Record[4096];

    public LogRecorder() {
        Logger.getRootLogger().addAppender((Appender)this);
    }

    public void addFilter(Filter filter) {
        this._filter = filter;
    }

    public void clearFilters() {
        this._filter = null;
    }

    public void close() {
    }

    public synchronized void doAppend(LoggingEvent loggingEvent) {
        this._records[(int)(this._recordId & 0xFFFL)] = new Record(this._recordId, loggingEvent);
        ++this._recordId;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public Filter getFilter() {
        return this._filter;
    }

    public Layout getLayout() {
        return null;
    }

    public String getName() {
        return this._name;
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    public void setLayout(Layout layout) {
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public Iterator<Record> iterator() {
        return new RecordIterator(Math.max(this._recordId - 4096L, 0L));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RecordIterator
    implements Iterator<Record> {
        private long _id;

        public RecordIterator(long currentRecordId) {
            this._id = currentRecordId;
        }

        @Override
        public boolean hasNext() {
            return this._id < LogRecorder.this._recordId;
        }

        @Override
        public Record next() {
            Record record = LogRecorder.this._records[(int)(this._id & 0xFFFL)];
            while (this._id < LogRecorder.this._recordId - 4096L) {
                this._id = LogRecorder.this._recordId - 4096L;
                record = LogRecorder.this._records[(int)(this._id & 0xFFFL)];
            }
            ++this._id;
            return record;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Record {
        private final long _id;
        private final String _logger;
        private final long _timestamp;
        private final String _threadName;
        private final String _level;
        private final String _message;

        public Record(long id, LoggingEvent event) {
            this._id = id;
            this._logger = event.getLoggerName();
            this._timestamp = event.timeStamp;
            this._threadName = event.getThreadName();
            this._level = event.getLevel().toString();
            this._message = event.getRenderedMessage();
        }

        public long getId() {
            return this._id;
        }

        public long getTimestamp() {
            return this._timestamp;
        }

        public String getThreadName() {
            return this._threadName;
        }

        public String getLevel() {
            return this._level;
        }

        public String getMessage() {
            return this._message;
        }

        public String getLogger() {
            return this._logger;
        }
    }
}

