/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.net.InetSocketAddress;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.common.QpidProperties;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.AuthenticationProviderAdapter;
import org.apache.qpid.server.model.adapter.HTTPPortAdapter;
import org.apache.qpid.server.model.adapter.PortAdapter;
import org.apache.qpid.server.model.adapter.StatisticsAdapter;
import org.apache.qpid.server.model.adapter.VirtualHostAdapter;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.IAuthenticationManagerRegistry;
import org.apache.qpid.server.transport.QpidAcceptor;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerAdapter
extends AbstractAdapter
implements Broker,
VirtualHostRegistry.RegistryChangeListener,
IApplicationRegistry.PortBindingListener,
IAuthenticationManagerRegistry.RegistryChangeListener {
    private final IApplicationRegistry _applicationRegistry;
    private String _name;
    private final Map<org.apache.qpid.server.virtualhost.VirtualHost, VirtualHostAdapter> _vhostAdapters = new HashMap<org.apache.qpid.server.virtualhost.VirtualHost, VirtualHostAdapter>();
    private final StatisticsAdapter _statistics;
    private final Map<QpidAcceptor, PortAdapter> _portAdapters = new HashMap<QpidAcceptor, PortAdapter>();
    private Collection<HTTPPortAdapter> _httpManagementPorts;
    private final Map<AuthenticationManager, AuthenticationProviderAdapter> _authManagerAdapters = new HashMap<AuthenticationManager, AuthenticationProviderAdapter>();

    public BrokerAdapter(IApplicationRegistry instance) {
        super(UUIDGenerator.generateRandomUUID());
        this._applicationRegistry = instance;
        this._name = "Broker";
        this._statistics = new StatisticsAdapter(instance);
        instance.getVirtualHostRegistry().addRegistryChangeListener(this);
        this.populateVhosts();
        instance.addPortBindingListener(this);
        this.populatePorts();
        instance.addRegistryChangeListener(this);
        this.populateAuthenticationManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateVhosts() {
        Map<org.apache.qpid.server.virtualhost.VirtualHost, VirtualHostAdapter> map = this._vhostAdapters;
        synchronized (map) {
            Collection<org.apache.qpid.server.virtualhost.VirtualHost> actualVhosts = this._applicationRegistry.getVirtualHostRegistry().getVirtualHosts();
            for (org.apache.qpid.server.virtualhost.VirtualHost vh : actualVhosts) {
                if (this._vhostAdapters.containsKey(vh)) continue;
                this._vhostAdapters.put(vh, new VirtualHostAdapter(this, vh));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<VirtualHost> getVirtualHosts() {
        Map<org.apache.qpid.server.virtualhost.VirtualHost, VirtualHostAdapter> map = this._vhostAdapters;
        synchronized (map) {
            return new ArrayList<VirtualHost>(this._vhostAdapters.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populatePorts() {
        Map<QpidAcceptor, PortAdapter> map = this._portAdapters;
        synchronized (map) {
            Map<InetSocketAddress, QpidAcceptor> acceptors = this._applicationRegistry.getAcceptors();
            for (Map.Entry<InetSocketAddress, QpidAcceptor> entry : acceptors.entrySet()) {
                if (this._portAdapters.containsKey(entry.getValue())) continue;
                this._portAdapters.put(entry.getValue(), new PortAdapter(this, entry.getValue(), entry.getKey()));
            }
            if (this._applicationRegistry.useHTTPManagement() || this._applicationRegistry.useHTTPSManagement()) {
                ArrayList<HTTPPortAdapter> httpPorts = new ArrayList<HTTPPortAdapter>();
                if (this._applicationRegistry.useHTTPManagement()) {
                    httpPorts.add(new HTTPPortAdapter(this, this._applicationRegistry.getHTTPManagementPort()));
                }
                if (this._applicationRegistry.useHTTPSManagement()) {
                    httpPorts.add(new HTTPPortAdapter(this, this._applicationRegistry.getHTTPSManagementPort(), Protocol.HTTPS, Transport.SSL));
                }
                this._httpManagementPorts = Collections.unmodifiableCollection(httpPorts);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Port> getPorts() {
        Map<QpidAcceptor, PortAdapter> map = this._portAdapters;
        synchronized (map) {
            ArrayList<Port> ports = new ArrayList<Port>(this._portAdapters.values());
            if (this._httpManagementPorts != null) {
                ports.addAll(this._httpManagementPorts);
            }
            return ports;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateAuthenticationManagers() {
        Map<AuthenticationManager, AuthenticationProviderAdapter> map = this._authManagerAdapters;
        synchronized (map) {
            IAuthenticationManagerRegistry authenticationManagerRegistry = this._applicationRegistry.getAuthenticationManagerRegistry();
            if (authenticationManagerRegistry != null) {
                Map<String, AuthenticationManager> authenticationManagers = authenticationManagerRegistry.getAvailableAuthenticationManagers();
                for (Map.Entry<String, AuthenticationManager> entry : authenticationManagers.entrySet()) {
                    if (this._authManagerAdapters.containsKey(entry.getValue())) continue;
                    this._authManagerAdapters.put(entry.getValue(), AuthenticationProviderAdapter.createAuthenticationProviderAdapter(this, entry.getValue()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<AuthenticationProvider> getAuthenticationProviders() {
        Map<AuthenticationManager, AuthenticationProviderAdapter> map = this._authManagerAdapters;
        synchronized (map) {
            ArrayList<AuthenticationProvider> authManagers = new ArrayList<AuthenticationProvider>(this._authManagerAdapters.values());
            return authManagers;
        }
    }

    @Override
    public VirtualHost createVirtualHost(String name, State initialState, boolean durable, LifetimePolicy lifetime, long ttl, Map<String, Object> attributes) throws AccessControlException, IllegalArgumentException {
        return null;
    }

    public VirtualHost createVirtualHost(Map<String, Object> attributes) throws AccessControlException, IllegalArgumentException {
        return null;
    }

    @Override
    public void deleteVirtualHost(VirtualHost vhost) throws AccessControlException, IllegalStateException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        return null;
    }

    @Override
    public State getActualState() {
        return null;
    }

    @Override
    public boolean isDurable() {
        return true;
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return LifetimePolicy.PERMANENT;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public Statistics getStatistics() {
        return this._statistics;
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        if (clazz == VirtualHost.class) {
            return this.getVirtualHosts();
        }
        if (clazz == Port.class) {
            return this.getPorts();
        }
        if (clazz == AuthenticationProvider.class) {
            return this.getAuthenticationProviders();
        }
        return Collections.emptySet();
    }

    @Override
    public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        if (childClass == VirtualHost.class) {
            return (C)this.createVirtualHost(attributes);
        }
        if (childClass == Port.class) {
            return (C)this.createPort(attributes);
        }
        if (childClass == AuthenticationProvider.class) {
            return (C)this.createAuthenticationProvider(attributes);
        }
        throw new IllegalArgumentException("Cannot create child of class " + childClass.getSimpleName());
    }

    private Port createPort(Map<String, Object> attributes) {
        return null;
    }

    private AuthenticationProvider createAuthenticationProvider(Map<String, Object> attributes) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void virtualHostRegistered(org.apache.qpid.server.virtualhost.VirtualHost virtualHost) {
        VirtualHostAdapter adapter = null;
        Map<org.apache.qpid.server.virtualhost.VirtualHost, VirtualHostAdapter> map = this._vhostAdapters;
        synchronized (map) {
            if (!this._vhostAdapters.containsKey(virtualHost)) {
                adapter = new VirtualHostAdapter(this, virtualHost);
                this._vhostAdapters.put(virtualHost, adapter);
            }
        }
        if (adapter != null) {
            this.childAdded(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void virtualHostUnregistered(org.apache.qpid.server.virtualhost.VirtualHost virtualHost) {
        VirtualHostAdapter adapter = null;
        Map<org.apache.qpid.server.virtualhost.VirtualHost, VirtualHostAdapter> map = this._vhostAdapters;
        synchronized (map) {
            adapter = this._vhostAdapters.remove(virtualHost);
        }
        if (adapter != null) {
            this.childRemoved(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authenticationManagerRegistered(AuthenticationManager authenticationManager) {
        AuthenticationProviderAdapter adapter = null;
        Map<AuthenticationManager, AuthenticationProviderAdapter> map = this._authManagerAdapters;
        synchronized (map) {
            if (!this._authManagerAdapters.containsKey(authenticationManager)) {
                adapter = AuthenticationProviderAdapter.createAuthenticationProviderAdapter(this, authenticationManager);
                this._authManagerAdapters.put(authenticationManager, adapter);
            }
        }
        if (adapter != null) {
            this.childAdded(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authenticationManagerUnregistered(AuthenticationManager authenticationManager) {
        AuthenticationProviderAdapter adapter;
        Map<AuthenticationManager, AuthenticationProviderAdapter> map = this._authManagerAdapters;
        synchronized (map) {
            adapter = this._authManagerAdapters.remove(authenticationManager);
        }
        if (adapter != null) {
            this.childRemoved(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bound(QpidAcceptor acceptor, InetSocketAddress bindAddress) {
        Map<QpidAcceptor, PortAdapter> map = this._portAdapters;
        synchronized (map) {
            if (!this._portAdapters.containsKey(acceptor)) {
                PortAdapter adapter = new PortAdapter(this, acceptor, bindAddress);
                this._portAdapters.put(acceptor, adapter);
                this.childAdded(adapter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbound(QpidAcceptor acceptor) {
        PortAdapter adapter = null;
        Map<QpidAcceptor, PortAdapter> map = this._portAdapters;
        synchronized (map) {
            adapter = this._portAdapters.remove(acceptor);
        }
        if (adapter != null) {
            this.childRemoved(adapter);
        }
    }

    @Override
    public Collection<String> getAttributeNames() {
        return AVAILABLE_ATTRIBUTES;
    }

    @Override
    public Object getAttribute(String name) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("name".equals(name)) {
            return this.getName();
        }
        if ("state".equals(name)) {
            return State.ACTIVE;
        }
        if ("durable".equals(name)) {
            return this.isDurable();
        }
        if ("lifetimePolicy".equals(name)) {
            return LifetimePolicy.PERMANENT;
        }
        if (!("timeToLive".equals(name) || "created".equals(name) || "updated".equals(name))) {
            if ("buildVersion".equals(name)) {
                return QpidProperties.getBuildVersion();
            }
            if (!"bytesRetained".equals(name)) {
                if ("operatingSystem".equals(name)) {
                    return System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch");
                }
                if ("platform".equals(name)) {
                    return System.getProperty("java.vendor") + " " + System.getProperty("java.runtime.version", System.getProperty("java.version"));
                }
                if (!"processPid".equals(name)) {
                    if ("productVersion".equals(name)) {
                        return QpidProperties.getReleaseVersion();
                    }
                    if ("supportedStoreTypes".equals(name)) {
                        // empty if block
                    }
                }
            }
        }
        return super.getAttribute(name);
    }

    @Override
    public Object setAttribute(String name, Object expected, Object desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return super.setAttribute(name, expected, desired);
    }
}

