/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.protocol.ProtocolEngineFactory;
import org.apache.qpid.protocol.ServerProtocolEngine;
import org.apache.qpid.server.protocol.AmqpProtocolVersion;
import org.apache.qpid.server.protocol.MultiVersionProtocolEngine;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.registry.IApplicationRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiVersionProtocolEngineFactory
implements ProtocolEngineFactory {
    private static final AtomicLong ID_GENERATOR = new AtomicLong(0L);
    private final IApplicationRegistry _appRegistry;
    private final Set<AmqpProtocolVersion> _supported;
    private final AmqpProtocolVersion _defaultSupportedReply;

    public MultiVersionProtocolEngineFactory(Set<AmqpProtocolVersion> supportedVersions, AmqpProtocolVersion defaultSupportedReply) {
        if (defaultSupportedReply != null && !supportedVersions.contains((Object)defaultSupportedReply)) {
            throw new IllegalArgumentException("The configured default reply (" + (Object)((Object)defaultSupportedReply) + ") to an unsupported protocol version initiation is itself not supported!");
        }
        this._appRegistry = ApplicationRegistry.getInstance();
        this._supported = supportedVersions;
        this._defaultSupportedReply = defaultSupportedReply;
    }

    public ServerProtocolEngine newProtocolEngine() {
        return new MultiVersionProtocolEngine(this._appRegistry, this._supported, this._defaultSupportedReply, ID_GENERATOR.getAndIncrement());
    }
}

