/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.qpid.protocol.ServerProtocolEngine;
import org.apache.qpid.server.configuration.ConfigStore;
import org.apache.qpid.server.configuration.ConfiguredObject;
import org.apache.qpid.server.configuration.ConnectionConfig;
import org.apache.qpid.server.configuration.ConnectionConfigType;
import org.apache.qpid.server.configuration.VirtualHostConfig;
import org.apache.qpid.server.logging.messages.ConnectionMessages;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.transport.ServerConnection;
import org.apache.qpid.transport.Receiver;
import org.apache.qpid.transport.Sender;
import org.apache.qpid.transport.network.Assembler;
import org.apache.qpid.transport.network.Disassembler;
import org.apache.qpid.transport.network.InputHandler;
import org.apache.qpid.transport.network.NetworkConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolEngine_0_10
extends InputHandler
implements ServerProtocolEngine,
ConnectionConfig {
    public static final int MAX_FRAME_SIZE = 65535;
    private NetworkConnection _network;
    private long _readBytes;
    private long _writtenBytes;
    private ServerConnection _connection;
    private final UUID _qmfId;
    private final IApplicationRegistry _appRegistry;
    private long _createTime = System.currentTimeMillis();

    public ProtocolEngine_0_10(ServerConnection conn, NetworkConnection network, IApplicationRegistry appRegistry) {
        super((Receiver)new Assembler((Receiver)conn));
        this._connection = conn;
        this._connection.setConnectionConfig(this);
        this._qmfId = appRegistry.getConfigStore().createId();
        this._appRegistry = appRegistry;
        if (network != null) {
            this.setNetworkConnection(network);
        }
        this._connection.onOpen(new Runnable(){

            public void run() {
                ProtocolEngine_0_10.this.getConfigStore().addConfiguredObject(ProtocolEngine_0_10.this);
            }
        });
    }

    public void setNetworkConnection(NetworkConnection network) {
        this.setNetworkConnection(network, (Sender<ByteBuffer>)network.getSender());
    }

    public void setNetworkConnection(NetworkConnection network, Sender<ByteBuffer> sender) {
        this._network = network;
        this._connection.setSender((Sender)new Disassembler(sender, 65535));
        this._connection.setPeerPrincipal(this._network.getPeerPrincipal());
        this._connection.getLogActor().message(ConnectionMessages.OPEN(null, null, null, false, false, false));
        this._connection.getLogActor().message(ConnectionMessages.OPEN(null, "0-10", null, false, true, false));
    }

    public SocketAddress getRemoteAddress() {
        return this._network.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this._network.getLocalAddress();
    }

    public void received(ByteBuffer buf) {
        super.received(buf);
        this._connection.receivedComplete();
    }

    public long getReadBytes() {
        return this._readBytes;
    }

    public long getWrittenBytes() {
        return this._writtenBytes;
    }

    public void writerIdle() {
    }

    public void readerIdle() {
    }

    @Override
    public VirtualHostConfig getVirtualHost() {
        return this._connection.getVirtualHost();
    }

    @Override
    public String getAddress() {
        return this.getRemoteAddress().toString();
    }

    @Override
    public Boolean isIncoming() {
        return true;
    }

    @Override
    public Boolean isSystemConnection() {
        return false;
    }

    @Override
    public Boolean isFederationLink() {
        return false;
    }

    @Override
    public String getAuthId() {
        return this._connection.getAuthorizedPrincipal() == null ? null : this._connection.getAuthorizedPrincipal().getName();
    }

    @Override
    public String getRemoteProcessName() {
        return null;
    }

    @Override
    public Integer getRemotePID() {
        return null;
    }

    @Override
    public Integer getRemoteParentPID() {
        return null;
    }

    @Override
    public ConfigStore getConfigStore() {
        return this._appRegistry.getConfigStore();
    }

    @Override
    public UUID getQMFId() {
        return this._qmfId;
    }

    @Override
    public ConnectionConfigType getConfigType() {
        return ConnectionConfigType.getInstance();
    }

    @Override
    public ConfiguredObject getParent() {
        return this.getVirtualHost();
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    public void closed() {
        super.closed();
        this.getConfigStore().removeConfiguredObject(this);
    }

    @Override
    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public Boolean isShadow() {
        return false;
    }

    @Override
    public void mgmtClose() {
        this._connection.mgmtClose();
    }

    public long getConnectionId() {
        return this._connection.getConnectionId();
    }
}

