/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryIterator;
import org.apache.qpid.server.queue.QueueEntryList;
import org.apache.qpid.server.queue.QueueEntryListFactory;
import org.apache.qpid.server.queue.SimpleQueueEntryImpl;
import org.apache.qpid.server.queue.SimpleQueueEntryList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityQueueList
implements QueueEntryList<SimpleQueueEntryImpl> {
    private final AMQQueue _queue;
    private final PriorityQueueEntrySubList[] _priorityLists;
    private final int _priorities;
    private final int _priorityOffset;

    public PriorityQueueList(AMQQueue queue, int priorities) {
        this._queue = queue;
        this._priorityLists = new PriorityQueueEntrySubList[priorities];
        this._priorities = priorities;
        this._priorityOffset = 5 - (priorities + 1) / 2;
        for (int i = 0; i < priorities; ++i) {
            this._priorityLists[i] = new PriorityQueueEntrySubList(queue, i);
        }
    }

    @Override
    public int getPriorities() {
        return this._priorities;
    }

    @Override
    public AMQQueue getQueue() {
        return this._queue;
    }

    @Override
    public SimpleQueueEntryImpl add(ServerMessage message) {
        int index = message.getMessageHeader().getPriority() - this._priorityOffset;
        if (index >= this._priorities) {
            index = this._priorities - 1;
        } else if (index < 0) {
            index = 0;
        }
        return this._priorityLists[index].add(message);
    }

    @Override
    public SimpleQueueEntryImpl next(SimpleQueueEntryImpl node) {
        SimpleQueueEntryImpl next = node.getNextValidEntry();
        if (next == null) {
            QueueEntryList nodeEntryList = node.getQueueEntryList();
            int index = this._priorityLists.length - 1;
            while (this._priorityLists[index] != nodeEntryList) {
                --index;
            }
            while (next == null && index != 0) {
                next = this._priorityLists[--index].getHead().getNextValidEntry();
            }
        }
        return next;
    }

    public PriorityQueueEntryListIterator iterator() {
        return new PriorityQueueEntryListIterator();
    }

    @Override
    public SimpleQueueEntryImpl getHead() {
        return this._priorityLists[this._priorities - 1].getHead();
    }

    @Override
    public void entryDeleted(SimpleQueueEntryImpl queueEntry) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PriorityQueueEntryImpl
    extends SimpleQueueEntryImpl {
        public PriorityQueueEntryImpl(PriorityQueueEntrySubList queueEntryList, ServerMessage<?> message) {
            super(queueEntryList, (ServerMessage)message);
        }

        @Override
        public int compareTo(QueueEntry o) {
            PriorityQueueEntrySubList pqel = (PriorityQueueEntrySubList)((PriorityQueueEntryImpl)o).getQueueEntryList();
            int otherPriority = pqel.getListPriority();
            int thisPriority = ((PriorityQueueEntrySubList)this.getQueueEntryList()).getListPriority();
            if (thisPriority != otherPriority) {
                return thisPriority > otherPriority ? -1 : 1;
            }
            return super.compareTo(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PriorityQueueEntrySubList
    extends SimpleQueueEntryList {
        private int _listPriority;

        public PriorityQueueEntrySubList(AMQQueue queue, int listPriority) {
            super(queue);
            this._listPriority = listPriority;
        }

        @Override
        protected PriorityQueueEntryImpl createQueueEntry(ServerMessage<?> message) {
            return new PriorityQueueEntryImpl(this, message);
        }

        public int getListPriority() {
            return this._listPriority;
        }
    }

    static class Factory
    implements QueueEntryListFactory {
        private final int _priorities;

        Factory(int priorities) {
            this._priorities = priorities;
        }

        public PriorityQueueList createQueueEntryList(AMQQueue queue) {
            return new PriorityQueueList(queue, this._priorities);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PriorityQueueEntryListIterator
    implements QueueEntryIterator<SimpleQueueEntryImpl> {
        private final SimpleQueueEntryList.QueueEntryIteratorImpl[] _iterators;
        private SimpleQueueEntryImpl _lastNode;

        PriorityQueueEntryListIterator() {
            this._iterators = new SimpleQueueEntryList.QueueEntryIteratorImpl[PriorityQueueList.this._priorityLists.length];
            for (int i = 0; i < PriorityQueueList.this._priorityLists.length; ++i) {
                this._iterators[i] = PriorityQueueList.this._priorityLists[i].iterator();
            }
            this._lastNode = this._iterators[this._iterators.length - 1].getNode();
        }

        @Override
        public boolean atTail() {
            for (int i = 0; i < this._iterators.length; ++i) {
                if (this._iterators[i].atTail()) continue;
                return false;
            }
            return true;
        }

        @Override
        public SimpleQueueEntryImpl getNode() {
            return this._lastNode;
        }

        @Override
        public boolean advance() {
            for (int i = this._iterators.length - 1; i >= 0; --i) {
                if (!this._iterators[i].advance()) continue;
                this._lastNode = this._iterators[i].getNode();
                return true;
            }
            return false;
        }
    }
}

