/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.pool.ReferenceCountingExecutorService;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.configuration.ConfigStore;
import org.apache.qpid.server.configuration.ConfiguredObject;
import org.apache.qpid.server.configuration.QueueConfigType;
import org.apache.qpid.server.configuration.QueueConfiguration;
import org.apache.qpid.server.configuration.plugins.ConfigurationPlugin;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.actors.QueueActor;
import org.apache.qpid.server.logging.messages.QueueMessages;
import org.apache.qpid.server.logging.subjects.QueueLogSubject;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.InboundMessageAdapter;
import org.apache.qpid.server.queue.NotificationCheck;
import org.apache.qpid.server.queue.QueueContext;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryIterator;
import org.apache.qpid.server.queue.QueueEntryList;
import org.apache.qpid.server.queue.QueueEntryListFactory;
import org.apache.qpid.server.queue.QueueEntryVisitor;
import org.apache.qpid.server.queue.QueueRunner;
import org.apache.qpid.server.queue.SimpleQueueEntryList;
import org.apache.qpid.server.queue.SubFlushRunner;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.security.AuthorizationHolder;
import org.apache.qpid.server.subscription.AssignedSubscriptionMessageGroupManager;
import org.apache.qpid.server.subscription.DefinedGroupMessageGroupManager;
import org.apache.qpid.server.subscription.MessageGroupManager;
import org.apache.qpid.server.subscription.Subscription;
import org.apache.qpid.server.subscription.SubscriptionList;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.LocalTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAMQQueue
implements AMQQueue,
Subscription.StateListener,
MessageGroupManager.SubscriptionResetHelper {
    private static final Logger _logger = Logger.getLogger(SimpleAMQQueue.class);
    private static final String QPID_GROUP_HEADER_KEY = "qpid.group_header_key";
    private static final String QPID_SHARED_MSG_GROUP = "qpid.shared_msg_group";
    private static final String QPID_DEFAULT_MESSAGE_GROUP = "qpid.default-message-group";
    private static final String QPID_NO_GROUP = "qpid.no-group";
    private static final int DEFAULT_MAX_GROUPS = 255;
    private final VirtualHost _virtualHost;
    private final AMQShortString _name;
    private final AMQShortString _owner;
    private AuthorizationHolder _authorizationHolder;
    private boolean _exclusive = false;
    private AMQSessionModel _exclusiveOwner;
    private final boolean _durable;
    private final boolean _autoDelete;
    private Exchange _alternateExchange;
    private final QueueEntryList<QueueEntry> _entries;
    private final SubscriptionList _subscriptionList = new SubscriptionList();
    private volatile Subscription _exclusiveSubscriber;
    private final AtomicInteger _atomicQueueCount = new AtomicInteger(0);
    private final AtomicLong _atomicQueueSize = new AtomicLong(0L);
    private final AtomicInteger _activeSubscriberCount = new AtomicInteger();
    private final AtomicLong _totalMessagesReceived = new AtomicLong();
    private final AtomicLong _dequeueCount = new AtomicLong();
    private final AtomicLong _dequeueSize = new AtomicLong();
    private final AtomicLong _enqueueCount = new AtomicLong();
    private final AtomicLong _enqueueSize = new AtomicLong();
    private final AtomicLong _persistentMessageEnqueueSize = new AtomicLong();
    private final AtomicLong _persistentMessageDequeueSize = new AtomicLong();
    private final AtomicLong _persistentMessageEnqueueCount = new AtomicLong();
    private final AtomicLong _persistentMessageDequeueCount = new AtomicLong();
    private final AtomicInteger _counsumerCountHigh = new AtomicInteger(0);
    private final AtomicLong _msgTxnEnqueues = new AtomicLong(0L);
    private final AtomicLong _byteTxnEnqueues = new AtomicLong(0L);
    private final AtomicLong _msgTxnDequeues = new AtomicLong(0L);
    private final AtomicLong _byteTxnDequeues = new AtomicLong(0L);
    private final AtomicLong _unackedMsgCount = new AtomicLong(0L);
    private final AtomicLong _unackedMsgCountHigh = new AtomicLong(0L);
    private final AtomicLong _unackedMsgBytes = new AtomicLong();
    private final AtomicInteger _bindingCountHigh = new AtomicInteger();
    private long _maximumMessageSize = ApplicationRegistry.getInstance().getConfiguration().getMaximumMessageSize();
    private long _maximumMessageCount = ApplicationRegistry.getInstance().getConfiguration().getMaximumMessageCount();
    private long _maximumQueueDepth = ApplicationRegistry.getInstance().getConfiguration().getMaximumQueueDepth();
    private long _maximumMessageAge = ApplicationRegistry.getInstance().getConfiguration().getMaximumMessageAge();
    private long _minimumAlertRepeatGap = ApplicationRegistry.getInstance().getConfiguration().getMinimumAlertRepeatGap();
    private long _capacity = ApplicationRegistry.getInstance().getConfiguration().getCapacity();
    private long _flowResumeCapacity = ApplicationRegistry.getInstance().getConfiguration().getFlowResumeCapacity();
    private final Set<NotificationCheck> _notificationChecks = EnumSet.noneOf(NotificationCheck.class);
    static final int MAX_ASYNC_DELIVERIES = 80;
    private final AtomicLong _stateChangeCount = new AtomicLong(Long.MIN_VALUE);
    private final Executor _asyncDelivery;
    private AtomicInteger _deliveredMessages = new AtomicInteger();
    private AtomicBoolean _stopped = new AtomicBoolean(false);
    private final Set<AMQSessionModel> _blockedChannels = new ConcurrentSkipListSet<AMQSessionModel>();
    private final AtomicBoolean _deleted = new AtomicBoolean(false);
    private final List<AMQQueue.Task> _deleteTaskList = new CopyOnWriteArrayList<AMQQueue.Task>();
    private LogSubject _logSubject;
    private LogActor _logActor;
    private static final String SUB_FLUSH_RUNNER = "SUB_FLUSH_RUNNER";
    private boolean _nolocal;
    private final AtomicBoolean _overfull = new AtomicBoolean(false);
    private boolean _deleteOnNoConsumers;
    private final CopyOnWriteArrayList<Binding> _bindings = new CopyOnWriteArrayList();
    private UUID _id;
    private final Map<String, Object> _arguments;
    private long _createTime = System.currentTimeMillis();
    private UUID _qmfId;
    private ConfigurationPlugin _queueConfiguration;
    private int _maximumDeliveryCount = ApplicationRegistry.getInstance().getConfiguration().getMaxDeliveryCount();
    private final MessageGroupManager _messageGroupManager;
    private final Collection<AMQQueue.SubscriptionRegistrationListener> _subscriptionListeners = new ArrayList<AMQQueue.SubscriptionRegistrationListener>();
    private AMQQueue.NotificationListener _notificationListener;
    private final long[] _lastNotificationTimes = new long[NotificationCheck.values().length];
    private QueueRunner _queueRunner = new QueueRunner(this);

    protected SimpleAMQQueue(UUID id, AMQShortString name, boolean durable, AMQShortString owner, boolean autoDelete, boolean exclusive, VirtualHost virtualHost, Map<String, Object> arguments) {
        this(id, name, durable, owner, autoDelete, exclusive, virtualHost, (QueueEntryListFactory)new SimpleQueueEntryList.Factory(), arguments);
    }

    public SimpleAMQQueue(UUID id, String queueName, boolean durable, String owner, boolean autoDelete, boolean exclusive, VirtualHost virtualHost, Map<String, Object> arguments) {
        this(id, queueName, durable, owner, autoDelete, exclusive, virtualHost, (QueueEntryListFactory)new SimpleQueueEntryList.Factory(), arguments);
    }

    public SimpleAMQQueue(UUID id, String queueName, boolean durable, String owner, boolean autoDelete, boolean exclusive, VirtualHost virtualHost, QueueEntryListFactory entryListFactory, Map<String, Object> arguments) {
        this(id, queueName == null ? null : new AMQShortString(queueName), durable, owner == null ? null : new AMQShortString(owner), autoDelete, exclusive, virtualHost, entryListFactory, arguments);
    }

    protected SimpleAMQQueue(UUID id, AMQShortString name, boolean durable, AMQShortString owner, boolean autoDelete, boolean exclusive, VirtualHost virtualHost, QueueEntryListFactory entryListFactory, Map<String, Object> arguments) {
        if (name == null) {
            throw new IllegalArgumentException("Queue name must not be null");
        }
        if (virtualHost == null) {
            throw new IllegalArgumentException("Virtual Host must not be null");
        }
        this._name = name;
        this._durable = durable;
        this._owner = owner;
        this._autoDelete = autoDelete;
        this._exclusive = exclusive;
        this._virtualHost = virtualHost;
        this._entries = entryListFactory.createQueueEntryList(this);
        this._arguments = arguments == null ? new HashMap<String, Object>() : new HashMap<String, Object>(arguments);
        this._id = id;
        this._qmfId = this.getConfigStore().createId();
        this._asyncDelivery = ReferenceCountingExecutorService.getInstance().acquireExecutorService();
        this._logSubject = new QueueLogSubject(this);
        this._logActor = new QueueActor(this, CurrentActor.get().getRootMessageLogger());
        CurrentActor.get().message(this._logSubject, QueueMessages.CREATED(String.valueOf(this._owner), this._entries.getPriorities(), this._owner != null, autoDelete, durable, !durable, this._entries.getPriorities() > 0));
        this.getConfigStore().addConfiguredObject(this);
        if (arguments != null && arguments.containsKey(QPID_GROUP_HEADER_KEY)) {
            if (arguments.containsKey(QPID_SHARED_MSG_GROUP) && String.valueOf(arguments.get(QPID_SHARED_MSG_GROUP)).equals("1")) {
                Object defaultGroup = arguments.get(QPID_DEFAULT_MESSAGE_GROUP);
                this._messageGroupManager = new DefinedGroupMessageGroupManager(String.valueOf(arguments.get(QPID_GROUP_HEADER_KEY)), defaultGroup == null ? QPID_NO_GROUP : defaultGroup.toString(), this);
            } else {
                this._messageGroupManager = new AssignedSubscriptionMessageGroupManager(String.valueOf(arguments.get(QPID_GROUP_HEADER_KEY)), 255);
            }
        } else {
            this._messageGroupManager = null;
        }
        this.resetNotifications();
    }

    public void resetNotifications() {
        this.setMaximumMessageAge(this._maximumMessageAge);
        this.setMaximumMessageCount(this._maximumMessageCount);
        this.setMaximumMessageSize(this._maximumMessageSize);
        this.setMaximumQueueDepth(this._maximumQueueDepth);
    }

    public void execute(Runnable runnable) {
        block2: {
            try {
                this._asyncDelivery.execute(runnable);
            }
            catch (RejectedExecutionException ree) {
                if (this._stopped.get()) break block2;
                _logger.error((Object)"Unexpected rejected execution", (Throwable)ree);
                throw ree;
            }
        }
    }

    @Override
    public AMQShortString getNameShortString() {
        return this._name;
    }

    @Override
    public void setNoLocal(boolean nolocal) {
        this._nolocal = nolocal;
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public UUID getQMFId() {
        return this._qmfId;
    }

    @Override
    public QueueConfigType getConfigType() {
        return QueueConfigType.getInstance();
    }

    @Override
    public ConfiguredObject getParent() {
        return this.getVirtualHost();
    }

    @Override
    public boolean isDurable() {
        return this._durable;
    }

    @Override
    public boolean isExclusive() {
        return this._exclusive;
    }

    @Override
    public void setExclusive(boolean exclusive) {
        this._exclusive = exclusive;
    }

    @Override
    public Exchange getAlternateExchange() {
        return this._alternateExchange;
    }

    @Override
    public void setAlternateExchange(Exchange exchange) {
        if (this._alternateExchange != null) {
            this._alternateExchange.removeReference(this);
        }
        if (exchange != null) {
            exchange.addReference(this);
        }
        this._alternateExchange = exchange;
    }

    @Override
    public Map<String, Object> getArguments() {
        return this._arguments;
    }

    @Override
    public boolean isAutoDelete() {
        return this._autoDelete;
    }

    @Override
    public AMQShortString getOwner() {
        return this._owner;
    }

    @Override
    public AuthorizationHolder getAuthorizationHolder() {
        return this._authorizationHolder;
    }

    @Override
    public void setAuthorizationHolder(AuthorizationHolder authorizationHolder) {
        this._authorizationHolder = authorizationHolder;
    }

    @Override
    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    @Override
    public String getName() {
        return this.getNameShortString().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void registerSubscription(Subscription subscription, boolean exclusive) throws AMQSecurityException, AMQQueue.ExistingExclusiveSubscription, AMQQueue.ExistingSubscriptionPreventsExclusive {
        if (!this.getVirtualHost().getSecurityManager().authoriseConsume(this)) {
            throw new AMQSecurityException("Permission denied");
        }
        if (this.hasExclusiveSubscriber()) {
            throw new AMQQueue.ExistingExclusiveSubscription();
        }
        if (exclusive && !subscription.isTransient()) {
            if (this.getConsumerCount() != 0) {
                throw new AMQQueue.ExistingSubscriptionPreventsExclusive();
            }
            this._exclusiveSubscriber = subscription;
        }
        if (subscription.isActive()) {
            this._activeSubscriberCount.incrementAndGet();
        }
        subscription.setStateListener(this);
        subscription.setQueueContext(new QueueContext(this._entries.getHead()));
        if (!this.isDeleted()) {
            subscription.setQueue(this, exclusive);
            if (this._nolocal) {
                subscription.setNoLocal(this._nolocal);
            }
            Collection<AMQQueue.SubscriptionRegistrationListener> collection = this._subscriptionListeners;
            synchronized (collection) {
                for (AMQQueue.SubscriptionRegistrationListener listener : this._subscriptionListeners) {
                    listener.subscriptionRegistered(this, subscription);
                }
            }
            this._subscriptionList.add(subscription);
            if (this._counsumerCountHigh.get() < this.getConsumerCount()) {
                this._counsumerCountHigh.incrementAndGet();
            }
            if (this.isDeleted()) {
                subscription.queueDeleted(this);
            }
        }
        this.deliverAsync(subscription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unregisterSubscription(Subscription subscription) throws AMQException {
        if (subscription == null) {
            throw new NullPointerException("subscription argument is null");
        }
        boolean removed = this._subscriptionList.remove(subscription);
        if (removed) {
            subscription.close();
            this.setExclusiveSubscriber(null);
            subscription.setQueueContext(null);
            if (this._messageGroupManager != null) {
                this.resetSubPointersForGroups(subscription, true);
            }
            Collection<AMQQueue.SubscriptionRegistrationListener> collection = this._subscriptionListeners;
            synchronized (collection) {
                for (AMQQueue.SubscriptionRegistrationListener listener : this._subscriptionListeners) {
                    listener.subscriptionUnregistered(this, subscription);
                }
            }
            if (this._autoDelete && this.getDeleteOnNoConsumers() && !subscription.isTransient() && this.getConsumerCount() == 0) {
                if (_logger.isInfoEnabled()) {
                    _logger.info((Object)("Auto-deleteing queue:" + this));
                }
                this.delete();
                subscription.queueDeleted(this);
            }
        }
    }

    @Override
    public Collection<Subscription> getConsumers() {
        ArrayList<Subscription> consumers = new ArrayList<Subscription>();
        SubscriptionList.SubscriptionNodeIterator iter = this._subscriptionList.iterator();
        while (iter.advance()) {
            consumers.add(iter.getNode().getSubscription());
        }
        return consumers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubscriptionRegistrationListener(AMQQueue.SubscriptionRegistrationListener listener) {
        Collection<AMQQueue.SubscriptionRegistrationListener> collection = this._subscriptionListeners;
        synchronized (collection) {
            this._subscriptionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscriptionRegistrationListener(AMQQueue.SubscriptionRegistrationListener listener) {
        Collection<AMQQueue.SubscriptionRegistrationListener> collection = this._subscriptionListeners;
        synchronized (collection) {
            this._subscriptionListeners.remove(listener);
        }
    }

    @Override
    public void resetSubPointersForGroups(Subscription subscription, boolean clearAssignments) {
        QueueEntry entry = this._messageGroupManager.findEarliestAssignedAvailableEntry(subscription);
        if (clearAssignments) {
            this._messageGroupManager.clearAssignments(subscription);
        }
        if (entry != null) {
            SubscriptionList.SubscriptionNodeIterator subscriberIter = this._subscriptionList.iterator();
            while (subscriberIter.advance()) {
                Subscription sub = subscriberIter.getNode().getSubscription();
                if (!sub.seesRequeues()) continue;
                this.updateSubRequeueEntry(sub, entry);
            }
            this.deliverAsync();
        }
    }

    @Override
    public boolean getDeleteOnNoConsumers() {
        return this._deleteOnNoConsumers;
    }

    @Override
    public void setDeleteOnNoConsumers(boolean b) {
        this._deleteOnNoConsumers = b;
    }

    @Override
    public void addBinding(Binding binding) {
        int bindingCountHigh;
        this._bindings.add(binding);
        int bindingCount = this._bindings.size();
        while (bindingCount > (bindingCountHigh = this._bindingCountHigh.get()) && !this._bindingCountHigh.compareAndSet(bindingCountHigh, bindingCount)) {
        }
        this.reconfigure();
    }

    private void reconfigure() {
        ConfigurationPlugin config = this.getVirtualHost().getConfiguration().getQueueConfiguration(this);
        if (config != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Reconfiguring queue(" + this + ") with config:" + config + " was " + this._queueConfiguration));
            }
            this.configure(config);
        }
    }

    @Override
    public int getBindingCountHigh() {
        return this._bindingCountHigh.get();
    }

    @Override
    public void removeBinding(Binding binding) {
        this._bindings.remove(binding);
        this.reconfigure();
    }

    @Override
    public List<Binding> getBindings() {
        return Collections.unmodifiableList(this._bindings);
    }

    @Override
    public int getBindingCount() {
        return this.getBindings().size();
    }

    @Override
    public LogSubject getLogSubject() {
        return this._logSubject;
    }

    @Override
    public void enqueue(ServerMessage message) throws AMQException {
        this.enqueue(message, null);
    }

    @Override
    public void enqueue(ServerMessage message, BaseQueue.PostEnqueueAction action) throws AMQException {
        this.enqueue(message, false, action);
    }

    @Override
    public void enqueue(ServerMessage message, boolean transactional, BaseQueue.PostEnqueueAction action) throws AMQException {
        if (transactional) {
            this.incrementTxnEnqueueStats(message);
        }
        this.incrementQueueCount();
        this.incrementQueueSize(message);
        this._totalMessagesReceived.incrementAndGet();
        Subscription exclusiveSub = this._exclusiveSubscriber;
        QueueEntry entry = this._entries.add(message);
        if (action != null || exclusiveSub == null && this._queueRunner.isIdle()) {
            SubscriptionList.SubscriptionNode node = this._subscriptionList.getMarkedNode();
            SubscriptionList.SubscriptionNode nextNode = node.findNext();
            if (nextNode == null) {
                nextNode = this._subscriptionList.getHead().findNext();
            }
            while (nextNode != null && !this._subscriptionList.updateMarkedNode(node, nextNode)) {
                node = this._subscriptionList.getMarkedNode();
                nextNode = node.findNext();
                if (nextNode != null) continue;
                nextNode = this._subscriptionList.getHead().findNext();
            }
            int loops = 2;
            while (entry.isAvailable() && loops != 0) {
                if (nextNode == null) {
                    --loops;
                    nextNode = this._subscriptionList.getHead();
                } else {
                    Subscription sub = nextNode.getSubscription();
                    this.deliverToSubscription(sub, entry);
                }
                nextNode = nextNode.findNext();
            }
        }
        if (entry.isAvailable()) {
            this.checkSubscriptionsNotAheadOfDelivery(entry);
            if (exclusiveSub != null) {
                this.deliverAsync(exclusiveSub);
            } else {
                this.deliverAsync();
            }
        }
        this.checkForNotification(entry.getMessage());
        if (action != null) {
            action.onEnqueue(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverToSubscription(Subscription sub, QueueEntry entry) throws AMQException {
        if (sub.trySendLock()) {
            try {
                if (!sub.isSuspended() && this.subscriptionReadyAndHasInterest(sub, entry) && this.mightAssign(sub, entry) && !sub.wouldSuspend(entry)) {
                    if (!(!sub.acquires() || this.assign(sub, entry) && entry.acquire(sub))) {
                        sub.restoreCredit(entry);
                    } else {
                        this.deliverMessage(sub, entry, false);
                    }
                }
            }
            finally {
                sub.releaseSendLock();
            }
        }
    }

    private boolean assign(Subscription sub, QueueEntry entry) {
        return this._messageGroupManager == null || this._messageGroupManager.acceptMessage(sub, entry);
    }

    private boolean mightAssign(Subscription sub, QueueEntry entry) {
        if (this._messageGroupManager == null || !sub.acquires()) {
            return true;
        }
        Subscription assigned = this._messageGroupManager.getAssignedSubscription(entry);
        return assigned == null || assigned == sub;
    }

    protected void checkSubscriptionsNotAheadOfDelivery(QueueEntry entry) {
    }

    private void incrementQueueSize(ServerMessage message) {
        long size = message.getSize();
        this.getAtomicQueueSize().addAndGet(size);
        this._enqueueCount.incrementAndGet();
        this._enqueueSize.addAndGet(size);
        if (message.isPersistent() && this.isDurable()) {
            this._persistentMessageEnqueueSize.addAndGet(size);
            this._persistentMessageEnqueueCount.incrementAndGet();
        }
    }

    @Override
    public long getTotalDequeueCount() {
        return this._dequeueCount.get();
    }

    @Override
    public long getTotalEnqueueCount() {
        return this._enqueueCount.get();
    }

    private void incrementQueueCount() {
        this.getAtomicQueueCount().incrementAndGet();
    }

    private void incrementTxnEnqueueStats(ServerMessage message) {
        this._msgTxnEnqueues.incrementAndGet();
        this._byteTxnEnqueues.addAndGet(message.getSize());
    }

    private void incrementTxnDequeueStats(QueueEntry entry) {
        this._msgTxnDequeues.incrementAndGet();
        this._byteTxnDequeues.addAndGet(entry.getSize());
    }

    private void deliverMessage(Subscription sub, QueueEntry entry, boolean batch) throws AMQException {
        this.setLastSeenEntry(sub, entry);
        this._deliveredMessages.incrementAndGet();
        this.incrementUnackedMsgCount(entry);
        sub.send(entry, batch);
    }

    private boolean subscriptionReadyAndHasInterest(Subscription sub, QueueEntry entry) throws AMQException {
        return sub.hasInterest(entry) && this.getNextAvailableEntry(sub) == entry;
    }

    private void setLastSeenEntry(Subscription sub, QueueEntry entry) {
        QueueContext subContext = (QueueContext)sub.getQueueContext();
        if (subContext != null) {
            QueueEntry releasedEntry = subContext.getReleasedEntry();
            QueueContext._lastSeenUpdater.set(subContext, entry);
            if (releasedEntry == entry) {
                QueueContext._releasedUpdater.compareAndSet(subContext, releasedEntry, null);
            }
        }
    }

    private void updateSubRequeueEntry(Subscription sub, QueueEntry entry) {
        block1: {
            QueueEntry oldEntry;
            QueueContext subContext = (QueueContext)sub.getQueueContext();
            if (subContext == null) break block1;
            while (!((oldEntry = subContext.getReleasedEntry()) != null && oldEntry.compareTo(entry) <= 0 || QueueContext._releasedUpdater.compareAndSet(subContext, oldEntry, entry))) {
            }
        }
    }

    @Override
    public void requeue(QueueEntry entry) {
        SubscriptionList.SubscriptionNodeIterator subscriberIter = this._subscriptionList.iterator();
        while (subscriberIter.advance() && entry.isAvailable()) {
            Subscription sub = subscriberIter.getNode().getSubscription();
            if (!sub.seesRequeues()) continue;
            this.updateSubRequeueEntry(sub, entry);
        }
        this.deliverAsync();
    }

    @Override
    public void dequeue(QueueEntry entry, Subscription sub) {
        this.decrementQueueCount();
        this.decrementQueueSize(entry);
        if (entry.acquiredBySubscription()) {
            this._deliveredMessages.decrementAndGet();
        }
        if (sub != null && sub.isSessionTransactional()) {
            this.incrementTxnDequeueStats(entry);
        }
        this.checkCapacity();
    }

    private void decrementQueueSize(QueueEntry entry) {
        ServerMessage message = entry.getMessage();
        long size = message.getSize();
        this.getAtomicQueueSize().addAndGet(-size);
        this._dequeueSize.addAndGet(size);
        if (message.isPersistent() && this.isDurable()) {
            this._persistentMessageDequeueSize.addAndGet(size);
            this._persistentMessageDequeueCount.incrementAndGet();
        }
    }

    void decrementQueueCount() {
        this.getAtomicQueueCount().decrementAndGet();
        this._dequeueCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resend(QueueEntry entry, Subscription subscription) throws AMQException {
        subscription.getSendLock();
        try {
            if (!subscription.isClosed()) {
                this.deliverMessage(subscription, entry, false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            subscription.releaseSendLock();
        }
    }

    @Override
    public int getConsumerCount() {
        return this._subscriptionList.size();
    }

    @Override
    public int getConsumerCountHigh() {
        return this._counsumerCountHigh.get();
    }

    @Override
    public int getActiveConsumerCount() {
        return this._activeSubscriberCount.get();
    }

    @Override
    public boolean isUnused() {
        return this.getConsumerCount() == 0;
    }

    @Override
    public boolean isEmpty() {
        return this.getMessageCount() == 0;
    }

    @Override
    public int getMessageCount() {
        return this.getAtomicQueueCount().get();
    }

    @Override
    public long getQueueDepth() {
        return this.getAtomicQueueSize().get();
    }

    @Override
    public int getUndeliveredMessageCount() {
        int count = this.getMessageCount() - this._deliveredMessages.get();
        if (count < 0) {
            return 0;
        }
        return count;
    }

    @Override
    public long getReceivedMessageCount() {
        return this._totalMessagesReceived.get();
    }

    @Override
    public long getOldestMessageArrivalTime() {
        QueueEntry entry = this.getOldestQueueEntry();
        return entry == null ? Long.MAX_VALUE : entry.getMessage().getArrivalTime();
    }

    protected QueueEntry getOldestQueueEntry() {
        return this._entries.next(this._entries.getHead());
    }

    @Override
    public boolean isDeleted() {
        return this._deleted.get();
    }

    @Override
    public List<QueueEntry> getMessagesOnTheQueue() {
        ArrayList<QueueEntry> entryList = new ArrayList<QueueEntry>();
        QueueEntryIterator<QueueEntry> queueListIterator = this._entries.iterator();
        while (queueListIterator.advance()) {
            QueueEntry node = queueListIterator.getNode();
            if (node == null || node.isDispensed()) continue;
            entryList.add(node);
        }
        return entryList;
    }

    @Override
    public void stateChange(Subscription sub, Subscription.State oldState, Subscription.State newState) {
        if (oldState == Subscription.State.ACTIVE && newState != Subscription.State.ACTIVE) {
            this._activeSubscriberCount.decrementAndGet();
        } else if (newState == Subscription.State.ACTIVE) {
            if (oldState != Subscription.State.ACTIVE) {
                this._activeSubscriberCount.incrementAndGet();
            }
            this.deliverAsync(sub);
        }
    }

    @Override
    public int compareTo(AMQQueue o) {
        return this._name.compareTo(o.getNameShortString());
    }

    public AtomicInteger getAtomicQueueCount() {
        return this._atomicQueueCount;
    }

    public AtomicLong getAtomicQueueSize() {
        return this._atomicQueueSize;
    }

    @Override
    public boolean hasExclusiveSubscriber() {
        return this._exclusiveSubscriber != null;
    }

    private void setExclusiveSubscriber(Subscription exclusiveSubscriber) {
        this._exclusiveSubscriber = exclusiveSubscriber;
    }

    long getStateChangeCount() {
        return this._stateChangeCount.get();
    }

    protected QueueEntryList getEntries() {
        return this._entries;
    }

    protected SubscriptionList getSubscriptionList() {
        return this._subscriptionList;
    }

    @Override
    public List<QueueEntry> getMessagesOnTheQueue(final long fromMessageId, final long toMessageId) {
        return this.getMessagesOnTheQueue(new QueueEntryFilter(){

            public boolean accept(QueueEntry entry) {
                long messageId = entry.getMessage().getMessageNumber();
                return messageId >= fromMessageId && messageId <= toMessageId;
            }

            public boolean filterComplete() {
                return false;
            }
        });
    }

    @Override
    public QueueEntry getMessageOnTheQueue(final long messageId) {
        List<QueueEntry> entries = this.getMessagesOnTheQueue(new QueueEntryFilter(){
            private boolean _complete;

            public boolean accept(QueueEntry entry) {
                this._complete = entry.getMessage().getMessageNumber() == messageId;
                return this._complete;
            }

            public boolean filterComplete() {
                return this._complete;
            }
        });
        return entries.isEmpty() ? null : entries.get(0);
    }

    public List<QueueEntry> getMessagesOnTheQueue(QueueEntryFilter filter) {
        ArrayList<QueueEntry> entryList = new ArrayList<QueueEntry>();
        QueueEntryIterator<QueueEntry> queueListIterator = this._entries.iterator();
        while (queueListIterator.advance() && !filter.filterComplete()) {
            QueueEntry node = queueListIterator.getNode();
            if (node.isDispensed() || !filter.accept(node)) continue;
            entryList.add(node);
        }
        return entryList;
    }

    @Override
    public void visit(QueueEntryVisitor visitor) {
        QueueEntry node;
        QueueEntryIterator<QueueEntry> queueListIterator = this._entries.iterator();
        while (queueListIterator.advance() && ((node = queueListIterator.getNode()).isDispensed() || !visitor.visit(node))) {
        }
    }

    @Override
    public List<QueueEntry> getMessagesRangeOnTheQueue(final long fromPosition, final long toPosition) {
        return this.getMessagesOnTheQueue(new QueueEntryFilter(){
            private long position = 0L;

            public boolean accept(QueueEntry entry) {
                ++this.position;
                return this.position >= fromPosition && this.position <= toPosition;
            }

            public boolean filterComplete() {
                return this.position >= toPosition;
            }
        });
    }

    @Override
    public void purge(long request) throws AMQException {
        this.clear(request);
    }

    @Override
    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public void deleteMessageFromTop() {
        QueueEntryIterator<QueueEntry> queueListIterator = this._entries.iterator();
        boolean noDeletes = true;
        while (noDeletes && queueListIterator.advance()) {
            QueueEntry node = queueListIterator.getNode();
            if (!node.acquire()) continue;
            this.dequeueEntry(node);
            noDeletes = false;
        }
    }

    @Override
    public long clearQueue() throws AMQException {
        return this.clear(0L);
    }

    private long clear(long request) throws AMQSecurityException {
        if (!this.getVirtualHost().getSecurityManager().authorisePurge(this)) {
            throw new AMQSecurityException("Permission denied: queue " + this.getName());
        }
        QueueEntryIterator<QueueEntry> queueListIterator = this._entries.iterator();
        long count = 0L;
        LocalTransaction txn = new LocalTransaction(this.getVirtualHost().getMessageStore());
        while (queueListIterator.advance()) {
            QueueEntry node = queueListIterator.getNode();
            if (!node.acquire()) continue;
            this.dequeueEntry(node, txn);
            if (++count != request) continue;
            break;
        }
        txn.commit();
        return count;
    }

    private void dequeueEntry(QueueEntry node) {
        AutoCommitTransaction txn = new AutoCommitTransaction(this.getVirtualHost().getMessageStore());
        this.dequeueEntry(node, txn);
    }

    private void dequeueEntry(final QueueEntry node, ServerTransaction txn) {
        txn.dequeue(this, node.getMessage(), new ServerTransaction.Action(){

            public void postCommit() {
                node.discard();
            }

            public void onRollback() {
            }
        });
    }

    @Override
    public void addQueueDeleteTask(AMQQueue.Task task) {
        this._deleteTaskList.add(task);
    }

    @Override
    public void removeQueueDeleteTask(AMQQueue.Task task) {
        this._deleteTaskList.remove(task);
    }

    @Override
    public int delete() throws AMQSecurityException, AMQException {
        if (!this._virtualHost.getSecurityManager().authoriseDelete(this)) {
            throw new AMQSecurityException("Permission denied: " + this.getName());
        }
        if (!this._deleted.getAndSet(true)) {
            for (Binding b : this.getBindings()) {
                this._virtualHost.getBindingFactory().removeBinding(b);
            }
            SubscriptionList.SubscriptionNodeIterator subscriptionIter = this._subscriptionList.iterator();
            while (subscriptionIter.advance()) {
                Subscription s = subscriptionIter.getNode().getSubscription();
                if (s == null) continue;
                s.queueDeleted(this);
            }
            this._virtualHost.getQueueRegistry().unregisterQueue(this._name);
            this.getConfigStore().removeConfiguredObject(this);
            List<QueueEntry> entries = this.getMessagesOnTheQueue(new QueueEntryFilter(){

                public boolean accept(QueueEntry entry) {
                    return entry.acquire();
                }

                public boolean filterComplete() {
                    return false;
                }
            });
            LocalTransaction txn = new LocalTransaction(this.getVirtualHost().getMessageStore());
            if (this._alternateExchange != null) {
                InboundMessageAdapter adapter = new InboundMessageAdapter();
                for (final QueueEntry entry : entries) {
                    adapter.setEntry(entry);
                    List<? extends BaseQueue> queues = this._alternateExchange.route(adapter);
                    if ((queues == null || queues.size() == 0) && this._alternateExchange.getAlternateExchange() != null) {
                        queues = this._alternateExchange.getAlternateExchange().route(adapter);
                    }
                    final ServerMessage message = entry.getMessage();
                    if (queues == null || queues.size() == 0) continue;
                    final List<? extends BaseQueue> rerouteQueues = queues;
                    txn.enqueue(rerouteQueues, entry.getMessage(), new ServerTransaction.Action(){

                        public void postCommit() {
                            try {
                                for (BaseQueue queue : rerouteQueues) {
                                    queue.enqueue(message);
                                }
                            }
                            catch (AMQException e) {
                                throw new RuntimeException(e);
                            }
                        }

                        public void onRollback() {
                        }
                    }, 0L);
                    txn.dequeue(this, entry.getMessage(), new ServerTransaction.Action(){

                        public void postCommit() {
                            entry.discard();
                        }

                        public void onRollback() {
                        }
                    });
                }
                this._alternateExchange.removeReference(this);
            } else {
                for (final QueueEntry entry : entries) {
                    ServerMessage message = entry.getMessage();
                    if (message == null) continue;
                    txn.dequeue(this, message, new ServerTransaction.Action(){

                        public void postCommit() {
                            entry.discard();
                        }

                        public void onRollback() {
                        }
                    });
                }
            }
            txn.commit();
            for (AMQQueue.Task task : this._deleteTaskList) {
                task.doTask(this);
            }
            this._deleteTaskList.clear();
            this.stop();
            CurrentActor.get().message(this._logSubject, QueueMessages.DELETED());
        }
        return this.getMessageCount();
    }

    @Override
    public void stop() {
        if (!this._stopped.getAndSet(true)) {
            ReferenceCountingExecutorService.getInstance().releaseExecutorService();
        }
    }

    @Override
    public void checkCapacity(AMQSessionModel channel) {
        if (this._capacity != 0L && this._atomicQueueSize.get() > this._capacity) {
            this._overfull.set(true);
            this._logActor.message(this._logSubject, QueueMessages.OVERFULL(this._atomicQueueSize.get(), this._capacity));
            this._blockedChannels.add(channel);
            channel.block(this);
            if (this._atomicQueueSize.get() <= this._flowResumeCapacity) {
                this._logActor.message(this._logSubject, QueueMessages.UNDERFULL(this._atomicQueueSize.get(), this._flowResumeCapacity));
                channel.unblock(this);
                this._blockedChannels.remove(channel);
            }
        }
    }

    private void checkCapacity() {
        if (this._capacity != 0L && this._overfull.get() && this._atomicQueueSize.get() <= this._flowResumeCapacity) {
            if (this._overfull.compareAndSet(true, false)) {
                this._logActor.message(this._logSubject, QueueMessages.UNDERFULL(this._atomicQueueSize.get(), this._flowResumeCapacity));
            }
            for (AMQSessionModel blockedChannel : this._blockedChannels) {
                blockedChannel.unblock(this);
                this._blockedChannels.remove(blockedChannel);
            }
        }
    }

    @Override
    public void deliverAsync() {
        this._stateChangeCount.incrementAndGet();
        this._queueRunner.execute(this._asyncDelivery);
    }

    @Override
    public void deliverAsync(Subscription sub) {
        if (this._exclusiveSubscriber == null) {
            this.deliverAsync();
        } else {
            SubFlushRunner flusher = (SubFlushRunner)sub.get(SUB_FLUSH_RUNNER);
            if (flusher == null) {
                flusher = new SubFlushRunner(sub);
                sub.set(SUB_FLUSH_RUNNER, flusher);
            }
            flusher.execute(this._asyncDelivery);
        }
    }

    @Override
    public void flushSubscription(Subscription sub) throws AMQException {
        if (!this.getVirtualHost().getSecurityManager().authoriseConsume(this)) {
            throw new AMQSecurityException("Permission denied: " + this.getName());
        }
        this.flushSubscription(sub, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushSubscription(Subscription sub, long iterations) throws AMQException {
        boolean atTail = false;
        boolean keepSendLockHeld = iterations <= 80L;
        boolean queueEmpty = false;
        try {
            if (keepSendLockHeld) {
                sub.getSendLock();
            }
            while (!sub.isSuspended() && !atTail && iterations != 0L) {
                try {
                    if (!keepSendLockHeld) {
                        sub.getSendLock();
                    }
                    if ((atTail = this.attemptDelivery(sub, true)) && this.getNextAvailableEntry(sub) == null) {
                        queueEmpty = true;
                        continue;
                    }
                    if (atTail) continue;
                    --iterations;
                }
                finally {
                    if (keepSendLockHeld) continue;
                    sub.releaseSendLock();
                }
            }
        }
        finally {
            if (keepSendLockHeld) {
                sub.releaseSendLock();
            }
            if (queueEmpty) {
                sub.queueEmpty();
            }
            sub.flushBatched();
        }
        if (!this.hasExclusiveSubscriber()) {
            this.advanceAllSubscriptions();
        }
        return atTail;
    }

    private boolean attemptDelivery(Subscription sub, boolean batch) throws AMQException {
        boolean subActive;
        boolean atTail = false;
        boolean bl = subActive = sub.isActive() && !sub.isSuspended();
        if (subActive) {
            QueueEntry node = this.getNextAvailableEntry(sub);
            if (node != null && node.isAvailable() && sub.hasInterest(node) && this.mightAssign(sub, node)) {
                if (!sub.wouldSuspend(node)) {
                    if (!(!sub.acquires() || this.assign(sub, node) && node.acquire(sub))) {
                        sub.restoreCredit(node);
                    } else {
                        this.deliverMessage(sub, node, batch);
                    }
                } else {
                    subActive = false;
                    node.addStateChangeListener(new QueueEntryListener(sub));
                }
            }
            atTail = node == null || this._entries.next(node) == null;
        }
        return atTail || !subActive;
    }

    protected void advanceAllSubscriptions() throws AMQException {
        SubscriptionList.SubscriptionNodeIterator subscriberIter = this._subscriptionList.iterator();
        while (subscriberIter.advance()) {
            SubscriptionList.SubscriptionNode subNode = subscriberIter.getNode();
            Subscription sub = subNode.getSubscription();
            if (!sub.acquires()) continue;
            this.getNextAvailableEntry(sub);
        }
    }

    private QueueEntry getNextAvailableEntry(Subscription sub) throws AMQException {
        QueueContext context = (QueueContext)sub.getQueueContext();
        if (context != null) {
            QueueEntry lastSeen = context.getLastSeenEntry();
            QueueEntry releasedNode = context.getReleasedEntry();
            QueueEntry node = releasedNode != null && lastSeen.compareTo(releasedNode) >= 0 ? releasedNode : this._entries.next(lastSeen);
            boolean expired = false;
            while (!(node == null || node.isAvailable() && !(expired = node.expired()) && sub.hasInterest(node) && this.mightAssign(sub, node))) {
                if (expired) {
                    expired = false;
                    if (node.acquire()) {
                        this.dequeueEntry(node);
                    }
                }
                if (QueueContext._lastSeenUpdater.compareAndSet(context, lastSeen, node)) {
                    QueueContext._releasedUpdater.compareAndSet(context, releasedNode, null);
                }
                lastSeen = context.getLastSeenEntry();
                releasedNode = context.getReleasedEntry();
                node = releasedNode != null && lastSeen.compareTo(releasedNode) > 0 ? releasedNode : this._entries.next(lastSeen);
            }
            return node;
        }
        return null;
    }

    @Override
    public boolean isEntryAheadOfSubscription(QueueEntry entry, Subscription sub) {
        QueueContext context = (QueueContext)sub.getQueueContext();
        if (context != null) {
            QueueEntry releasedNode = context.getReleasedEntry();
            return releasedNode != null && releasedNode.compareTo(entry) < 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long processQueue(QueueRunner runner) throws AMQException {
        long stateChangeCount = Long.MIN_VALUE;
        long previousStateChangeCount = Long.MIN_VALUE;
        long rVal = Long.MIN_VALUE;
        boolean deliveryIncomplete = true;
        boolean lastLoop = false;
        int iterations = 80;
        int numSubs = this._subscriptionList.size();
        int perSub = Math.max(iterations / Math.max(numSubs, 1), 1);
        while (iterations != 0 && (previousStateChangeCount != (stateChangeCount = this._stateChangeCount.get()) || deliveryIncomplete)) {
            if (previousStateChangeCount != stateChangeCount) {
                lastLoop = false;
                rVal = stateChangeCount;
            }
            previousStateChangeCount = stateChangeCount;
            boolean allSubscriptionsDone = true;
            SubscriptionList.SubscriptionNodeIterator subscriptionIter = this._subscriptionList.iterator();
            while (subscriptionIter.advance()) {
                Subscription sub = subscriptionIter.getNode().getSubscription();
                sub.getSendLock();
                try {
                    for (int i = 0; i < perSub; ++i) {
                        boolean subscriptionDone = this.attemptDelivery(sub, true);
                        if (subscriptionDone) {
                            sub.flushBatched();
                            if (!lastLoop || sub.isSuspended()) break;
                            sub.queueEmpty();
                            break;
                        }
                        allSubscriptionsDone = false;
                        lastLoop = false;
                        if (--iterations != 0) continue;
                        sub.flushBatched();
                        break;
                    }
                    sub.flushBatched();
                }
                finally {
                    sub.releaseSendLock();
                }
            }
            if (allSubscriptionsDone && lastLoop) {
                deliveryIncomplete = false;
                continue;
            }
            if (allSubscriptionsDone) {
                deliveryIncomplete = this._subscriptionList.size() != 0;
                lastLoop = true;
                continue;
            }
            lastLoop = false;
            deliveryIncomplete = true;
        }
        if (iterations == 0) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Rescheduling runner:" + runner));
            }
            return 0L;
        }
        return rVal;
    }

    @Override
    public void checkMessageStatus() throws AMQException {
        QueueEntryIterator<QueueEntry> queueListIterator = this._entries.iterator();
        while (queueListIterator.advance()) {
            QueueEntry node = queueListIterator.getNode();
            if (node.isDispensed()) continue;
            if (node.expired() && node.acquire()) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Dequeuing expired node " + node));
                }
                this.dequeueEntry(node);
                continue;
            }
            ServerMessage msg = node.getMessage();
            if (msg == null) continue;
            this.checkForNotification(msg);
        }
    }

    @Override
    public long getMinimumAlertRepeatGap() {
        return this._minimumAlertRepeatGap;
    }

    @Override
    public void setMinimumAlertRepeatGap(long minimumAlertRepeatGap) {
        this._minimumAlertRepeatGap = minimumAlertRepeatGap;
    }

    @Override
    public long getMaximumMessageAge() {
        return this._maximumMessageAge;
    }

    @Override
    public void setMaximumMessageAge(long maximumMessageAge) {
        this._maximumMessageAge = maximumMessageAge;
        if (maximumMessageAge == 0L) {
            this._notificationChecks.remove((Object)NotificationCheck.MESSAGE_AGE_ALERT);
        } else {
            this._notificationChecks.add(NotificationCheck.MESSAGE_AGE_ALERT);
        }
    }

    @Override
    public long getMaximumMessageCount() {
        return this._maximumMessageCount;
    }

    @Override
    public void setMaximumMessageCount(long maximumMessageCount) {
        this._maximumMessageCount = maximumMessageCount;
        if (maximumMessageCount == 0L) {
            this._notificationChecks.remove((Object)NotificationCheck.MESSAGE_COUNT_ALERT);
        } else {
            this._notificationChecks.add(NotificationCheck.MESSAGE_COUNT_ALERT);
        }
    }

    @Override
    public long getMaximumQueueDepth() {
        return this._maximumQueueDepth;
    }

    @Override
    public void setMaximumQueueDepth(long maximumQueueDepth) {
        this._maximumQueueDepth = maximumQueueDepth;
        if (maximumQueueDepth == 0L) {
            this._notificationChecks.remove((Object)NotificationCheck.QUEUE_DEPTH_ALERT);
        } else {
            this._notificationChecks.add(NotificationCheck.QUEUE_DEPTH_ALERT);
        }
    }

    @Override
    public long getMaximumMessageSize() {
        return this._maximumMessageSize;
    }

    @Override
    public void setMaximumMessageSize(long maximumMessageSize) {
        this._maximumMessageSize = maximumMessageSize;
        if (maximumMessageSize == 0L) {
            this._notificationChecks.remove((Object)NotificationCheck.MESSAGE_SIZE_ALERT);
        } else {
            this._notificationChecks.add(NotificationCheck.MESSAGE_SIZE_ALERT);
        }
    }

    @Override
    public long getCapacity() {
        return this._capacity;
    }

    @Override
    public void setCapacity(long capacity) {
        this._capacity = capacity;
    }

    @Override
    public long getFlowResumeCapacity() {
        return this._flowResumeCapacity;
    }

    @Override
    public void setFlowResumeCapacity(long flowResumeCapacity) {
        this._flowResumeCapacity = flowResumeCapacity;
        this.checkCapacity();
    }

    @Override
    public boolean isOverfull() {
        return this._overfull.get();
    }

    @Override
    public Set<NotificationCheck> getNotificationChecks() {
        return this._notificationChecks;
    }

    @Override
    public List<Long> getMessagesOnTheQueue(int num) {
        return this.getMessagesOnTheQueue(num, 0);
    }

    @Override
    public List<Long> getMessagesOnTheQueue(int num, int offset) {
        int i;
        ArrayList<Long> ids = new ArrayList<Long>(num);
        QueueEntryIterator<QueueEntry> it = this._entries.iterator();
        for (i = 0; i < offset; ++i) {
            it.advance();
        }
        for (i = 0; i < num && !it.atTail(); ++i) {
            it.advance();
            ids.add(it.getNode().getMessage().getMessageNumber());
        }
        return ids;
    }

    @Override
    public AMQSessionModel getExclusiveOwningSession() {
        return this._exclusiveOwner;
    }

    @Override
    public void setExclusiveOwningSession(AMQSessionModel exclusiveOwner) {
        this._exclusive = true;
        this._exclusiveOwner = exclusiveOwner;
    }

    @Override
    public void configure(ConfigurationPlugin config) {
        if (config != null) {
            if (config instanceof QueueConfiguration) {
                this.setMaximumMessageAge(((QueueConfiguration)config).getMaximumMessageAge());
                this.setMaximumQueueDepth(((QueueConfiguration)config).getMaximumQueueDepth());
                this.setMaximumMessageSize(((QueueConfiguration)config).getMaximumMessageSize());
                this.setMaximumMessageCount(((QueueConfiguration)config).getMaximumMessageCount());
                this.setMinimumAlertRepeatGap(((QueueConfiguration)config).getMinimumAlertRepeatGap());
                this.setMaximumDeliveryCount(((QueueConfiguration)config).getMaxDeliveryCount());
                this._capacity = ((QueueConfiguration)config).getCapacity();
                this._flowResumeCapacity = ((QueueConfiguration)config).getFlowResumeCapacity();
            }
            this._queueConfiguration = config;
        }
    }

    @Override
    public ConfigurationPlugin getConfiguration() {
        return this._queueConfiguration;
    }

    @Override
    public ConfigStore getConfigStore() {
        return this.getVirtualHost().getConfigStore();
    }

    @Override
    public long getMessageDequeueCount() {
        return this._dequeueCount.get();
    }

    @Override
    public long getTotalEnqueueSize() {
        return this._enqueueSize.get();
    }

    @Override
    public long getTotalDequeueSize() {
        return this._dequeueSize.get();
    }

    @Override
    public long getByteTxnEnqueues() {
        return this._byteTxnEnqueues.get();
    }

    @Override
    public long getByteTxnDequeues() {
        return this._byteTxnDequeues.get();
    }

    @Override
    public long getMsgTxnEnqueues() {
        return this._msgTxnEnqueues.get();
    }

    @Override
    public long getMsgTxnDequeues() {
        return this._msgTxnDequeues.get();
    }

    @Override
    public long getPersistentByteEnqueues() {
        return this._persistentMessageEnqueueSize.get();
    }

    @Override
    public long getPersistentByteDequeues() {
        return this._persistentMessageDequeueSize.get();
    }

    @Override
    public long getPersistentMsgEnqueues() {
        return this._persistentMessageEnqueueCount.get();
    }

    @Override
    public long getPersistentMsgDequeues() {
        return this._persistentMessageDequeueCount.get();
    }

    public String toString() {
        return String.valueOf(this.getNameShortString());
    }

    @Override
    public long getUnackedMessageCountHigh() {
        return this._unackedMsgCountHigh.get();
    }

    @Override
    public long getUnackedMessageCount() {
        return this._unackedMsgCount.get();
    }

    @Override
    public long getUnackedMessageBytes() {
        return this._unackedMsgBytes.get();
    }

    @Override
    public void decrementUnackedMsgCount(QueueEntry queueEntry) {
        this._unackedMsgCount.decrementAndGet();
        this._unackedMsgBytes.addAndGet(-queueEntry.getSize());
    }

    private void incrementUnackedMsgCount(QueueEntry entry) {
        long unackedMsgCountHigh;
        long unackedMsgCount = this._unackedMsgCount.incrementAndGet();
        this._unackedMsgBytes.addAndGet(entry.getSize());
        while (unackedMsgCount > (unackedMsgCountHigh = this._unackedMsgCountHigh.get()) && !this._unackedMsgCountHigh.compareAndSet(unackedMsgCountHigh, unackedMsgCount)) {
        }
    }

    public LogActor getLogActor() {
        return this._logActor;
    }

    @Override
    public int getMaximumDeliveryCount() {
        return this._maximumDeliveryCount;
    }

    @Override
    public void setMaximumDeliveryCount(int maximumDeliveryCount) {
        this._maximumDeliveryCount = maximumDeliveryCount;
    }

    private void checkForNotification(ServerMessage<?> msg) throws AMQException {
        Set<NotificationCheck> notificationChecks = this.getNotificationChecks();
        AMQQueue.NotificationListener listener = this._notificationListener;
        if (listener != null && !notificationChecks.isEmpty()) {
            long currentTime = System.currentTimeMillis();
            long thresholdTime = currentTime - this.getMinimumAlertRepeatGap();
            for (NotificationCheck check : notificationChecks) {
                if (!check.isMessageSpecific() && this._lastNotificationTimes[check.ordinal()] >= thresholdTime || !check.notifyIfNecessary(msg, this, listener)) continue;
                this._lastNotificationTimes[check.ordinal()] = currentTime;
            }
        }
    }

    @Override
    public void setNotificationListener(AMQQueue.NotificationListener listener) {
        this._notificationListener = listener;
    }

    @Override
    public void setDescription(String description) {
        if (description == null) {
            this._arguments.remove("x-qpid-description");
        } else {
            this._arguments.put("x-qpid-description", description);
        }
    }

    @Override
    public String getDescription() {
        return (String)this._arguments.get("x-qpid-description");
    }

    private final class QueueEntryListener
    implements QueueEntry.StateChangeListener {
        private final Subscription _sub;

        public QueueEntryListener(Subscription sub) {
            this._sub = sub;
        }

        public boolean equals(Object o) {
            return o instanceof QueueEntryListener && this._sub == ((QueueEntryListener)o)._sub;
        }

        public int hashCode() {
            return System.identityHashCode(this._sub);
        }

        public void stateChanged(QueueEntry entry, QueueEntry.State oldSate, QueueEntry.State newState) {
            entry.removeStateChangeListener(this);
            SimpleAMQQueue.this.deliverAsync(this._sub);
        }
    }

    public static interface QueueEntryFilter {
        public boolean accept(QueueEntry var1);

        public boolean filterComplete();
    }
}

