/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.database;

import java.security.Principal;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.log4j.Logger;
import org.apache.qpid.server.security.auth.database.AbstractPasswordFilePrincipalDatabase;
import org.apache.qpid.server.security.auth.database.PlainUser;
import org.apache.qpid.server.security.auth.sasl.amqplain.AmqPlainInitialiser;
import org.apache.qpid.server.security.auth.sasl.crammd5.CRAMMD5Initialiser;
import org.apache.qpid.server.security.auth.sasl.plain.PlainInitialiser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainPasswordFilePrincipalDatabase
extends AbstractPasswordFilePrincipalDatabase<PlainUser> {
    private final Logger _logger = Logger.getLogger(PlainPasswordFilePrincipalDatabase.class);

    public PlainPasswordFilePrincipalDatabase() {
        super(new AmqPlainInitialiser(), new PlainInitialiser(), new CRAMMD5Initialiser());
    }

    @Override
    public boolean verifyPassword(String principal, char[] password) throws AccountNotFoundException {
        char[] pwd = this.lookupPassword(principal);
        if (pwd == null) {
            throw new AccountNotFoundException("Unable to lookup the specfied users password");
        }
        return this.compareCharArray(pwd, password);
    }

    @Override
    protected PlainUser createUserFromPassword(Principal principal, char[] passwd) {
        return new PlainUser(principal.getName(), passwd);
    }

    @Override
    protected PlainUser createUserFromFileData(String[] result) {
        return new PlainUser(result);
    }

    @Override
    protected Logger getLogger() {
        return this._logger;
    }
}

